#include "rcui.h"

#include <engine/engine.h>
#include "engine/engine-private.h"

extern RcEngine *RC_engine;

void
on_main_window_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
   gtk_main_quit();
}

void
on_mainw_entry_activate                (GtkEntry      *entry,
                                        gpointer         user_data)
{
  on_mainw_OKbutton_clicked (NULL, user_data);
}


void
on_mainw_OKbutton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkEntry *tentry = GTK_ENTRY(lookup_widget(GTK_WIDGET(user_data),"mainw_entry"));
  GtkTextView *tview = GTK_TEXT_VIEW(lookup_widget(GTK_WIDGET(user_data),"mainw_bottomtextview"));
  
  gboolean  quit_flag;
  G_CONST_RETURN gchar *utfexpr;
  gchar *expr;
  RcLastRes RC_result;
  
  GtkTreeIter search_iter;
  
  utfexpr = gtk_entry_get_text(tentry);
  /*g_print("Input> %s\n",expr);*/
  expr = g_convert (utfexpr, -1, "ASCII", "UTF-8", NULL, NULL, NULL);
  /*expr = g_locale_from_utf8 (utfexpr, -1, NULL, NULL, NULL);*/
  if (!expr) {
    expr = g_strdup((gchar *)utfexpr);
    g_print(_("Error: could not convert input to ASCII\n"));
    RCUI_new_infomsg (tview, _("error: malformed expression\n"), RCUI_MSG_ERROR);
    gtk_entry_set_text(tentry, "");
    return;
  }
    
  quit_flag = rc_engine_execute( RC_engine, expr );
  RC_result = rc_import_lastres();
  /*g_print("TYPE=%d\n",rc_import_result_type());*/	
  
  if ( RC_result.expType == RC_EXP_ERROR) {
    RCUI_new_infomsg (tview, rc_import_result_error(), RCUI_MSG_ERROR);
    
    if (RC_result.err_reason == RC_ERR_UNDEFINED) {
    
      switch (ui_params.insert_mode)
      {
        case RCUI_INSERT_END: 
          search_iter = RCUI_append_expr (ui_stores.mainw_store, RC_result.name, RC_result.expr, "undefined", 
            (gchar *)expr);
          /* var is now undefined, so remove it */
          RCUI_remove_var_at_iter (ui_stores.mainw_store, search_iter);
          break;
            
        case RCUI_INSERT_BEFORE : RCUI_insert_before (ui_stores.mainw_store, &ui_params.selected_iter,
                                RC_result.name, RC_result.expr, RC_result.value, (gchar *)expr); 
            break;

        case RCUI_INSERT_AFTER : RCUI_insert_after (ui_stores.mainw_store, &ui_params.selected_iter,
                                RC_result.name, RC_result.expr, RC_result.value, (gchar *)expr); 
            break;

        case RCUI_REPLACE : RCUI_replace_expr (ui_stores.mainw_store, &ui_params.selected_iter, 
                                RC_result.name, RC_result.expr, RC_result.value, (gchar *)expr);
            break;

        default : break;
      }
      
 
    }
    
    RCUI_add_to_history (ui_stores.history, (gchar *)expr);
  }
    
  else {
    if ( RC_result.expType != RC_EXP_COMMAND) {
        
      /* var/func already exists : edit line */
      /* if (RC_result.replaced == TRUE) { */
      
      
/*      if (RCUI_name_is_in_list(ui_stores.mainw_store, RC_result.name, &search_iter) == TRUE) {
         RCUI_replace_expr (ui_stores.mainw_store, &search_iter, 
          RC_result.name, RC_result.expr, RC_result.value, (gchar *)expr);
      }
      
      else */
      switch (ui_params.insert_mode)
      {
        case RCUI_INSERT_END: RCUI_append_expr (ui_stores.mainw_store, RC_result.name, 
                                RC_result.expr, RC_result.value, (gchar *)expr); 
            break;
            
        case RCUI_INSERT_BEFORE : RCUI_insert_before (ui_stores.mainw_store, &ui_params.selected_iter,
                                RC_result.name, RC_result.expr, RC_result.value, (gchar *)expr); 
            break;

        case RCUI_INSERT_AFTER : RCUI_insert_after (ui_stores.mainw_store, &ui_params.selected_iter,
                                RC_result.name, RC_result.expr, RC_result.value, (gchar *)expr); 
            break;

        case RCUI_REPLACE : RCUI_replace_expr (ui_stores.mainw_store, &ui_params.selected_iter, 
                                RC_result.name, RC_result.expr, RC_result.value, (gchar *)expr);
            break;

        default : break;
      }
      
      RCUI_add_to_history (ui_stores.history, (gchar *)expr);
    }  
  }
  gtk_entry_set_text(tentry, "");
  
  g_free (expr);
}


void
on_mainw_RMVbutton_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkEntry *tentry = GTK_ENTRY(lookup_widget(GTK_WIDGET(user_data),"mainw_entry"));
  GtkWidget *UPbutton = GTK_WIDGET(lookup_widget(GTK_WIDGET(user_data),"mainw_upb"));
  GtkWidget *DOWNbutton = GTK_WIDGET(lookup_widget(GTK_WIDGET(user_data),"mainw_downb"));
  GtkWidget *STATEbutton = GTK_WIDGET(lookup_widget(GTK_WIDGET(user_data),"mainw_linestateb"));
  GtkWidget *INSERTbox = GTK_WIDGET(lookup_widget(GTK_WIDGET(user_data),"mainw_linecombo"));

  if (ui_params.col_selected == TRUE)
    RCUI_remove_expr (ui_stores.mainw_store, &ui_params.selected_iter);
    
  ui_params.col_selected = FALSE;
  gtk_widget_set_sensitive (GTK_WIDGET(button), FALSE);
  gtk_widget_set_sensitive (UPbutton, FALSE);
  gtk_widget_set_sensitive (DOWNbutton, FALSE);
  gtk_widget_set_sensitive (STATEbutton, FALSE);
  gtk_widget_set_sensitive (INSERTbox, FALSE);

  gtk_entry_set_text(tentry, "");
}

void
on_mainw_tree_cursor_changed  (GtkTreeView *treeview, gpointer user_data)
{
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkTreeModel *model;
  
  gchar *user_input;
  GtkWidget *RMVbutton = GTK_WIDGET(lookup_widget(GTK_WIDGET(user_data),"mainw_RMVbutton"));
  GtkWidget *UPbutton = GTK_WIDGET(lookup_widget(GTK_WIDGET(user_data),"mainw_upb"));
  GtkWidget *DOWNbutton = GTK_WIDGET(lookup_widget(GTK_WIDGET(user_data),"mainw_downb"));
  GtkWidget *STATEbutton = GTK_WIDGET(lookup_widget(GTK_WIDGET(user_data),"mainw_linestateb"));
  GtkWidget *INSERTbox = GTK_WIDGET(lookup_widget(GTK_WIDGET(user_data),"mainw_linecombo"));

  GtkEntry *tentry = GTK_ENTRY(lookup_widget(GTK_WIDGET(user_data),"mainw_entry"));
  
  model = gtk_tree_view_get_model(treeview);
  gtk_tree_view_get_cursor (treeview, &path, &focus_column);
  if (gtk_tree_model_get_iter(model, &ui_params.selected_iter, path))
  {
    gtk_tree_model_get (model, &ui_params.selected_iter, INPUT_COLUMN, &user_input, -1);
    ui_params.col_selected = TRUE;
    gtk_widget_set_sensitive (RMVbutton, TRUE);
    gtk_widget_set_sensitive (UPbutton, TRUE);
    gtk_widget_set_sensitive (DOWNbutton, TRUE);
    gtk_widget_set_sensitive (STATEbutton, TRUE);
    gtk_widget_set_sensitive (INSERTbox, TRUE);
    
    /*g_print ("Input entry: %s\n", user_input);*/
    gtk_entry_set_text(tentry, user_input);
    g_free (user_input);  
  }
  
  else 
    ui_params.col_selected = FALSE;
}

gboolean
on_mainw_entry_key_press_cb (GtkWidget *entry, GdkEventKey *event, gpointer data)
{
  gchar tmp;
  if (event->state & GDK_SHIFT_MASK) {
    if (event->keyval == GDK_Return || event->keyval == GDK_KP_Enter) {
      tmp = ui_params.insert_mode;
      ui_params.insert_mode = RCUI_REPLACE;
      if (ui_params.col_selected == TRUE)
        on_mainw_OKbutton_clicked (NULL, data);
      ui_params.insert_mode = tmp;
      return TRUE;
    }
    else return FALSE;
  }
  return FALSE;
}


void
on_mainw_upb_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  if (ui_params.col_selected == TRUE)
    RCUI_move_up (ui_stores.mainw_store, &ui_params.selected_iter);
}


void
on_mainw_downb_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  if (ui_params.col_selected == TRUE)
    RCUI_move_down (ui_stores.mainw_store, &ui_params.selected_iter);
}

void
on_mainw_linecombo_changed             (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  ui_params.insert_mode = gtk_combo_box_get_active (combobox);
  g_assert ( ui_params.insert_mode >= 0);
}


void
on_mainw_linestateb_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  if (ui_params.col_selected == TRUE)
    RCUI_switch_activate (ui_stores.mainw_store, &ui_params.selected_iter);
}

