/***************************************************************************
 *                             RasMol 2.7.4.2                              *
 *                                                                         *
 *                                 RasMol                                  *
 *                 Molecular Graphics Visualisation Tool                   *
 *                            19 November 2007                             *
 *                          (rev. 21 March 2008)                           *
 *                                                                         *
 *                   Based on RasMol 2.6 by Roger Sayle                    *
 * Biomolecular Structures Group, Glaxo Wellcome Research & Development,   *
 *                      Stevenage, Hertfordshire, UK                       *
 *         Version 2.6, August 1995, Version 2.6.4, December 1998          *
 *                   Copyright (C) Roger Sayle 1992-1999                   *
 *                                                                         *
 *                          and Based on Mods by                           *
 *Author             Version, Date             Copyright                   *
 *Arne Mueller       RasMol 2.6x1   May 98     (C) Arne Mueller 1998       *
 *Gary Grossman and  RasMol 2.5-ucb Nov 95     (C) UC Regents/ModularCHEM  *
 *Marco Molinaro     RasMol 2.6-ucb Nov 96         Consortium 1995, 1996   *
 *                                                                         *
 *Philippe Valadon   RasTop 1.3     Aug 00     (C) Philippe Valadon 2000   *
 *                                                                         *
 *Herbert J.         RasMol 2.7.0   Mar 99     (C) Herbert J. Bernstein    * 
 *Bernstein          RasMol 2.7.1   Jun 99         1998-2008               *
 *                   RasMol 2.7.1.1 Jan 01                                 *
 *                   RasMol 2.7.2   Aug 00                                 *
 *                   RasMol 2.7.2.1 Apr 01                                 *
 *                   RasMol 2.7.2.1.1 Jan 04                               *
 *                   RasMol 2.7.3   Feb 05                                 *
 *                   RasMol 2.7.3.1 Apr 06                                 *
 *                   RasMol 2.7.4   Nov 07                                 *
 *                   RasMol 2.7.4.1 Jan 08                                 *
 *                   RasMol 2.7.4.2 Mar 08                                 *
 *                                                                         *
 * RasMol 2.7.3 incorporates changes by Clarice Chigbo, Ricky Chachra,     *
 * and Mamoru Yamanishi.  Work on RasMol 2.7.3 supported in part by        *
 * grants DBI-0203064, DBI-0315281 and EF-0312612 from the U.S. National   *
 * Science Foundation and grant DE-FG02-03ER63601 from the U.S. Department *
 * of Energy.  RasMol 2.7.4 incorporates changes by G. Todorov, Nan Jia,   *
 * N. Darakev, P. Kamburov, G. McQuillan, J. Jemilawon.  Work on RasMol    *
 * 2.7.4 supported in part by grant 1R15GM078077-01 from the National      *
 * Institute of General Medical Sciences (NIGMS). The content is solely    *
 * the responsibility of the authors and does not necessarily represent    * 
 * the official views of the funding organizations.                        *
 *                                                                         *
 * The code for use of RasMol under GTK in RasMol 2.7.4.2 was written by   *
 * Teemu  Ikonen.                                                          *
 *                                                                         *
 *                    and Incorporating Translations by                    *
 *  Author                               Item                     Language *
 *  Isabel Servan Martinez,                                                *
 *  Jose Miguel Fernandez Fernandez      2.6   Manual             Spanish  *
 *  Jose Miguel Fernandez Fernandez      2.7.1 Manual             Spanish  *
 *  Fernando Gabriel Ranea               2.7.1 menus and messages Spanish  *
 *  Jean-Pierre Demailly                 2.7.1 menus and messages French   *
 *  Giuseppe Martini, Giovanni Paolella, 2.7.1 menus and messages          *
 *  A. Davassi, M. Masullo, C. Liotto    2.7.1 help file          Italian  *
 *  G. Pozhvanov                         2.7.3 menus and messages Russian  *
 *  G. Todorov                           2.7.3 menus and messages Bulgarian*
 *  Nan Jia, G. Todorov                  2.7.3 menus and messages Chinese  *
 *  Mamoru Yamanishi, Katajima Hajime    2.7.3 menus and messages Japanese *
 *                                                                         *
 *                             This Release by                             *
 * Herbert J. Bernstein, Bernstein + Sons, 5 Brewster Ln, Bellport, NY, USA*
 *                       yaya@bernstein-plus-sons.com                      *
 *               Copyright(C) Herbert J. Bernstein 1998-2008               *
 *                                                                         *
 *                READ THE FILE NOTICE FOR RASMOL LICENSES                 *
 *Please read the file NOTICE for important notices which apply to this    *
 *package and for license terms (GPL or RASLIC).                           *
 ***************************************************************************/
 
/* langsel.c
 */

/***************************************************************************
 *                                                                         *
 * The Spanish translations in langsel.c were provided in late 2000 and    *
 * early 2001 by Fernando Gabriel Ranea <davinci@dinamica.com.ar>, who     *
 * created a version of RasMol with Spanish messages.  Those translations  *
 * were adapted by Herbert J. Bernstein to create a general multilingual   *
 * structure for RasMol.  In order to add another languages, define that   *
 * language in langsel.h, define a token for that language in tokens.h,    *
 * add code to recognize that token to tokens.c and command.c, and add     *
 * parallel lines with translations to the new language to langsel.c.      *
 * When entering menu items, you must identify a character in the item     *
 * to be underlined as a menu bar accelerator character.  The position of  *
 * that character (starting from 0 for the left-most character) should be  *
 * the last field of the line.  In addition, all menu items need to be     *
 * repeated for the Windows version with an ampersand ("&") before the     *
 * menu bar accelerator character.                                         *
 *                                                                         *
 * To date the following translations have been provided:                  *
 *                                                                         *
 * Spanish  Fernando Gabriel Ranea <davinci@dinamica.com.ar>               *
 *          January 2001                                                   *
 * French   Jean-Pierre Demailly <Jean-Pierre.Demailly@ujf-grenoble.fr>    *
 *          February 2001                                                  *
 * Italian  Giuseppe Martini <martini@iigb.na.cnr.it> and                  *
 *          Giovanni Paolella <paolella@dbbm.unina.it>                     *
 *          with contributions by: A. Davassi, M. Masullo, C. Liotto,      *
 *          G. Paolella, G. Martini of the joint bioinformatics            *
 *          groups of DBBM-UNINA and IIGB-CNR in Naples, Italy.            *
 *          March 2001                                                     *
 * Russian  Gregory A. Pozhvanov <pozhvanov@gmail.com>                     *    
 *          February 2006                                                  *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>

#define LANGSEL
#include "rasmol.h"
#include "graphics.h"
#include "langsel.h"
#include "command.h"
#include "cmndline.h"


extern int Interactive;

static char * langnames[NUMLANGS] = {
  "English",
  "French",
  "German",
  "Italian",
  "Spanish",
  "Russian",
  "Chinese",
  "Japanese",
  "Bulgarian"
};


#ifdef MSWIN
langfont langfonts[NUMLANGS] = {
  { "RASMOL_ENGLISH_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET",
    English },
  { "RASMOL_FRENCH_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET", 
    French },
  { "RASMOL_GERMAN_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET", 
    German },
  { "RASMOL_ITALIAN_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET", 
    Italian },
  { "RASMOL_SPANISH_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET", 
    Spanish },
  { "RASMOL_RUSSIAN_MENU_FONT", 
    RUSSIAN_CHARSET,
    "RUSSIAN_CHARSET", 
    Russian },
  { "RASMOL_CHINESE_MENU_FONT", 
    GB2312_CHARSET,
    "GB2312_CHARSET", 
    Chinese },
  { "RASMOL_JAPANESE_MENU_FONT", 
    SHIFTJIS_CHARSET,
    "SHIFTJIS_CHARSET", 
    Japanese },
  { "RASMOL_BULGARIAN_MENU_FONT", 
    RUSSIAN_CHARSET,
    "RUSSIAN_CHARSET", 
    Bulgarian }
};
#else
#ifdef APPLEMAC
langfont langfonts[NUMLANGS] = {
  { "RASMOL_ENGLISH_MENU_FONT", 
    "Monaco", 
    English },
  { "RASMOL_FRENCH_MENU_FONT", 
    "Monaco", 
    French },
  { "RASMOL_GERMAN_MENU_FONT", 
    "Monaco", 
    German },
  { "RASMOL_ITALIAN_MENU_FONT", 
    "Monaco", 
    Italian },
  { "RASMOL_SPANISH_MENU_FONT", 
    "Monaco", 
    Spanish },
  { "RASMOL_RUSSIAN_MENU_FONT", 
    "ER Kurier Macintosh", 
    Russian },
  { "RASMOL_CHINESE_MENU_FONT", 
    "Beijing", 
    Chinese },
  { "RASMOL_JAPANESE_MENU_FONT", 
    "Osaka", 
    Japanese },
  { "RASMOL_BULGARIAN_MENU_FONT", 
    "ER Kurier Macintosh", 
    Bulgarian }
};
#else
langfont langfonts[NUMLANGS] = {
  { "RASMOL_ENGLISH_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    English },
  { "RASMOL_FRENCH_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1"  ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    French },
  { "RASMOL_GERMAN_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    German },
  { "RASMOL_ITALIAN_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    Italian },
  { "RASMOL_SPANISH_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    Spanish },
  { "RASMOL_RUSSIAN_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*1251" ":"
    "-*-serf-bold-o-normal-*-14-*-*1251" ":"
    "-*-*-bold-o-normal-*-14-*-*1251", 
    Russian },
  { "RASMOL_CHINESE_MENU_FONT", 
    "*-16-*-gb2312.1980-0", 
    Chinese },
  { "RASMOL_JAPANESE_MENU_FONT", 
    "*-r-*-14-*-jisx0208.1983-0", 
    Japanese },
  { "RASMOL_BULGARIAN_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*1251" ":"
    "-*-serf-bold-o-normal-*-14-*-*1251" ":"
    "-*-*-bold-o-normal-*-14-*-*1251", 
    Bulgarian }
};
#endif
#endif
	

static langstr langstrs[] = {
  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, English,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  English,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, English,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  English,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, English,0},

  { "Invalid command syntax!\n",                       ErrSyntax,   English,0},
  { "Parameter value too large!\n",                    ErrBigNum,   English,0},
  { "Invalid parameter setting!\n",                    ErrBadOpt,   English,0},
  { "Invalid parameter name!\n",                       ErrParam,    English,0},
  { "Filename string expected!\n",                     ErrFilNam,   English,0},
  { "Molecule database loaded!\n",                     ErrBadLoad,  English,0},
  { "Integer value expected!\n",                       ErrNotNum,   English,0},
  { "Comma separator missing!\n",                      ErrNotSep,   English,0},
  { "Close bracket ']' expected!\n",                   ErrNotBrac,  English,0},
  { "No colour specified!\n",                          ErrNoCol,    English,0},
  { "Unknown or incorrect colour!\n",                  ErrColour,   English,0},
  { "Invalid command argument!\n",                     ErrBadArg,   English,0},
  { "Syntax error in expression!\n",                   ErrBadExpr,  English,0},
  { "Close parenthesis ')' expected!\n",               ErrParen,    English,0},
  { "Script command stack too deep!\n",                ErrScript,   English,0},
  { "Open parenthesis '(' expected!\n",                ErrFunc,     English,0}, 
  { "Invalid or missing atom set name!\n",             ErrSetName,  English,0},
  { "Not enough memory to define set!\n",              ErrBadSet,   English,0},
  { "Command disabled in script file!\n",              ErrInScrpt,  English,0},
  { "Command invalid (valid only within a script)!\n", ErrOutScrpt, English,0},
  { "Molecule database not loaded!\n",                 ErrBadMolDB, English,0},
  { "Bond for rotation not picked!\n",                 ErrNoBond,   English,0},
  { "Error: File '",                                   StrErrFile,  English,0},
  { "' not found!\n\n",                                StrNotFnd,   English,0},
  { "Error: Unrecognised compression format!\n\n",     StrCFmt,     English,0},
  { "Error: Unable to decompress file!\n\n",           StrDcmp,     English,0},
  { "Script command line too long!\n",                 StrSLong,    English,0},
  { "Command Error: Insufficient memory!\n",           StrSMem,     English,0},
  { "Unable to find RasMol help file!\n",              StrHFil,     English,0},
  { "Ambiguous help topic requested!\n",               StrHTop,     English,0},
  { "No available help on requested topic!\n",         StrHNone,    English,0},
  { "Command Error: Unable to reopen help file!\n",    StrHROpn,    English,0},
  { "String constant unterminated!\n",                 StrCTerm,    English,0},
  { "String constant too long!\n",                     StrCLong,    English,0},
  { "Invalid floating point number!\n",                StrFNum,     English,0},
  { "No Atoms to Centre!\n",                           StrCent,     English,0},
  { "Unable to copy to clipboard!\n",                  StrCClip,    English,0},
  { "Cannot open dots file '",                         StrDFile,    English,0},
  { "Warning: No suitable printer!\n",                 StrNPrint,   English,0},
  { "Unit Cell",                                       StrUCell,    English,0},
  { "Space Group",                                     StrSGroup,   English,0},
  { "No crystal symmetry data!\n",                     StrSymm,     English,0},
  { "Unrecognised command!\n",                         StrUnrec,    English,0},
  { "Warning: Ignoring rest of command!\n",            StrIgnore,   English,0},
  { "Warning: Remote command too long!\n",             StrRCLong,   English,0},
  { "Cannot open script file '",                       StrSFile,    English,0},
  { "Identifier too long!\n",                          StrILong,    English,0},
  { "Molecule name ......... ",                        StrMolNam,   English,0},
  { "Classification ........ ",                        StrClass,    English,0},
  { "Secondary Structure ... ",                        StrSecSt,    English,0},
  { "No Assignment\n",                                 StrNoAsmt,   English,0},
  { "PDB Data Records\n",                              StrPDBRec,   English,0},
  { "Calculated\n",                                    StrCalc,     English,0},
  { "Database Code ......... ",                        StrDBCode,   English,0},
  { "Experiment Technique .. ",                        StrExpTec,   English,0},
  { "Number of Chains ...... ",                        StrNumChn,   English,0},
  { "Number of Groups ...... ",                        StrNumGrp,   English,0},
  { "Number of Atoms ....... ",                        StrNumAtm,   English,0},
  { "Number of Bonds ....... ",                        StrNumBnd,   English,0},
  { "Number of Bridges ..... ",                        StrNumBrg,   English,0},
  { "Number of H-Bonds ..... ",                        StrNumHbd,   English,0},
  { "Number of Helices ..... ",                        StrNumHel,   English,0},
  { "Number of Strands ..... ",                        StrNumStrnd, English,0},
  { "Number of Turns ....... ",                        StrNumTrn,   English,0},
  { "Memory allocation failed",                        StrMalloc,   English,0},
  { "Too many new residues",                           StrXSRes,    English,0},
  { "Too many new atom types",                         StrXSAtyp,   English,0},
#ifndef MSWIN
  { "Open...",                                         StrMOpen,    English,0},
  { "Save As...",                                      StrMSaveAs,  English,0},
  { "Close",                                           StrMClose,   English,0},
  { "",                                                StrMEmpty,   English,0},
#ifdef APPLEMAC 
  { "Page Setup",                                      StrMPSetup,  English,0},
  { "Print",                                           StrMPrint,   English,0},
  { "Quit",                                            StrMExit,    English,0},
#else
  { "Exit",                                            StrMExit,    English,0},
#endif
  { "Wireframe",                                       StrMWirefr,  English,0},
  { "Backbone",                                        StrMBackbn,  English,0},
  { "Sticks",                                          StrMSticks,  English,1},
  { "Spacefill",                                       StrMSpacefl, English,0},
  { "Ball & Stick",                                    StrMBallStk, English,0},
  { "Ribbons",                                         StrMRibbons, English,0},
  { "Strands",                                         StrMStrands, English,3},
  { "Cartoons",                                        StrMCartoon, English,0},
  { "Molecular Surface",                               StrMMolSurf, English,0},
  { "Monochrome",                                      StrMMonochr, English,0},
  { "CPK",                                             StrMCPK,     English,0},
  { "Shapely",                                         StrMShapely, English,0},
  { "Group",                                           StrMGroup,   English,0},
  { "Chain",                                           StrMChain,   English,1},
  { "Temperature",                                     StrMTemp,    English,0},
  { "Structure",                                       StrMStruct,  English,2},
  { "User",                                            StrMUser,    English,0},
  { "Model",                                           StrMModel,   English,2},
  { "Alt",                                             StrMAlt,     English,0},
  { "Slab Mode",                                       StrMSlab,    English,0},
  { "Hydrogens",                                       StrMHydr,    English,1},
  { "Hetero Atoms",                                    StrMHet,     English,2},
  { "Specular",                                        StrMSpec,    English,1},
  { "Shadows",                                         StrMShad,    English,1},
  { "Stereo",                                          StrMStereo,  English,5},
  { "Labels",                                          StrMLabel,   English,0},
  { "Pick Off",                                        StrMPOff,    English,5},
  { "Pick Ident",                                      StrMPIdent,  English,5},
  { "Pick Distance",                                   StrMPDist,   English,5},
  { "Pick Monitor",                                    StrMPMon,    English,0},
  { "Pick Angle",                                      StrMPAng,    English,5},
  { "Pick Torsion",                                    StrMPTrsn,   English,5},
  { "Pick Label",                                      StrMPLabl,   English,5}, 
  { "Pick Centre",                                     StrMPCent,   English,5},
  { "Pick Coord",                                      StrMPCoord,  English,6},
  { "Pick Bond",                                       StrMPBond,   English,5},
  { "Rotate Bond",                                     StrMRBond,   English,0},
  { "Rotate Mol",                                      StrMRMol,    English,7},
  { "Rotate All",                                      StrMRAll,    English,7},
  { "BMP ...",                                         StrMBMP,     English,0},  
  { "GIF ...",                                         StrMGIF,     English,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    English,5},  
  { "PPM ...",                                         StrMPPM,     English,2},  
  { "Sun Raster...",                                   StrMSRast,   English,0},  
  { "PostScript...",                                   StrMPostscr, English,0},  
  { "PICT...",                                         StrMPICT,    English,1},  
  { "Vector PS ...",                                   StrMVECPS,   English,0},  
  { "Molscript ...",                                   StrMMSCR,    English,1},  
  { "Kinemage ...",                                    StrMKine,    English,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  English,2}, 
  { "VRML ...",                                        StrMVRML,    English,3},  
  { "Ramachandran ...",                                StrMRPP,     English,3},  
  { "Raster3D ...",                                    StrMR3D,     English,6},  
  { "RasMol Script ...",                               StrMSCR,     English,8},  
  { "About RasMol...",                                 StrMAbout,   English,0},
  { "User Manual...",                                  StrMUserM,   English,0},
  { "Undo",                                            StrMUndo,    English,0},
  { "Cut",                                             StrMCut,     English,1},
  { "Copy",                                            StrMCopy,    English,1},
  { "Paste",                                           StrMPaste,   English,0},
#ifdef APPLEMAC
  { "Clear",                                           StrMClear,   English,1},
#else
  { "Delete",                                          StrMDelete,  English,0},
#endif
  { "Select all",                                      StrMSelAll,  English,0},
  { "File",                                            StrMFile,    English,0},
  { "Edit",                                            StrMEdit,    English,0},
  { "Display",                                         StrMDisplay, English,0},
  { "Colours",                                         StrMColour,  English,0},
  { "Options",                                         StrMOpt,     English,0},
  { "Settings",                                        StrMSettings,English,0},
  { "Export",                                          StrMExport,  English,1},
#ifdef APPLEMAC
  { "Window",                                          StrMWindow,  English,0},
#endif
  { "Help",                                            StrMHelp,    English,0},
#ifdef APPLEMAC
  { "Main Window",                                     StrMMainWin,  English,0},
  { "Command Line",                                    StrMCmndLin,  English,0},
#endif
#else
  { "&Open ...",                                       StrMOpen,    English,0},
  { "&Information",                                    StrMInfo,    English,0},
  { "&Close",                                          StrMClose,   English,0},
  { "&Print",                                          StrMPrint,   English,0},
  { "P&rint Setup",                                    StrMPSetup,  English,0},
  { "&Exit",                                           StrMExit,    English,0},
  { "&Wireframe",                                      StrMWirefr,  English,0},
  { "&Backbone",                                       StrMBackbn,  English,0},
  { "S&ticks",                                         StrMSticks,  English,1},
  { "&Spacefill",                                      StrMSpacefl, English,0},
  { "&Ball && Stick",                                  StrMBallStk, English,0},
  { "&Ribbons",                                        StrMRibbons, English,0},
  { "Str&ands",                                        StrMStrands, English,3},
  { "&Cartoons",                                       StrMCartoon, English,0},
  { "&Molecular Surface",                              StrMMolSurf, English,0},
  { "&Monochrome",                                     StrMMonochr, English,0},
  { "&CPK",                                            StrMCPK,     English,0},
  { "&Shapely",                                        StrMShapely, English,0},
  { "&Group",                                          StrMGroup,   English,0},
  { "C&hain",                                          StrMChain,   English,1},
  { "&Temperature",                                    StrMTemp,    English,0},
  { "St&ructure",                                      StrMStruct,  English,2},
  { "&User",                                           StrMUser,    English,0},
  { "Mo&del",                                          StrMModel,   English,2},
  { "&Alt",                                            StrMAlt,     English,0},
  { "&Slab Mode",                                      StrMSlab,    English,0},
  { "H&ydrogens",                                      StrMHydr,    English,1},
  { "He&tero Atoms",                                   StrMHet,     English,2},
  { "S&pecular",                                       StrMSpec,    English,1},
  { "S&hadows",                                        StrMShad,    English,1},
  { "Stere&o",                                         StrMStereo,  English,5},
  { "&Labels",                                         StrMLabel,   English,0},
  { "Pick &Off",                                       StrMPOff,    English,5},
  { "Pick &Ident",                                     StrMPIdent,  English,5},
  { "Pick &Distance",                                  StrMPDist,   English,5},
  { "&Pick Monitor",                                   StrMPMon,    English,0},
  { "Pick &Angle",                                     StrMPAng,    English,5},
  { "Pick &Torsion",                                   StrMPTrsn,   English,5},
  { "Pick &Label",                                     StrMPLabl,   English,5}, 
  { "Pick &Centre",                                    StrMPCent,   English,5},
  { "Pick C&oord",                                     StrMPCoord,  English,6},
  { "Pick &Bond",                                      StrMPBond,   English,5},
  { "&Rotate Bond",                                    StrMRBond,   English,0},
  { "Rotate &Mol",                                     StrMRMol,    English,7},
  { "Rotate &All",                                     StrMRAll,    English,7},
  { "&BMP ...",                                        StrMBMP,     English,0},  
  { "&GIF ...",                                        StrMGIF,     English,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    English,5}, 
  { "PP&M ...",                                        StrMPPM,     English,2},  
  { "&Sun Raster...",                                  StrMSRast,   English,0},  
  { "&PostScript...",                                  StrMPostscr, English,0},  
  { "P&ICT...",                                        StrMPICT,    English,1},  
  { "&Vector PS ...",                                  StrMVECPS,   English,0},  
  { "M&olscript ...",                                  StrMMSCR,    English,1},  
  { "&Kinemage ...",                                   StrMKine,    English,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  English,2},  
  { "VRM&L ...",                                       StrMVRML,    English,3},  
  { "Ram&achandran ...",                               StrMRPP,     English,3},  
  { "Raster&3D ...",                                   StrMR3D,     English,6},  
  { "RasMol S&cript ...",                              StrMSCR,     English,8},  
  { "&About RasMol...",                                StrMAbout,   English,0},
  { "&User Manual...",                                 StrMUserM,   English,0},
  { "&Undo",                                           StrMUndo,    English,0},
  { "C&ut",                                            StrMCut,     English,1},
  { "C&opy",                                           StrMCopy,    English,1},
  { "&Paste",                                          StrMPaste,   English,0},
  { "&Delete",                                         StrMDelete,  English,0},
  { "&Select all",                                     StrMSelAll,  English,0},
  { "&File",                                           StrMFile,    English,0},
  { "&Edit",                                           StrMEdit,    English,0},
  { "&Display",                                        StrMDisplay, English,0},
  { "&Colours",                                        StrMColour,  English,0},
  { "&Options",                                        StrMOpt,     English,0},
  { "&Settings",                                       StrMSettings,English,0},
  { "E&xport",                                         StrMExport,  English,1},
  { "&Help",                                           StrMHelp,    English,0},
#endif
  { "PDB file name:",                                  StrPrmtPDB,  English,0},
  { "Image file name:",                                StrPrmtImg,  English,0},
  { "Molecule file name:",                             StrPrmtMol,  English,0},
  { "Warning: ",                                       StrWarn,     English,0},
  { "Chain",                                           StrChain,    English,0},
  { "Register",                                        StrRegister, English,0},
  { "Donate",                                          StrDonate,   English,0},
  { "Do not show this dialog at startup",              StrNoShow,   English,0},
  { "No Warranty, Open Source, GPL, Donations Appreciated", StrWarranty, English,0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Spanish,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Spanish,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Spanish,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Spanish,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Spanish,0},

  { "Sintaxis de comando invlida!\n",                ErrSyntax,   Spanish,0},
  { "Valor de parmetro demasiado larga!\n",          ErrBigNum,   Spanish,0},
  { "Valor de parmetro invlido!\n",                 ErrBadOpt,   Spanish,0},
  { "Nombre de parmetro invlido!\n",                ErrParam,    Spanish,0},
  { "Se esperaba un nombre de archivo!\n",            ErrFilNam,   Spanish,0},
  { "Base de datos de molculas cargada!\n",          ErrBadLoad,  Spanish,0},
  { "Se esperaba un valor entero!\n",                 ErrNotNum,   Spanish,0},
  { "Separador coma perdido!\n",                      ErrNotSep,   Spanish,0},
  { "Se esperaba cerrar corchete ']'!\n",             ErrNotBrac,  Spanish,0},
  { "No se ha especificado un color!\n",              ErrNoCol,    Spanish,0},
  { "Color incorrecto o desconocido!\n",              ErrColour,   Spanish,0},
  { "Argumento de comando invlido!\n",               ErrBadArg,   Spanish,0},
  { "Error de sintaxis en la expresin!\n",           ErrBadExpr,  Spanish,0},
  { "Se esperaba cerrar parntesis ')'!\n",           ErrParen,    Spanish,0},
  { "Pila del comando de script demasiado grande!\n", ErrScript,   Spanish,0},
  { "Se esperaba abrir parentesis '('!\n",            ErrFunc,     Spanish,0},
  { "Nombre de tomo invlido o errneo!\n",          ErrSetName,  Spanish,0},
  { "No hay suficiente memoria para definir!\n",      ErrBadSet,   Spanish,0},
  { "Comando deshabilitado en el archivo de script!\n", ErrInScrpt,  Spanish,0},
  { "Comando invlido (comando vlido slo dentro un script)!\n", ErrOutScrpt, Spanish,0},
  { "Base de datos de molculas no cargada!\n",       ErrBadMolDB, Spanish,0},
  { "Enlace para el giro no elegido!\n",              ErrNoBond,   Spanish,0},
  { "Error: Archivo '",                               StrErrFile,  Spanish,0},
  { "' no encontrado!\n\n",                            StrNotFnd,   Spanish,0},
  { "Error: Formato de compresin no reconocido!\n\n", StrCFmt,     Spanish,0},
  { "Error: Incapaz de descomprimir el archivo!\n\n", StrDcmp,     Spanish,0},
  { "Script de lnea de comando demasiado largo!\n",  StrSLong,    Spanish,0},
  { "Error de comando: Memoria insuficiente!",        StrSMem,     Spanish,0},
  { "Incapaz de encontrar el archivo de ayuda del RasMol!\n", StrHFil,     Spanish,0},
  { "Tpico de ayuda requerido ambiguo!\n",           StrHTop,     Spanish,0},
  { "No hay ayuda disponible para el tpico requerido!\n", StrHNone,    Spanish,0},
  { "Error de comando: Incapaz de reabrir el archivo de ayuda!\n", StrHROpn,    Spanish,0},
  { "Constante de cadena indeterminada!\n",           StrCTerm,    Spanish,0},
  { "Constante de cadena muy larga !\n",              StrCLong,    Spanish,0},
  { "Nmero de punto flotante invlido!\n",           StrFNum,     Spanish,0},
  { "No hay tomos para centrar!\n",                  StrCent,     Spanish,0},
  { "Incapaz de copiar al portapapeles!\n",           StrCClip,    Spanish,0},
  { "No se puede abrir el archivo de puntos '",       StrDFile,    Spanish,0},
  { "Cuidado: No hay impresora disponible!\n",        StrNPrint,   Spanish,0},
  { "Clula Unidad",                                   StrUCell,    Spanish,0},
  { "Grupo Espacial",                                  StrSGroup,   Spanish,0},
  { "No hay datos de simetra del cristal\n",         StrSymm,     Spanish,0},
  { "Comando no reconocido!\n",                       StrUnrec,    Spanish,0},
  { "Cuidado: se ignora el resto del comando!\n",     StrIgnore,   Spanish,0},
  { "Cuidado: comando remoto demasiado largo!\n",     StrRCLong,   Spanish,0},
  { "No se puede abrir el archivo de script '",       StrSFile,    Spanish,0},
  { "Identificador demasiado largo!\n",               StrILong,    Spanish,0},
  { "Nombre de la Molcula . ",                        StrMolNam,   Spanish,0},
  { "Clasificacin ......... ",                        StrClass,    Spanish,0},
  { "Estructura Secundaria . ",                        StrSecSt,    Spanish,0},
  { "No Asignada\n",                                   StrNoAsmt,   Spanish,0},
  { "Registro PDB\n",                                  StrPDBRec,   Spanish,0},
  { "Calculado\n",                                     StrCalc,     Spanish,0},
  { "Cdigo de Base de Datos ",                        StrDBCode,   Spanish,0},
  { "Tcnica de Experimento  ",                        StrExpTec,   Spanish,0},
  { "Nmero de Cadenas ..... ",                        StrNumChn,   Spanish,0},
  { "Nmero de Grupos ...... ",                        StrNumGrp,   Spanish,0},
  { "Nmero de Atomos ...... ",                        StrNumAtm,   Spanish,0},
  { "Nmero de Enlaces ..... ",                        StrNumBnd,   Spanish,0},
  { "Nmero de Puentes ..... ",                        StrNumBrg,   Spanish,0},
  { "Nmero de Uniones-H ... ",                        StrNumHbd,   Spanish,0},
  { "Nmero de Hlices ..... ",                        StrNumHel,   Spanish,0},
  { "Nmero de Hebras ...... ",                        StrNumStrnd, Spanish,0},
  { "Nmero de Giros ....... ",                        StrNumTrn,   Spanish,0},
  { "Falla en la asignacin de memoria",               StrMalloc,   Spanish,0},
  { "Demasiados residuos nuevos",                      StrXSRes,    Spanish,0},
  { "Demasiados tipos de tomos nuevos",               StrXSAtyp,   Spanish,0},
#ifndef MSWIN
  { "Abrir...",                                        StrMOpen,    Spanish,0},
  { "Guardar como...",                                 StrMSaveAs,  Spanish,0},
  { "Cerrar",                                          StrMClose,   Spanish,0},
  { "",                                                StrMEmpty,   Spanish,0},
#ifdef APPLEMAC
  { "Configurar pgina",                               StrMPSetup,  Spanish,3},
  { "Imprimir",                                        StrMPrint,   Spanish,0},
  { "Quitar",                                          StrMExit,    Spanish,0},
#else
  { "Salir",                                           StrMExit,    Spanish,0},
#endif
  { "Alambre",                                         StrMWirefr,  Spanish,0},
  { "Esqueleto",                                       StrMBackbn,  Spanish,0},
  { "Bastones",                                        StrMSticks,  Spanish,3},
  { "Espacio Completo",                                StrMSpacefl, Spanish,2},
  { "Bolas & Bastones",                                StrMBallStk, Spanish,0},
  { "Cintas",                                          StrMRibbons, Spanish,0},
  { "Hebras",                                          StrMStrands, Spanish,0},
  { "Dibujo",                                          StrMCartoon, Spanish,0},
  { "Superficie Molecular",                            StrMMolSurf, Spanish,11},
  { "Monocromo",                                       StrMMonochr, Spanish,0},
  { "CPK",                                             StrMCPK,     Spanish,0},
  { "Forma",                                           StrMShapely, Spanish,0},
  { "Grupo",                                           StrMGroup,   Spanish,0},
  { "Cadena",                                          StrMChain,   Spanish,2},
  { "Temperatura",                                     StrMTemp,    Spanish,0},
  { "Estructura",                                      StrMStruct,  Spanish,3},
  { "Usuario",                                         StrMUser,    Spanish,0},
  { "Modelo",                                          StrMModel,   Spanish,2},
  { "Alt",                                             StrMAlt,     Spanish,0},
  { "Modo Aserrado",                                   StrMSlab,    Spanish,6},
  { "Hidrgenos",                                      StrMHydr,    Spanish,1},
  { "Heterotomos",                                    StrMHet,     Spanish,2},
  { "Especular",                                       StrMSpec,    Spanish,2},
  { "Sombras",                                         StrMShad,    Spanish,2},
  { "Estereo",                                         StrMStereo,  Spanish,6},
  { "Etiquetas",                                       StrMLabel,   Spanish,3},
  { "Desactivar eleccin",                             StrMPOff,    Spanish,0},
  { "Elegir identificacin",                           StrMPIdent,  Spanish,7},
  { "Elegir distancia",                                StrMPDist,   Spanish,9},
  { "Elegir monitor",                                  StrMPMon,    Spanish,13},
  { "Elegir ngulo",                                   StrMPAng,    Spanish,8},
  { "Elegir torsiones",                                StrMPTrsn,   Spanish,7},
  { "Elegir etiqueta",                                 StrMPLabl,   Spanish,10}, 
  { "Elegir centro",                                   StrMPCent,   Spanish,7},
  { "Elegir coordenadas",                              StrMPCoord,  Spanish,8},
  { "Elegir enlace",                                   StrMPBond,   Spanish,7},
  { "Girar enlace",                                    StrMRBond,   Spanish,0},
  { "Girar molcula",                                  StrMRMol,    Spanish,6},
  { "Girar todo",                                      StrMRAll,    Spanish,6},
  { "BMP ...",                                         StrMBMP,     Spanish,0},  
  { "GIF ...",                                         StrMGIF,     Spanish,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Spanish,5},  
  { "PPM ...",                                         StrMPPM,     Spanish,2},  
  { "Sun Raster...",                                   StrMSRast,   Spanish,0},  
  { "PostScript...",                                   StrMPostscr, Spanish,0},  
  { "PICT...",                                         StrMPICT,    Spanish,1},  
  { "Vector PS ...",                                   StrMVECPS,   Spanish,0},  
  { "Molscript ...",                                   StrMMSCR,    Spanish,1},  
  { "Kinemage ...",                                    StrMKine,    Spanish,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Spanish,2},  
  { "VRML ...",                                        StrMVRML,    Spanish,3},  
  { "Ramachandran ...",                                StrMRPP,     Spanish,3},  
  { "Raster3D ...",                                    StrMR3D,     Spanish,6},  
  { "RasMol Script ...",                               StrMSCR,     Spanish,8},  
  { "Acerca del RasMol...",                            StrMAbout,   Spanish,0},
  { "Manual del Usuario...",                           StrMUserM,   Spanish,0},
  { "Deshacer",                                        StrMUndo,    Spanish,0},
  { "Cortar",                                          StrMCut,     Spanish,2},
  { "Copiar",                                          StrMCopy,    Spanish,1},
  { "Pegar",                                           StrMPaste,   Spanish,0},
#ifdef APPLEMAC
  { "Borrar",                                          StrMClear,   Spanish,0},
#else
  { "Borrar",                                          StrMDelete,  Spanish,0},
#endif
  { "Seleccionar todo",                                StrMSelAll,  Spanish,0},
  { "Archivo",                                         StrMFile,    Spanish,0},
  { "Editar",                                          StrMEdit,    Spanish,0},
  { "Mostrar",                                         StrMDisplay ,Spanish,0},
  { "Colores",                                         StrMColour,  Spanish,0},
  { "Opciones",                                        StrMOpt,     Spanish,0},
  { "Configuraciones",                                 StrMSettings,Spanish,3},
  { "Exportar",                                        StrMExport,  Spanish,1},
#ifdef APPLEMAC
  { "Ventana",                                         StrMWindow,  Spanish,0},
#endif
  { "Ayuda",                                           StrMHelp,    Spanish,1},
#ifdef APPLEMAC
  { "Ventana principal",                               StrMMainWin,  Spanish,0},
  { "Lnea de comando",                                StrMCmndLin,  Spanish,0},
#endif
#else
  { "&Abrir ...",                                      StrMOpen,    Spanish,0},
  { "&Informacin",                                    StrMInfo,    Spanish,0},
  { "&Cerrar",                                         StrMClose,   Spanish,0},
  { "Im&primir",                                       StrMPrint,   Spanish,0},
  { "Con&figurar impresora",                           StrMPSetup,  Spanish,3},
  { "&Salir",                                          StrMExit,    Spanish,0},
  { "&Alambre",                                        StrMWirefr,  Spanish,0},
  { "&Esqueleto",                                      StrMBackbn,  Spanish,0},
  { "Bas&tones",                                       StrMSticks,  Spanish,3},
  { "Es&pacio Completo",                               StrMSpacefl, Spanish,2},
  { "&Bolas && Bastones",                              StrMBallStk, Spanish,0},
  { "&Cintas",                                         StrMRibbons, Spanish,0},
  { "&Hebras",                                         StrMStrands, Spanish,0},
  { "&Dibujo",                                         StrMCartoon, Spanish,0},
  { "Superficie &Molecular",                           StrMMolSurf, Spanish,11},
  { "&Monocromo",                                      StrMMonochr, Spanish,0},
  { "&CPK",                                            StrMCPK,     Spanish,0},
  { "&Forma",                                          StrMShapely, Spanish,0},
  { "&Grupo",                                          StrMGroup,   Spanish,0},
  { "Ca&dena",                                         StrMChain,   Spanish,2},
  { "&Temperatura",                                    StrMTemp,    Spanish,0},
  { "Est&ructura",                                     StrMStruct,  Spanish,3},
  { "&Usuario",                                        StrMUser,    Spanish,0},
  { "Mo&delo",                                         StrMModel,   Spanish,2},
  { "&Alt",                                            StrMAlt,     Spanish,0},
  { "Modo A&serrado",                                  StrMSlab,    Spanish,6},
  { "H&idrgenos",                                     StrMHydr,    Spanish,1},
  { "He&terotomos",                                   StrMHet,     Spanish,2},
  { "Es&pecular",                                      StrMSpec,    Spanish,2},
  { "So&mbras",                                        StrMShad,    Spanish,2},
  { "Estere&o",                                        StrMStereo,  Spanish,6},
  { "Eti&quetas",                                      StrMLabel,   Spanish,3},
  { "&Desactivar eleccin",                            StrMPOff,    Spanish,0},
  { "Elegir &identificacin",                          StrMPIdent,  Spanish,7},
  { "Elegir di&stancia",                               StrMPDist,   Spanish,9},
  { "Elegir monito&r",                                 StrMPMon,    Spanish,13},
  { "Elegir &ngulo",                                  StrMPAng,    Spanish,8},
  { "Elegir &torsiones",                               StrMPTrsn,   Spanish,7},
  { "Elegir eti&queta",                                StrMPLabl,   Spanish,10}, 
  { "Elegir &centro",                                  StrMPCent,   Spanish,7},
  { "Elegir c&oordenadas",                             StrMPCoord,  Spanish,8},
  { "Elegir &enlace",                                  StrMPBond,   Spanish,7},
  { "&Girar enlace",                                   StrMRBond,   Spanish,0},
  { "Girar &molcula",                                 StrMRMol,    Spanish,6},
  { "Girar &todo",                                     StrMRAll,    Spanish,6},
  { "&BMP ...",                                        StrMBMP,     Spanish,0},  
  { "&GIF ...",                                        StrMGIF,     Spanish,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Spanish,5},  
  { "PP&M ...",                                        StrMPPM,     Spanish,2},  
  { "&Sun Raster...",                                  StrMSRast,   Spanish,0},  
  { "&PostScript...",                                  StrMPostscr, Spanish,0},  
  { "P&ICT...",                                        StrMPICT,    Spanish,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Spanish,0},  
  { "M&olscript ...",                                  StrMMSCR,    Spanish,1},  
  { "&Kinemage ...",                                   StrMKine,    Spanish,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Spanish,2},  
  { "VRM&L ...",                                       StrMVRML,    Spanish,3},  
  { "Ram&achandran ...",                               StrMRPP,     Spanish,3},  
  { "Raster&3D ...",                                   StrMR3D,     Spanish,6},  
  { "RasMol S&cript ...",                              StrMSCR,     Spanish,8},  
  { "&Acerca del RasMol...",                           StrMAbout,   Spanish,0},
  { "&Manual del Usuario...",                          StrMUserM,   Spanish,0},
  { "&Deshacer",                                       StrMUndo,    Spanish,0},
  { "Co&rtar",                                         StrMCut,     Spanish,2},
  { "C&opiar",                                         StrMCopy,    Spanish,1},
  { "&Pegar",                                          StrMPaste,   Spanish,0},
  { "&Borrar",                                         StrMDelete,  Spanish,0},
  { "&Seleccionar todo",                               StrMSelAll,  Spanish,0},
  { "&Archivo",                                        StrMFile,    Spanish,0},
  { "&Editar",                                         StrMEdit,    Spanish,0},
  { "&Mostrar",                                        StrMDisplay ,Spanish,0},
  { "&Colores",                                        StrMColour,  Spanish,0},
  { "&Opciones",                                       StrMOpt,     Spanish,0},
  { "Con&figuraciones",                                StrMSettings,Spanish,3},
  { "E&xportar",                                       StrMExport,  Spanish,1},
  { "A&yuda",                                          StrMHelp,    Spanish,1},
#endif
  { "Nombre del archivo PDB:",                         StrPrmtPDB,  Spanish,0},
  { "Nombre del archivo de imagen:",                   StrPrmtImg,  Spanish,0},
  { "Nombre del archivo de molcula:",                 StrPrmtMol,  Spanish,0},
  { "Cuidado: ",                                       StrWarn,     Spanish,0},
  { "Cadena",                                          StrChain,    Spanish,0},
  { "Para registrarse",                                StrRegister, Spanish,0}, 
  { "Para donar",                                      StrDonate,   Spanish,0}, 
  { "No muestran este dilogo al comienzo",            StrNoShow,   Spanish,0}, 
  { "Ninguna garanta, Open Source, GPL, donaciones apreciadas", StrWarranty, Spanish, 0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Italian,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Italian,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Italian,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Italian,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Italian,0},

  { "Sintassi del comando errata!\n",                  ErrSyntax,   Italian,0},
  { "Valore del parametro troppo grande!\n",           ErrBigNum,   Italian,0},
  { "Parametro di impostazione non valido!\n",         ErrBadOpt,   Italian,0},
  { "Nome del parametro non valido!\n",                ErrParam,    Italian,0},
  { "Stringa col nome del documento richiesta!\n",     ErrFilNam,   Italian,0},
  { "Archivio della molecola caricato!\n",             ErrBadLoad,  Italian,0},
  { "Valore intero richiesto!\n",                      ErrNotNum,   Italian,0},
  { "Virgola di separazione richiesta!\n",             ErrNotSep,   Italian,0},
  { "Parentesi chiusa ']' richiesta!\n",               ErrNotBrac,  Italian,0},
  { "Colore non specificato!\n",                       ErrNoCol,    Italian,0},
  { "Colore non corretto o non specificato!\n",        ErrColour,   Italian,0},
  { "Argomento del comando non corretto!\n",           ErrBadArg,   Italian,0},
  { "Errore di sintassi nell'espressione!\n",          ErrBadExpr,  Italian,0},
  { "Parentesi chiusa ')' richiesta!\n",               ErrParen,    Italian,0},
  { "La pila dei comandi  troppo profonda!\n",        ErrScript,   Italian,0},
  { "Parentesi aperta '(' richiesta!\n",               ErrFunc,     Italian,0},
  { "Nome set atomo non valido o assente!\n",          ErrSetName,  Italian,0},
  { "Memoria insufficiente per definire set!\n",       ErrBadSet,   Italian,0},
  { "Comando disabilitato nel documento di script!\n", ErrInScrpt,  Italian,0},
  { "Comando non valido (valido solo dentro uno script)!\n", ErrOutScrpt, Italian,0},
  { "Archivio della molecola non caricato!\n",         ErrBadMolDB, Italian,0},
  { "Legame per rotazione non selezionato\n",          ErrNoBond,   Italian,0},
  { "Errore: Documento '",                             StrErrFile,  Italian,0},
  { "' non trovato!\n\n",                              StrNotFnd,   Italian,0},
  { "Errore: Formato di compressione non riconosciuto!\n\n", StrCFmt,     Italian,0},
  { "Errore: Incapace di decomprimere il documento!\n\n", StrDcmp,     Italian,0},
  { "Script di linea di comando troppo lungo!\n",      StrSLong,    Italian,0},
  { "Errore di comando: Memoria insufficiente!",       StrSMem,     Italian,0},
  { "Incapace di trovare il documento dell'aiuto di RasMol!\n", StrHFil,     Italian,0},
  { "Richiesta di argomento di aiuto ambiguo!\n",      StrHTop,     Italian,0},
  { "Argomento di aiuto non disponibile!\n",           StrHNone,    Italian,0},
  { "Errore di comando: Incapace di riaprire documento di aiuto!\n", StrHROpn,    Italian,0},
  { "Costante di stringa non terminata!\n",            StrCTerm,    Italian,0},
  { "Costante di stringa troppo lunga!\n",             StrCLong,    Italian,0},
  { "Numero in virgola mobile non valido!\n",          StrFNum,     Italian,0},
  { "Non ci sono atomi da centrare!\n",                StrCent,     Italian,0},
  { "Incapace di copiare nel blocco appunti!\n",       StrCClip,    Italian,0},
  { "Non si pu aprire un file di punti '",            StrDFile,    Italian,0},
  { "Attenzione: Stampante non disponibile!\n",        StrNPrint,   Italian,0},
  { "Cella Unitaria",                                  StrUCell,    Italian,0},
  { "Gruppo Spaziale",                                 StrSGroup,   Italian,0},
  { "Assenza dati simmetria del cristallo\n",          StrSymm,     Italian,0},
  { "Comando non riconosciuto!\n",                     StrUnrec,    Italian,0},
  { "Attenzione: si ignora la restante parte del comando!\n",StrIgnore,   Italian,0},
  { "Attenzione: comando remoto troppo lungo!\n",      StrRCLong,   Italian,0},
  { "Impossibile aprire documento di script '",        StrSFile,    Italian,0},
  { "Identificatore troppo lungo!\n",                  StrILong,    Italian,0},
  { "Nome della Molecola ... ",                        StrMolNam,   Italian,0},
  { "Classificazione ....... ",                        StrClass,    Italian,0},
  { "Struttura Secondaria .. ",                        StrSecSt,    Italian,0},
  { "Nessuna assegnazione\n",                          StrNoAsmt,   Italian,0},
  { "Registro PDB\n",                                  StrPDBRec,   Italian,0},
  { "Calcolato\n",                                     StrCalc,     Italian,0},
  { "Codice di database .... ",                        StrDBCode,   Italian,0},
  { "Tecnica sperimentale .. ",                        StrExpTec,   Italian,0},
  { "Numero di Catene ...... ",                        StrNumChn,   Italian,0},
  { "Numero di Gruppi ...... ",                        StrNumGrp,   Italian,0},
  { "Numero di Atomi ....... ",                        StrNumAtm,   Italian,0},
  { "Numero di Legami ...... ",                        StrNumBnd,   Italian,0},
  { "Numero di Ponti S-S ... ",                        StrNumBrg,   Italian,0},
  { "Numero di Legami-H .... ",                        StrNumHbd,   Italian,0},
  { "Numero di Eliche ...... ",                        StrNumHel,   Italian,0},
  { "Numero di Foglietti ... ",                        StrNumStrnd, Italian,0},
  { "Numero di Turns ....... ",                        StrNumTrn,   Italian,0},
  { "Assegnazione di memoria fallita",                 StrMalloc,   Italian,0},
  { "Troppi residui nuovi",                            StrXSRes,    Italian,0},
  { "Troppi tipi di atomi nuovi",                      StrXSAtyp,   Italian,0},
#ifndef MSWIN
  { "Apri...",                                         StrMOpen,    Italian,0},
  { "Salva col nome...",                               StrMSaveAs,  Italian,0},
  { "Chiudi",                                          StrMClose,   Italian,0},
  { "",                                                StrMEmpty,   Italian,0},
#ifdef APPLEMAC
  { "Imposta pagina",                                  StrMPSetup,  Italian,0},
  { "Stampa",                                          StrMPrint,   Italian,0},
  { "Esci",                                            StrMExit,    Italian,0},
#else
  { "Esci",                                            StrMExit,    Italian,0},
#endif
  { "Fildiferro",                                      StrMWirefr,  Italian,0},
  { "Scheletro",                                       StrMBackbn,  Italian,0},
  { "Bastoncini",                                      StrMSticks,  Italian,3},
  { "Riempimento spaziale",                            StrMSpacefl, Italian,2},
  { "Palle e Bastoncini",                              StrMBallStk, Italian,0},
  { "Nastri",                                          StrMRibbons, Italian,0},
  { "Fili",                                            StrMStrands, Italian,0},
  { "Vignetta",                                        StrMCartoon, Italian,0},
  { "Superficie Molecolare",                           StrMMolSurf, Italian,11},
  { "Monocromatico",                                   StrMMonochr, Italian,0},
  { "CPK",                                             StrMCPK,     Italian,0},
  { "Forma",                                           StrMShapely, Italian,0},
  { "Gruppo",                                          StrMGroup,   Italian,0},
  { "Catena",                                          StrMChain,   Italian,2},
  { "Temperatura",                                     StrMTemp,    Italian,0},
  { "Struttura",                                       StrMStruct,  Italian,3},
  { "Utente",                                          StrMUser,    Italian,0},
  { "Modello",                                         StrMModel,   Italian,2},
  { "Alt",                                             StrMAlt,     Italian,0},
  { "Appiattito",                                      StrMSlab,    Italian,6},
  { "Idrogeni",                                        StrMHydr,    Italian,1},
  { "Eteroatomi",                                      StrMHet,     Italian,2},
  { "Speculare",                                       StrMSpec,    Italian,2},
  { "Ombre",                                           StrMShad,    Italian,2},
  { "Stereo",                                          StrMStereo,  Italian,5},
  { "Etichette",                                       StrMLabel,   Italian,3},
  { "Elimina selezione",                               StrMPOff,    Italian,14},
  { "Identifica",                                      StrMPIdent,  Italian,0},
  { "Seleziona distanza",                              StrMPDist,   Italian,10},
  { "Seleziona monitor",                               StrMPMon,    Italian,0},
  { "Seleziona angolo",                                StrMPAng,    Italian,11},
  { "Seleziona torsione",                              StrMPTrsn,   Italian,10},
  { "Seleziona etichetta",                             StrMPLabl,   Italian,14}, 
  { "Seleziona centro",                                StrMPCent,   Italian,10},
  { "Seleziona coordinate",                            StrMPCoord,  Italian,11},
  { "Seleziona legame",                                StrMPBond,   Italian,10},
  { "Ruota legame",                                    StrMRBond,   Italian,0},
  { "Ruota molecola",                                  StrMRMol,    Italian,6},
  { "Ruota tutto",                                     StrMRAll,    Italian,6},
  { "BMP ...",                                         StrMBMP,     Italian,0},  
  { "GIF ...",                                         StrMGIF,     Italian,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Italian,5},  
  { "PPM ...",                                         StrMPPM,     Italian,2},  
  { "Sun Raster...",                                   StrMSRast,   Italian,0},  
  { "PostScript...",                                   StrMPostscr, Italian,0},  
  { "PICT...",                                         StrMPICT,    Italian,1},  
  { "Vector PS ...",                                   StrMVECPS,   Italian,0},  
  { "Molscript ...",                                   StrMMSCR,    Italian,1},  
  { "Kinemage ...",                                    StrMKine,    Italian,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Italian,2},  
  { "VRML ...",                                        StrMVRML,    Italian,3},  
  { "Ramachandran ...",                                StrMRPP,     Italian,3},  
  { "Raster3D ...",                                    StrMR3D,     Italian,6},  
  { "RasMol Script ...",                               StrMSCR,     Italian,8},  
  { "Informazioni su RasMol...",                       StrMAbout,   Italian,0},
  { "Manuale utente...",                               StrMUserM,   Italian,0},
  { "Annulla",                                         StrMUndo,    Italian,0},
  { "Taglia",                                          StrMCut,     Italian,2},
  { "Copia",                                           StrMCopy,    Italian,1},
  { "Incolla",                                         StrMPaste,   Italian,0},
#ifdef APPLEMAC
  { "Cancella",                                        StrMClear,   Italian,0},
#else
  { "Elimina",                                         StrMDelete,  Italian,0},
#endif
  { "Seleziona tutto",                                 StrMSelAll,  Italian,0},
  { "Archivio",                                        StrMFile,    Italian,0},
  { "Modifica",                                        StrMEdit,    Italian,0},
  { "Mostra",                                          StrMDisplay ,Italian,0},
  { "Colori",                                          StrMColour,  Italian,0},
  { "Opzioni",                                         StrMOpt,     Italian,0},
  { "Impostazioni",                                    StrMSettings,Italian,3},
  { "Esporta",                                         StrMExport,  Italian,1},
#ifdef APPLEMAC
  { "Finestra",                                        StrMWindow,  Italian,0},
#endif
  { "Aiuto",                                           StrMHelp,    Italian,1},
#ifdef APPLEMAC
  { "Finestra Principale",                             StrMMainWin,  Italian,0},
  { "Linea di Comando",                                StrMCmndLin,  Italian,0},
#endif
#else
  { "&Apri ...",                                       StrMOpen,    Italian,0},
  { "&Informazione",                                   StrMInfo,    Italian,0},
  { "&Chiudi",                                         StrMClose,   Italian,0},
  { "St&ampa",                                         StrMPrint,   Italian,0},
  { "Imp&osta pagina",                                 StrMPSetup,  Italian,3},
  { "&Esci",                                           StrMExit,    Italian,0},
  { "&Fildiferro",                                     StrMWirefr,  Italian,0},
  { "&Scheletro",                                      StrMBackbn,  Italian,0},
  { "Bas&toncini",                                     StrMSticks,  Italian,3},
  { "Ri&empimento spaziale",                           StrMSpacefl, Italian,2},
  { "&Palle e Bastoncini",                             StrMBallStk, Italian,0},
  { "&Nastri",                                         StrMRibbons, Italian,0},
  { "&Fili",                                           StrMStrands, Italian,0},
  { "&Vignetta",                                       StrMCartoon, Italian,0},
  { "Superficie &Molecolare",                          StrMMolSurf, Italian,11},
  { "&Monocromatico",                                  StrMMonochr, Italian,0},
  { "&CPK",                                            StrMCPK,     Italian,0},
  { "&Forma",                                          StrMShapely, Italian,0},
  { "&Gruppo",                                         StrMGroup,   Italian,0},
  { "Ca&tena",                                         StrMChain,   Italian,2},
  { "&Temperatura",                                    StrMTemp,    Italian,0},
  { "Str&uttura",                                      StrMStruct,  Italian,3},
  { "&Utente",                                         StrMUser,    Italian,0},
  { "Mo&dello",                                        StrMModel,   Italian,2},
  { "&Alt",                                            StrMAlt,     Italian,0},
  { "Appiat&tito",                                     StrMSlab,    Italian,6},
  { "I&drogeni",                                       StrMHydr,    Italian,1},
  { "Et&eroatomi",                                     StrMHet,     Italian,2},
  { "&Speculare",                                      StrMSpec,    Italian,0},
  { "Om&bre",                                          StrMShad,    Italian,2},
  { "Stere&o",                                         StrMStereo,  Italian,5},
  { "Eti&chette",                                      StrMLabel,   Italian,3},
  { "Disattiva sele&zione",                            StrMPOff,    Italian,14},
  { "&Identifica",                                     StrMPIdent,  Italian,0},
  { "Seleziona &distanza",                             StrMPDist,   Italian,10},
  { "&Seleziona monitor",                              StrMPMon,    Italian,0},
  { "Seleziona a&ngolo",                               StrMPAng,    Italian,11},
  { "Seleziona &torsione",                             StrMPTrsn,   Italian,10},
  { "Seleziona etic&hetta",                            StrMPLabl,   Italian,14}, 
  { "Seleziona &centro",                               StrMPCent,   Italian,10},
  { "Seleziona c&oordinate",                           StrMPCoord,  Italian,11},
  { "Seleziona &legame",                               StrMPBond,   Italian,10},
  { "&Ruota legame",                                   StrMRBond,   Italian,0},
  { "Ruota &molecola",                                 StrMRMol,    Italian,6},
  { "Ruota &tutto",                                    StrMRAll,    Italian,6},
  { "&BMP ...",                                        StrMBMP,     Italian,0},  
  { "&GIF ...",                                        StrMGIF,     Italian,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Italian,5},  
  { "PP&M ...",                                        StrMPPM,     Italian,2},  
  { "&Sun Raster...",                                  StrMSRast,   Italian,0},  
  { "&PostScript...",                                  StrMPostscr, Italian,0},  
  { "P&ICT...",                                        StrMPICT,    Italian,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Italian,0},  
  { "M&olscript ...",                                  StrMMSCR,    Italian,1},  
  { "&Kinemage ...",                                   StrMKine,    Italian,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Italian,2},  
  { "VRM&L ...",                                       StrMVRML,    Italian,3},  
  { "Ram&achandran ...",                               StrMRPP,     Italian,3},  
  { "Raster&3D ...",                                   StrMR3D,     Italian,6},  
  { "RasMol S&cript ...",                              StrMSCR,     Italian,8},  
  { "&Informazioni su RasMol...",                      StrMAbout,   Italian,0},
  { "&Manuale utente...",                              StrMUserM,   Italian,0},
  { "&Annulla",                                        StrMUndo,    Italian,0},
  { "Ta&glia",                                         StrMCut,     Italian,2},
  { "C&opia",                                          StrMCopy,    Italian,1},
  { "&Incolla",                                        StrMPaste,   Italian,0},
  { "&Cancella",                                       StrMDelete,  Italian,0},
  { "&Seleziona tutto",                                StrMSelAll,  Italian,0},
  { "&Archivio",                                       StrMFile,    Italian,0},
  { "&Modifica",                                       StrMEdit,    Italian,0},
  { "&Mostra",                                         StrMDisplay ,Italian,0},
  { "&Colori",                                         StrMColour,  Italian,0},
  { "&Opzioni",                                        StrMOpt,     Italian,0},
  { "Con&figurazione",                                 StrMSettings,Italian,3},
  { "E&sporta",                                        StrMExport,  Italian,1},
  { "A&iuto",                                          StrMHelp,    Italian,1},
#endif
  { "Nome documento PDB:",                             StrPrmtPDB,  Italian,0},
  { "Nome documento immagine:",                        StrPrmtImg,  Italian,0},
  { "Nome documento molecola:",                        StrPrmtMol,  Italian,0},
  { "Attenzione: ",                                    StrWarn,     Italian,0},
  { "Catena",                                          StrChain,    Italian,0},
  { "Per registrarsi",                                 StrRegister, Italian, 0},
  { "Per donare",                                      StrDonate,   Italian, 0}, 
  { "Non mostrare questo dialogo all'avviamento",      StrNoShow,   Italian, 0}, 
  { "Nessuna garanzia, Open Source, GPL, donazioni apprezzate", StrWarranty, Italian, 0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, French,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  French,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, French,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  French,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, French,0},

  { "Syntaxe de commande incorrecte!\n",               ErrSyntax,   French ,0},
  { "Valeur du paramtre trop grande!\n",              ErrBigNum,   French ,0},
  { "Valeur du paramtre incorrecte!\n",               ErrBadOpt,   French ,0},
  { "Nom du paramtre incorrect!\n",                   ErrParam,    French ,0},
  { "Un nom de fichier est attendu!\n",                ErrFilNam,   French ,0},
  { "Base de donnes de molcules charge!\n",         ErrBadLoad,  French ,0},
  { "Une valeur entire est attendue!\n",              ErrNotNum,   French ,0},
  { "Manque une virgule de sparation!\n",             ErrNotSep,   French ,0},
  { "Manque un crochet fermant ']'!\n",                ErrNotBrac,  French ,0},
  { "Aucune couleur n'a t spcifie!\n",             ErrNoCol,    French ,0},
  { "Couleur incorrecte ou inconnue!\n",               ErrColour,   French ,0},
  { "Argument de commande invalide!\n",                ErrBadArg,   French ,0},
  { "Erreur de syntaxe dans l'expression!\n",          ErrBadExpr,  French ,0},
  { "Une parenthse fermante ')' est attendue!\n",     ErrParen,    French ,0},
  { "La pile de commande est trop profonde!\n",        ErrScript,   French ,0},
  { "Une parenthse ouvrante '(' est attendue!\n",     ErrFunc,     French ,0},
  { "Nom d'atome invalide ou erron!\n",               ErrSetName,  French ,0},
  { "Mmoire insuffisante pour dfinir l'ensemble!\n", ErrBadSet,   French ,0},
  { "Commande dsactive dans le fichier de script!\n", ErrInScrpt,  French ,0},
  { "Commande invalide (le serait seulement dans un script)!\n", ErrOutScrpt, French ,0},
  { "Base de donnes de molcules non charge!\n",     ErrBadMolDB, French ,0},
  { "Liaison de tourner non choisi!\n",                ErrNoBond,   French ,0},
  { "Erreur: Fichier '",                               StrErrFile,  French ,0},
  { "' non trouv!\n\n",                               StrNotFnd,   French ,0},
  { "Erreur: Format de compression non reconnu!\n\n",  StrCFmt,     French ,0},
  { "Erreur: Impossible de dcompresser le fichier!\n\n", StrDcmp,     French ,0},
  { "Ligne de command de script trop longue!\n",       StrSLong,    French ,0},
  { "Erreur de commande: Mmoire inuffisante!\n",      StrSMem,     French ,0},
  { "Impossible de trouver le fichier d'aide sur RasMol!\n",  StrHFil,     French ,0},
  { "Requte d'aide thmatique ambige!\n",            StrHTop,     French ,0},
  { "Pas d'aide disponible sur le thme requis!\n",    StrHNone,    French ,0},
  { "Erreur de commande: Impossible de rouvrir le fichier d'aide!\n",   StrHROpn,    French ,0},
  { "Chane de caractres non termine!\n",            StrCTerm,    French ,0},
  { "Chane de caractres trop longue!\n",             StrCLong,    French ,0},
  { "Nombre  virgule flottante invalide!\n",          StrFNum,     French ,0},
  { "Aucun atome  recentrer!\n",                      StrCent,     French ,0},
  { "Impossible de copier le porte-papiers!\n",        StrCClip,    French ,0},
  { "Impossible d'ouvrir le fichier de points '",      StrDFile,    French ,0},
  { "Avertissement: Aucune imprimante disponible!\n",  StrNPrint,   French ,0},
  { "Cellule Unit",                                   StrUCell,    French ,0},
  { "Groupe Spatial",                                  StrSGroup,   French ,0},
  { "Pas de donnes de symtrie du cristal!\n",        StrSymm,     French ,0},
  { "Commande non reconnue!\n",                        StrUnrec,    French ,0},
  { "Avertissement: Reste de la commande ignore!\n",  StrIgnore,   French ,0},
  { "Avertissement: Command indirecte trop longue!\n", StrRCLong,   French ,0},
  { "Impossible d'ouvrir le fichier de script file '", StrSFile,    French ,0},
  { "Identificateur trop long!\n",                     StrILong,    French ,0},
  { "Nom de la molcule .... ",                        StrMolNam,   French ,0},
  { "Classification ........ ",                        StrClass,    French ,0},
  { "Structure Secondaire... ",                        StrSecSt,    French ,0},
  { "Non assign\n",                                   StrNoAsmt,   French ,0},
  { "Registre PDB\n",                                  StrPDBRec,   French ,0},
  { "Calcul\n",                                       StrCalc,     French ,0},
  { "Code de Base de Donnes ",                        StrDBCode,   French ,0},
  { "Technique exprim.  ... ",                        StrExpTec,   French ,0},
  { "Nombre de Chanes ..... ",                        StrNumChn,   French ,0},
  { "Nombre de Groupes ..... ",                        StrNumGrp,   French ,0},
  { "Nombre d'Atomes ....... ",                        StrNumAtm,   French ,0},
  { "Nombre de Liaisons .... ",                        StrNumBnd,   French ,0},
  { "Nombre de Ponts ....... ",                        StrNumBrg,   French ,0},
  { "Nombre de Liaisons-H .. ",                        StrNumHbd,   French ,0},
  { "Nombre d'Hlices ...... ",                        StrNumHel,   French ,0},
  { "Nombre de Tresses ..... ",                        StrNumStrnd, French ,0},
  { "Nombre de Tours ....... ",                        StrNumTrn,   French ,0},
  { "Allocation mmoire dfaillante",                  StrMalloc,   French ,0},
  { "Nouveaux rsidus trop nombreux",                  StrXSRes,    French ,0},
  { "Nouveaux type d'atomes trop nombreux",            StrXSAtyp,   French ,0},
#ifndef MSWIN
  { "Ouvrir...",                                       StrMOpen,    French ,0},
  { "Sauver sous...",                                  StrMSaveAs,  French ,0},
  { "Fermer",                                          StrMClose,   French ,0},
  { "",                                                StrMEmpty,   French ,0},
#ifdef APPLEMAC
  { "Configuration des Pages",                         StrMPSetup,  French ,0},
  { "Imprimer",                                        StrMPrint,   French ,0},
  { "Quitter",                                         StrMExit,    French ,0},
#else
  { "Terminer",                                        StrMExit,    French ,0},
#endif
  { "Fil",                                             StrMWirefr,  French ,0},
  { "Squelette",                                       StrMBackbn,  French ,0},
  { "Btons",                                          StrMSticks,  French ,0},
  { "Espace rl occup",                              StrMSpacefl, French ,0},
  { "Boules et Btons",                                StrMBallStk, French ,1},
  { "Rubans",                                          StrMRibbons, French ,0},
  { "Tresses",                                         StrMStrands, French ,0},
  { "Ebauches",                                        StrMCartoon, French ,5},
  { "Surface Molcular",                               StrMMolSurf, French ,8},
  { "Monochrome",                                      StrMMonochr, French ,0},
  { "CPK",                                             StrMCPK,     French ,0},
  { "Forme",                                           StrMShapely, French ,0},
  { "Groupe",                                          StrMGroup,   French ,0},
  { "Chane",                                          StrMChain,   French ,1},
  { "Temprature",                                     StrMTemp,    French ,0},
  { "Structure",                                       StrMStruct,  French ,0},
  { "Utilisateur",                                     StrMUser,    French ,0},
  { "Modle",                                          StrMModel,   French ,2},
  { "Alt",                                             StrMAlt,     French ,0},
  { "Vision en Coupe",                                 StrMSlab,    French ,10},
  { "Hydrognes",                                      StrMHydr,    French ,1},
  { "Htroatomes",                                    StrMHet,     French ,0},
  { "Reflets",                                         StrMSpec,    French ,0},
  { "Ombres",                                          StrMShad,    French ,0},
  { "Stro",                                          StrMStereo,  French ,0},
  { "Labels",                                          StrMLabel,   French ,0},
  { "Dsactiver Choix",                                StrMPOff,    French ,0},
  { "Activer Identification",                          StrMPIdent,  French ,8},
  { "Activer Distance",                                StrMPDist,   French ,8},
  { "Activer Moniteur",                                StrMPMon,    French ,8},
  { "Activer Angle",                                   StrMPAng,    French ,8},
  { "Activer Torsion",                                 StrMPTrsn,   French ,8},
  { "Activer Label",                                   StrMPLabl,   French ,8}, 
  { "Activer Centre",                                  StrMPCent,   French ,8},
  { "Activer Coord",                                   StrMPCoord,  French ,8},
  { "Activer Liaison",                                 StrMPBond,   French ,9},
  { "Tourner Liaison",                                 StrMRBond,   French ,10},
  { "Tourner Molcule",                                StrMRMol,    French ,9},
  { "Tourner Globalement",                             StrMRAll,    French ,8},
  { "BMP ...",                                         StrMBMP,     French ,0},  
  { "GIF ...",                                         StrMGIF,     French ,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    French ,5}, 
  { "PPM ...",                                         StrMPPM,     French ,2},  
  { "Sun Raster...",                                   StrMSRast,   French ,0},  
  { "PostScript...",                                   StrMPostscr, French ,0},  
  { "PICT...",                                         StrMPICT,    French ,1},  
  { "Vector PS ...",                                   StrMVECPS,   French ,0},  
  { "Molscript ...",                                   StrMMSCR,    French ,1},  
  { "Kinemage ...",                                    StrMKine,    French ,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  French ,2},  
  { "VRML ...",                                        StrMVRML,    French ,3},  
  { "Ramachandran ...",                                StrMRPP,     French ,3},  
  { "Raster3D ...",                                    StrMR3D,     French ,6},  
  { "RasMol Script ...",                               StrMSCR,     French ,8},  
  { "A propos de RasMol...",                           StrMAbout,   French ,0},
  { "Manual utilisateur...",                           StrMUserM,   French ,0},
  { "Annuler",                                         StrMUndo,    French ,0},
  { "Couper",                                          StrMCut,     French ,0},
  { "Copier",                                          StrMCopy,    French ,1},
  { "Coller",                                          StrMPaste,   French ,2},
#ifdef APPLEMAC
  { "Effacer",                                         StrMClear,   French ,0},
#else
  { "Dtruire",                                        StrMDelete,  French ,0},
#endif
  { "Slectionner tout",                               StrMSelAll,  French ,0},
  { "Fichier",                                         StrMFile,    French ,0},
  { "Editer",                                          StrMEdit,    French ,0},
  { "Montrer",                                         StrMDisplay, French ,0},
  { "Couleurs",                                        StrMColour,  French ,0},
  { "Options",                                         StrMOpt,     French ,0},
  { "Configuration",                                   StrMSettings,French ,3},
  { "Exporter",                                        StrMExport,  French ,1},
#ifdef APPLEMAC
  { "Fentre",                                         StrMWindow,  French ,0},
#endif
  { "Aide",                                            StrMHelp,    French ,0},
#ifdef APPLEMAC
  { "Fentre Principale",                              StrMMainWin,  French ,0},
  { "Ligne de Commande",                               StrMCmndLin,  French ,0},
#endif
#else
  { "&Ouvrir ...",                                     StrMOpen,    French ,0},
  { "&Information",                                    StrMInfo,    French ,0},
  { "&Fermer",                                         StrMClose,   French ,0},
  { "Im&primer",                                       StrMPrint,   French ,2},
  { "&Configuration des Pages",                        StrMPSetup,  French ,0},
  { "&Terminer",                                       StrMExit,    French ,0},
  { "&Fil",                                            StrMWirefr,  French ,0},
  { "&Squelette",                                      StrMBackbn,  French ,0},
  { "&Btons",                                         StrMSticks,  French ,0},
  { "&Espace rel occup",                             StrMSpacefl, French ,0},
  { "B&oules et Btons",                               StrMBallStk, French ,1},
  { "&Ribbons",                                        StrMRibbons, French ,0},
  { "&Tresses",                                        StrMStrands, French ,0},
  { "Ebauc&hes",                                       StrMCartoon, French ,5},
  { "Surface &Molcular",                              StrMMolSurf, French ,8},
  { "&Monochrome",                                     StrMMonochr, French ,0},
  { "&CPK",                                            StrMCPK,     French ,0},
  { "&Forme",                                          StrMShapely, French ,0},
  { "&Groupe",                                         StrMGroup,   French ,0},
  { "C&hane",                                         StrMChain,   French ,1},
  { "&Temprature",                                    StrMTemp,    French ,0},
  { "&Structure",                                      StrMStruct,  French ,0},
  { "&Utilisateur",                                    StrMUser,    French ,0},
  { "Mo&dle",                                         StrMModel,   French ,2},
  { "&Alt",                                            StrMAlt,     French ,0},
  { "Vision en &Coupe",                                StrMSlab,    French ,10},
  { "H&ydrognes",                                     StrMHydr,    French ,1},
  { "&Htroatomes",                                   StrMHet,     French ,0},
  { "&Reflets",                                        StrMSpec,    French ,0},
  { "&Ombres",                                         StrMShad,    French ,0},
  { "&Stro",                                         StrMStereo,  French ,0},
  { "&Labels",                                         StrMLabel,   French ,0},
  { "&Dsactiver Choix",                               StrMPOff,    French ,0},
  { "Activer &Identification",                         StrMPIdent,  French ,8},
  { "Activer &Distance",                               StrMPDist,   French ,8},
  { "Activer &Moniteur",                               StrMPMon,    French ,8},
  { "Activer &Angle",                                  StrMPAng,    French ,8},
  { "Activer &Torsion",                                StrMPTrsn,   French ,8},
  { "Activer &Label",                                  StrMPLabl,   French ,8}, 
  { "Activer &Centre",                                 StrMPCent,   French ,8},
  { "Activer &Coord",                                  StrMPCoord,  French ,8},
  { "Activer L&iaison",                                StrMPBond,   French ,9},
  { "Tourner Li&aison",                                StrMRBond,   French ,10},
  { "Tourner M&olcule",                               StrMRMol,    French ,9},
  { "Tourner &Globalement",                            StrMRAll,    French ,8},
  { "&BMP ...",                                        StrMBMP,     French ,0},  
  { "&GIF ...",                                        StrMGIF,     French ,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    French ,5},  
  { "PP&M ...",                                        StrMPPM,     French ,2},  
  { "&Sun Raster...",                                  StrMSRast,   French ,0},  
  { "&PostScript...",                                  StrMPostscr, French ,0},  
  { "P&ICT...",                                        StrMPICT,    French ,1},  
  { "&Vector PS ...",                                  StrMVECPS,   French ,0},  
  { "M&olscript ...",                                  StrMMSCR,    French ,1},  
  { "&Kinemage ...",                                   StrMKine,    French ,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  French ,2},  
  { "VRM&L ...",                                       StrMVRML,    French ,3},  
  { "Ram&achandran ...",                               StrMRPP,     French ,3},  
  { "Raster&3D ...",                                   StrMR3D,     French ,6},  
  { "RasMol S&cript ...",                              StrMSCR,     French ,8},  
  { "&A propos de RasMol...",                          StrMAbout,   French ,0},
  { "&Manual utilisateur...",                          StrMUserM,   French ,0},
  { "&Annuler",                                        StrMUndo,    French ,0},
  { "&Couper",                                         StrMCut,     French ,0},
  { "C&opier",                                         StrMCopy,    French ,1},
  { "Co&ller",                                         StrMPaste,   French ,2},
  { "&Dtruire",                                       StrMDelete,  French ,0},
  { "&Slectionner tout",                              StrMSelAll,  French ,0},
  { "&Fichier",                                        StrMFile,    French ,0},
  { "&Editer",                                         StrMEdit,    French ,0},
  { "&Montrer",                                        StrMDisplay, French ,0},
  { "&Couleurs",                                       StrMColour,  French ,0},
  { "&Options",                                        StrMOpt,     French ,0},
  { "Con&figuration",                                  StrMSettings,French ,3},
  { "E&xporter",                                       StrMExport,  French ,1},
  { "&Aide",                                           StrMHelp,    French ,0},
#endif
  { "Nom du fichier PDB:",                             StrPrmtPDB,  French ,0},
  { "Nom du fichier Image:",                           StrPrmtImg,  French ,0},
  { "Nom du fichier de Molcule:",                     StrPrmtMol,  French ,0},
  { "Avertissement: ",                                 StrWarn,     French ,0},
  { "Chane",                                          StrChain,    French ,0},
  { "S'enregistrer",                                   StrRegister, French, 0}, 
  { "Donner",                                          StrDonate,   French, 0},
  { "Ne montrez pas ce dialogue au dmarrage",         StrNoShow,   French, 0}, 
  { "Aucunes garantie, Open Source, GPL, donations apprcies", StrWarranty, French, 0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Russian,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Russian,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Russian,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Russian,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Russian,0},

  { "  !\n",                   ErrSyntax,   Russian,0},
  { "   !\n",           ErrBigNum,   Russian,0},
  { "  !\n",                 ErrBadOpt,   Russian,0},
  { "  !\n",                       ErrParam,    Russian,0},
  { "   !\n",                 ErrFilNam,   Russian,0},
  { "    !\n",             ErrBadLoad,  Russian,0},
  { "  !\n",             ErrNotNum,   Russian,0},
  { "  !\n",             ErrNotSep,   Russian,0},
  { "   ']'!\n",                ErrNotBrac,  Russian,0},
  { "   !\n",                    ErrNoCol,    Russian,0},
  { "     !\n", ErrColour,   Russian,0},
  { "  !\n",                    ErrBadArg,   Russian,0},
  { "   !\n",            ErrBadExpr,  Russian,0},
  { "   ')'!\n",                ErrParen,    Russian,0},
  { "   !\n",               ErrScript,   Russian,0},
  { "   '('!\n",                ErrFunc,     Russian,0},
  { "     !\n",   ErrSetName,  Russian,0},
  { "    !\n",   ErrBadSet,   Russian,0},
  { "    !\n",            ErrInScrpt,  Russian,0},
  { "  (   )!\n", ErrOutScrpt, Russian,0},
  { "     !\n",          ErrBadMolDB, Russian,0},
  { "    !\n",               ErrNoBond,   Russian,0},
  { ":  '",                                  StrErrFile,  Russian,0},
  { "'  !\n\n",                                StrNotFnd,   Russian,0},
  { ":   !\n\n",          StrCFmt,     Russian,0},
  { ":   !\n\n",        StrDcmp,     Russian,0},
  { "    !\n",     StrSLong,    Russian,0},
  { ":  !\n",                  StrSMem,     Russian,0},
  { "  RasMol  !\n",                StrHFil,     Russian,0},
  { "   !\n",            StrHTop,     Russian,0},
  { "     !\n",       StrHNone,    Russian,0},
  { " :    !\n", StrHROpn,    Russian,0},
  { "  !\n",            StrCTerm,    Russian,0},
  { "   !\n",          StrCLong,    Russian,0},
  { "    !\n",           StrFNum,     Russian,0},
  { "   !\n",                 StrCent,     Russian,0},
  { "    !\n",         StrCClip,    Russian,0},
  { "    '",                 StrDFile,    Russian,0},
  { ":   !\n", StrNPrint,   Russian,0},
  { "  ",                             StrUCell,    Russian,0},
  { " ",                         StrSGroup,   Russian,0},
  { "    !\n",             StrSymm,     Russian,0},
  { " !\n",                       StrUnrec,    Russian,0},
  { ":   !\n",    StrIgnore,   Russian,0},
  { ":    !\n",  StrRCLong,   Russian,0},
  { "    '",               StrSFile,    Russian,0},
  { "  !\n",                StrILong,    Russian,0},
  { " .............. ",                        StrMolNam,   Russian,0},
  { " ......... ",                        StrClass,    Russian,0},
  { "  ... ",                        StrSecSt,    Russian,0},
  { " \n",                                  StrNoAsmt,   Russian,0},
  { "  PDB\n",                             StrPDBRec,   Russian,0},
  { "\n",                                     StrCalc,     Russian,0},
  { "   ....... ",                        StrDBCode,   Russian,0},
  { "  .. ",                  StrExpTec,   Russian,0},
  { "  ...... ",                        StrNumChn,   Russian,0},
  { "  ...... ",                        StrNumGrp,   Russian,0},
  { "  ..... ",                        StrNumAtm,   Russian,0},
  { "  ..... ",                        StrNumBnd,   Russian,0},
  { " S-S  ",                        StrNumBrg,   Russian,0},
  { "    ",                  StrNumHbd,   Russian,0},
  { " - ... ",                  StrNumHel,   Russian,0},
  { " - ..... ",                  StrNumStrnd, Russian,0},
  { " - ... ",                  StrNumTrn,   Russian,0},
  { "   ",                   StrMalloc,   Russian,0},
  { "  ",                          StrXSRes,    Russian,0},
  { "    ",                StrXSAtyp,   Russian,0},
#ifndef MSWIN

  { "...",                                      StrMOpen,    Russian,0},
  { " ...",                                StrMSaveAs,  Russian,0},
  { "",                                         StrMClose,   Russian,0},
  { "",                                                StrMEmpty,   Russian,0},
#ifdef APPLEMAC

  { " ",                                StrMPSetup,  Russian,0},
  { "",                                          StrMPrint,   Russian,0},
  { "",                                           StrMExit,    Russian,0},
#else

  { "" ,                                           StrMExit,    Russian,0},
#endif

  { "",                                          StrMWirefr,  Russian,2},
  { "",                                          StrMBackbn,  Russian,0},
  { "",                                           StrMSticks,  Russian,0},
  { "-- ",                         StrMSpacefl, Russian,0},
  { "  ",                                   StrMBallStk, Russian,0},
  { "",                                           StrMRibbons, Russian,0},
  { "",                                            StrMStrands, Russian,0},
  { "",                                          StrMCartoon, Russian,0},
  { ". ",                              StrMMolSurf, Russian,0},
  { "׸-",                                     StrMMonochr, Russian,0},
  { ". ",                                    StrMCPK,     Russian,0},
  { "",                                         StrMShapely, Russian,0},
  { "",                                          StrMGroup,   Russian,0},
  { "",                                            StrMChain,   Russian,2},
  { "",                                     StrMTemp,    Russian,0},
  { "",                                       StrMStruct,  Russian,0},
  { "",                                StrMUser,    Russian,4},
  { "",                                          StrMModel,   Russian,2},
  { "",                                  StrMAlt,     Russian,1},
  { "",                                         StrMSlab,    Russian,0},
  { " H",                                         StrMHydr,    Russian,0},
  { "",                                     StrMHet,     Russian,0},
  { " ",                          StrMSpec,    Russian,0},
  { "",                                            StrMShad,    Russian,0},
  { "",                                          StrMStereo,  Russian,3},
  { "",                                         StrMLabel,   Russian,0},
  { " ",                                 StrMPOff,    Russian,0},
  { "",                                        StrMPIdent,  Russian,0},
  { "",                                      StrMPDist,   Russian,0},
  { "",                                         StrMPMon,    Russian,1},
  { "",                                            StrMPAng,    Russian,0},
  { " ",                                 StrMPTrsn,   Russian,0},
  { "",                                           StrMPLabl,   Russian,0}, 
  { " ",                                    StrMPCent,   Russian,6},
  { "",                                      StrMPCoord,  Russian,0},
  { "",                                           StrMPBond,   Russian,0},
  { " ",                                   StrMRBond,   Russian,2},
  { " ",                                StrMRMol,    Russian,10},
  { " ",                                     StrMRAll,    Russian,8},
  { "BMP ...",                                         StrMBMP,     Russian,0},  
  { "GIF ...",                                         StrMGIF,     Russian,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Russian,5},  
  { "PPM ...",                                         StrMPPM,     Russian,2},  
  { "Sun Raster...",                                   StrMSRast,   Russian,0},  
  { "PostScript...",                                   StrMPostscr, Russian,0},  
  { "PICT...",                                         StrMPICT,    Russian,1},  
  { "Vector PS ...",                                   StrMVECPS,   Russian,0},  
  { "Molscript ...",                                   StrMMSCR,    Russian,1},  
  { "Kinemage ...",                                    StrMKine,    Russian,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Russian,2},  
  { "VRML ...",                                        StrMVRML,    Russian,3},  
  { "Ramachandran ...",                                StrMRPP,     Russian,3},  
  { "Raster3D ...",                                    StrMR3D,     Russian,6},  
  { "RasMol Script ...",                               StrMSCR,     Russian,8},  
  { "  RasMol...",                           StrMAbout,   Russian,0},
  { " ...",                     StrMUserM,   Russian,0},
  { "",                                          StrMUndo,    Russian,0},
  { "",                                        StrMCut,     Russian,2},
  { "",                                      StrMCopy,    Russian,0},
  { "",                                        StrMPaste,   Russian,1},
#ifdef APPLEMAC
  { "",                                        StrMClear,   Russian,1},
#else
  { "",                                         StrMDelete,  Russian,1},
#endif  
  
  { " ",                                    StrMSelAll,  Russian,9},
  { "",                                            StrMFile,    Russian,0},
  { "",                                          StrMEdit,    Russian,0},
  { "",                                             StrMDisplay, Russian,0},
  { "",                                            StrMColour,  Russian,0},
  { "",                                           StrMOpt,     Russian,0},
  { "",                                       StrMSettings,Russian,0},
  { "",                                         StrMExport,  Russian,0},
#ifdef APPLEMAC
  { "",                                            StrMWindow,  Russian,0},
#endif
  { "",                                         StrMHelp,    Russian,5},
#ifdef APPLEMAC
  { " ",                                    StrMMainWin,  Russian,0},
  { " ",                                StrMCmndLin,  Russian,0},
#endif
#else
  { "& ...",                                    StrMOpen,    Russian,0},
  { "&",                                     StrMInfo,    Russian,0},
  { "&",                                        StrMClose,   Russian,0},
  { "&",                                         StrMPrint,   Russian,0},
  { "& ",                               StrMPSetup,  Russian,0},
  { "&",                                          StrMExit,    Russian,2},
  { "&",                                         StrMWirefr,  Russian,2},
  { "&",                                         StrMBackbn,  Russian,0},
  { "&",                                          StrMSticks,  Russian,0},
  { "&-- ",                        StrMSpacefl, Russian,0},
  { "&  ",                                  StrMBallStk, Russian,0},
  { "&",                                          StrMRibbons, Russian,0},
  { "&",                                           StrMStrands, Russian,0},
  { "&",                                         StrMCartoon, Russian,0},
  { "&. ",                             StrMMolSurf, Russian,0},
  { "&׸-",                                    StrMMonochr, Russian,0},
  { "&. ",                                   StrMCPK,     Russian,0},
  { "&",                                        StrMShapely, Russian,0},
  { "&",                                         StrMGroup,   Russian,0},
  { "&",                                           StrMChain,   Russian,0},
  { "&",                                    StrMTemp,    Russian,0},
  { "&",                                      StrMStruct,  Russian,0},
  { "&",                               StrMUser,    Russian,4},
  { "&",                                         StrMModel,   Russian,0},
  { "&",                                 StrMAlt,     Russian,1},
  { "&",                                        StrMSlab,    Russian,0},
  { "& H",                                        StrMHydr,    Russian,0},
  { "&",                                    StrMHet,     Russian,0},
  { "& ",                         StrMSpec,    Russian,0},
  { "&",                                           StrMShad,    Russian,0},
  { "&",                                         StrMStereo,  Russian,3},
  { "&",                                        StrMLabel,   Russian,0},
  { "& ",                                StrMPOff,    Russian,0},
  { "&",                                       StrMPIdent,  Russian,0},
  { "&",                                      StrMPDist,   Russian,0},
  { "&",                                        StrMPMon,    Russian,1},
  { "&",                                           StrMPAng,    Russian,0},
  { "& ",                                StrMPTrsn,   Russian,0},
  { "&",                                          StrMPLabl,   Russian,0}, 
  { " &",                                   StrMPCent,   Russian,6},
  { "&",                                     StrMPCoord,  Russian,0},
  { "&",                                          StrMPBond,   Russian,0},
  { "& ",                                  StrMRBond,   Russian,2},
  { " &",                               StrMRMol,    Russian,10},
  { " &",                                    StrMRAll,    Russian,8},
  { "&BMP ...",                                        StrMBMP,     Russian,0},  
  { "&GIF ...",                                        StrMGIF,     Russian,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Russian,5},  
  { "PP&M ...",                                        StrMPPM,     Russian,2},  
  { "&Sun Raster...",                                  StrMSRast,   Russian,0},  
  { "&PostScript...",                                  StrMPostscr, Russian,0},  
  { "P&ICT...",                                        StrMPICT,    Russian,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Russian,0},  
  { "M&olscript ...",                                  StrMMSCR,    Russian,1},  
  { "&Kinemage ...",                                   StrMKine,    Russian,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Russian,2},  
  { "VRM&L ...",                                       StrMVRML,    Russian,3},  
  { "Ram&achandran ...",                               StrMRPP,     Russian,3},  
  { "Raster&3D ...",                                   StrMR3D,     Russian,6},  
  { "RasMol S&cript ...",                              StrMSCR,     Russian,8},  
  { "&  RasMol...",                          StrMAbout,   Russian,0},
  { "& ...",                    StrMUserM,   Russian,0},
  { "&",                                         StrMUndo,    Russian,0},
  { "&",                                       StrMCut,     Russian,2},
  { "&",                                     StrMCopy,    Russian,0},
  { "&",                                       StrMPaste,   Russian,1},
  { "&",                                        StrMDelete,  Russian,1},
  { " &",                                   StrMSelAll,  Russian,0},
  { "&",                                           StrMFile,    Russian,0},
  { "&",                                         StrMEdit,    Russian,0},
  { "&",                                            StrMDisplay, Russian,0},
  { "&",                                           StrMColour,  Russian,0},
  { "&",                                          StrMOpt,     Russian,0},
  { "&",                                      StrMSettings,Russian,0},
  { "&",                                        StrMExport,  Russian,0},
  { "&",                                        StrMHelp,    Russian,5},
#endif
  { "  PDB:",                                  StrPrmtPDB,  Russian,0},
  { "  :",                              StrPrmtImg,  Russian,0},
  { "  :",                             StrPrmtMol,  Russian,0},
  { ": ",                                StrWarn,     Russian,0},
  { "",                                            StrChain,    Russian,0},
  { "",                                     StrRegister, Russian, 0},
  { "",                                   StrDonate,   Russian, 0},
  { "     ",              StrNoShow,   Russian, 0},
  { " , Open Source, GPL,  ", StrWarranty, Russian, 0},



  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Bulgarian,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Bulgarian,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Bulgarian,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Bulgarian,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Bulgarian,0},

  { "  !\n",		       ErrSyntax,   Bulgarian,0},
  { "    \n!",	       ErrBigNum,   Bulgarian,0},
  { "   !\n",	       ErrBadOpt,   Bulgarian,0},
  { "   !\n",		       ErrParam,    Bulgarian,0},
  { "    !\n",			       ErrFilNam,   Bulgarian,0},
  { "    !\n",	       ErrBadLoad,  Bulgarian,0},
  { "   !\n",			       ErrNotNum,   Bulgarian,0},
  { "  !\n",		       ErrNotSep,   Bulgarian,0},
  { "    ']'!\n", 	       ErrNotBrac,  Bulgarian,0},
  { "   !\n",			       ErrNoCol,    Bulgarian, 0},
  { "   !\n",		       ErrColour,   Bulgarian,0},
  { "  !\n",		       ErrBadArg,   Bulgarian,0},
  { "   !\n",	       ErrBadExpr,  Bulgarian,0},
  { "    ')'!\n", 	       ErrParen,    Bulgarian,0},
  { "     !\n",     ErrScript,   Bulgarian,0},
  { "    '('!\n",                 ErrFunc,     Bulgarian,0},
  { "      !\n",    ErrSetName,  Bulgarian, 0},
  { "      !\n",  ErrBadSet,   Bulgarian,0},
  { "     !\n",      ErrInScrpt,  Bulgarian,0},
  { "   (    )!\n", ErrOutScrpt, Bulgarian,0},
  { "      !\n",       ErrBadMolDB, Bulgarian,0},
  { "     !\n",	       ErrNoBond,   Bulgarian,0},
  { ":  '",				       StrErrFile,  Bulgarian,0},
  { ",   !\n\n",			       StrNotFnd,   Bulgarian,0},
  { ":    !\n\n",       StrCFmt,     Bulgarian,0},
  { ":    !\n\n",  StrDcmp,     Bulgarian,0},
  { "      !\n",      StrSLong,    Bulgarian,0},
  { ":  !\n\n",		       StrSMem,     Bulgarian,0},
  { "     e !\n\n",      StrHFil,     Bulgarian,0},
  { "   !\n",		       StrHTop,     Bulgarian,0},
  { "    !\n",		       StrHNone,    Bulgarian,0},
  { "  :     !\n", StrHROpn,    Bulgarian,0},
  { "  !\n",		       StrCTerm,    Bulgarian,0},
  { "    !\n",	       StrCLong,    Bulgarian,0},
  { "    !\n",	       StrFNum,     Bulgarian,0},
  { "   !\n",		       StrCent,     Bulgarian,0},
  { "    !\n",	       StrCClip,    Bulgarian,0},
  { "     '",	       StrDFile,    Bulgarian,0},
  { ":   !\n",	       StrNPrint,   Bulgarian,0},
  { " ",    			       StrUCell,    Bulgarian,0},
  { " ",			       StrSGroup,   Bulgarian,0},
  { "    !\n",	       StrSymm,     Bulgarian,0},
  { " !\n",			       StrUnrec,    Bulgarian,0},
  { ":     !\n",StrIgnore,   Bulgarian,0},
  { ":     !\n",StrRCLong,   Bulgarian,0},
  { "     '",       StrSFile,    Bulgarian,0},
  { "   !\n",	       StrILong,    Bulgarian,0},
  { "   ..... ",			       StrMolNam,   Bulgarian,0},
  { " .......... ",			       StrClass,    Bulgarian,0},
  { "  .... ",			       StrSecSt,    Bulgarian,0},
  { " \n",				       StrNoAsmt,   Bulgarian,0},
  { "  PDB\n",				       StrPDBRec,   Bulgarian,0},
  { "\n",				       StrCalc,     Bulgarian,0},
  { "    ..... ",			       StrDBCode,   Bulgarian,0},
  { "  ... ",		       StrExpTec,   Bulgarian,0},
  { "  ..... ",			       StrNumChn,   Bulgarian,0},
  { "  ...... ",			       StrNumGrp,   Bulgarian,0},
  { "  ...... ",			       StrNumAtm,   Bulgarian,0},
  { "  ..... ",			       StrNumBnd,   Bulgarian,0},
  { "  .... ",			       StrNumBrg,   Bulgarian,0},
  { "   . ",		       StrNumHbd,   Bulgarian,0},
  { "  .... ",			       StrNumHel,   Bulgarian,0},
  { "  ...... ",			       StrNumStrnd, Bulgarian,0},
  { "  ...... ",			       StrNumTrn,   Bulgarian,0},
  { "   !\n",		       StrMalloc,   Bulgarian,0},
  { "  !\n",			       StrXSRes,    Bulgarian,0},
  { "    !\n",	       StrXSAtyp,   Bulgarian,0},
#ifndef MSWIN
  { " ...",                                      StrMOpen,    Bulgarian,0},
  { "  ...",                                 StrMSaveAs,  Bulgarian,0},
  { "",                                         StrMClose,   Bulgarian,0},
  { "",                                                StrMEmpty,   Bulgarian,0},
#ifdef APPLEMAC
  { "  ",                             StrMPSetup,  Bulgarian,0},
  { "",                                           StrMPrint,   Bulgarian,0},
  { "",                                           StrMExit,    Bulgarian,0},
#else
  { "",                                           StrMExit,    Bulgarian,0},
#endif
  { "",                                          StrMWirefr,  Bulgarian,0},
  { "",                                         StrMBackbn,  Bulgarian,0},
  { "",                                          StrMSticks,  Bulgarian,1},
  { "-- ",                          StrMSpacefl, Bulgarian,0},
  { "  ",                                  StrMBallStk, Bulgarian,0},
  { "",                                           StrMRibbons, Bulgarian,0},
  { "",                                           StrMStrands, Bulgarian,3},
  { "",                                        StrMCartoon, Bulgarian,0},
  { ". ",                               StrMMolSurf, Bulgarian,0},
  { "-",                                      StrMMonochr, Bulgarian,0},
  { ". ",                                   StrMCPK,     Bulgarian,0},
  { "",                                           StrMShapely, Bulgarian,0},
  { "",                                           StrMGroup,   Bulgarian,0},
  { "",                                          StrMChain,   Bulgarian,1},
  { "",                                     StrMTemp,    Bulgarian,0},
  { "",                                       StrMStruct,  Bulgarian,2},
  { "",                                   StrMUser,    Bulgarian,0},
  { "",                                           StrMModel,   Bulgarian,2},
  { "",                                    StrMAlt,     Bulgarian,0},
  { "",                                         StrMSlab,    Bulgarian,0},
  { "",                                       StrMHydr,    Bulgarian,0},
  { " ",                                    StrMHet,     Bulgarian,0},
  { "",                                       StrMSpec,    Bulgarian,0},
  { "",                                           StrMShad,    Bulgarian,0},
  { "",                                          StrMStereo,  Bulgarian,3},
  { "",                                         StrMLabel,   Bulgarian,0},
  { " ",                                   StrMPOff,    Bulgarian,0},
  { "",                                             StrMPIdent,  Bulgarian,0},
  { "",                                       StrMPDist,   Bulgarian,0},
  { "",                                         StrMPMon,    Bulgarian,0},
  { "",                                            StrMPAng,    Bulgarian,0},
  { "",                                        StrMPTrsn,   Bulgarian,0},
  { "",                                          StrMPLabl,   Bulgarian,0}, 
  { "  ",                                 StrMPCent,   Bulgarian,0},
  { "",                                      StrMPCoord,  Bulgarian,0},
  { "",                                          StrMPBond,   Bulgarian,0},
  { " ",                                  StrMRBond,   Bulgarian,0},
  { " ",                                StrMRMol,    Bulgarian,10},
  { " ",                                  StrMRAll,    Bulgarian,12},
  { "BMP ...",                                         StrMBMP,     Bulgarian,0},  
  { "GIF ...",                                         StrMGIF,     Bulgarian,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Bulgarian,5},  
  { "PPM ...",                                         StrMPPM,     Bulgarian,2},  
  { "Sun Raster...",                                   StrMSRast,   Bulgarian,0},  
  { "PostScript...",                                   StrMPostscr, Bulgarian,0},  
  { "PICT...",                                         StrMPICT,    Bulgarian,1},  
  { "Vector PS ...",                                   StrMVECPS,   Bulgarian,0},  
  { "Molscript ...",                                   StrMMSCR,    Bulgarian,1},  
  { "Kinemage ...",                                    StrMKine,    Bulgarian,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Bulgarian,2},  
  { "VRML ...",                                        StrMVRML,    Bulgarian,3},  
  { "Ramachandran ...",                                StrMRPP,     Bulgarian,3},  
  { "Raster3D ...",                                    StrMR3D,     Bulgarian,6},  
  { "RasMol Script ...",                               StrMSCR,     Bulgarian,8},
  { " ...",                                    StrMAbout,   Bulgarian,0},
  { "  ...",                   StrMUserM,   Bulgarian,0},
  { "",                                           StrMUndo,    Bulgarian,0},
  { "",                                          StrMCut,     Bulgarian,1},
  { "",                                          StrMCopy,    Bulgarian,1},
  { "",                                         StrMPaste,   Bulgarian,0},
#ifdef APPLEMAC
  { "",                                         StrMClear,   Bulgarian,1},
#else
  { "",                                          StrMDelete,  Bulgarian,0},
#endif
  { " ",                                   StrMSelAll,  Bulgarian,0},
  { "",                                            StrMFile,    Bulgarian,0},
  { "",                                        StrMEdit,    Bulgarian,0},
  { "",                                          StrMDisplay, Bulgarian,0},
  { "",                                         StrMColour,  Bulgarian,0},
  { "",                                           StrMOpt,     Bulgarian,0},
  { "",                                       StrMSettings,Bulgarian,0},
  { "",                                         StrMExport,  Bulgarian,1},
#ifdef APPLEMAC
  { "",                                        StrMWindow,  Bulgarian,0},
#endif
  { "",                                           StrMHelp,    Bulgarian,0},
#ifdef APPLEMAC
  { " ",                                StrMMainWin,  Bulgarian,0},
  { " ",                                    StrMCmndLin,  Bulgarian,0},
#endif
#else
  { "& ...",                                     StrMOpen,    Bulgarian,0},
  { "&",                                     StrMInfo,    Bulgarian,0},
  { "&",                                        StrMClose,   Bulgarian,0},
  { "&",                                          StrMPrint,   Bulgarian,0},
  { "&  ",                            StrMPSetup,  Bulgarian,0},
  { "&",                                          StrMExit,    Bulgarian,2},
  { "&",                                         StrMWirefr,  Bulgarian,0},
  { "&",                                        StrMBackbn,  Bulgarian,0},
  { "&",                                         StrMSticks,  Bulgarian,1},
  { "&-- ",                         StrMSpacefl, Bulgarian,0},
  { "&  ",                                 StrMBallStk, Bulgarian,2},
  { "&",                                          StrMRibbons, Bulgarian,0},
  { "&",                                          StrMStrands, Bulgarian,0},
  { "&",                                       StrMCartoon, Bulgarian,0},
  { "&. ",                              StrMMolSurf, Bulgarian,0},
  { "&-",                                     StrMMonochr, Bulgarian,0},
  { "&. ",                                  StrMCPK,     Bulgarian,0},
  { "&",                                          StrMShapely, Bulgarian,0},
  { "&",                                          StrMGroup,   Bulgarian,0},
  { "&",                                         StrMChain,   Bulgarian,1},
  { "&",                                    StrMTemp,    Bulgarian,0},
  { "&",                                      StrMStruct,  Bulgarian,2},
  { "&",                                  StrMUser,    Bulgarian,0},
  { "&",                                          StrMModel,   Bulgarian,2},
  { "&",                                   StrMAlt,     Bulgarian,0},
  { "&",                                        StrMSlab,    Bulgarian,0},
  { "&",                                      StrMHydr,    Bulgarian,0},
  { "& ",                                   StrMHet,     Bulgarian,0},
  { "&",                                      StrMSpec,    Bulgarian,0},
  { "&",                                          StrMShad,    Bulgarian,1},
  { "&",                                         StrMStereo,  Bulgarian,1},
  { "&",                                        StrMLabel,   Bulgarian,0},
  { "& ",                                  StrMPOff,    Bulgarian,0},
  { "&",                                            StrMPIdent,  Bulgarian,1},
  { "&",                                      StrMPDist,   Bulgarian,0},
  { "&",                                        StrMPMon,    Bulgarian,1},
  { "&",                                           StrMPAng,    Bulgarian,0},
  { "&",                                       StrMPTrsn,   Bulgarian,1},
  { "&",                                         StrMPLabl,   Bulgarian,0}, 
  { "&  ",                                StrMPCent,   Bulgarian,2},
  { "&",                                     StrMPCoord,  Bulgarian,0},
  { "&",                                         StrMPBond,   Bulgarian,0},
  { "& ",                                 StrMRBond,   Bulgarian,0},
  { " &",                               StrMRMol,    Bulgarian,10},
  { " &",                                 StrMRAll,    Bulgarian,12},
  { "&BMP ...",                                        StrMBMP,     Bulgarian,0},  
  { "&GIF ...",                                        StrMGIF,     Bulgarian,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Bulgarian,5}, 
  { "PP&M ...",                                        StrMPPM,     Bulgarian,2},  
  { "&Sun Raster...",                                  StrMSRast,   Bulgarian,0},  
  { "&PostScript...",                                  StrMPostscr, Bulgarian,0},  
  { "P&ICT...",                                        StrMPICT,    Bulgarian,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Bulgarian,0},  
  { "M&olscript ...",                                  StrMMSCR,    Bulgarian,1},  
  { "&Kinemage ...",                                   StrMKine,    Bulgarian,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Bulgarian,2},  
  { "VRM&L ...",                                       StrMVRML,    Bulgarian,3},  
  { "Ram&achandran ...",                               StrMRPP,     Bulgarian,3},  
  { "Raster&3D ...",                                   StrMR3D,     Bulgarian,6},  
  { "RasMol S&cript ...",                              StrMSCR,     Bulgarian,8},  
  { "& ...",                                   StrMAbout,   Bulgarian,0},
  { "&  ...",                  StrMUserM,   Bulgarian,0},
  { "&",                                          StrMUndo,    Bulgarian,0},
  { "&",                                         StrMCut,     Bulgarian,1},
  { "&",                                        StrMCopy,    Bulgarian,0},
  { "&",                                        StrMPaste,   Bulgarian,1},
  { "&",                                         StrMDelete,  Bulgarian,1},
  { "& ",                                  StrMSelAll,  Bulgarian,0},
  { "&",                                           StrMFile,    Bulgarian,0},
  { "&",                                       StrMEdit,    Bulgarian,0},
  { "&",                                         StrMDisplay, Bulgarian,0},
  { "&",                                        StrMColour,  Bulgarian,0},
  { "&",                                          StrMOpt,     Bulgarian,0},
  { "&",                                      StrMSettings,Bulgarian,0},
  { "&",                                        StrMExport,  Bulgarian,1},
  { "&",                                          StrMHelp,    Bulgarian,0},
#endif
  { "  PDB :",                                StrPrmtPDB,  Bulgarian,0},
  { "    :",                  StrPrmtImg,  Bulgarian,0},
  { "    :",                     StrPrmtMol,  Bulgarian,0},
  { ": ",                                      StrWarn,     Bulgarian,0},
  { "",                                          StrChain,    Bulgarian,0},
  { "",                                     StrRegister, Bulgarian, 0},
  { "",                                        StrDonate,   Bulgarian, 0},
  { "     ",              StrNoShow,   Bulgarian, 0},
  { " , Open Source, GPL,    ", StrWarranty, Bulgarian, 0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Chinese,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Chinese,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Chinese,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Chinese,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Chinese,0},

  { "ָЧ﷨!\n",                                   ErrSyntax,   Chinese,0},
  { "ֵ̫!\n",                                     ErrBigNum,  Chinese,0},
  { "Ч趨!\n",                                   ErrBadOpt,   Chinese,0},
  { "Ч!\n",                                   ErrParam,    Chinese,0},
  { "ļϵ!\n",                                ErrFilNam,   Chinese,0},
  { "װطݿ!\n",                                 ErrBadLoad,  Chinese,0},
  { "Ԥֵ!\n",                                     ErrNotNum,   Chinese,0},
  { "ŷ붪ʧ!\n",                                   ErrNotSep,   Chinese,0},
  { "ر']'!\n",                                ErrNotBrac,  Chinese,0},
  { "ûָɫ!\n",                                   ErrNoCol,    Chinese,0},
  { "ȷɫ!\n",                              ErrColour,   Chinese,0},
  { "ָЧ˵!\n",                                 ErrBadArg,   Chinese,0},
  { "﷨!\n",                                 ErrBadExpr,  Chinese,0},
  { "ر')'!\n",                                ErrParen,    Chinese,0},
  { "űָջ̫!\n",                                  ErrScript,   Chinese,0},
  { "'('!\n",                                  ErrFunc,     Chinese,0},
  { "Чʧԭ!\n",                             ErrSetName,  Chinese,0},
  { "ڴ治ȷ涨!\n",                                ErrBadSet,   Chinese,0},
  { "ڽűļɥʧ!\n",                         ErrInScrpt,  Chinese,0},
  { "ָЧ(һűЧ)!\n",                      ErrOutScrpt, Chinese,0},
  { "δװݿ⣡\n",                                 ErrBadMolDB, Chinese,0},
  { "תѭĻѧûбѡ!\n",                        ErrNoBond,   Chinese,0},
  { ":ļ '",                                       StrErrFile,  Chinese,0},
  { "' ûҵ!!\n\n",                                  StrNotFnd,   Chinese,0},
  { ":δѹʽ!\n\n",                             StrCFmt,     Chinese,0},
  { ":޷ѹ!\n\n",                           StrDcmp,   Chinese,0},
  { "űָ̫!\n",                                  StrSLong,    Chinese,0},
  { "ָӴ:ڴ治!\n",                               StrSMem,     Chinese,0},
  { "ҲRasMolļ\n",                           StrHFil,     Chinese,0},
  { "\n",                               StrHTop,     Chinese,0},
  { "ûпеİ\n",                          StrHNone,    Chinese,0},
  { "ָӴ:޷򿪰ļ!\n",                        StrHROpn,    Chinese,0},
  { "޷ֹ\n",                                 StrCTerm,   Chinese,0},
  { "̫\n",                                    StrCLong,    Chinese,0},
  { "Ч!\n",                                   StrFNum,     Chinese,0},
  { "ûеĵԭӣ\n",                               StrCent,     Chinese,0},
  { "޷!\n",                                StrCClip,    Chinese,0},
  { "ܴԲļ'",                                  StrDFile,    Chinese,0},
  { "ע:ûʺϵĴӡ\n",                           StrNPrint,   Chinese,0},
  { "Ԫϸ",                                         StrUCell,    Chinese,0},
  { "ռȺ",                                           StrSGroup,   Chinese,0},
  { "ûоԳݣ\n",                              StrSymm,     Chinese,0},
  { "δָ!\n",                                      StrUnrec,    Chinese,0},
  { "ע:ʣָӣ\n",                              StrIgnore,   Chinese,0},
  { "ע:Զָ̫!\n",                               StrRCLong,   Chinese,0},
  { "ֵܴ '",                                 StrSFile,    Chinese,0},
  { "ʶ!\n",                                     StrILong,    Chinese,0},
  { " ......... ",                               StrMolNam,   Chinese,0},
  { " ........ ",                                   StrClass,    Chinese,0},
  { "ṹ ... ",                                    StrSecSt,    Chinese,0},
  { "ת \n",                                        StrNoAsmt,   Chinese,0},
  { "PDBݼ¼\n",                                    StrPDBRec,   Chinese,0},
  { "\n",                                           StrCalc,     Chinese,0},
  { "ݿ ......... ",                             StrDBCode,   Chinese,0},
  { "ʵ鼼 .. ",                                     StrExpTec,   Chinese,0},
  { "...... ",                                  StrNumChn,   Chinese,0},
  { "Ⱥ...... ",                                  StrNumGrp,   Chinese,0},
  { "ԭӵ....... ",                                StrNumAtm,   Chinese,0},
  { "ѧ ....... ",                             StrNumBnd,  Chinese,0},
  { "ż..... ",                                  StrNumBrg,   Chinese,0},
  { "Hѧ ..... ",                              StrNumHbd,   Chinese,0},
  { " ..... ",                                 StrNumHel,   Chinese,0},
  { "ά ..... ",                               StrNumStrnd, Chinese,0},
  { "ת ....... ",                            StrNumTrn,   Chinese,0},
  { "ڴʧ",                                      StrMalloc,   Chinese,0},
  { "̫µĲ",                                      StrXSRes,    Chinese,0},
  { "̫µԭ",                                   StrXSAtyp,   Chinese,0},
#ifndef MSWIN
  { "...",                                         StrMOpen,    Chinese,0},
  { "浽...",                                       StrMSaveAs,  Chinese,0},
  { "ر",                                            StrMClose,   Chinese,0},
  { "",                                                StrMEmpty,   Chinese,0},
#ifdef APPLEMAC
  { "ҳ",                                        StrMPSetup,  Chinese,0},
  { "ӡ",                                            StrMPrint,   Chinese,0},
  { "˳",                                            StrMExit,    Chinese,0},
#else
  { "˳",                                            StrMExit,    Chinese,0},
#endif
  { "߿",                                            StrMWirefr,  Chinese,0},
  { "",                                            StrMBackbn,  Chinese,0},
  { "֦",                                            StrMSticks,  Chinese,1},
  { "ռ",                                        StrMSpacefl, Chinese,0},
  { "κ֦״",                                      StrMBallStk, Chinese,0},
  { "ϵ",                                            StrMRibbons, Chinese,0},
  { "ά",                                            StrMStrands, Chinese,3},
  { "ͼ",                                            StrMCartoon, Chinese,0},
  { "ӱ",                                        StrMMolSurf, Chinese,0},
  { "ɫ",                                            StrMMonochr, Chinese,0},
  { "CPK",                                             StrMCPK,     Chinese,0},
  { "",                                         StrMShapely, Chinese,0},
  { "Ⱥ",                                              StrMGroup,   Chinese,0},
  { "",                                              StrMChain,   Chinese,1},
  { "¶",                                            StrMTemp,    Chinese,0},
  { "ṹ",                                            StrMStruct,  Chinese,2},
  { "û",                                            StrMUser,    Chinese,0},
  { "ģ",                                            StrMModel,   Chinese,2},
  { "Alt",                                            StrMAlt,     Chinese,0},
  { "ƽģʽ",                                        StrMSlab,    Chinese,0},
  { "",                                              StrMHydr,    Chinese,1},
  { "ԭ",                                        StrMHet,     Chinese,2},
  { "",                                            StrMSpec,    Chinese,1},
  { "Ӱ",                                            StrMShad,    Chinese,1},
  { "",                                          StrMStereo,  Chinese,5},
  { "ǩ",                                            StrMLabel,   Chinese,0},
  { "ѡ",                                            StrMPOff,    Chinese,5},
  { "",                                            StrMPIdent,  Chinese,5},
  { "ѡ",                                        StrMPDist,   Chinese,5},
  { "ѡ",                                      StrMPMon,    Chinese,0},
  { "ѡǶ",                                        StrMPAng,    Chinese,5},
  { "ѡת",                                        StrMPTrsn,   Chinese,5},
  { "ѡǩ",                                        StrMPLabl,   Chinese,5}, 
  { "ѡ",                                        StrMPCent,   Chinese,5},
  { "ѡ",                                        StrMPCoord,  Chinese,6},
  { "ѡѧ",                                      StrMPBond,   Chinese,5},
  { "ѧֻ",                                      StrMRBond,   Chinese,0},
  { "Ħֻ",                                        StrMRMol,    Chinese,7},
  { "ȫֻ",                                        StrMRAll,    Chinese,7},
  { "BMP ...",                                         StrMBMP,     Chinese,0},  
  { "GIF ...",                                         StrMGIF,     Chinese,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Chinese,5},  
  { "PPM ...",                                         StrMPPM,     Chinese,2},  
  { "̫...",                                      StrMSRast,   Chinese,0},  
  { "...",                                         StrMPostscr, Chinese,0},  
  { "PICT...",                                         StrMPICT,    Chinese,1},  
  { "ʸ PS ...",                                     StrMVECPS,   Chinese,0},  
  { "Molscript ...",                                   StrMMSCR,    Chinese,1},  
  { "Kinemage ...",                                    StrMKine,    Chinese,0},  
  { "POV 3 ...",                                   StrMPOVRAY,  Chinese,2},  
  { "ʵģ ...",                              StrMVRML,    Chinese,3},  
  { "Ramachandran ...",                                StrMRPP,     Chinese,3},  
  { "3D ...",                                      StrMR3D,     Chinese,6},  
  { "RasMol ĸ ...",                                 StrMSCR,     Chinese,8},  
  { " RasMol...",                                  StrMAbout,   Chinese,0},
  { "ûֲ...",                                      StrMUserM,   Chinese,0},
  { "",                                            StrMUndo,    Chinese,0},
  { "",                                            StrMCut,     Chinese,1},
  { "",                                            StrMCopy,    Chinese,1},
  { "ճ",                                            StrMPaste,   Chinese,0},
#ifdef APPLEMAC
  { "",                                            StrMClear,   Chinese,1},
#else
  { "ɾ",                                            StrMDelete,  Chinese,0},
#endif
  { "ȫѡ",                                            StrMSelAll,  Chinese,0},
  { "ļ",                                            StrMFile,    Chinese,0},
  { "༭",                                            StrMEdit,    Chinese,0},
  { "չʾ",                                            StrMDisplay, Chinese,0},
  { "ɫ",                                            StrMColour,  Chinese,0},
  { "",                                            StrMOpt,     Chinese,0},
  { "",                                            StrMSettings,Chinese,0},
  { "",                                            StrMExport,  Chinese,1},
#ifdef APPLEMAC
  { "",                                            StrMWindow,  Chinese,0},
#endif
  { "",                                            StrMHelp,    Chinese,0},
#ifdef APPLEMAC
  { "",                                          StrMMainWin,  Chinese,0},
  { "",                                          StrMCmndLin,  Chinese,0},
#endif
#else
  { " (&O)",                                       StrMOpen,    Chinese,0},
  { "Ϣ (&I)",                                       StrMInfo,    Chinese,0},
  { "ر (&C)",                                       StrMClose,   Chinese,0},
  { "ӡ (&P)",                                       StrMPrint,   Chinese,0},
  { "ӡ (&R)",                                    StrMPSetup,  Chinese,0},
  { "˳ (&E)",                                       StrMExit,    Chinese,0},
  { "߿ (&W)",                                       StrMWirefr,  Chinese,0},
  { "(&M)",                                        StrMBackbn,  Chinese,0},
  { "֦ (&B)",                                       StrMSticks,  Chinese,1},
  { "ռ (&S)",                                   StrMSpacefl, Chinese,0},
  { "κ֦״ (&H)",                                 StrMBallStk, Chinese,0},
  { "ϵ (&R)",                                       StrMRibbons, Chinese,0},
  { "ά (&T)",                                       StrMStrands, Chinese,3},
  { "ͼ (&C)",                                       StrMCartoon, Chinese,0},
  { "ӱ (&M)",                                   StrMMolSurf, Chinese,0},
  { "ɫ (&M)",                                       StrMMonochr, Chinese,0},
  { "&CPK",                                            StrMCPK,     Chinese,0},
  { " (&H)",                                       StrMShapely, Chinese,0},
  { "Ⱥ (&G)",                                         StrMGroup,   Chinese,0},
  { " (&C)",                                         StrMChain,   Chinese,1},
  { "¶ (&T)",                                       StrMTemp,    Chinese,0},
  { "ṹ (&S)",                                       StrMStruct,  Chinese,2},
  { "û (&U)",                                       StrMUser,    Chinese,0},
  { "ģ (&D)",                                       StrMModel,   Chinese,2},
  { "ѡ (&A)",                                       StrMAlt,     Chinese,0},
  { "ƽģʽ (&P)",                                   StrMSlab,    Chinese,0},
  { " (&H)",                                         StrMHydr,    Chinese,1},
  { "ԭ (&N)",                                   StrMHet,     Chinese,2},
  { " (&T)",                                       StrMSpec,    Chinese,1},
  { "Ӱ (&D)",                                       StrMShad,    Chinese,1},
  { " (&S)",                                     StrMStereo,  Chinese,5},
  { "ǩ (&L)",                                       StrMLabel,   Chinese,0},
  { "ѡ (&O)",                                       StrMPOff,    Chinese,5},
  { " (&I)",                                       StrMPIdent,  Chinese,5},
  { "ѡ (&D)",                                   StrMPDist,   Chinese,5},
  { "ѡ (&S)",                                 StrMPMon,    Chinese,0},
  { "ѡǶ (&A)",                                   StrMPAng,    Chinese,5},
  { "ѡת (&T)",                                   StrMPTrsn,   Chinese,5},
  { "ѡǩ (&L)",                                   StrMPLabl,   Chinese,5}, 
  { "ѡ (&C)",                                   StrMPCent,   Chinese,5},
  { "ѡ (&X)",                                   StrMPCoord,  Chinese,6},
  { "ѡѧ (&B)",                                 StrMPBond,   Chinese,5},
  { "ѧֻ (&R)",                                 StrMRBond,   Chinese,0},
  { "Ħֻ (&M)",                                   StrMRMol,    Chinese,7},
  { "ȫֻ (&H)",                                   StrMRAll,    Chinese,7},
  { "&BMP ...",                                        StrMBMP,     Chinese,0},  
  { "&GIF ...",                                        StrMGIF,     Chinese,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Chinese,5},  
  { "PP&M ...",                                        StrMPPM,     Chinese,2},  
  { "̫(&S)...",                                  StrMSRast,   Chinese,0},  
  { " (&P)...",                                    StrMPostscr, Chinese,0},  
  { "P&ICT...",                                        StrMPICT,    Chinese,1},  
  { "ʸPS (&V)...",                                  StrMVECPS,   Chinese,0},  
  { "M&olscript ...",                                  StrMMSCR,    Chinese,1},  
  { "&Kinemage ...",                                   StrMKine,    Chinese,0},  
  { "POV3(&V)...",                                 StrMPOVRAY,  Chinese,2},  
  { "ʵģ (&L)",                              StrMVRML,    Chinese,3},  
  { "Ram&achandran ...",                               StrMRPP,     Chinese,3},  
  { "3D(&3) ...",                                  StrMR3D,     Chinese,6},  
  { "RasMolĸ (&c) ...",                             StrMSCR,     Chinese,8},  
  { "RasMol (&A)...",                               StrMAbout,   Chinese,0},
  { "ûֲ  (&M)...",                                 StrMUserM,   Chinese,0},
  { " (&Z)",                                       StrMUndo,    Chinese,0},
  { " (&X)",                                       StrMCut,     Chinese,1},
  { " (&C)",                                       StrMCopy,    Chinese,1},
  { "ճ (&V)",                                       StrMPaste,   Chinese,0},
  { "ɾ (&D)",                                       StrMDelete,  Chinese,0},
  { "ȫѡ (&S)",                                       StrMSelAll,  Chinese,0},
  { "ļ (&F)",                                       StrMFile,    Chinese,0},
  { "༭ (&E)",                                       StrMEdit,    Chinese,0},
  { "չʾ (&D)",                                       StrMDisplay, Chinese,0},
  { "ɫ (&C)",                                       StrMColour,  Chinese,0},
  { " (&O)",                                       StrMOpt,     Chinese,0},
  { " (&S",                                        StrMSettings,Chinese,0},
  { " (&X)",                                       StrMExport,  Chinese,1},
  { " (&H)",                                       StrMHelp,    Chinese,0},
#endif
  { "PDBļ:",                                      StrPrmtPDB,  Chinese,0},
  { "ͼļƣ",                                     StrPrmtImg,  Chinese,0},
  { "ļƣ",                                     StrPrmtMol,  Chinese,0},
  { "ע: ",                                           StrWarn,     Chinese,0},
  { "ʽṹ",                                         StrChain,    Chinese,0},
  { "ע",                                            StrRegister, Chinese,0},
  { "",                                            StrDonate,   Chinese,0},
  { "ҪԻ",                        StrNoShow,   Chinese,0},
  { "ޱޣԴ룬ͨù֤",    StrWarranty, Chinese,0},
  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Japanese,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Japanese,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Japanese,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Japanese,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Japanese,0},

  { "ޥɤʸˡŬڤǤ!\n",                   ErrSyntax,   Japanese,0},
  { "ѥ᡼礭ޤ!\n",                        ErrBigNum,   Japanese,0},
  { "ѥ᡼꤬ŬڤǤ!\n",                    ErrBadOpt,   Japanese,0},
  { "ѥ᡼̾ŬڤǤ!\n",                        ErrParam,    Japanese,0},
  { "ե̾򼨤ʸ󤬤ޤ!\n",                 ErrFilNam,  Japanese,0},
  { "ʬҹ¤ǡ١ɤߤޤ!\n",                 ErrBadLoad,  Japanese,0},
  { "ͤꤹɬפޤ!\n",                     ErrNotNum,   Japanese,0},
  { "ڤʥޡˤޤ! \n",                     ErrNotSep,   Japanese,0},
  { "å ']' ޤޤ!\n",                 ErrNotBrac,  Japanese,0},
  { "ꤵƤޤ!\n",                           ErrNoCol,    Japanese,0},
  { "λ꤬ŬڤǤ!\n",                             ErrColour,   Japanese,0},
  { "ޥɤΰŬڤǤ!\n",                   ErrBadArg,   Japanese,0},
  { "ɽ˸꤬ޤ!\n",                         ErrBadExpr,  Japanese,0},
  { "å ')' ޤ!\n",                       ErrParen,    Japanese,0},
  { "ץȤʣޤ!\n",                         ErrScript,   Japanese,0},
  { "å '(' ޤ!\n",                        ErrFunc,     Japanese,0}, 
  { "Ĥ̾ŬڤǤ!\n",                         ErrSetName,  Japanese,0},
  { "Ĥ뤿ɬפʥ꡼ݤǤޤ!\n",  ErrBadSet,   Japanese,0},
  { "ץȥեǤϻȤʤޥɤޤ!\n",     ErrInScrpt,  Japanese,0},
  { "ץȥեǤȤʤޥɤǤ!\n",         ErrOutScrpt, Japanese,0},
  { "ʬҹ¤ǡ١ɤ߹ޤ!\n",              ErrBadMolDB, Japanese,0},
  { "žΤη礬ꤵƤޤ!\n",                ErrNoBond,   Japanese,0},
  { "顼: ե '",                                 StrErrFile,  Japanese,0},
  { "'Ĥޤ!\n\n",                             StrNotFnd,   Japanese,0},
  { "顼: եΰ̷Ǥ!\n\n",             StrCFmt,     Japanese,0},
  { "顼: ̤줿եŸǤޤ!\n\n",        StrDcmp,     Japanese,0},
  { "ץȤΣԤĹޤ!\n",                      StrSLong,    Japanese,0},
  { "ޥɥ顼: ꡼­ޤ!\n",               StrSMem,     Japanese,0},
  { "RasMolΥإץե뤬Ĥޤ!\n",             StrHFil,     Japanese,0},
  { "إץեˤʤΥȥԥåꤷޤ!\n",    StrHTop,     Japanese,0},
  { "ꤵ줿ȥԥåˤϥ饤إפޤ!\n",  StrHNone,    Japanese,0},
  { "ޥɥ顼: إץե򳫤ȤǤޤ!\n",  StrHROpn,    Japanese,0},
  { "ʸĤƤޤ\n",                       StrCTerm,    Japanese,0},
  { "ʸĹޤ!\n",                             StrCLong,    Japanese,0},
  { "͡ʾˤɽŬڤǤ!\n",                   StrFNum,     Japanese,0},
  { "濴֤Ҥޤ!\n",                        StrCent,     Japanese,0},
  { "åץܡɤ˥ԡǤޤ!\n",                   StrCClip,    Japanese,0},
  { "ʥɥåȡ˥ե򳫤ȤǤޤ: '",         StrDFile,    Japanese,0},
  { ": ץ󥿡ꤵƤޤ!\n",               StrNPrint,   Japanese,0},
  { "ñ̳ʻ",                                         StrUCell,    Japanese,0},
  { "ַ",                                           StrSGroup,   Japanese,0},
  { "뾽оǤ!\n",                           StrSymm,     Japanese,0},
  { "ޥɤ̣Ǥ!\n",                           StrUnrec,    Japanese,0},
  { ": ĤΥޥɤ̵뤷ޤ!\n",                  StrIgnore,   Japanese,0},
  { ": ⡼ȥޥɤĹޤ!\n",                 StrRCLong,   Japanese,0},
  { "ץȥե򳫤ȤǤޤ:'",             StrSFile,    Japanese,0},
  { "̻ҤĹޤ!\n",                               StrILong,    Japanese,0},
  { "ʬ̾ ............ ",                                StrMolNam,   Japanese,0},
  { "ʬ .............. ",                                  StrClass,    Japanese,0},
  { "󼡹¤... ",                                     StrSecSt,    Japanese,0},
  { "󤵤Ƥޤ\n",                            StrNoAsmt,   Japanese,0},
  { "PDBǡΥ쥳ɤˤ\n",                         StrPDBRec,   Japanese,0},
  { "׻ˤ\n",                                      StrCalc,     Japanese,0},
  { "ֹ ........ ",                             StrDBCode,   Japanese,0},
  { "¸ˡ .......... ",                                     StrExpTec,   Japanese,0},
  { "线ο .......... ",                                StrNumChn,   Japanese,0},
  { "롼פο ...... ",                               StrNumGrp,   Japanese,0},
  { "Ҥο .......... ",                                StrNumAtm,   Japanese,0},
  { "ο .......... ",                                StrNumBnd,   Japanese,0},
  { "S-Sο ....... ",                               StrNumBrg,   Japanese,0},
  { "Ƿο ...... ",                             StrNumHbd,   Japanese,0},
  { "إåο .... ",                             StrNumHel,   Japanese,0},
  { "ȥɤο .... ",                             StrNumStrnd, Japanese,0},
  { "ο ........ ",                               StrNumTrn,   Japanese,0},
  { "꡼γݤ˼Ԥޤ",                         StrMalloc,   Japanese,0},
  { "Ĵμब¿ޤ",                              StrXSRes,    Japanese,0},
  { "Ҥμब¿ޤ",                              StrXSAtyp,   Japanese,0},
#ifndef MSWIN
  { "...",                                         StrMOpen,    Japanese,0},
  { "̾¸...",                                      StrMSaveAs,  Japanese,0},
  { "Ĥ",                                           StrMClose,   Japanese,0},
  { "",                                                StrMEmpty,   Japanese,0},
#ifdef APPLEMAC
  { "ڡ",                                      StrMPSetup,  Japanese,0},
  { "",                                           StrMPrint,   Japanese,0},
  { "λ",                                            StrMExit,    Japanese,0},
#else
  { "λ",                                            StrMExit,    Japanese,0},
#endif
  { "磻䡼ե졼",                                    StrMWirefr,  Japanese,0},
  { "线",                                              StrMBackbn,  Japanese,0},
  { "ƥå",                                         StrMSticks,  Japanese,1},
  { "ֽŶǥ",                                      StrMSpacefl, Japanese,0},
  { "",                                              StrMBallStk, Japanese,0},
  { "ܥ",                                            StrMRibbons, Japanese,0},
  { "ȥ",                                         StrMStrands, Japanese,3},
  { "ȥ",                                        StrMCartoon, Japanese,0},
  { "ʬɽ",                                           StrMMolSurf, Japanese,0},
  { "",                                            StrMMonochr, Japanese,0},
  { "CPKʥ顼",                                             StrMCPK,     Japanese,0},
  { "",                                              StrMShapely, Japanese,0},
  { "롼",                                         StrMGroup,   Japanese,0},
  { "",                                              StrMChain,   Japanese,1},
  { "",                                            StrMTemp,    Japanese,0},
  { "¤",                                            StrMStruct,  Japanese,2},
  { "桼",                                         StrMUser,    Japanese,0},
  { "ǥ",                                           StrMModel,   Japanese,2},
  { "Ĵ¤",                                             StrMAlt,     Japanese,0},
  { "֥⡼",                                     StrMSlab,    Japanese,0},
  { "Ǹ",                                         StrMHydr,    Japanese,1},
  { "إƥ",                                       StrMHet,     Japanese,2},
  { "",                                            StrMSpec,    Japanese,1},
  { "",                                              StrMShad,    Japanese,1},
  { "ƥ쥪",                                         StrMStereo,  Japanese,5},
  { "٥",                                          StrMLabel,   Japanese,0},
  { "",                                          StrMPOff,    Japanese,5},
  { "򤵤줿Τɽ",                             StrMPIdent,  Japanese,5},
  { "Υ¬",                                     StrMPDist,   Japanese,5},
  { "Υɽ",                                     StrMPMon,    Japanese,0},
  { "٤¬",                                     StrMPAng,    Japanese,5},
  { "̳ѤϤ",                                  StrMPTrsn,   Japanese,5},
  { "٥դ",                                  StrMPLabl,   Japanese,5}, 
  { "濴",                                     StrMPCent,   Japanese,5},
  { "ɸɽ",                                     StrMPCoord,  Japanese,6},
  { "",                                     StrMPBond,   Japanese,5},
  { "ž",                                     StrMRBond,   Japanese,0},
  { "ʬҤž",                                     StrMRMol,    Japanese,7},
  { "٤Ƥž",                                   StrMRAll,    Japanese,7},
  { "BMP ...",                                         StrMBMP,     Japanese,0},  
  { "GIF ...",                                         StrMGIF,     Japanese,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Japanese,5},  
  { "PPM ...",                                         StrMPPM,     Japanese,2},  
  { "Sun Raster...",                                   StrMSRast,   Japanese,0},  
  { "PostScript...",                                   StrMPostscr, Japanese,0},  
  { "PICT...",                                         StrMPICT,    Japanese,1},  
  { "Vector PS ...",                                   StrMVECPS,   Japanese,0},  
  { "Molscript ...",                                   StrMMSCR,    Japanese,1},  
  { "Kinemage ...",                                    StrMKine,    Japanese,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Japanese,2},  
  { "VRML ...",                                        StrMVRML,    Japanese,3},  
  { "Ramachandran ...",                                StrMRPP,     Japanese,3},  
  { "Raster3D ...",                                    StrMR3D,     Japanese,6},  
  { "RasMolץ...",                           StrMSCR,     Japanese,8},  
  { "RasMolˤĤ...",                                StrMAbout,   Japanese,0},
  { "ޥ˥奢...",                                     StrMUserM,   Japanese,0},
  { "᤹",                                         StrMUndo,    Japanese,0},
  { "å",                                           StrMCut,     Japanese,1},
  { "ԡ",                                           StrMCopy,    Japanese,1},
  { "ڡ",                                         StrMPaste,   Japanese,0},
#ifdef APPLEMAC
  { "õ",                                             StrMClear,   Japanese,1},
#else
  { "",                                             StrMDelete,  Japanese,0},
#endif
  { "٤Ƥ",                                       StrMSelAll,  Japanese,0},
  { "ե",                                            StrMFile,    Japanese,0},
  { "Խ",                                            StrMEdit,    Japanese,0},
  { "ɽˡ",                                         StrMDisplay, Japanese,0},
  { "",                                         StrMColour,  Japanese,0},
  { "ץ",                                         StrMOpt,     Japanese,0},
  { "",                                        StrMSettings,Japanese,0},
  { "",                                          StrMExport,  Japanese,1},
#ifdef APPLEMAC
  { "ɥ",                                          StrMWindow,  Japanese,0},
#endif
  { "إ",                                            StrMHelp,    Japanese,0},
#ifdef APPLEMAC
  { "ᥤ󥦥ɥ",                                     StrMMainWin,  Japanese,0},
  { "ޥɥ饤",                                    StrMCmndLin,  Japanese,0},
#endif
#else
  { "(&O) ...",                                       StrMOpen,    Japanese,0},
  { "(&I)",                                    StrMInfo,    Japanese,0},
  { "Ĥ(&C)",                                          StrMClose,   Japanese,0},
  { "(&P)",                                          StrMPrint,   Japanese,0},
  { "ڡ(&R)",                                    StrMPSetup,  Japanese,0},
  { "λ(&E)",                                           StrMExit,    Japanese,0},
  { "磻䡼ե졼(&W)",                                      StrMWirefr,  Japanese,0},
  { "线(&M)",                                       StrMBackbn,  Japanese,0},
  { "ƥå(&B)",                                         StrMSticks,  Japanese,1},
  { "ֽŶǥ(&S)",                                      StrMSpacefl, Japanese,0},
  { "(&H)",                                  StrMBallStk, Japanese,0},
  { "ܥ(&R)",                                        StrMRibbons, Japanese,0},
  { "ȥ(&T)",                                        StrMStrands, Japanese,3},
  { "ȥ(&C)",                                       StrMCartoon, Japanese,0},
  { "ʬɽ(&M)",                              StrMMolSurf, Japanese,0},
  { "(&M)",                                     StrMMonochr, Japanese,0},
  { "&CPKʥ顼",                                            StrMCPK,     Japanese,0},
  { "(&H)",                                        StrMShapely, Japanese,0},
  { "롼(&G)",                                          StrMGroup,   Japanese,0},
  { "(&C)",                                          StrMChain,   Japanese,1},
  { "(&T)",                                    StrMTemp,    Japanese,0},
  { "¤(&S)",                                      StrMStruct,  Japanese,2},
  { "桼(&U)",                                           StrMUser,    Japanese,0},
  { "ǥ(&D)",                                          StrMModel,   Japanese,2},
  { "Ĵ¤(&A)",                                            StrMAlt,     Japanese,0},
  { "֥⡼(&P)",                                      StrMSlab,    Japanese,0},
  { "Ǹ(&H)",                                      StrMHydr,    Japanese,1},
  { "إƥ(&N)",                                   StrMHet,     Japanese,2},
  { "(&T)",                                       StrMSpec,    Japanese,1},
  { "(&D)",                                        StrMShad,    Japanese,1},
  { "ƥ쥪(&S)",                                         StrMStereo,  Japanese,5},
  { "٥(&L)",                                         StrMLabel,   Japanese,0},
  { "(&O)",                                       StrMPOff,    Japanese,5},
  { "򤵤줿Τɽ(&I)",                                     StrMPIdent,  Japanese,5},
  { "Υ¬(&D)",                                  StrMPDist,   Japanese,5},
  { "Υɽ(&S)",                                   StrMPMon,    Japanese,0},
  { "٤¬(&A)",                                     StrMPAng,    Japanese,5},
  { "̳ѤϤ(&T)",                                   StrMPTrsn,   Japanese,5},
  { "٥դ(&L)",                                     StrMPLabl,   Japanese,5}, 
  { "濴(&C)",                                    StrMPCent,   Japanese,5},
  { "ɸɽ(&X)",                                     StrMPCoord,  Japanese,6},
  { "(&B)",                                      StrMPBond,   Japanese,5},
  { "ž(&R)",                                    StrMRBond,   Japanese,0},
  { "ʬҤž(&M)",                                     StrMRMol,    Japanese,7},
  { "٤Ƥž(&H)",                                     StrMRAll,    Japanese,7},
  { "&BMP ...",                                        StrMBMP,     Japanese,0},  
  { "&GIF ...",                                        StrMGIF,     Japanese,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Japanese,5},  
  { "PP&M ...",                                        StrMPPM,     Japanese,2},  
  { "&Sun Raster...",                                  StrMSRast,   Japanese,0},  
  { "&PostScript...",                                  StrMPostscr, Japanese,0},  
  { "PICT... &26",                                        StrMPICT,    Japanese,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Japanese,0},  
  { "M&olscript ...",                                  StrMMSCR,    Japanese,1},  
  { "Kinemage ...  (&29)",                                   StrMKine,    Japanese,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Japanese,2},  
  { "VRM&L ...",                                       StrMVRML,    Japanese,3},  
  { "Ram&achandran ...",                               StrMRPP,     Japanese,3},  
  { "Raster&3D ...",                                   StrMR3D,     Japanese,6},  
  { "RasMolץ(&C)...",                              StrMSCR,     Japanese,8},  
  { "RasMolˤĤ(&A)...",                                StrMAbout,   Japanese,0},
  { "ޥ˥奢(&M)...",                                 StrMUserM,   Japanese,0},
  { "᤹(&Z)",                                           StrMUndo,    Japanese,0},
  { "å(&X)",                                            StrMCut,     Japanese,1},
  { "ԡ(&C)",                                           StrMCopy,    Japanese,1},
  { "ڡ(&V)",                                          StrMPaste,   Japanese,0},
  { "(&D)",                                         StrMDelete,  Japanese,0},
  { "٤Ƥ(&S)",                                     StrMSelAll,  Japanese,0},
  { "ե(&F)",                                           StrMFile,    Japanese,0},
  { "Խ(&E)",                                           StrMEdit,    Japanese,0},
  { "ɽˡ(&D)",                                        StrMDisplay, Japanese,0},
  { "(&C)",                                        StrMColour,  Japanese,0},
  { "ץ(&O)",                                        StrMOpt,     Japanese,0},
  { "(&S)",                                       StrMSettings,    Japanese,0},
  { "(&X)",                                         StrMExport,  Japanese,1},
  { "إ(&H)",                                           StrMHelp,    Japanese,0},
#endif
  { "PDBե̾:",                                  StrPrmtPDB,  Japanese,0},
  { "ե̾:",                                StrPrmtImg,  Japanese,0},
  { "ʬҹ¤ե̾:",                             StrPrmtMol,  Japanese,0},
  { "ٹ: ",                                           StrWarn,     Japanese,0},
  { "",                                              StrChain,    Japanese,0},
  { "桼Ͽ",                                        StrRegister, Japanese,0},
  { "դˤĤ",                                          StrDonate,   Japanese,0},
  { "ưˤΥɽʤ",              StrNoShow,   Japanese,0},
  { "GPLˤݾ̵Υץ󥽡դ򤪴ꤤޤ", StrWarranty, Japanese,0}





};

 
 
void SwitchLang( language lang ) {

  int ii;
  int kmsg;

  kmsg = sizeof(langstrs)/sizeof(langstr);
  for (ii = 0; ii < MaxStrFlag; ii++) {
     MsgStrs[ii] = (char *)0;
     MsgLens[ii] = 0;
     MsgAuxl[ii] = 0;
  }
  for (ii = 0; ii < kmsg; ii++) {
    if (langstrs[ii].lang == lang) {
      MsgStrs[langstrs[ii].msgno] = langstrs[ii].msg;
      MsgLens[langstrs[ii].msgno] = strlen(langstrs[ii].msg);
      MsgAuxl[langstrs[ii].msgno] = langstrs[ii].aux;
    }
  }
  for (ii = 0; ii < kmsg; ii++) {
    if (langstrs[ii].lang == English && !(MsgStrs[langstrs[ii].msgno])) {
      WriteString("\nError: Translation missing for ...\n");
      WriteString(langstrs[ii].msg);
      MsgStrs[langstrs[ii].msgno] = langstrs[ii].msg;
      MsgLens[langstrs[ii].msgno] = strlen(langstrs[ii].msg);
      MsgAuxl[langstrs[ii].msgno] = langstrs[ii].aux;
    }
  }
  Language = lang;
  UpdateLanguage();
  if (Interactive)
    ReDrawWindow();
    if (Language != lang) {
      for (ii = 0; ii < kmsg; ii++) {
        if (langstrs[ii].lang == Language) {
          MsgStrs[langstrs[ii].msgno] = langstrs[ii].msg;
          MsgLens[langstrs[ii].msgno] = strlen(langstrs[ii].msg);
          MsgAuxl[langstrs[ii].msgno] = langstrs[ii].aux;
        }
      }
    ReDrawWindow();
    UpdateLanguage();
    InvalidateCmndLine();
    WriteString("Error: Unable to find font for ");
    WriteString((char *)lang2str(lang));
    WriteString("\n");
    for (ii = 0; ii < NUMLANGS; ii++) {
      if (langfonts[ii].lang == lang) {
        WriteString(langfonts[ii].menufontlist);
        WriteString("\n");
      	
      }
    	
    }
  }

}

language str2lang ( const char * langstr) {

  int ilang;

  for (ilang = 0; ilang < NUMLANGS; ilang++) {
  
    if (!strcasecmp(langstr,langnames[ilang])) {
      return (language) ilang;	
    }
    
  }

  return English;
  	
	
	
}

const char * lang2str ( language lang) {
	
	if ((int)lang >= 0 && (int)lang < NUMLANGS) return langnames[(int)lang];
	else return langnames[0];
}
