/* 
 * @LANG: c++
 */

#include <iostream>
using std::cout;
using std::endl;

%%{
	machine foo;

	action c1 {i}
	action c2 {j}
	action c3 {k}
	action one { cout << "  one" << endl;}
	action two { cout << "  two" << endl;}
	action three { cout << "  three" << endl;}

	one = 'a' 'b' when c1 'c' @one;

	two = 'a'* 'b' when c2 'c' @two;
	
	three = 'a'+ 'b' when c3 'c' @three;

	main := ( one | two | three ) 0 @{fbreak;};
	
}%%

%% write data noerror;

void test( int i, int j, int k, char *str )
{
	int cs = foo_start;
	char *p = str;
	cout << "run:" << endl;
	%% write exec noend;
	if ( cs >= foo_first_final )
		cout << "  success" << endl;
	else
		cout << "  failure" << endl;
	cout << endl;
}

int main()
{
	test( 0, 0, 0, "abc" );
	test( 1, 0, 0, "abc" );
	test( 0, 1, 0, "abc" );
	test( 1, 1, 0, "abc" );
	test( 0, 0, 1, "abc" );
	test( 1, 0, 1, "abc" );
	test( 0, 1, 1, "abc" );
	test( 1, 1, 1, "abc" );
	return 0;
}

#ifdef _____OUTPUT_____
run:
  failure

run:
  one
  success

run:
  two
  success

run:
  one
  two
  success

run:
  three
  success

run:
  one
  three
  success

run:
  two
  three
  success

run:
  one
  two
  three
  success

#endif
