#include "allegro.h"
#include "gunobj.h"
#include "gun_arc.h"
#include "trigtable.h"
#include "spaceobj.h"
#include <vector>

#include "weaponobj.h"
#include "hull_weapon_arc.h"
#include "ebox.h"

using namespace std;

WeaponArc::WeaponArc( int z, int d, SAMPLE * _smp, int al ):
WeaponObject( d, "Arc", 43000, al, z, -1 ) {
	smp = _smp;

	BITMAP * temp = create_bitmap( 4, 16 );
	rectfill( temp, 0, 0, 3, 15, makecol(40,40,40) );
	arc_collide = new ECollide( temp, 3, makecol(255,0,255), 40 );
	destroy_bitmap( temp );

}


void WeaponArc::MakeShot(int x, int y, vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight ) {
	if ( smp != NULL )
		play_sample( smp, 255, 128, 1000, false );

	shot_counter = 13;

	for ( int ang = 2; ang <= 90; ang+=7 ) {
		int ang1 = (720+90-ang)%360;
		int ang2 = (720+90+ang)%360;
		Ammo->push_back( new WeaponNode((int)(x+tcos[ang1]*4),(int)(y+tsine[ang1]*12),tcos[ang1]/4.8,-1.72, new Arc_WHull(strength*2+1,arc_collide), alignment ) );
		Ammo->push_back( new WeaponNode((int)(x+tcos[ang2]*4),(int)(y+tsine[ang2]*12),tcos[ang2]/4.8,-1.72, new Arc_WHull(strength*2+1,arc_collide), alignment ) );
	}

}


WeaponObject * WeaponArc::copy() {

	return new WeaponArc( strength, dir, smp, alignment );

}


WeaponArc::~WeaponArc() {
	delete arc_collide;
}
