#ifndef race_texture
#define race_texture

#include <ClanLib/gl.h>

class CL_Surface;
class CL_SurfaceProvider;

class Texture
{
 public:
	Texture();
	~Texture();
	Texture(CL_Surface *surface, bool alpha=false );
	
	CL_Surface *surface;
	// to get i.e. width call texture.surface->get_width() etc.
	
	CL_SurfaceProvider *provider;
	
	void bind()
	{
		glBindTexture(GL_TEXTURE_2D, texture_handles[id]);
	}
	
	void erase()
	{
		glDeleteTextures(1, &id);
	}
	
 private:
	unsigned int id;
	static std::vector<GLuint> texture_handles;
	static unsigned short num_textures;
};

#endif
