/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001, 2002 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>

#include "../texture.h"
#include "../tile_enums.h"
#include "../height_map.h"
#include "../object_3d.h"
#include "tree.h"

std::vector<Object3D*> Tree::models;
std::vector<Texture> Tree::textures;

void Tree::draw(float x, float y, float z, int item )
{
	if( HeightMap::under_water(x,y,z) )
		return;
	
	if( item >= Items(TREE_1)
		&& (unsigned)item < (Items(TREE_1) + 10)
		&& (unsigned)item < (Items(TREE_1) + textures.size()))
	{
		glPushMatrix();
		glTranslatef( x, y, z );
		glRotatef( x*y, 0.0f, 0.0f, 1.0f); // rotate tree based on pos so all trees look a bit different
		
		textures[item-Items(TREE_1)].bind();
		models[item-Items(TREE_1)]->draw();
		
		glPopMatrix();
	}
}


void Tree::load( CL_ResourceManager &res )
{
	textures.clear();

	int i, num_items = CL_Integer( "trees/num_items", &res );
	CL_String res_base_name = "trees/tree_";
	
	for( i=0; i < num_items; i++ )
	{
		CL_String res_name = res_base_name;
		res_name += i;
		models.push_back( Object3D::load(res_name, &res) );
		res_name += "_tex";
	
		textures.push_back( Texture(CL_Surface::load(res_name, &res)) );
	}
}

