#include <ClanLib/core.h>
#include <fstream>

#include "attractor.h"
#include "ok_area.h"

Attractor::Attractor( int x, int y ) 
{
	this->x = x;
	this->y = y;
}

void Attractor::save( CL_String str )
{
/*
 * Race Drive file format:
 * 
 * attr_x       attractor x
 * attr_y       attractor y
 * ok_x
 * ok_y         
 * ok_x         ok_area[1]->x
 * ok_y         ok_area[1]->y
 * ok_x         ok_area[2]->x
 * ok_y         ok_area[2]->y
 * ok_x         ...
 * ok_y
 * ...
 * -1           ok_area ends. next attr starts
 * attr_x
 * attr_y
 * ok_x
 * ok_y
 * ...
 * 9999         end of drive file ( added by the editors EditAttractors class )
 * 
 */

	std::ofstream fout( str.get_string(), std::ios::app );

	fout << x << std::endl;  // attractor_x 
	fout << y << std::endl;

	for( std::vector<OkArea*>::iterator it = ok_area.begin();
	 it != ok_area.end();
	 it++ )
	{
		fout << (*it)->x << "\n";  // ok_area x
		fout << (*it)->y << "\n";  // ok_area y
	}

	fout << -1 << std::endl;

	fout.close();
}

bool Attractor::on_attractor( float _x, float _y  )
{
	int cx = (int)_x;
	int cy = (int)_y;
	
	// check if car is on attractor

	if( x == cx && y == cy )
  		return true;

	// check if car is on ok area.

	for( std::vector<OkArea*>::iterator it = ok_area.begin();
		it != ok_area.end();
		it++ )
	{
		if( (*it)->x == cx && (*it)->y == cy )
			return true;
	}

	// car is not on attr or ok_area 

	return false;
}


