#
# must.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'amstd/to_s'


class Object

  def must( *args )
    args.each {|c| return self if c === self }
    raise TypeError, "wrong arg type '#{type}' for required #{args.join('/')}"
  end

  def must_have( *args )
    args.each do |m|
      unless self.respond_to? m then
        name = _name2str( m )
        tos = self.to_s; tos = tos[0, 15] + '...' if tos.size > 15
        raise ArgumentError, "arg #{tos}(#{type}) does not have '#{name}'"
      end
    end
    self
  end
  alias needed must_have

  def must_be( eq )
    unless self == eq then
      raise ArgumentError, "expected #{eq.inspect} but is #{inspect}(#{type})"
    end
    self
  end

  def must_exist
    if self.nil? then
      raise ArgumentError, 'is wrongly nil'
    end
  end

end
