#
# gconst.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'amstd/to_s'
require 'amstd/must'


def global_const( name, val )
  name = _name2str( name )

  unless /\A\$[a-zA-Z]\w*\z/ === name then
    raise ArgumentError, "wrong name '#{name}' for global constant"
  end

  eval "#{name} = val"
  trace_var( name ) do
    raise NameError, "global constant '#{name}' is already initialized"
  end
end
