% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ping.R
\name{ping}
\alias{ping}
\alias{col_ping}
\alias{eol_ping}
\alias{itis_ping}
\alias{ncbi_ping}
\alias{tropicos_ping}
\alias{nbn_ping}
\alias{gbif_ping}
\alias{bold_ping}
\alias{ipni_ping}
\alias{vascan_ping}
\alias{fg_ping}
\title{Ping an API used in taxize to see if it's working.}
\usage{
col_ping(what = "status", ...)

eol_ping(what = "status", ...)

itis_ping(what = "status", ...)

ncbi_ping(what = "status", key = NULL, ...)

tropicos_ping(what = "status", ...)

nbn_ping(what = "status", ...)

gbif_ping(what = "status", ...)

bold_ping(what = "status", ...)

ipni_ping(what = "status", ...)

vascan_ping(what = "status", ...)

fg_ping(what = "status", ...)
}
\arguments{
\item{what}{(character) One of status (default), content, or an HTTP status
code. If status, we just check that the HTTP status code is 200, or similar
signifying the service is up. If content, we do a simple, quick check to
determine if returned content matches what's expected. If an HTTP status
code, it must match an appropriate code. See \code{\link{status_codes}}.}

\item{...}{Curl options passed on to \code{\link[crul]{verb-GET}}}

\item{key}{(character) NCBI Entrez API key. optional. See 
\code{\link{get_uid}}}
}
\value{
A logical, TRUE or FALSE
}
\description{
Ping an API used in taxize to see if it's working.
}
\details{
For ITIS, see \code{\link[ritis]{description}}, which provides
number of scientific and common names in a character string.
}
\examples{
\dontrun{
col_ping()
col_ping("content")
col_ping(200)
col_ping("200")
col_ping(204)

itis_ping()
eol_ping()
ncbi_ping()
tropicos_ping()
nbn_ping()

gbif_ping()
gbif_ping(200)

bold_ping()
bold_ping(200)
bold_ping("content")

ipni_ping()
ipni_ping(200)
ipni_ping("content")

vascan_ping()
vascan_ping(200)
vascan_ping("content")

# curl options
vascan_ping(verbose = TRUE)
eol_ping(500, verbose = TRUE)
}
}
