\name{segregation.test}
\alias{segregation.test}
\alias{segregation.test.ppp}
\title{
  Test of Spatial Segregation of Types
}
\description{
  Performs a Monte Carlo test of spatial segregation of the types
  in a multitype point pattern.
}
\usage{
segregation.test(X, \dots)

\method{segregation.test}{ppp}(X, \dots, nsim = 19,
       permute = TRUE, verbose = TRUE, Xname)
}
\arguments{
  \item{X}{
    Multitype point pattern (object of class \code{"ppp"}
    with factor-valued marks).
  }
  \item{\dots}{
    Additional arguments passed to \code{\link{relrisk.ppp}}
    to control the smoothing parameter or bandwidth selection.
  }
  \item{nsim}{
    Number of simulations for the Monte Carlo test.
  }
  \item{permute}{
    Argument passed to \code{\link{rlabel}}. If \code{TRUE} (the
    default), randomisation is performed by randomly permuting the
    labels of \code{X}. If \code{FALSE}, randomisation is performing
    by resampling the labels with replacement.
  }
  \item{verbose}{
    Logical value indicating whether to print progress reports.
  }
  \item{Xname}{
    Optional character string giving the name of the dataset \code{X}.
  }
}
\details{
  The Monte Carlo test of spatial segregation of types,
  proposed by Kelsall and Diggle (1995)
  and Diggle et al (2005), is applied to the point pattern \code{X}.
  The test statistic is
  \deqn{
    T = \sum_i \sum_m \left( \widehat p(m \mid x_i) - \overline p_m
    \right)^2
  }{
    T = sum[i] sum[m] (phat(m | x[i]) - pbar[m])^2
  }
  where \eqn{\widehat p(m \mid x_i)}{phat(m | x[i])} is the
  leave-one-out kernel smoothing estimate of the probability that the
  \eqn{i}-th data point has type \eqn{m}, and
  \eqn{\overline p_m}{pbar[m]} is the average fraction of data points
  which are of type \eqn{m}.
  The statistic \eqn{T} is evaluated for the data and
  for \code{nsim} randomised versions of \code{X}, generated by
  randomly permuting or resampling the marks.
  
  Note that, by default, automatic bandwidth selection will be
  performed separately for each randomised pattern. This computation
  can be very time-consuming but is necessary for the test to be
  valid in most conditions. A short-cut is to specify the value of
  the smoothing bandwidth \code{sigma} as shown in the examples.
}
\value{
  An object of class \code{"htest"} representing the result of the test.
}
\references{
  Kelsall, J.E. and Diggle, P.J. (1995)
  Kernel estimation of relative risk.
  \emph{Bernoulli} \bold{1}, 3--16.

  Diggle, P.J., Zheng, P. and Durr, P. (2005)
  Non-parametric estimation of spatial segregation in a
  multivariate point process: bovine tuberculosis in
  Cornwall, UK. 
  \emph{Applied Statistics} \bold{54}, 645--658.
}
\seealso{
  \code{\link{relrisk}}
}
\examples{
  segregation.test(hyytiala, 5)

  if(interactive()) segregation.test(hyytiala, hmin=0.05) 
}
\author{\adrian
  
  
  \rolf
  
  and \ege
  
}
\keyword{spatial}
\keyword{htest}
