% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{safeError}
\alias{safeError}
\title{Declare an error safe for the user to see}
\usage{
safeError(error)
}
\arguments{
\item{error}{Either an "error" object or a "character" object (string).
In the latter case, the string will become the message of the error
returned by \code{safeError}.}
}
\value{
An "error" object
}
\description{
This should be used when you want to let the user see an error
message even if the default is to sanitize all errors. If you have an
error \code{e} and call \code{stop(safeError(e))}, then Shiny will
ignore the value of \code{getOption("shiny.sanitize.errors")} and always
display the error in the app itself.
}
\details{
An error generated by \code{safeError} has priority over all
other Shiny errors. This can be dangerous. For example, if you have set
\code{options(shiny.sanitize.errors = TRUE)}, then by default all error
messages are omitted in the app, and replaced by a generic error message.
However, this does not apply to \code{safeError}: whatever you pass
through \code{error} will be displayed to the user. So, this should only
be used when you are sure that your error message does not contain any
sensitive information. In those situations, \code{safeError} can make
your users' lives much easier by giving them a hint as to where the
error occurred.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

# uncomment the desired line to experiment with shiny.sanitize.errors
# options(shiny.sanitize.errors = TRUE)
# options(shiny.sanitize.errors = FALSE)

# Define UI
ui <- fluidPage(
  textInput('number', 'Enter your favorite number from 1 to 10', '5'),
  textOutput('normalError'),
  textOutput('safeError')
)

# Server logic
server <- function(input, output) {
  output$normalError <- renderText({
    number <- input$number
    if (number \%in\% 1:10) {
      return(paste('You chose', number, '!'))
    } else {
      stop(
        paste(number, 'is not a number between 1 and 10')
      )
    }
  })
  output$safeError <- renderText({
    number <- input$number
    if (number \%in\% 1:10) {
      return(paste('You chose', number, '!'))
    } else {
      stop(safeError(
        paste(number, 'is not a number between 1 and 10')
      ))
    }
  })
}

# Complete app with UI and server components
shinyApp(ui, server)
}
}
\seealso{
\code{\link{shiny-options}}
}

