% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{as_quosure}
\alias{as_quosure}
\alias{new_quosure}
\title{Coerce object to quosure}
\usage{
as_quosure(x, env = NULL)

new_quosure(expr, env = caller_env())
}
\arguments{
\item{x}{An object to convert. Either an \link[=is_expression]{expression} or a
formula.}

\item{env}{The environment in which the expression should be
evaluated. Only used for symbols and calls. This should typically
be the environment in which the expression was created.}

\item{expr}{The expression wrapped by the quosure.}
}
\description{
While \code{new_quosure()} wraps any R object (including expressions,
formulas, or other quosures) into a quosure, \code{as_quosure()}
converts formulas and quosures and does not double-wrap.
}
\section{Life cycle}{

\itemize{
\item \code{as_quosure()} now requires an explicit default environment for
creating quosures from symbols and calls.
\item \code{as_quosureish()} is deprecated as of rlang 0.2.0. This function
assumes that quosures are formulas which is currently true but
might not be in the future.
}
}

\examples{
# as_quosure() converts expressions or any R object to a validly
# scoped quosure:
env <- env(var = "thing")
as_quosure(quote(var), env)


# The environment is ignored for formulas:
as_quosure(~foo, env)
as_quosure(~foo)

# However you must supply it for symbols and calls:
try(as_quosure(quote(var)))
}
\seealso{
\code{\link[=quo]{quo()}}, \code{\link[=is_quosure]{is_quosure()}}
}
