% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Serializer.R
\docType{methods}
\name{serializeToFile}
\alias{serializeToFile}
\alias{serializeToFile,Serializer,World,Model,character-method}
\title{Serialize a model to a file.}
\usage{
serializeToFile(.Object, world, model, filePath, ...)

\S4method{serializeToFile}{Serializer,World,Model,character}(.Object, world,
  model, filePath, baseUri = as.character(NA))
}
\arguments{
\item{.Object}{a Serializer object}

\item{world}{a World object}

\item{model}{a Model object}

\item{filePath}{a file path that the serialized model will be written to}

\item{...}{Additional parameters}

\item{baseUri}{a base URI to use for the serialization}
}
\value{
an integer containing the return status where non zero indicates an error occurred during serialization
}
\description{
Serialize a model to a file.
}
