% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.varImp.train.R
\name{plot.varImp.train}
\alias{ggplot.varImp.train}
\alias{plot.varImp.train}
\title{Plotting variable importance measures}
\usage{
\method{plot}{varImp.train}(x, top = dim(x$importance)[1], ...)

\method{ggplot}{varImp.train}(data, mapping = NULL,
  top = dim(data$importance)[1], ..., environment = NULL)
}
\arguments{
\item{x, data}{an object with class \code{varImp}.}

\item{top}{a scalar numeric that specifies the number of variables to be
displayed (in order of importance)}

\item{mapping, environment}{unused arguments to make consistent with
\pkg{ggplot2} generic method}

\item{\dots}{arguments to pass to the lattice plot function
(\code{\link[lattice:xyplot]{dotplot}} and \code{\link{panel.needle}})}
}
\value{
a lattice plot object
}
\description{
This function produces lattice and ggplot plots of objects with class
"varImp.train". More info will be forthcoming.
}
\details{
For models where there is only one importance value, such a regression
models, a "Pareto-type" plot is produced where the variables are ranked by
their importance and a needle-plot is used to show the top variables.
Horizontal bar charts are used for \code{ggplot}.

When there is more than one importance value per predictor, the same plot is
produced within conditioning panels for each class. The top predictors are
sorted by their average importance.
}
\author{
Max Kuhn
}
\keyword{hplot}

