% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projpred.R
\name{get_refmodel.brmsfit}
\alias{get_refmodel.brmsfit}
\alias{get_refmodel}
\title{Get Reference Models}
\usage{
\method{get_refmodel}{brmsfit}(object, newdata = NULL, resp = NULL, folds = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{folds}{Only used for k-fold variable selection. A vector of fold
indices for each data point in data.}

\item{...}{Further arguments currently ignored.}
}
\value{
A \code{refmodel} object to be used in
  \code{\link[projpred:varsel]{varsel}} and related variable selection
  methods.
}
\description{
Get reference model structure from \code{brmsfit} objects for use in
\code{\link[projpred:varsel]{varsel}} and related variable selection methods.
This method is called automatically when performing variable selection via
\code{\link{varsel.brmsfit}} and so you will rarely need to call it manually
yourself.
}
