% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO-methods.R
\name{import_qiime_sample_data}
\alias{import_qiime_sample_data}
\title{Import just \code{sample_data} file from QIIME pipeline.}
\usage{
import_qiime_sample_data(mapfilename)
}
\arguments{
\item{mapfilename}{(Required). A character string or connection.
That is, any suitable \code{file} argument to the \code{\link{read.table}} function. 
The name of the QIIME map
file required for processing pyrosequencing tags
in QIIME as well as some of the post-clustering analysis. This is a required
input file for running QIIME. Its strict formatting specification is expected by
this function, do not attempt to modify it manually once it has worked properly
in QIIME.}
}
\value{
A \code{sample_data} object.
}
\description{
QIIME produces several files that can be analyzed in the phyloseq-package, 
This includes the map-file, which is an important \emph{input}
to QIIME that can also indicate sample covariates. It is converted naturally to the 
sample_data component data type in phyloseq-package, based on the R data.frame.
}
\details{
See \code{\link{import_qiime}} for more information about QIIME. It is also the
suggested function for importing QIIME-produced data files.
}
\examples{
 mapfile <- system.file("extdata", "master_map.txt", package = "phyloseq")
 import_qiime_sample_data(mapfile)
}
\seealso{
\code{\link{import}}

\code{\link{merge_phyloseq}}

\code{\link{phyloseq}}

\code{\link{import_qiime}}

\code{\link{import_qiime_otu_tax}}

\code{\link{import_env_file}}
}

