// help_html.cpp  Generated by running: cat help.html | ./html2CString help_html.cpp

const char *help_html = 
"<html>\n"
"<!-- help.html Generated from make and source help.html.in !-->\n"
"\n"
"\n"
"<head>\n"
"<title>Quickplot Help</title>\n"
"<link rel=\"shortcut icon\" href=\"/favicon.ico\" type=\"image/x-icon\" />\n"
"</head>\n"
"\n"
"<body>\n"
"\n"
"\n"
"<center>\n"
"<h1>Quickplot Help</h1>\n"
"</center>\n"
"\n"
"Quickplot can load data from GUIs (graphical user interfaces), the\n"
"command line, or by reading the data from standard input.&nbsp; Data\n"
"is loaded into fields.&nbsp; A field represents a series of numbers,\n"
"like for example the values for one variable.&nbsp; Any two fields may be\n"
"plotted against each other.\n"
"\n"
"<br><br>\n"
"\n"
"\n"
"<h3>Zooming</h3>\n"
"\n"
"<blockquote>\n"
"\n"
"<li><b>Zooming In</b>&nbsp;&nbsp; Put the pointer (mouse) on a corner\n"
"of plot region you want to zoom to.&nbsp; Press the right mouse button\n"
"and hold and drag the zoom box.&nbsp; Release the right mouse button\n"
"then it is at another corner of the zoom region.&nbsp; Now Quickplot\n"
"will zoom into that zoom region.\n"
"\n"
"<p> You can zoom in as many times as you like, or calculations will\n"
"permit.&nbsp; In all cases we've seen round off problems don't happen\n"
"until you are looking past at one data point in the plot window.&nbsp;\n"
"Quickplot will print a warning message to standard output if this\n"
"happens.&nbsp; This happens when you zoom in so far as to make it so\n"
"that the pixel distance between two adjacent points is about 10 <sup>\n"
"9 </sup> pixels.&nbsp; Quickplot culls out points that are not\n"
"adjacent to the plot window or in the plot window.&nbsp; Quickplot\n"
"linearly interpolates lines to points adjacent to points in the plot\n"
"window or on other sides of the plot window. <li><b>Zooming Out</b>\n"
"&nbsp;&nbsp; Put the pointer (mouse) in the plot window.&nbsp; Press\n"
"the right mouse button and hold and drag the zoom box.&nbsp; Release\n"
"the right mouse button then it (the zoom box) is past one edge of the\n"
"plot window.&nbsp; Now Quickplot will zoom out to the previous zoom\n"
"level.</p>\n"
"\n"
"<p> Or to zoom out to a full view (top zoom level) of the plot: Put\n"
"the pointer (mouse) in the plot window.&nbsp; Press the right mouse\n"
"button and hold and drag the zoom box.&nbsp; Release the right mouse\n"
"button then the zoom box is past two edges (a corner) of the plot\n"
"window.&nbsp; Now Quickplot will zoom out to the top zoom level (no\n"
"zoom).</p>\n"
"\n"
"</blockquote>\n"
"\n"
"\n"
"<br>\n"
"<h3>Graph Value Picking</h3>\n"
"\n"
"<blockquote>\n"
"The left mouse button is used for picking and displaying\n"
"X and Y values from the graph.&nbsp; Just try it and see.\n"
"\n"
"<p> There are three modes of number display value picking, which may\n"
"be selected on the Plot List pop-up window:\n"
"\n"
"<ul>\n"
"\n"
"<li><b>Pick Pointer Values</b>&nbsp;&nbsp; shows values where the mouse\n"
"pointer is in the scale of the respective plot</li>\n"
"\n"
"<li><b>Interpolate Plot Values</b>&nbsp;&nbsp; shows values where the\n"
"X position of the mouse pointer is with the Y value displayed being a\n"
"linearly interpolated value</li>\n"
"\n"
"<li><b>Pick Plot Point Values</b>&nbsp;&nbsp; shows X and Y plot point\n"
"positions that are closest to mouse pointer X position.</li>\n"
"\n"
"</ul>\n"
"</p>\n"
"</blockquote>\n"
"\n"
"\n"
"<br>\n"
"<h3>Loadable File Formats</h3>\n"
"<ul>\n"
"\n"
"<li><b>ASCII text</b>&nbsp;&nbsp; Quickplot can load ASCII text (plan\n"
"text) files.&nbsp; The number of fields (numbers) on each line must be\n"
"the same.&nbsp; Any number of non-number characters other than a new\n"
"line character may used to separate numbers on a given line.&nbsp; The\n"
"characters in numbers can only be the following 15 characters\n"
"\".+-eE0123456789\".&nbsp;\n"
"\n"
"Example:\n"
"<blockquote>\n"
"<pre>\n"
"-1 -1.3 -1\n"
"0 1.1e-2 0\n"
"2 1.2E-2 1\n"
"30 1.3e+2 3\n"
"</pre>\n"
"</blockquote>\n"
"\n"
"The above example has three fields and four values for each\n"
"field.&nbsp; A file may have any counting number of fields, that's\n"
"1,2,3,4 or more fields.&nbsp; If a file is loaded with a single field\n"
"an additional field, with the same number of values as the field in\n"
"the file, will be added before the field from the file.&nbsp;\n"
"Quickplot can read ASCII text files from standard input.\n"
"\n"
"<p>\n"
"\n"
"<li><b><a href=\"http://www.mega-nerd.com/libsndfile/\">libsndfile</a>\n"
"sound file</b>&nbsp;&nbsp; Using the package libsndfile Quickplot can\n"
"read many sound file formats.&nbsp; An incomplete list of readable\n"
"sound file formats includes: Microsoft WAV, SGI/Apple AIFF/AIFC, and\n"
"Sun/DEC/NeXT AU/SND..&nbsp; See the <a\n"
"href=\"http://www.mega-nerd.com/libsndfile/\">libsndfile home-page</a>\n"
"for a full list of supported sound file formats.&nbsp;\n"
"\n"
"<p>\n"
"\n"
"When loading a sound file the first field (sequence) loaded will be\n"
"the time sequence, then each sound channel will follow in separate\n"
"fields.\n"
"\n"
"Quickplot may be a little slow with sound files larger than thirty\n"
"seconds long.&nbsp; Thirty seconds of sound sampled at 44KHZ with one\n"
"channel would load 1.32 million data points.&nbsp; Quickplot cannot\n"
"read sound files from standard input. </ul>\n"
"\n"
"\n"
"\n"
"<br>\n"
"<h3>Quickly looking at a hundred thousand, a million, or more data points?</h3>\n"
"<blockquote>\n"
"\n"
"If you need to look at large files quickly, try running Quickplot\n"
"including the two options '--no-lines' and '--point-size=0' in the\n"
"command line.&nbsp; This will make the plot drawing and redrawing as\n"
"fast as it can be at the expense of having points that are just one\n"
"pixel in size, which should be no problem if you have that many\n"
"points.&nbsp; Once you zoom to a picture that you like you can\n"
"increase the point size or add lines, using the GUI (graphical user\n"
"interface), if you need to.&nbsp; Quickplot loads the entire file into\n"
"memory for any file loaded, so you may need to be careful of your\n"
"memory usage when working with large files.\n"
"\n"
"<p> By default plots created in Quickplot with 1,000,000 or more\n"
"points will by drawn without lines and points of size one pixel,\n"
"unless the user has included one or more of the following options in\n"
"the command line: --no-lines, --no-points, --line-width, or\n"
"--point-size.&nbsp; For plots with less than 1,000,000 points the\n"
"default line width is 3 pixels and the default point size is 5 pixels.\n"
"</p>\n"
"\n"
"<p> On a 2.4 Gig Hz Pentium 4 (with <a\n"
"href=\"http://www.gentoo.org/\">Gentoo GNU/Linux</a>) with 256 Megabytes\n"
"of RAM it has been observed to take 8 seconds to load and display an\n"
"ASCII text file with 1 million data points; after startup it was\n"
"observed to take about one second to redraw with the one million\n"
"points in view.&nbsp; When repeating this with lines of width 3 pixels\n"
"and points of size 5 pixels the loading time is about the same and the\n"
"drawing time increases by about 3 seconds.&nbsp; Drawing time didn't\n"
"seem to vary with window size.</p>\n"
"\n"
"</blockquote>\n"
"\n"
"\n"
"\n"
"<br>\n"
"<h3>Command Line Options</h3>\n"
"\n"
"<b>Usage: quickplot [<font color=#902040>OPTIONS</font>] [file1] [<font\n"
"color=#902040>OPTIONS</font>] [file2] [<font\n"
"color=#902040>OPTIONS</font>] ...</b>\n"
"\n"
"<p> If no -p or --plot option is given then the default initial plots\n"
"will be up to 12 plots.&nbsp; The default initial plots will be of all\n"
"fields, except the first field in the order that the field was loaded\n"
"from a file plotted against the first field in the file.&nbsp; If a\n"
"file contains one field (like a sound file) than a field that contains\n"
"a linear (time) sequence of values will be generated before the file's\n"
"field is loaded. If standard input is read it will be the first file\n"
"loaded.</p>\n"
"\n"
"<p></p>\n"
"\n"
"\n"
"<b><font color=#902040>OPTIONS</font></b></p>\n"
"\n"
"<ul>\n"
"\n"
"<li><b><font color=#902040>--about</font></b> or <b><font\n"
"color=#902040>-a</font></b>&nbsp;&nbsp; display some information\n"
"about Quickplot\n"
"\n"
"<li><b><font color=#902040>--canvas-color RGB</font></b> or <b><font\n"
"color=#902040>-c RGB</font></b>&nbsp;&nbsp; start quickplot with the\n"
"graph background (canvas) color RGB. Examples: --canvas-color #FF0000\n"
"or --canvas-color \"red\" would make it red.\n"
"\n"
"<li><b><font color=#902040>--different-scales</font></b> or <b><font\n"
"color=#902040>-d</font></b>&nbsp;&nbsp;\n"
"load plots on the same graph with different scales. By default\n"
"Quickplot will load plots on the same graph with the same scale if the\n"
"span of x,y values in all the plots are within an order of magnitude\n"
"of each other.\n"
"\n"
"<li> <b><font color=#902040>--geometry GEOMETRY</font></b> or <b><font\n"
"color=#902040>-geometry GEOMETRY</font></b>&nbsp;&nbsp; create the\n"
"initial window with the given geometry GEOMETRY, see man page X(1) for\n"
"the GEOMETRY format. Example: quickplot --geometry=1000x300-0+30\n"
"\n"
"<li> <b><font color=#902040>--grid-color RGB</font></b> or <b><font\n"
"color=#902040>-C RGB</font></b>&nbsp;&nbsp; start quickplot with the grid\n"
"color RGB. Example: --grid-color #00FF00 would make it green.\n"
"\n"
"<blockquote>\n"
"<b><font color=#902040>RGB</font></b> may be in one of these formats:\n"
"<ul>\n"
"<li>#RGB (each of R, G and B is a single hex digit)\n"
"<li>#RRGGBB\n"
"<li>#RRRGGGBBB\n"
"<li>#RRRRGGGGBBBB\n"
"<li>A name from the X color database, which may be\n"
"in /usr/X11R6/lib/X11/rgb.txt. Example colors are\n"
"\"steelblue\" and \"gainsboro\".\n"
"</ul>\n"
"</blockquote>\n"
"\n"
"<li><b><font color=#902040>--grid-line-width SIZE</font></b> or\n"
"<b><font color=#902040>-g SIZE</font></b>&nbsp;&nbsp; start quickplot\n"
"using plot grid width SIZE in pixels\n"
"\n"
"<li><b><font color=#902040>--help</font></b> or <b><font\n"
"color=#902040>-h</font></b>&nbsp;&nbsp; display this help\n"
"\n"
"<li><b><font color=#902040>--label-separator CHAR</font></b> or\n"
"<b><font color=#902040>-b CHAR</font></b>&nbsp;&nbsp; when reading\n"
"labels from the last file in the augment list before this option flag\n"
"use <b><font color=#902040>CHAR</font></b> as the label (single\n"
"character) separator. The default label separator is ' ' (space). If\n"
"this file is not an ASCII text file this will be ignored. See option:\n"
"<a href=\"#option_L\"><b>--labels</b> or\n"
"<b>-L</b></a>.\n"
"\n"
"<a name=option_L> <li><b><font color=#902040>--labels</font></b> or\n"
"<b><font color=#902040>-L</font></b>&nbsp;&nbsp; read labels from the\n"
"first line not skipped of the last file in the augment list before\n"
"this option flag. If this file is not an ASCII text file this will be\n"
"ignored.\n"
"\n"
"<li><b><font color=#902040>--line-width SIZE</font></b> or <b><font\n"
"color=#902040>-I SIZE</font></b>&nbsp;&nbsp; start quickplot using\n"
"plot line width SIZE in pixels\n"
"\n"
"<li><b><font color=#902040>--linear-field [L_OPTIONS]</font></b> or\n"
"<b><font color=#902040>-l [L_OPTIONS]</font></b>&nbsp;&nbsp; make a\n"
"field that is a uniformly changing linear sequence of values, like for\n"
"example time.&nbsp; The number of values will be gotten from the\n"
"previous file's values loaded.&nbsp; The field generated will be added\n"
"as the first field of the previous file. For sound files this option\n"
"is ignored.\n"
"\n"
"<br>\n"
"<b><font color=#902040>L_OPTIONS</font></b>\n"
"\n"
"<blockquote>\n"
"\n"
"The L_OPTIONS only have an effect after the --linear-field (or -l)\n"
"option and they act on the field made from that argument.&nbsp; The\n"
"L_OPTIONS are:\n"
"\n"
"<ul>\n"
"\n"
"<li><b><font color=#902040>--start VALUE</font></b> or <b><font\n"
"color=#902040>-r VALUE</font></b>&nbsp;&nbsp; set the first value in the\n"
"sequence to VALUE.&nbsp; The The default first value will be zero.\n"
"\n"
"<li><b><font color=#902040>--step SIZE</font></b> or <b><font\n"
"color=#902040>-t SIZE</font></b>&nbsp;&nbsp; set the sequence step size to\n"
"SIZE.&nbsp; The default is 1.\n"
"\n"
"</ul>\n"
"</blockquote>\n"
"\n"
"<!--\n"
"<li><b><font color=#902040>--log</font></b>&nbsp; &nbsp; take the log\n"
"(base 10) of the values in all fields in the previous file read.&nbsp;\n"
"If you want plots with log scales and some without log scales you can\n"
"list the file twice in the command line, once without the --log option\n"
"after and once with.&nbsp; When loading sound files this option is\n"
"ignored.\n"
"-->\n"
"\n"
"<li><b><font color=#902040>--no-buttons</font></b> or <b><font\n"
"color=#902040>-B</font></b>&nbsp;&nbsp; start quickplot with no\n"
"button bar\n"
"\n"
"<li><b><font color=#902040>--no-default-plots</font></b>&nbsp;&nbsp;\n"
"by default when no --plot or -p options are given Quickplot will make\n"
"some plots with the files loaded at start up. This option will cause\n"
"Quickplot not to make these default plots.&nbsp;&nbsp; When files are\n"
"loaded using the GUI defaults plot will not be made if this is set.\n"
"\n"
"<li><b><font color=#902040>--no-grid</font></b> or <b><font\n"
"color=#902040>-G</font></b>&nbsp;&nbsp; start quickplot with out\n"
"drawing graph grid lines, by default, in the graphs\n"
"\n"
"<li><b><font color=#902040>--no-gui</font></b>&nbsp;&nbsp; start\n"
"quickplot with out showing any of the standard GUI's (graphical user\n"
"interfaces). This is the same as uses the options --no-buttons\n"
"--no-menubar --no-statusbar and --no-tabs.\n"
"\n"
"<li><b><font color=#902040>--no-lines</font></b> or <b><font\n"
"color=#902040>-i</font></b>&nbsp;&nbsp; start quickplot to plot\n"
"without drawing lines in the graphs by default\n"
"\n"
"<li><b><font color=#902040>--no-menubar</font></b> or <b><font\n"
"color=#902040>-M</font></b>&nbsp;&nbsp; start quickplot with no\n"
"menubar\n"
"\n"
"<li><b><font color=#902040>--no-pipe</font></b> or <b><font\n"
"color=#902040>-N</font></b>&nbsp;&nbsp; don't read data in from\n"
"standard input\n"
"\n"
"<li><b><font color=#902040>--no-points</font></b> or <b><font\n"
"color=#902040>-o</font></b>&nbsp;&nbsp; start quickplot to plot\n"
"without drawing points in the graphs by default\n"
"\n"
"<li><b><font color=#902040>--no-statusbar</font></b>&nbsp;&nbsp; start\n"
"Quickplot with no status bar displayed. The Quickplot status bar is a\n"
"thin widget at the bottom of the main Quickplot window which displays\n"
"pointer x, y graph values and mode information.\n"
"\n"
"<li><b><font color=#902040>--no-tabs</font></b>&nbsp;&nbsp; start\n"
"Quickplot with no graph tabs displayed. Quickplot uses a notebook\n"
"like widget to let you select and view multiple graphs.\n"
"\n"
"<li><b><font color=#902040>--number-of-plots NUM</font></b> or\n"
"<b><font color=#902040>-n NUM</font></b>&nbsp;&nbsp; set the possible\n"
"initial number of plots to NUM.&nbsp; The default possible initial\n"
"number of plots is 12.\n"
"\n"
"<li><b><font color=#902040>--pipe </font></b> or <b><font\n"
"color=#902040>-P</font></b>&nbsp;&nbsp; read in data from standard\n"
"input.&nbsp; By default Quickplot looks for data from standard input\n"
"and stops looking if no data is found in some short amount of\n"
"time.&nbsp; This option will cause Quickplot to wait for standard\n"
"input indefinitely.\n"
"\n"
"<li><b><font color=#902040>--plot LIST </font></b> or <b><font\n"
"color=#902040>-p LIST</font></b>&nbsp;&nbsp; plot the following list\n"
"of fields, LIST, at startup.&nbsp; example: --plot \"0 1 3 4\" will plot\n"
"field 1 VS field 0 and field 4 VS field 3.&nbsp; DataFields are\n"
"numbered, starting at 0, in the order that they are read in from a\n"
"file or created, as in the case of option --linear-field.&nbsp; A\n"
"separate Graph Tab will be created for each --plot (or -p) option\n"
"given.\n"
"\n"
"<li><b><font color=#902040>--point-size SIZE</font></b> or <b><font\n"
"color=#902040>-O SIZE</font></b>&nbsp;&nbsp; start quickplot using\n"
"plot point size SIZE in pixels\n"
"\n"
"<li><b><font color=#902040>--print-about</font></b>&nbsp;&nbsp;\n"
"prints the About HTML document to standard output and then exits\n"
"\n"
"<li><b><font color=#902040>--print-help</font></b>&nbsp;&nbsp; prints\n"
"this Help HTML document to standard output and then exits\n"
"\n"
"<li><b><font color=#902040>--same-scale</font></b> or <b><font\n"
"color=#902040>-s</font></b>&nbsp;&nbsp; plot all start-up plots on\n"
"the same scale\n"
"\n"
"<li><b><font color=#902040>--silent</font></b>&nbsp;&nbsp; don't spew\n"
"even on error.&nbsp; The --silent option will override the effect of\n"
"the --verbose option.\n"
"\n"
"<li><b><font color=#902040>--skip-lines NUM</font></b> or <b><font\n"
"color=#902040>-S NUM</font></b>&nbsp; &nbsp; skip the first NUM lines\n"
"in the previous file read. The previous file in the argument list\n"
"should be an ASCII text file.\n"
"\n"
"<li><b><font color=#902040>--verbose</font></b> or <b><font\n"
"color=#902040>-v</font></b>&nbsp;&nbsp; spew more to standard output\n"
"\n"
"<li><b><font color=#902040>--version</font></b> or <b><font\n"
"color=#902040>-V</font></b>&nbsp;&nbsp; print the Quickplot version\n"
"number and then exit returning 0 exit status\n"
"\n"
"<li><b><font color=#902040>--with-libsndfile</font></b>&nbsp;&nbsp; if\n"
"quickplot is linked with the libsndfile library, print the version of\n"
"the libsndfile library that quickplot is linked with, and exit\n"
"returning status 0 if quickplot is linked with the libsndfile library\n"
"and 1 if quickplot is not linked with the libsndfile library\n"
"\n"
"<br>&nbsp;\n"
"\n"
"<li><b><font color=#902040>GTK+ OPTIONS</font></b><br> The following\n"
"GTK+ options are parsed by the <a\n"
"href=\"http://www.gtkmm.org/\">gtkmm</a> and <a\n"
"href=\"http://www.gtk.org/\">GTK+</a> APIs (application programming\n"
"interfaces), which Quickplot uses.\n"
"\n"
"<blockquote>\n"
"\n"
"<table> <!-- We got this list from running `galeon --help'. Where\n"
"does GTK+ keep this info??? !-->\n"
"\n"
"<tr><td valign=top>--gdk-debug=FLAGS</td><td valign=top> &nbsp;&nbsp;Gdk debugging flags to set</td></tr>\n"
"<tr><td valign=top>--gdk-no-debug=FLAGS</td><td valign=top> &nbsp;&nbsp;Gdk debugging flags to unset</td></tr>\n"
"<tr><td valign=top>--display=DISPLAY</td><td valign=top> &nbsp;&nbsp;X display to use</td></tr>\n"
"<tr><td valign=top>--screen=SCREEN</td><td valign=top> &nbsp;&nbsp;X screen to use</td></tr>\n"
"<tr><td valign=top>--sync</td><td valign=top> &nbsp;&nbsp;Make X calls synchronous</td></tr>\n"
"<tr><td valign=top>--name=NAME</td><td valign=top> &nbsp;&nbsp;Program name as used by the window manager</td></tr>\n"
"<tr><td valign=top>--class=CLASS</td><td valign=top> &nbsp;&nbsp;Program class as used by the window manager</td></tr>\n"
"<tr><td valign=top>--gxid-host=HOST</td><td valign=top> </td></tr>\n"
"<tr><td valign=top>--gxid-port=PORT</td><td valign=top> </td></tr>\n"
"<tr><td valign=top>--gtk-debug=FLAGS</td><td valign=top> &nbsp;&nbsp;Gtk+ debugging flags to set</td></tr>\n"
"<tr><td valign=top>--gtk-no-debug=FLAGS</td><td valign=top> &nbsp;&nbsp;Gtk+ debugging flags to unset</td></tr>\n"
"<tr><td valign=top>--g-fatal-warnings</td><td valign=top> &nbsp;&nbsp;Make all warnings fatal</td></tr>\n"
"<tr><td valign=top>--gtk-module=MODULE</td><td valign=top> &nbsp;&nbsp;Load an additional Gtk module</td></tr>\n"
"\n"
"</table>\n"
"\n"
"</blockquote>\n"
"\n"
"\n"
"</ul>\n"
"\n"
"\n"
"\n"
"<br>\n"
"<h3>Key Bindings</h3>\n"
"\n"
"<blockquote>\n"
"Quickplot has GUIs for all of the following immutable keyboard short-cuts:\n"
"\n"
"\n"
"<ul>\n"
"\n"
"<li><b>a</b>&nbsp;&nbsp; show information <b><u>a</u></b>bout Quickplot using a web browser</li>\n"
"<li><b>b</b>&nbsp;&nbsp; toggles the visibility of the <b><u>b</u></b>utton bar</li>\n"
"<li><b>c</b>&nbsp;&nbsp; <b><u>c</u></b>opies the current focused main window frame</li>\n"
"<li><b>d</b>&nbsp;&nbsp; <b><u>d</u></b>elete the main window. This will not close the last main window.</li>\n"
"<li><b>f</b>&nbsp;&nbsp; makes a new main window <b><u>f</u></b>rame</li></li>\n"
"<li><b>g</b>&nbsp;&nbsp; show/hide the <b><u>g</u></b>raph configuration widget</li>\n"
"<li><b>h</b>&nbsp;&nbsp; show <b><u>h</u></b>elp using a web browser</li>\n"
"<li><b>i</b>&nbsp;&nbsp; save a PNG <b><u>i</u></b>mage of the graph</li>\n"
"<li><b>m</b>&nbsp;&nbsp; show/hide the <b><u>m</u></b>enu bar</li>\n"
"<li><b>n</b>&nbsp;&nbsp; make a <b><u>n</u></b>ew graph</li>\n"
"<li><b>o</b>&nbsp;&nbsp; <b><u>o</u></b>pen a data file</li>\n"
"<li><b>p</b>&nbsp;&nbsp; show/hide the <b><u>p</u></b>lot lister widget</li>\n"
"<li><b>q</b>&nbsp;&nbsp; <b><u>q</u></b>uit</li>\n"
"<li><b>s</b>&nbsp;&nbsp; toggles the visibility of the <b><u>s</u></b>tatus bar</li>\n"
"<li><b>t</b>&nbsp;&nbsp; toggles the visibility of the graph <b><u>t</u></b>abs</li>\n"
"<li><b>esc</b>&nbsp;&nbsp; close the current focused window. This will not close the last main window.</li>\n"
"\n"
"\n"
"</ul>\n"
"</blockquote>\n"
"\n"
"\n"
"&nbsp;<br>\n"
"\n"
"<center><hr></hr>\n"
"<a href=\"index.html\">Top</a><hr></hr>\n"
"<a href=\"http://quickplot.sourceforge.net/\">Quickplot</a>\n"
"&nbsp;&nbsp; version 0.8.6 &nbsp;&nbsp;\n"
"release date: Thu Jan 6 20:26:45 EST 2005\n"
"</center>\n"
"</body>\n"
"</html>\n"
;
