/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: check_for_stdin.c,v 1.1 1998/02/28 18:09:06 lance Exp $ */
#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#define WAIT_SECONDS 2

int check_for_stdin(void)
{
  fd_set rfds;
  struct timeval tv;
  
  /* Watch stdin (fd 0) to see when it has input. */
  FD_ZERO(&rfds);
  FD_SET(0, &rfds);
  /* Wait up to (tv.tv_sec)  seconds and (tv.tv_usec) micro seconds . */
  tv.tv_sec = WAIT_SECONDS;
  tv.tv_usec = 0;
  
  /* Don't rely on the value of tv now! */
  
  if (select(1, &rfds, NULL, NULL, &tv))
    /* printf("Data is available now.\n");*/
    /* FD_ISSET(0, &rfds) will be true */
    return 1;
  else
    /* printf("No data within %d seconds.\n",tv.tv_sec);*/
    return 0;
}

#if(0) /* test program */
/* cc -o test check_for_stdin.c */
main()
{
  printf("check_for_stdin() = %d\n",check_for_stdin());
}
#endif
