"""
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
"""

__version__ = "$Revision: 1.8 $"
# $Source: /cvsroot/quantlib/QuantLib-Python/QuantLib/test/complexmarketelements.py,v $

import math
import QuantLib
import unittest

class ComplexMarketElementTest(unittest.TestCase):
    def runTest(self):
        "Testing complex market element"
        # Testing derived market elements
        for f in [lambda x: x + 10,
                  lambda x: x * 10,
                  lambda x: x - 10]:
            me = QuantLib.SimpleMarketElement(17.0)
            h = QuantLib.MarketElementHandle(me)
            derived_me = QuantLib.DerivedMarketElement(h,f)
            derived_result = derived_me.value()
            function_result = f(me.value())
            if not (math.fabs(derived_result - function_result) < 1e-10):
                self.fail("""
derived market element yields %(derived_result)f
function result is %(function_result)f
                """ % locals())

        # Testing composite market element
        me1 = QuantLib.SimpleMarketElement(12.0)
        me2 = QuantLib.SimpleMarketElement(13.0)
        h1 = QuantLib.MarketElementHandle(me1)
        h2 = QuantLib.MarketElementHandle(me2)
        for f in [lambda x,y: x + y,
                  lambda x,y: x * y,
                  lambda x,y: x - y]:
            composite_me = QuantLib.CompositeMarketElement(h1,h2,f)
            composite_result = composite_me.value()
            function_result = f(me1.value(),me2.value())
            if not (math.fabs(composite_result - function_result) < 1e-10):
                self.fail("""
composite market element yields %(composite_result)f
function result is %(function_result)f
                """ % locals())


if __name__ == '__main__':
    print 'testing QuantLib', QuantLib.__version__, QuantLib.QuantLibc.__file__, QuantLib.__file__
    import sys
    suite = unittest.TestSuite()
    suite.addTest(ComplexMarketElementTest())
    if sys.hexversion >= 0x020100f0:
        unittest.TextTestRunner(verbosity=2).run(suite)
    else:
        unittest.TextTestRunner().run(suite)
    raw_input('press any key to continue')
