
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: String.i,v 1.9 2002/02/19 10:35:43 lballabio Exp $

#ifndef quantlib_string_i
#define quantlib_string_i


%{
typedef std::string String;
%}

%typemap(python,in) String, const String & {
    if (PyString_Check($source)) {
        $target = new std::string(PyString_AsString($source));
    } else {
        PyErr_SetString(PyExc_TypeError,"not a string");
        return NULL;
    }
};

%typemap(python,freearg) String, const String & {
    delete $source;
};

%typemap(python,out) String, const String & {
    $target = PyString_FromString($source->c_str());
};

%typemap(python,ret) String, const String & {
    delete $source;
};


// typemap Python list of strings to std::vector<std::string>

%{
	typedef std::vector<std::string> StringVector;
%}

%typemap(python,in) StringVector (StringVector temp), 
                    StringVector * (StringVector temp), 
                    const StringVector & (StringVector temp) {
    if (PyTuple_Check($source) || PyList_Check($source)) {
        int size = (PyTuple_Check($source) ?
            PyTuple_Size($source) :
            PyList_Size($source));
        temp = StringVector(size);
        $target = &temp;
		for (int i=0; i<size; i++) {
			PyObject* o = PySequence_GetItem($source,i);
			if (PyString_Check(o)) {
				(*$target)[i] = PyString_AsString(o);
                Py_DECREF(o);
			} else {
				PyErr_SetString(PyExc_TypeError,
				                "sequence must contain strings");
                Py_DECREF(o);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a sequence");
		return NULL;
	}
};

%typemap(python,out) StringVector, const StringVector & {
    $target = PyTuple_New($source->size());
    for (QL::Size i=0; i<$source->size(); i++)
        PyTuple_SetItem($target,i,PyString_FromString((*$source)[i].c_str()));
};

%typemap(python,ret) StringVector {
    delete $source;
}



#endif
