
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Operators.i,v 1.9 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_operators_i
#define quantlib_operators_i

%include QLArray.i
%include BoundaryConditions.i

%{
using QuantLib::FiniteDifferences::TridiagonalOperator;
%}

class TridiagonalOperator {
  public:
    // constructors
    TridiagonalOperator(Array low, Array mid, Array high);
    ~TridiagonalOperator();
    // operator interface
    Array solveFor(const Array& rhs) const;
    Array applyTo(const Array& v) const;
    // inspectors
    int size() const;
    // modifiers
    void setLowerBC(BoundaryCondition bc);
    void setUpperBC(BoundaryCondition bc);
    void setFirstRow(double, double);
    void setMidRow(int, double, double, double);
    void setMidRows(double, double, double);
    void setLastRow(double, double);
};

%addmethods TridiagonalOperator {
    TridiagonalOperator __add__(const TridiagonalOperator& O) {
        return *self+O;
    }
    TridiagonalOperator __sub__(const TridiagonalOperator& O) {
        return *self-O;
    }
    TridiagonalOperator __mul__(double a) {
        return *self*a;
    }
    TridiagonalOperator __div__(double a) {
        return *self/a;
    }
    TridiagonalOperator __iadd__(const TridiagonalOperator& O) {
        return *self+O;
    }
    TridiagonalOperator __isub__(const TridiagonalOperator& O) {
        return *self-O;
    }
    TridiagonalOperator __imul__(double a) {
        return *self*a;
    }
    TridiagonalOperator __rmul__(double a) {
        return *self*a;
    }
    TridiagonalOperator __idiv__(double a) {
        return *self/a;
    }
};

%{
typedef TridiagonalOperator TridiagonalIdentity;
using QuantLib::FiniteDifferences::DPlus;
using QuantLib::FiniteDifferences::DMinus;
using QuantLib::FiniteDifferences::DZero;
using QuantLib::FiniteDifferences::DPlusDMinus;
%}

// they are the same class, but fake inheritance to redefine the constructor
%name(Identity) class TridiagonalIdentity : public TridiagonalOperator {
  public:
    // constructor redefined below
    ~TridiagonalIdentity();
};

%addmethods TridiagonalIdentity {
    TridiagonalIdentity(int gridPoints) {
        return new TridiagonalOperator(
            TridiagonalOperator::identity(gridPoints));
    }
}

class DPlus : public TridiagonalOperator {
  public:
    DPlus(int gridPoints, double h);
    ~DPlus();
};

class DMinus : public TridiagonalOperator {
  public:
    DMinus(int gridPoints, double h);
    ~DMinus();
};

class DZero : public TridiagonalOperator {
  public:
    DZero(int gridPoints, double h);
    ~DZero();
};

class DPlusDMinus : public TridiagonalOperator {
  public:
    DPlusDMinus(int gridPoints, double h);
    ~DPlusDMinus();
};


%{
using QuantLib::FiniteDifferences::valueAtCenter;
using QuantLib::FiniteDifferences::firstDerivativeAtCenter;
using QuantLib::FiniteDifferences::secondDerivativeAtCenter;
%}

double valueAtCenter(const Array& a);

double firstDerivativeAtCenter(const Array& a, const Array& g);

double secondDerivativeAtCenter(const Array& a, const Array& g);

%{
using QuantLib::Math::SymmetricEigenvalues;
using QuantLib::Math::SymmetricEigenvectors;
%}

Array SymmetricEigenvalues(Matrix &s);

Matrix SymmetricEigenvectors(Matrix &s);


#endif
