
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Interpolation.i,v 1.11 2002/03/12 11:25:38 nando Exp $

#ifndef quantlib_interpolation_i
#define quantlib_interpolation_i

%include QLArray.i
%include Matrix.i

%{
using QuantLib::Array;
using QuantLib::Math::Matrix;
using QuantLib::Handle;
using QuantLib::Math::Interpolation;
using QuantLib::Math::LinearInterpolation;
using QuantLib::Math::CubicSpline;
using QuantLib::Math::Interpolation2D;
using QuantLib::Math::BilinearInterpolation;

// safe versions which copy their arguments
// Python users are not supposed to worry about lifetimes
class PyInterpolation {
  public:
    PyInterpolation(const Array& x, const Array& y, bool allowExtrapolation)
    : x_(x), y_(y) {}
    double __call__(double x) { return (*f_)(x); }
  protected:
    Array x_, y_;
    Handle<Interpolation<Array::const_iterator,
                         Array::const_iterator> > f_;
};

class PyInterpolation2D {
  public:
    PyInterpolation2D(const Array& x, const Array& y, const Matrix& m, bool allowExtrapolation)
    : x_(x), y_(y), m_(m) {}
    double __call__(double x, double y) { return (*f_)(x,y); }
  protected:
    Array x_, y_;
    Matrix m_;
    Handle<Interpolation2D<Array::const_iterator,
                           Array::const_iterator,
                           Matrix> > f_;
};


class PyLinearInterpolation : public PyInterpolation {
  public:
    PyLinearInterpolation(const Array& x, const Array& y, bool allowExtrapolation)
    : PyInterpolation(x,y,allowExtrapolation) {
        f_ = Handle<Interpolation<Array::const_iterator,
                                  Array::const_iterator> >(
                new LinearInterpolation<Array::const_iterator,
                                        Array::const_iterator>(
                    x_.begin(),x_.end(),y_.begin(), allowExtrapolation));
    }
};

class PyCubicSpline : public PyInterpolation {
  public:
    PyCubicSpline(const Array& x, const Array& y, bool allowExtrapolation)
    : PyInterpolation(x,y,allowExtrapolation) {
        f_ = Handle<Interpolation<Array::const_iterator,
                                  Array::const_iterator> >(
                new CubicSpline<Array::const_iterator,
                                Array::const_iterator>(
                    x_.begin(),x_.end(),y_.begin(), allowExtrapolation));
    }
};


class PyBilinearInterpolation : public PyInterpolation2D {
  public:
    PyBilinearInterpolation(const Array& x, const Array& y, const Matrix& m, bool allowExtrapolation)
    : PyInterpolation2D(x,y,m,allowExtrapolation) {
        f_ = Handle<Interpolation2D<Array::const_iterator,
                                    Array::const_iterator,
                                    Matrix> >(
                new BilinearInterpolation<Array::const_iterator,
                                          Array::const_iterator,
                                          Matrix>(
                    x_.begin(),x_.end(),y_.begin(),y_.end(),m_, allowExtrapolation));
    }
};
%}

%name(LinearInterpolation)
class PyLinearInterpolation {
  public:
    PyLinearInterpolation(const Array& x, const Array& y, bool allowExtrapolation);
    ~PyLinearInterpolation();
    double __call__(double x);
};

%name(CubicSpline)
class PyCubicSpline {
  public:
    PyCubicSpline(const Array& x, const Array& y, bool allowExtrapolation);
    ~PyCubicSpline();
    double __call__(double x);
};
    
%name(BilinearInterpolation)
class PyBilinearInterpolation {
  public:
    PyBilinearInterpolation(const Array& x, const Array& y, const Matrix& m, bool allowExtrapolation);
    ~PyBilinearInterpolation();
    double __call__(double x, double y);
};


#endif
