/*******************************************************************************
FILENAME:      sysconfig.cpp
REVISION:      2001.8.12 first created.
         
AUTHOR:        kingson benben00
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <iostream.h>
// Maybe a bug:	if the config file is not exist and you try to read it,
//		it maybe cause a never stop loop.
//		if the directory of the file is not exist,
//		it alse cause a endless loop
//	Reason: when use ifstream::ifstream(...), not note whether ifstream
//		is open or not.
//	Fixed:	use ifstream::is_open(), and if ifstream is not oepn,
//		use ofstream to new the file and reopen ifstream.
//		use a status function ok() to get right status.
//		if can not new this file, ok() will return false
//	
// iostream.h is different between unix and windows
// function: istream & gets( char **, char ='\n' ) can not find in windows
// so I change the source--
// use istream & getline( char *, int, char = '\n' ) instead :)
// now it only can deal with m_BUF_SIZE bytes, but I think it enough
#define m_BUF_SIZE 256
// only in function: ifstream & operator >> ( ifstream &a, CSysConfigGroup &b )
// I think it can work well like before 

#include <fstream.h>
#include "sysconfig.h"

/* CSysConfigGroup Implementation */

CSysConfigGroup::CSysConfigGroup (const char *szGroupName0)
{
   szGroupName = NULL;
   if (szGroupName0 != NULL)
       szGroupName = strdup (szGroupName0);
   pOurCap = NULL;
   nTotalCap = 0; 
}

CSysConfigGroup::~CSysConfigGroup ()
{
   if (pOurCap == NULL)
       return;
   for (int i = 0; i < nTotalCap; i++) 
   {
       free (pOurCap[i].szName);
       free (pOurCap[i].szValue);
   }
   free (pOurCap);
}

char *CSysConfigGroup::szGetGroupName ()
{
    return szGroupName;
}

bool CSysConfigGroup::SetGroupName (const char *szGroupName0)
{
    if (szGroupName != NULL)
        free (szGroupName);
    szGroupName = strdup (szGroupName0);
    return true;
}

SysConfigCap *CSysConfigGroup::pFindItem (const char *szItemName)
{
   if (pOurCap == NULL)
       return NULL;
   for (int i = 0; i < nTotalCap; i++) 
       if (strcmp (pOurCap[i].szName, szItemName) == 0)
           return &pOurCap[i];
   return NULL;
}

bool CSysConfigGroup::bChangeItem (const char *szItemName, const char *szNewValue)
{
    SysConfigCap *p;
    if ((p = pFindItem (szItemName)) == NULL)
         return bAddItem (szItemName, szNewValue);
    free (p->szValue);
    p->szValue = strdup (szNewValue);
    return true;
}

bool CSysConfigGroup::bAddItem (const char *szItemName, const char *szValue)
{
   if (pOurCap == NULL)
   {
       pOurCap = (SysConfigCap *) malloc (sizeof (SysConfigCap));
       nTotalCap = 1; 
   }
   else
   {
       nTotalCap ++;
       pOurCap = (SysConfigCap *) realloc 
                     (pOurCap, nTotalCap * sizeof (SysConfigCap));
   }
   pOurCap[nTotalCap - 1].szName = strdup (szItemName);
   pOurCap[nTotalCap - 1].szValue = strdup (szValue);
   return true;
}

char *CSysConfigGroup::szGetItemValue (const char *szItemName)
{
    SysConfigCap *p = pFindItem (szItemName);
    if (p == NULL)
        return NULL;
    return p->szValue;
}

ifstream & operator >> (ifstream &a, CSysConfigGroup &b)
{
   char *p, szTemp[128];
   char szItemName[128], szValue[128];
   int i;
   
   // char *buf;
   char *buf = new char[m_BUF_SIZE];
//   memset( buf, 0, m_BUF_SIZE );
   /* read the name */

//   if ( a.eof() )
//   {
//	delete buf;
//	return a;
//   }
	
   do
   {
       // a.gets(&buf);		   
       a.getline( buf, m_BUF_SIZE );
   }
   //while (buf != NULL && buf[0] == '\0');
   while ( !a.eof() && buf[0] == '\0' );
	
   
   //if (buf == NULL)
   if ( a.eof() )
   {
       // add by smartfish		   
       delete buf;	
       
       return a;
   }
   
   for (p = buf; *p != '['; p++)
       ;
   for (p++, i = 0; *p != ']' && *p; p++, i++)
       szTemp[i] = *p;
   szTemp[i] = '\0';
   b.SetGroupName (szTemp);

   do
   {
       // a.gets(&buf);	   
       a.getline( buf, m_BUF_SIZE );

       //if (buf == NULL)
       if ( a.eof() )
           break;

       if (buf[0] == '\0')
           break; 
       for (i = 0, p = buf; *p != '='; p++, i++)
            szItemName[i] = *p;
       szItemName[i] = '\0';

       for (i = 0, p++; *p != '\0'; p++, i++)
            szValue[i] = *p;
       szValue[i] = '\0';
       b.bAddItem (szItemName, szValue);
   }
   while (! a.eof () && buf[0] != '\0');
  
   // add by smartfish
   delete buf;
   
   return a;
}

ofstream & operator << (ofstream &a, CSysConfigGroup &b)
{
    
    a << "[" << b.szGroupName << "]" << "\n";
    for (int i = 0; i < b.nTotalCap; i++) 
        a << b.pOurCap[i].szName << "=" << b.pOurCap[i].szValue << "\n";
    a << "\n";
    return a;
}

/* SysConfig Implementation */
CSysConfig::CSysConfig (const char *szFileName0)
{
    ppOurGroup = NULL;
    nTotalGroup = 0;
    if (szFileName0 != NULL)
    {
        szFileName = strdup (szFileName0);
        ifstream mystream (szFileName);

	// add by smartfish
	if ( !mystream.is_open() )
	{
		mystream.close();	
		ofstream out (szFileName);
		out.close();
		mystream.open(szFileName);
	}
	if ( !mystream.is_open() )
	{
		bOK = false;
		return;
	}		

        CSysConfigGroup *pTmpGroup;
        do
        {
            pTmpGroup = new CSysConfigGroup ();
            mystream >> *pTmpGroup;
            if (pTmpGroup->nTotalCap == 0) 
            {
                delete pTmpGroup;
                continue;
            }
            AddGroup (pTmpGroup);
        }
        while (! mystream.eof ());
	
	mystream.close();
    }
    else
        szFileName = NULL;    

    modified = 0;

    bOK = true;

}

bool CSysConfig::ok()
{
	return bOK;
}

CSysConfig::~CSysConfig ()
{
    if (szFileName != NULL)
        free (szFileName);
    if (modified)
        bSave (szFileName);
    for (int i = 0; i < nTotalGroup; i++)
        delete ppOurGroup[i];
}

bool CSysConfig::bSave (const char *szFileName)
{
    ofstream mystream (szFileName);
    for (int i = 0; i < nTotalGroup; i++)
        mystream << *ppOurGroup[i];
    modified = 0;
    mystream.close();
    return true;
}

CSysConfigGroup *CSysConfig::AddGroup (CSysConfigGroup *p)
{
     if (ppOurGroup == NULL)
     {
         nTotalGroup = 1;
         ppOurGroup = (CSysConfigGroup **) malloc
                      (nTotalGroup * sizeof (CSysConfigGroup *));
     }    
     else
     {
         nTotalGroup ++;
         ppOurGroup = (CSysConfigGroup **) realloc
                 (ppOurGroup, nTotalGroup * sizeof (CSysConfigGroup *));
     }
     ppOurGroup[nTotalGroup - 1] = p;
     return p;
}

CSysConfigGroup *CSysConfig::pFindGroup (const char *szGroup)
{
    CSysConfigGroup *p = NULL;
    for (int i = 0; i < nTotalGroup; i++)
    {
        if (strcmp (ppOurGroup[i]->szGetGroupName(), szGroup) == 0)
        {
             p = ppOurGroup[i];
             break;
        }
    }
    return p;
}

bool CSysConfig::bWriteCapItem (const char *szGroup, 
                       const char *capName, const char *value)
{
    CSysConfigGroup *p = pFindGroup (szGroup);

    if (p == NULL)
        p = pCreateNewGroup (szGroup);

    p->bAddItem (capName, value);
    modified = 1;
    return true;
}

//add by kingson
bool CSysConfig::bChangeCapItem(const char *szGroup,const char *szCapName,const char *szNewValue)
{
    CSysConfigGroup *p = pFindGroup (szGroup);

    if (p == NULL)
    {
	    p = pCreateNewGroup (szGroup);
	    p->bAddItem (szCapName, szNewValue);
    }
    else
	    p->bChangeItem(szCapName,szNewValue);

    modified = 1;
    return true;

}

void CSysConfig::DeleteGroup(const char *szGroup)
{

    CSysConfigGroup *p =pFindGroup (szGroup);
    if(p!=NULL)
    {
	    delete p;
	    nTotalGroup--;
    }

}
char *CSysConfig::szReadCapItem (const char *szGroup, const char *szCapName)
{
    CSysConfigGroup *p = pFindGroup (szGroup);
    if (p == NULL)
        return NULL;
    return p->szGetItemValue (szCapName);
}


CSysConfigGroup *CSysConfig::pCreateNewGroup (const char *szGroup)
{
    CSysConfigGroup *p = new CSysConfigGroup (szGroup);
    return AddGroup (p);
}

