#ifndef QPPDVIEW_H
#define	QPPDVIEW_H

#include <qlistview.h>
#include <qdict.h>

#include <cups/cups.h>
#include <cups/ppd.h>
#include "globalppd.h"

class QPPDBaseItem;

class QPPDView : public QListView
{
	Q_OBJECT;
public:
	QPPDView(global_ppd_file_t *ppd = 0, QWidget *parent = 0, const char *name = 0);
	~QPPDView();

	void initialize(global_ppd_file_t *ppd, cups_dest_t *dest = 0);
	void markChoices(global_ppd_file_t *ppd);
	void updateChoices(global_ppd_file_t *ppd);
	void getCupsOptions(int& num_options, cups_option_t **options, bool incldef = false);
	bool hasConflict();
	void checkConflict();

public slots:
	void checkConstraints();

protected:
	void resizeEvent(QResizeEvent *);

private:
	global_ppd_file_t	*ppd_;
	QPPDBaseItem	*rootitem_;
	QDict<QPPDBaseItem>	options_;
	bool		conflict_;
};

#endif
