#ifndef QPPDOPTIONVIEW_H
#define	QPPDOPTIONVIEW_H

#include <qgroupbox.h>

class QListBox;
class QButtonGroup;
class QWidgetStack;
class NumericWidget;
class QListViewItem;
class QPPDOptionItem;
class QPPDNumericalOptionItem;
class QPPDBaseItem;

class QPPDOptionView : public QGroupBox
{
	Q_OBJECT;
public:
	enum ViewType {List, Radio, Numeric};
	QPPDOptionView(QWidget *parent = 0, const char *name = 0);
	~QPPDOptionView();
	void setAllowNonChangeable(bool on = true) { allowNonChangeable_ = on; }
	bool allowNonChangeable() const { return allowNonChangeable_; }
	QSize sizeHint() const;
signals:
	void optionChanged();
public slots:
	void setOption(QListViewItem *item);
	void selectionChanged(int index);
	void valueChanged(double value);
private:
	QWidgetStack	*stack_;
	QListBox	*optionpickone_;
	QButtonGroup	*optionboolean_;
	NumericWidget	*optionnumeric_;
	QWidget	*optionempty_;
	QPPDBaseItem	*ppdopt_;
	bool		allowNonChangeable_;
};

#endif
