#ifndef	QPPDBASEITEM_H
#define	QPPDBASEITEM_H

#include <qlistview.h>
#include <qpixmap.h>
#include <qlist.h>
#include <qdict.h>

#include <cups/ppd.h>
#include <cups/cups.h>
#include "globalppd.h"

class QPPDBaseItem : public QListViewItem
{
public:
	enum OptionType { Regular, Numeric };

	QPPDBaseItem(global_ppd_file_t *ppd, QListView *parent);
	QPPDBaseItem(global_ppd_file_t *ppd, QListViewItem *parent);
	QPPDBaseItem(global_ppd_file_t *ppd, QListViewItem *parent, QListViewItem *after);
	~QPPDBaseItem();

	virtual void setConflict(bool on = true);
	virtual void paintCell(QPainter *P, const QColorGroup& cg, int column, int width, int align);
	virtual int textWidth(QPainter *p) const;
	virtual void paintText(QPainter *p, const QColorGroup& cg, int r);
	virtual void setupDict(QDict<QPPDBaseItem>& dict) const;
	bool isGroup() const { return !children_.isEmpty(); }
	bool isOption() const { return (children_.isEmpty() && depth()>1 && type_ == Regular); }
	bool isNumeric() const { return (children_.isEmpty() && depth()>1 && type_ == Numeric); }
	bool showConflict() const { return (conflict_ && (isOption() || (isGroup() && !isOpen()))); }
	virtual void updateConflict() {}

	virtual void markChoices(global_ppd_file_t *ppd);
	virtual void getCupsOptions(int& num_options, cups_option_t **options, bool incldef = false);
	virtual void updateChoices(global_ppd_file_t *ppd);

public:
	bool	conflict_;
	QList<QPPDBaseItem>	children_;
	global_ppd_file_t	*ppd_;
	int			type_;
};

#endif
