/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : jeu jun 15 09:52:49 CEST 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@emic.ucl.ac.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <stdlib.h>
#include <qmessagebox.h>

#include <qwindowsstyle.h>

#include <cups/ipp.h>

#include <signal.h>

void signal_handler(int);
char tempFile[1024];
bool fromStdin = false;
char job_output = 0;	// 0: dialog, 1: console, 2: none

#include "qcupsprintdialog.h"
#include "qtcups.h"

void showmsgdialog(const char *msg, int type = 0) {
	switch (type) {
	   case 0: QMessageBox::information(NULL,QObject::tr("Print information"),msg,QMessageBox::Ok|QMessageBox::Default,0); break;
	   case 1: QMessageBox::warning(NULL,QObject::tr("Print warning"),msg,QMessageBox::Ok|QMessageBox::Default,0); break;
	   case 2: QMessageBox::critical(NULL,QObject::tr("Print error"),msg,QMessageBox::Ok|QMessageBox::Default,0); break;
	}
}

void showmsgconsole(const char *msg, int type = 0) {
	debug(type == 0 ? "Print info: %s" : (type == 1 ? "Print warning: %s" : "Print error: %s"),msg);
}

void showmsg(const char *msg, int type = 0) {
	switch (job_output) {
	   case 0: showmsgdialog(msg,type); break;
	   case 1: showmsgconsole(msg,type); break;
	   default: break;
	}
}

void errormsg(const char *msg) {
	showmsg(msg,2);
	exit(1);
}

int main(int argc, char *argv[])
{
  QApplication a(argc, argv);
  a.setFont(QFont("helvetica", 12));
  /* uncomment the following line, if you want a Windows 95 look*/
  a.setStyle(new QWindowsStyle);

	// install translation
	QtCUPS::setLocale();

	// initialize variables
	const char	*files[100] = {0};	// maximum 100 files to print
	int		num_files(0);
	int		num_options(0);
	cups_option_t	*options(0);
        QString		title("QtCups");
        QString		printer;
        bool		hasFiles(false);

#if defined(HAVE_SIGACTION) && !defined(HAVE_SIGSET)
	struct sigaction action;
#endif /* HAVE_SIGACTION && !HAVE_SIGSET*/

        // parse command line and update variables
        for (int i=1;i<argc;i++)
        	if (argv[i][0] == '-')
        		switch (argv[i][1]) {
        		   case 'd':	// printer or destination
        		   	if (argv[i][2] != '\0')
        		   		printer = argv[i]+2;
        		   	else
        		   		printer = argv[++i];
        		   	break;
        		   case 't':	// title
        		   	if (argv[i][2] != '\0')
        		   		title = argv[i]+2;
        		   	else
        		   		title = argv[++i];
        		   	break;
        		   case 'o':	// option
        		   	if (argv[i][2] != '\0')
        		   		num_options = cupsParseOptions(argv[i]+2,num_options,&options);
        		   	else
        		   		num_options = cupsParseOptions(argv[++i],num_options,&options);
        		   	break;
        		   case 'j':	// job output mode
        		   	if (argv[i][2] != '\0') {
        		   		if (strcmp(argv[i]+2,"console") == 0) job_output = 1;
        		   		else if (strcmp(argv[i]+2,"none") == 0) job_output = 2;
        		   	}
        		   	else {
        		   		i++;
	       		   		if (strcmp(argv[i],"console") == 0) job_output = 1;
	       		   		else if (strcmp(argv[i],"none") == 0) job_output = 2;
        		   	}
        		   	break;
        		   default:	// unsupported option -> show message and exit
								printer = QObject::tr("Unsupported option : %1").arg(argv[i]);
        		   	errormsg(printer.data());
        		   	break;
        		}
        	else {	// file to print
        		hasFiles = true;
        		if (access(argv[i],F_OK) != 0) {	// file not found
        			QString	msg = QObject::tr("\"%s\": file not found").arg(argv[i]);
        			showmsg(msg.data(),2);
        		}
        		else files[num_files++] = argv[i];
         	}
	// do nothing if only inexistent files
	if (hasFiles && num_files == 0) exit(1);

	// update title if only 1 file
	if (num_files == 1) title = files[0];
	
	// initialize print setup dialog (printer name, and print options)
	QCupsPrintDialog	dlg;
	if (!printer.isEmpty()) dlg.setPrinter(printer.data());
	if (num_options > 0) dlg.setCupsOptions(num_options,options);
	// show it
	if (dlg.exec()) {
		dlg.getAllOptions(num_options,&options);
		printer = dlg.printerName();

		// output everything (for debug only)
/*		printf("printer = %s\n",printer.data());
		for (int i=0;i<num_options;i++) {
			cups_option_t	*opt = options+i;
			printf("%s = %s\n",opt->name,opt->value);
		}
		return (0);*/

		if (num_files == 0) {
			// print from stdin
			//errormsg("Print from STDIN not yet supported");

#  if defined(HAVE_SIGSET)
			sigset(SIGHUP, signal_handler);
			sigset(SIGINT, signal_handler);
			sigset(SIGTERM, signal_handler);
#  elif defined(HAVE_SIGACTION)
			memset(&action, 0, sizeof(action));
			action.sa_handler = signal_handler;

			sigaction(SIGHUP, &action, NULL);
			sigaction(SIGINT, &action, NULL);
			sigaction(SIGTERM, &action, NULL);
#  else
			signal(SIGHUP, signal_handler);
			signal(SIGINT, signal_handler);
			signal(SIGTERM, signal_handler);
#  endif

			num_files = 1;
			cupsTempFile(tempFile,sizeof(tempFile));
			files[0] = tempFile;
			fromStdin = true;
			FILE	*fout = fopen(files[0],"w");
			if (!fout) errormsg(QObject::tr("Unable to open temporary file"));
			char	buffer[8192];
			int	s;

			// read stdin and write to temporary file
			while ((s=fread(buffer,1,sizeof(buffer),stdin)) > 0)
				fwrite(buffer,1,s,fout);

			s = ftell(fout);
			fclose(fout);
			if (s <= 0) errormsg(QObject::tr("Stdin is empty, no job sent"));
		}
		// print all files
		int	id = cupsPrintFiles(printer.data(),num_files,files,title.data(),num_options,options);

		if (id <= 0) errormsg(ippErrorString(cupsLastError()));
		else {
			QString	msg;
			msg.sprintf(QObject::tr("Job sent (ID = %d)"),id);
			showmsg(msg,0);
		}

		// if printing from stdin, remove temporary file
		if (fromStdin) unlink(files[0]);
	}

	return (0);
}

void signal_handler(int s) {
	unlink(tempFile);
	exit(s);
}
