#include "repeater.h"
#include "qsstvglobal.h"
#include "sstvrx.h"
#include "sstvtx.h"
#include "thumbwindow.h"
#include "configdiag.h"

bool brepeater;
bool brepGetPicture;

repeater::repeater()
{
  brepGetPicture=FALSE;
  autoImagePtr=0;
  imageTimer = new QTimer(this,"imTimer");
  delayTimer = new QTimer(this,"delTimer");
  delayPicTimer = new QTimer(this,"delPicTimer");
  abortTimer = new QTimer(this,"abortTimer");
  connect( imageTimer, SIGNAL(timeout()),this,SLOT(slotAutoTX()) );
  connect( delayTimer, SIGNAL(timeout()),this,SLOT(slotDelAck()) );
  connect( delayPicTimer, SIGNAL(timeout()),this,SLOT(slotDelPicSend()) );
  connect( abortTimer, SIGNAL(timeout()),this,SLOT(slotAbortWaitStart()) );
  connect(tx,SIGNAL(signalTXEnd()),SLOT(slotTXEnd()));
} 

repeater::~repeater()
{
  
} 


void repeater::slotRepeaterButton(bool b)
{
  brepeater=b;
  brepGetPicture=FALSE;
  if(rx) // avoid calling rx during startup
    {
      rx->slotStop();
      rx->slotStart();
    }
  if(b)
    {
      restartImageTimer(); 
    }
  else
    {
      imageTimer->stop(); 
    }
}


void repeater::restartImageTimer()
{
  imageTimer->stop();
  if(irepImInterval>0)
  	{
  		imageTimer->start(irepImInterval*60000,TRUE);
  	}
}

  
void  repeater:: slotSendAck()
{

  delayTimer->start(10,TRUE);
  restartImageTimer();
 
}

void repeater::slotDelAck()
{

  tx->sendCWstr(configFile.readOption("RepeaterAckText"));
  
}

void repeater::slotAbortWaitStart()
{
  if(!rx->bincomingImage)
    {
      brepGetPicture=FALSE;
      rx->slotStop();
      rx->slotStart();
    }

}

void repeater::slotTXEnd()
{
	if(!brepeater) return;
  if(!brepGetPicture)
    { 
      abortTimer->start(9000,TRUE); 
    }

  brepGetPicture=!brepGetPicture; // toggle it
  rx->slotStart();
}

void  repeater::slotSendPicture(int tc)
{
  tx->modeChange(tc);
  delayPicTimer->start(3000,TRUE);
}

void  repeater::slotDelPicSend()
{
 QString t;
 QFileInfo *f;
 f=tw->getLatest();
 t=f->filePath(); 
 if (!t.isEmpty())
   {
     tx->load(t);
   }
 tx->slotStart();

}


void  repeater::slotAutoTX()
{
  char str1[20];
  const char *str2;

  sprintf(str1,"Repeaterimage%d",autoImagePtr+1);
  str2=configFile.readOption(str1);
  if(++autoImagePtr>=NUMBEROFREPEATERIMAGES)
    {
      autoImagePtr=0;
    }
  tx->modeChange(lookupModeString(configFile.readOption("RepeaterMode")));
  brepGetPicture=FALSE; //tx will autamatically restart rx
  if(tx->load(str2,FALSE))
    {
      tx->slotStart();
    }
  else
    {
      rx->slotStart();
    }
  restartImageTimer();  
}



