/***************************************************************************
                          ftp.cpp  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ftp.h"

#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qdns.h>
#include <qprogressbar.h>
#include "qsstvglobal.h"
#include <unistd.h>
#include <qsocket.h>
#include <stdlib.h>

//#define DEBUGFTP

ftp::ftp(QString h, QString u,QString p): ftpForm()
{
	hide();
	commandSocket = new QSocket( this );
	connect(commandSocket,SIGNAL(hostFound()),this,SLOT(commandHostFound()));
	connect(commandSocket,SIGNAL(connected()),this,SLOT(commandConnected()));
	connect(commandSocket,SIGNAL(connectionClosed()),this,SLOT(commandClosed()));
	connect(commandSocket,SIGNAL(readyRead()),this,SLOT(commandReadyRead()));
	connect(commandSocket,SIGNAL(error(int)),this,SLOT(commandError(int)));
	dataSocket = new QSocket( this );
	connect(dataSocket,SIGNAL(hostFound()),this,SLOT(dataHostFound()));
	connect(dataSocket,SIGNAL(connected()),this,SLOT(dataConnected()));
	connect(dataSocket,SIGNAL(connectionClosed()),this,SLOT(dataClosed()));
	connect(dataSocket,SIGNAL(readyRead()),this,SLOT(dataReadyRead()));
	connect(dataSocket,SIGNAL(error(int)),this,SLOT(dataError(int)));
	connect(dataSocket,SIGNAL(bytesWritten(int)),this,SLOT(dataBytesWritten(int)));	
	ftpState=FTPIDLE;
	hostName=h;
	userName=u;
	password=p;
}

ftp::~ftp()
{
	delete commandSocket;
	delete dataSocket;
}


void ftp::slotCancel()
{
	delete this;
}

void ftp::upload(QString s,QString ren,QString remDir)
{
	fromName=s;
	renam=ren;
	remoteDir=remDir;
	written=0;
	inpf.setName(fromName);
	if(!inpf.open(IO_ReadOnly)) return;
	show();
	commandSocket->connectToHost(hostName,iftpPort);
	progressBar->setTotalSteps( inpf.size());
	progressBar->reset();
}



void ftp::commandHostFound()
{
#ifdef DEBUGFTP
	debug("ftp: commandHostFound");
#endif
	ftpState=FTPHOSTFOUND;
}

void ftp::commandConnected()
{
#ifdef DEBUGFTP
	debug("ftp: commandConnected");
#endif
	ftpState=FTPCONNECTED;
}

void ftp::commandClosed()
{
#ifdef DEBUGFTP
	debug("ftp: commandClosed");
#endif
}

void ftp::commandReadyRead()
{
	QString s,r;
#ifdef DEBUGFTP
	debug("ftp: commandReadyRead");
#endif
	r=commandSocket->readLine();
	statusLine->setText(r);
#ifdef DEBUGFTP
	debug("ftp: read: %s",(const char *)r);
#endif
//Lookup return code
	int p=atoi(r.left(3));
	switch (ftpState)
		{
			case FTPCONNECTED:
				if (p!=220)
					{
						debug("ftp: connection failed error %d",p);
						delete this;
					}
				else
					{
						// login proces
						ftpState=FTPLOGIN;
						s="USER "+userName +"\r\n";
						commandSocket->writeBlock(s,s.length());
					}
			break;
			case FTPLOGIN:
				{
					if(p==331)
						{
							s="PASS " + password +"\r\n";
							commandSocket->writeBlock(s,s.length());
							ftpState=FTPPASSW;
						}
					else if (p==230)
						{
							ftpState=FTPPASSW;
						}
					else
						{
							quitFTP();
						}
				}
			break;
			case FTPPASSW:
				{
					if((p==230)||(p==202))
						{
							ftpState=FTPCWD;
							s="CWD "+remoteDir+"\r\n";
							commandSocket->writeBlock(s,s.length());
						}
					else
					{
						quitFTP();
					}
				}
			break;
			case FTPCWD:
				{
					if(p==250)
						{
							ftpState=FTPBIN;
							s="TYPE I\r\n";
							commandSocket->writeBlock(s,s.length());
						}
					else
						{
							quitFTP();
						}
				
				}
			break;
			
			case FTPBIN:
				{
					if(p==200)
						{
							ftpState=FTPPASV;
							s="PASV\r\n";
							commandSocket->writeBlock(s,s.length());
						}
					else
						{
							quitFTP();
						}
				
				}
			break;
			
			case FTPPASV:
				{
					if(p==227)
						{
							// setup ip-address and portnumber
							QString s = r;
							int i = s.find( "(" );
							int i2 = s.find( ")" );
							s = s.mid( i + 1, i2 - i - 1 );
							if ( dataSocket->isOpen() )  dataSocket->close();
							QStringList lst = QStringList::split( ',', s );
							int port = ( lst[ 4 ].toInt() << 8 ) + lst[ 5 ].toInt();
							dataSocket->connectToHost(lst[0]+"."+lst[1]+"."+lst[2]+"."+lst[3], port);
							ftpState=FTPDATAOPEN;
							QFileInfo t(inpf);
							s="STOR " + t.fileName() + "\r\n";
							commandSocket->writeBlock(s,s.length());
						}
					else
						{
							quitFTP();
						}
				}
			break;
			case FTPDATAOPEN:
				{
					if((p==125)||(p==150))
						{
							int len=inpf.readBlock(tempBuf,255);
							dataSocket->writeBlock(tempBuf,len);
						}
					else if(p==226)
						{
							// data transfer complete
							s="DELE " + renam +"\r\n";
							commandSocket->writeBlock(s,s.length());
							ftpState=FTPDELETE;
						}
					else
						{
							quitFTP();
						}
				}
			break;
			case FTPDELETE:
				{
					if((p==250)||(p==450)||(p==550))
						{
							ftpState=FTPRENFROM;
							QFileInfo t(inpf);
							s="RNFR " + t.fileName()+"\r\n" ;
							commandSocket->writeBlock(s,s.length());
						}
					else
						{
							quitFTP();
						}					
				}
			break;
			case FTPRENFROM:
				{
					if(p==350)
						{
							ftpState=FTPEND;
							s="RNTO " + renam+"\r\n" ;
							commandSocket->writeBlock(s,s.length());
						}
					else
						{
							quitFTP();
						}
				}
			break;
			case FTPEND:
				{
					quitFTP();
				}
			break;
			case FTPQUIT:
				{
					delete this;
				}
			break;
			default:
				debug("ftp: ftpstate illegal state %d",(int)ftpState);
		}
}


void ftp::quitFTP()
{
	if (dataSocket->isOpen()) dataSocket->close();
	QString s="QUIT\r\n";
	commandSocket->writeBlock(s,s.length());
	ftpState=FTPQUIT;
}

void ftp::dataHostFound()
{
#ifdef DEBUGFTP
	debug("ftp: dataHostFound");
#endif
}
void ftp::dataConnected()
{
#ifdef DEBUGFTP
	debug("ftp: dataConnected");
#endif
}


void ftp::dataClosed()
{
#ifdef DEBUGFTP
	debug("ftp: dataClosed");
#endif
}
void ftp:: dataReadyRead()
{
#ifdef DEBUGFTP
	debug("ftp: dataReadyRead");
#endif
}


void ftp::commandError(int e)
{
	dataError(e);
}

void ftp::dataError(int e)
{
#ifdef DEBUGFTP
	debug("ftp: dataError %d",e);
#endif
	switch (e)
		{
			case QSocket::ErrConnectionRefused:
				debug("ftp: connection refused");
			break;
			
			case QSocket::ErrHostNotFound:
				debug("ftp: host not found");
			break;
			case QSocket::ErrSocketRead:
				debug("ftp: socjket read error");
			break;
			default:
				debug("unknown socket error");
			break;
	}
	commandSocket->close();
	dataSocket->close();
	delete this;		
}

void ftp::dataBytesWritten(int b)
{
	int len;
	written+=(uint) b;
	progressBar->setProgress(written);
	len=inpf.readBlock(tempBuf,255);
	if (len>0) dataSocket->writeBlock(tempBuf,len);
	else
		{
			dataSocket->close();
		}
}
