/***************************************************************************
                          rxtxcommon.h  -  QSSTV
                             -------------------
    begin                : Fri Jun 15 2001
    copyright            : (C) 2001 by Johan Maes
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RXTXCOMMON_H
#define RXTXCOMMON_H
#include <qtimer.h>
#include "sstvparam.h"

#ifdef  DEBUGQSSTV
#include "debugger.h"
#endif


/**
  *@author Johan Maes
  */

class rxtxCommon
{
public: 
	rxtxCommon();
	~rxtxCommon();
	void calculateTiming();
protected:
	QTimer *timer;
	bool dumpActive;
	unsigned long imageSampleCounter;
	unsigned long stateSampleCounter;
	unsigned short int lineCounter;
	enum eTxRxState state;
	enum efaxState faxState;
	unsigned int visCode;
  unsigned int visBits;
	double startTime;
	double hsTime;
	double bpTime;
	double f1Time;
  double f2Time;
  double f3Time;
  double f4Time;
  double f5Time;
  double fpTime;
  double p6Time;
  double p7Time;
  double p8Time;
  double time1PerPixel;
  double time2PerPixel;
  double lineTime;	
  unsigned int pixelCounter;
  unsigned int linePixelCounter;
	unsigned int pixelsPerLine;
	float sample;
	short int isample;
	unsigned int *videoBuffer0;
  unsigned int *videoBuffer1;
  float sampleSum;
	int pcounter;
	unsigned long sampleCounter;
#ifdef  DEBUGQSSTV
	debugger *deb;
	void sendToDebugger();
#endif
	void initAllCounters();
};

#endif
