/*
	Description: start-up dialog

	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qsettings.h>
#include "common.h"
#include "rangeselectimpl.h"

using namespace QGit;

RangeSelectImpl::RangeSelectImpl(QWidget* par, QString* r, const QStringList& tl,
                                 bool* q) : RangeSelectBase(par, 0, true) {
	range = r;
	quit = q;
	*quit = true; // if user press ESC everything works as expected
	QStringList tmp1(tl), tmp2; // tag list tl is unsorted
	tmp1.sort();
	loopList(it, tmp1)
		tmp2.prepend(*it);

	comboBoxTo->insertStringList(tmp2);
	comboBoxTo->insertItem("HEAD", 0);
	comboBoxFrom->insertStringList(tmp2);
	comboBoxFrom->setFocus();

	int f = flags();
	checkBoxDiffCache->setChecked(f & DIFF_INDEX_F);
	checkBoxShowAll->setChecked(f & ALL_BRANCHES_F);
	checkBoxShowWholeHistory->setChecked(f & WHOLE_HISTORY_F);
	checkBoxShowDialog->setChecked(f & RANGE_SELECT_F);
}

void RangeSelectImpl::checkBoxDiffCache_toggled(bool b) {

	setFlag(DIFF_INDEX_F, b);
}

void RangeSelectImpl::checkBoxShowDialog_toggled(bool b) {

	setFlag(RANGE_SELECT_F, b);
}

void RangeSelectImpl::pushButtonOk_clicked() {

	*range = comboBoxFrom->currentText();
	if (!range->isEmpty())
		range->append("..");

	range->append(comboBoxTo->currentText());
	range->prepend(lineEditOptions->text() + " ");
	*range = range->stripWhiteSpace();
	*quit = false;
	close();
}

void RangeSelectImpl::checkBoxShowAll_toggled(bool b) {

	QString opt(lineEditOptions->text());
	opt.remove("--all");
	if (b)
		opt.append(" --all");

	lineEditOptions->setText(opt.stripWhiteSpace());
	setFlag(ALL_BRANCHES_F, b);
}

void RangeSelectImpl::checkBoxShowWholeHistory_toggled(bool b) {

	if (b) {
		fromBckUp = comboBoxFrom->currentText();
		toBckUp = comboBoxTo->currentText();
		comboBoxFrom->setCurrentText("");
		comboBoxTo->setCurrentText("HEAD");

	} else {
		comboBoxFrom->setCurrentText(fromBckUp);
		comboBoxTo->setCurrentText(toBckUp);
	}
	comboBoxFrom->setEnabled(!b);
	comboBoxTo->setEnabled(!b);
	setFlag(WHOLE_HISTORY_F, b);
}
