/*
 * qdacco: offline Dacco Catalan <-> English dictionary
 * Copyright (C) 2005-2006 Carles Pina i estany <carles@pina.cat>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 or any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
*/


#ifndef HTTPCONNECTION_H
#define HTTPCONNECTION_H

#include <QApplication>
#include <QDialog>
#include <QMessageBox>
#include <QtNetwork>
#include <QMainWindow>
#include "auxiliar.h"
//#include "main.h"

/*Original idea to program it from:
 * http://cvs.sourceforge.net/viewcvs.py/kmess/kmess/kmess/network/extra/httpsoapconnection.h?rev=1.1&view=auto
 */

class HTTPConnection : public QObject {
	Q_OBJECT

	public:
		HTTPConnection (QMainWindow *window);
		//virtual ~Connection();
		
		int sendNewWord(const QString &paraula, const QString &user,const QString &email, int idioma_actiu);

		int sendSuggestion(const QString &paraula,const QString &translation, const QString &examples, const QString &notes, const QString &user, const QString &email, int idioma_actiu);

		int send_post(const QString &q);

		QString* getStateError();


	private slots:
		void slotHeaderReceived(const QHttpResponseHeader &header);
		void slotRequestFinished(int id, bool error);

	private:
		QHttp *http;
	
	signals:
		void requestFailed();
		void requestFinished();
};
#endif
