/*
 * qdacco: offline Dacco Catalan <-> English dictionary
 * Copyright (C) 2005-2006 Carles Pina i estany <carles@pina.cat>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 or any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
*/


#ifndef HTTPCONNECTION_CPP
#define HTTPCONNECTION_CPP

#include "connection.h"

/*Original idea to program it from:
http://cvs.sourceforge.net/viewcvs.py/kmess/kmess/kmess/network/extra/httpsoapconnection.cpp?rev=1.1&view=auto
 */

HTTPConnection::HTTPConnection(QMainWindow *m) {
	http = new QHttp(Auxiliar::getHost(), 80);
	/*connect(http,SIGNAL(requestFinished(int,bool)),
			this, SLOT(slotRequestFinished(int,bool)));
	*/
	connect(http,SIGNAL(requestFinished(int,bool)),
			m,SLOT(changeActive(int,bool)));
}

int HTTPConnection::sendNewWord(const QString &paraula, const QString &user,
				const QString &email, int idioma_actiu) {
	QString idioma;
	QString *content;

	if (idioma_actiu==1) {
		idioma="catal";
	}
	else {
		idioma="english";
	}

	content=new QString("name="+user+"&version="+Auxiliar::getVersion()+"&word="+paraula+"&email="+email+"&language="+idioma+"&type=new");
	
	send_post(*content);

	return 0;
}

int HTTPConnection::sendSuggestion(const QString &paraula,const QString &translation, const QString &examples, const QString &notes, const QString &user, const QString &email, int idioma_actiu) {
	QString idioma;
	QString *content;
	
        if (idioma_actiu==1) {
                idioma="catal";
        }
        else {
                idioma="english";
        }

	content=new QString("name="+user+"&version="+Auxiliar::getVersion()+"&word="+paraula+"&email="+email+"&language="+idioma+"&translation="+translation+"&examples="+examples+"&notes="+notes+"&type=suggestion");
	
	send_post(*content);
	
	return 0;
}


int HTTPConnection::send_post(const QString &q) {
	QByteArray content; 
	content = q.toUtf8();

	QHttpRequestHeader header("POST", Auxiliar::getURL());

	//header.setContentType("text/xml; charset=\"utf-8\"");
	header.setContentType("application/x-www-form-urlencoded");
	header.setContentLength(content.length());
	header.setValue("Host",Auxiliar::getHost());

	http->request(header,content);

	return 0;
}

void HTTPConnection::slotHeaderReceived(const QHttpResponseHeader &header) {
	//printf("Rebut a slotHeaderReceived: %s\n",(const char*)header.reasonPhrase());
}

void HTTPConnection::slotRequestFinished(int id, bool error) {
	/*
	if (http->error() == QHttp::NoError) {
		printf("Entrada enviada correctament\n");
	}
	else {
		printf("Problema enviant l'entrada: %s\n",(const char*)http->errorString());
	}*/
}


QString* HTTPConnection::getStateError() {
	QString *ret;
	
	if (http->error() == QHttp::NoError) {
		ret=new QString("");
	}
	else {
		ret=new QString(http->errorString());
	}
	return ret;
}
#endif
