/*
 * qdacco: offline Dacco Catalan <-> English dictionary
 * Copyright (C) 2005-2006 Carles Pina i estany <carles@pina.cat>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 or any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
*/


#include "configure.h"

Configure::Configure(QWidget *parent) 
{
	ui.setupUi(this);
	connect(ui.ok,SIGNAL(clicked()),this,SLOT(okf()));
	connect(ui.cancel,SIGNAL(clicked()),this,SLOT(cancelf()));
	connect(ui.busca_fitxer,SIGNAL(clicked()),this,SLOT(busca_fitxerf()));
	connect(ui.busca_browser,SIGNAL(clicked()),this,SLOT(busca_browserf()));
	connect(ui.ajuda,SIGNAL(clicked()),this,SLOT(ajuda_busca()));
	connect(ui.ajuda_browser,SIGNAL(clicked()),this,SLOT(ajuda_browser()));

	if (Auxiliar::isWindows()) {
		ui.busca_browser->hide();
		ui.ajuda_browser->hide();
		ui.browser->hide();
		ui.lbrowser->hide();
	}
}

void Configure::ajuda_busca() {
	QMessageBox::information(this,tr("Information"),tr("You should select the \"dictionaries\" directory and click \"Open\""));
}


void Configure::ajuda_browser() {
	QMessageBox::information(this,tr("Information"),tr("Some entries has links (e.g. to photos). Select which browser do you want to use"));
}


void Configure::busca_fitxerf() {
	QString workingDirectory;

	QFileDialog *dlg = new QFileDialog(this);
	dlg->setFileMode(QFileDialog::Directory);

	/*dlg->setCaption( QFileDialog::tr( "Open" ) );
	dlg->setMode( QFileDialog::DirectoryOnly);*/

	
	if (dlg->exec() == QDialog::Accepted) {
		QStringList result;
		result=dlg->selectedFiles();
		//workingDirectory = dlg->url();
		ui.directori->setText(result.at(0));
	}
	delete dlg;
}


void Configure::busca_browserf() {
	QString workingDirectory;

	QFileDialog *dlg = new QFileDialog(this);
	dlg->setFileMode(QFileDialog::ExistingFile);

	if (dlg->exec() == QDialog::Accepted) {
		QStringList result;
		result=dlg->selectedFiles();
		ui.browser->setText(result.at(0));
	}
	delete dlg;
}

void Configure::carregar_config() {
    	QSettings qs("dacco","qdacco");
	QString dictionaries;

	//Get dictionaries file
	dictionaries=qs.value("/dacco/directori", "" ).toString();

	dictionaries=search_directory(dictionaries,Auxiliar::getDictionariesDirectory(),QDir::currentPath()+"/dictionaries/");

	ui.directori->setText(dictionaries);

        ui.traduccio_defecte->setCurrentIndex(qs.value("/dacco/diccionari_per_defecte",1).toInt()-1);

        ui.idioma_defecte->setCurrentIndex(qs.value("/dacco/idioma_per_defecte",1).toInt());

        language=ui.idioma_defecte->currentIndex();

	ui.browser->setText(qs.value("/dacco/browser","").toString());
	if (ui.browser->text()=="") {
		QFile file("/etc/alternatives/x-www-browser");
		if (file.exists()) {
			ui.browser->setText("/etc/alternatives/x-www-browser");	
		}
	}
	
	if (Auxiliar::isWindows()) {
		ui.browser->setText("cmd /c start ");
	}

        ui.nom->setText(qs.value("/dacco/name","").toString());
        ui.email->setText(qs.value("/dacco/email","").toString());

	//traduccio_defecte->setCount(qs.readNumEntry("/dacco/diccionari_per_defecte",2)-1);
}


void Configure::okf()
{
    QSettings settings("dacco","qdacco");

    settings.setValue("/dacco/directori", ui.directori->text());
    settings.setValue("/dacco/diccionari_per_defecte",ui.traduccio_defecte->currentIndex()+1);
    settings.setValue("/dacco/idioma_per_defecte",ui.idioma_defecte->currentIndex());
    settings.setValue("/dacco/version","0.5");

    if (language!=ui.idioma_defecte->currentIndex()) {
                    QMessageBox::information(this, "qdacco",
    "To change the default language, you will have to restart qdacco");
    }

    settings.setValue("/dacco/name",ui.nom->text());
    settings.setValue("/dacco/email",ui.email->text());


    settings.setValue("/dacco/browser",ui.browser->text());

    this->close();
}

void Configure::cancelf()
{
        QSettings settings("dacco","qdacco");
        
	settings.setValue("/Dacco/configurat",1);

        this->close();
}

QString Configure::search_directory(QString current,QString d1,QString d2)
{
	//2 directories is enough, else I will do in a list/array/...
        if (current=="") {
                QDir dir(d1);
		if (dir.exists()) {
                        current="/usr/share/dacco-common/dictionaries/";
                }
        }

	if (current=="") {
		QDir dir2(d2);
		if (dir2.exists()) {
			current=d2;
		}
	}
	return current;
}
