# $Id: qcad.pro,v 1.60 2004/09/11 09:26:07 andrew Exp $

TEMPLATE = app
CONFIG += qt warn_on link_prl

# demo version:
demo {
  message("demo")
  DEFINES+=QC_DEMO
}

# global defs
exists( ../../defs.pro ) {
  include( ../../defs.pro )
}

LIBS += -lqassistantclient

# These libs are usually not needed when using qt-mt.
# However, if you are getting undefined references, try linking these in:
#
#LIBS += -lXinerama -lXi -lXext -lSM -lICE -ldl -lpng -lXft -lXinerama -lXrandr -lXrender -lXcursor -lpthread -lXinerama -lXrandr
#LIBS += -L/usr/X11/lib -lXrender -lXft

# detect scripting support:
exists( ../../qcadscripting ) {
  !rs_no_scripting {
    message( "qsa support.." )
    DEFINES += RS_QSA_SCRIPTING
    CONFIG += rs_qsa_scripting
  }
}

# detect cam support:
exists( ../../qcadcam ) {
  !rs_no_cam {
    message( "cam support.." )
    DEFINES += RS_CAM
    CONFIG += rs_cam
  }
}

# detect apple:
exists(/Users) {
  message( "apple detected.." )
  CONFIG += rs_apple
}


# Application specific targets:

# CAM Expert:
rs_cam {
  demo {
    rs_apple {
      TARGET = CAMExpertDemo
    }
    else {
      TARGET = camexpert_demo
    }
  }
  else {
    rs_apple {
      TARGET = CAMExpert
    }
    else {
      TARGET = camexpert
    }
  }
}

# QCad:
else {
  demo {
    rs_apple {
      TARGET = QCadDemo
    }
    else {
      TARGET = qcad_demo
    }
  }
  else {
    rs_apple {
      TARGET = QCad
    }
    else {
      TARGET = qcad
    }
  }
}


# Application specific defines:

# CAM Expert:
rs_cam {
	demo {
    	DEFINES +=  QC_APPKEY="\"/CAMExpertDemo\"" QC_APPDIR="\"camexpertdemo\""
		DEFINES += QC_APPNAME="\"CAM Expert Demo\""
	}
	else {
    	DEFINES +=  QC_APPKEY="\"/CAMExpert\"" QC_APPDIR="\"camexpert\""
		DEFINES += QC_APPNAME="\"CAM Expert\""
	}
}

# QCad:
else {
	custom {
		#allows override app name with custom one
	}
	else {
		demo {
			DEFINES += QC_APPKEY="\"/QCadDemo\"" QC_APPDIR="\"qcaddemo\""
			DEFINES += QC_APPNAME="\"QCad Demo\""
		}
		else {
			DEFINES += QC_APPKEY="\"/QCad\"" QC_APPDIR="\"qcad\""
			DEFINES += QC_APPNAME="\"QCad\""
		}
	}
}


# libraries:
#unix {
    rs_qsa_scripting {
        LIBS += -L../../qcadscripting/lib -lqcadscripting
    }
    LIBS += \
            -L../../qcadguiqt/lib -lqcadguiqt \
            -L../../qcadactions/lib -lqcadactions \
            -L../../qcadcmd/lib -lqcadcmd \
            -L../../qcadlib/lib -lqcad \
            -L../../dxflib/lib -ldxf \
            -L../../fparser/lib -lfparser
    rs_cam {
        LIBS += -L../../qcadcam/lib -lqcadcam
    }
#}

#win32 {
#    CONFIG += thread
#    rs_qsa_scripting {
#        LIBS += ../../qcadscripting/lib/qcadscripting.lib
#    }
#    LIBS += \
#            ../../qcadguiqt/lib/qcadguiqt.lib \
#            ../../qcadactions/lib/qcadactions.lib \
#            ../../qcadcmd/lib/qcadcmd.lib \
#            ../../qcadlib/lib/qcad.lib \
#            ../../dxflib/lib/dxflib.lib \
#            ../../fparser/lib/fparser.lib
#    rs_cam {
#        LIBS += ../../qcadcam/lib/qcadcam.lib
#    }
#}


# icon
!custom {
	win32:RC_FILE = qcad.rc
	unix:RC_FILE = qcad.icns
}

# include paths:
INCLUDEPATH += ../../fparser/include \
               ../../dxflib/include \
               ../../qcadlib/include \
               ../../qcadcmd/include \
               ../../qcadactions/include \
               ../../qcadguiqt/include
rs_cam {
    INCLUDEPATH += ../../qcadcam/include
}
rs_qsa_scripting {
    INCLUDEPATH += ../../qcadscripting/include
}


HEADERS        = qc_applicationwindow.h \
                 qc_dialogfactory.h \
                 qc_graphicview.h \
                 qc_mdiwindow.h \
                 main.h
SOURCES        = qc_applicationwindow.cpp \
                 qc_dialogfactory.cpp \
                 qc_graphicview.cpp \
                 qc_mdiwindow.cpp \
                 main.cpp 
TRANSLATIONS = ts/qcad_cs.ts \
               ts/qcad_et.ts \
               ts/qcad_en.ts \
               ts/qcad_da.ts \
               ts/qcad_de.ts \
               ts/qcad_el.ts \
               ts/qcad_es.ts \
               ts/qcad_fr.ts \
               ts/qcad_hu.ts \
               ts/qcad_it.ts \
               ts/qcad_nl.ts \
               ts/qcad_no.ts \
               ts/qcad_pl.ts \
               ts/qcad_ru.ts \
               ts/qcad_sk.ts \
               ts/qcad_tr.ts

IMAGES = \
images/contents.png \
images/document.png \
images/editclear.png \
images/qcad16.png \
images/qcad.png


DESTDIR     = ..

OBJECTS_DIR = obj
MOC_DIR     = moc

# load scripting support:
rs_qsa_scripting {
  #load( qsa )
  LIBS += -lqsa
}

exists( custom.pro ) {
	include( custom.pro )
}

exists( custom.cpp ) {
  SOURCES += custom.cpp
}
