/***************************************************************************
                          rstatuspanel.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rstatuspanel.cpp 1998/09/20 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rstatuspanel.h"

#include <qlabel.h>
#include <qprogressbar.h>
#include <qslider.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qwindowdefs.h>

#include "rappwin.h"
#include "rcadwidget.h"
#include "rgraphic.h"
#include "rconfig.h"
#include "rlayoutdef.h"
#include "rlog.h"
#include "rxpmstat.h"


// Constructor:
//
RStatusPanel::RStatusPanel(QWidget* _parent, 
               const char* _name,
               WFlags _f)
:RWidget(_parent, _name, _f)
{
  graphic=0;

  setFrameStyle(Panel|Raised);
  setLineWidth(1);

  fSep1 = new QFrame(this, "sep1");
  fSep1->setFrameStyle(VLine|Sunken);

  fSep2 = new QFrame(this, "sep2");
  fSep2->setFrameStyle(VLine|Sunken);

  lStatus = new QLabel("", this);
  lStatus->setAlignment(AlignLeft|AlignTop|WordBreak);

  lMouse = new QLabel(this);
  lMouse->setPixmap(QPixmap(mouse_xpm));
  lMouse->setAlignment(AlignCenter|AlignVCenter);

  lLeftButton = new QLabel("", this);
  lLeftButton->setAlignment(AlignRight|AlignTop|WordBreak);

  lRightButton = new QLabel("", this);
  lRightButton->setAlignment(AlignLeft|AlignTop|WordBreak);

  lFunction = new QLabel("", this);
  lFunction->setAlignment(AlignLeft|AlignTop|WordBreak);

  progressBar = new QProgressBar(100, this, "progressbar");
  progressBar->hide();

  reinit();
}



// Destructor:
//
RStatusPanel::~RStatusPanel()
{

}


// Re-Initialize:
//
void
RStatusPanel::reinit()
{
  lStatus->setFont( RCONFIG->getFont(2) );
  lLeftButton->setFont( RCONFIG->getFont(2) );
  lRightButton->setFont( RCONFIG->getFont(2) );
  lFunction->setFont( RCONFIG->getFont(2) );
}



// Resize event:
//
void 
RStatusPanel::resizeEvent(QResizeEvent* _ev)
{
  RWidget::resizeEvent(_ev);
  resizeChildren();
}



// Resize the children:
//
void
RStatusPanel::resizeChildren()
{
  // Width of mouse icon in the center:
  //
  int mouseLabelWidth = lMouse->pixmap()->width();

  // Resize Seperators:
  //
  if(fSep1) fSep1->setGeometry(width()/3,   2, 2, height()-4);
  if(fSep2) fSep2->setGeometry(width()/3*2, 2, 2, height()-4);

  // Resize Labels:
  //

  // Status label left:
  //
  if(lStatus) {
    lStatus->setGeometry(2, 2, width()/3-4, height()-4);
  }

  // Left button information (center/left):
  //
  if(lLeftButton) {
    lLeftButton->setGeometry(width()/3+2, 2,
                             width()/6-4-mouseLabelWidth/2, height()-4);
  }

  // Mouse icon (center/center):
  //
  if(lMouse) {
    lMouse->setGeometry(width()/2-mouseLabelWidth/2, 2,
                        mouseLabelWidth, height()-4);
    lMouse->hide();
  }

  // Right button information (center/right):
  //
  if(lRightButton) {
    lRightButton->setGeometry(width()/2+mouseLabelWidth/2+2, 2,
                              width()/6-4-mouseLabelWidth/2, height()-4);
  }

  // Function information (right):
  //
  if(lFunction) {
    lFunction->setGeometry(width()/3*2+2, 2,
                           width()/3-4, height()-4);
  }

  // Progress BAr:
  //
  if(progressBar) {
    progressBar->setGeometry(4, height()/2+4, width()/3-8, height()/2-8);
  }
}



// Set the pointer to a graphic and update the layers:
//
void 
RStatusPanel::setGraphic(RGraphic* _graphic) 
{
  graphic=_graphic;
}



// Set a new Status Text:
//
void
RStatusPanel::setStatus(const QString& _stat)
{
  if(lStatus) {
    if(_stat) lStatus->setText(_stat);
    else      lStatus->clear();
  }
}



// Set a new Left Mouse Button Status Text:
//
void
RStatusPanel::setLeftButtonStatus(const QString& _lButStat)
{
  if(lLeftButton) {
    if(_lButStat) {
      lLeftButton->setText(_lButStat);
      if(lMouse) lMouse->show();
    }
    else {
      lLeftButton->clear();
      if(lMouse) lMouse->hide();
    }
  }
}



// Set a new Right Mouse Button Status Text:
//
void
RStatusPanel::setRightButtonStatus(const QString& _rButStat)
{
  if(lRightButton) {
    if(_rButStat) lRightButton->setText(_rButStat);
    else          lRightButton->clear();
  }
}



// Set a new Function Status Text:
//
void
RStatusPanel::setFunctionStatus(const QString& _fStat)
{
  if(lFunction) {
    if(_fStat) lFunction->setText(_fStat);
    else       lFunction->clear();
  }
}



// Set a new Action Status Text:
//   (mouse buttons / function)
//
void
RStatusPanel::setActionStatus(const QString& _lButStat, const QString& _rButStat, const QString& _fStat)
{
  setLeftButtonStatus(_lButStat);
  setRightButtonStatus(_rButStat);
  setFunctionStatus(_fStat);
}



// Clear all status texts:
//
void
RStatusPanel::clear()
{
  setStatus();
  setActionStatus();
}



//
// Progress bar:
//

// Set progress steps (progress bar in status bar)
//
// _prg: number of progress steps
//
void 
RStatusPanel::iniProgress(int _prgSteps, const QString& _label)
{
  if(progressBar) {
    progressBar->show();
    progressBar->setTotalSteps(_prgSteps);
    progressBar->reset();
    setStatus(_label);
  }
}



// Set progress (progress bar in status bar)
//
// _prg: progress in percentage
//
void 
RStatusPanel::setProgress(int _prg, int _every)
{
  static int every=0;
  if(progressBar) {
    // Set progress:
    //
    ++every;
    if(every>=_every &&
       _prg<progressBar->totalSteps()) {
      progressBar->setProgress(_prg);
      every=0;
    }
  }
}



// Del progress (progress bar in status bar)
//
void 
RStatusPanel::delProgress()
{
  if(progressBar) {
    // Remove progress bar:
    //
    progressBar->reset();
    progressBar->hide();
    setStatus();
  }
}



// EOF



