/***************************************************************************
                          rfile.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rfile.cpp 1998/09/25 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rfile.h"

#include <qfileinfo.h>

#include "rconfig.h"
#include "rlog.h"
#include "ryesnodialog.h"


// copies file _source to file _dest
//
// _what: What is this file? (Machinegenerator, ...) Used for overwrite warning
//
// return: true: successful
//         false: error
//
bool 
fileCopy(QString _source, QString _dest, const QString& _what, QWidget* _parent)
{
  bool ret=false;
  
  QFile sourceFile(_source);
  QFile destFile(_dest);

  if(!destFile.exists() || 
     fileOverwriteWarning(_dest, _what, _parent)) {
      
    if(sourceFile.open(IO_ReadOnly)) {
      if(destFile.open(IO_WriteOnly)) {
    
        char* buffer;
        buffer= new char[sourceFile.size()+1];
      
        sourceFile.readBlock(buffer, sourceFile.size());
        destFile.writeBlock(buffer, sourceFile.size());
               
        destFile.close();
        ret=true;
      }
      sourceFile.close();
    }
  }
  
  return ret;
}



// Overwrite-Dialog:
//
// _file: filename
// _what: e.g.: "Machine-Generator 'name' does already..."
//               -> _what = Machine-Generator
// _ext:  show extensions
//
bool
fileOverwriteWarning(const QString& _file, const QString& _what, QWidget* _parent)
{
  if(_file && _what) {
    // Overwrite?
    //
    QString mes;
    mes = QString("%1\n'%2'\n%3\n%4\n")
                 .arg(_what)
		 .arg(_file)
		 .arg(QObject::tr("does already exist!"))
		 .arg(QObject::tr("Do you wish to overwrite it?"));
    RYesNoDialog overDlg(mes, 
                         QObject::tr("Yes"), QObject::tr("No"),
                         _parent);
    if(overDlg.exec()) {
      return true;
    }
  }
  
  return false;
}


// Delete file _file:
//
// _what: e.g.: "Machine-Generator 'name' does already..."
//               -> _what = Machine-Generator
//
bool 
fileDelete(const QString& _file, const QString& _what, QWidget* _parent)
{
  if(_file && _what) {
    QFile file(_file);
    if(file.exists()) {
      QString mes;
      mes = QString("%1 %2\n'%3'?")
                   .arg(QObject::tr("Delete"))
		   .arg(_what)
		   .arg(_file);
      RYesNoDialog overDlg(mes, 
                           QObject::tr("Yes"), QObject::tr("No"),
                           _parent);
      if(overDlg.exec()) {
        QFile(_file).remove();
        return true;
      }
    }
  }
  return false;
}



// Check Format of file _file:
//   Format must be _format and version must be _version
//
bool     
fileCheckFormat(const QString& _file, 
                const QString& _format, 
                const QString& _version)
{
  bool ret=true;
  QString value;
  
  RLOG("\nfileCheckFormat");
  RLOG("\nFile: ");
  RLOG(_file);
  RLOG("\nFormat: ");
  RLOG(_format);
  RLOG("\nVersion: ");
  RLOG(_version);
  
  // Check Format type:
  //
  if(_format) {
    value = fileGetFormatInfo(_file, "Format");
    
    RLOG("\nRead Format: ");
    RLOG(value);
    
    if( value.upper() != _format.upper() ) {
      ret=false;
    }
  }
  
  // Check Format version:
  //
  if(_version) {
    value = fileGetFormatInfo(_file, "Version");
    
    RLOG("\nRead Version: ");
    RLOG(value);
    
    if( value.upper() != _version.upper() ) {
      ret=false;
    }
  }
  
  RLOG("\nReturn: ");
  RLOG(ret);

  return ret;
}




// Get Format info of file _file. Info name: _name
//
QString
fileGetFormatInfo(const QString& _file, const QString& _name)
{
  bool done=false;     // Finished?
  QString ret="";
    
  RLOG("\nfileGetFormatInfo");
  RLOG("\nFile: ");
  RLOG(_file);
  RLOG("\nName: ");
  if(_name) RLOG(_name);
  //RLOG("\nMax. Length: ");
  //RLOG(_maxLength);
  
  if( !_file.isEmpty() && !_name.isEmpty() ) {
    QFile file(_file);
    if(file.exists()) {
      FILE* fp=fopen(_file, "rt");
    
      if(fp) {
        
        // Check Format:
        //
        char  fLine[128];    // The whole line:  "# Format:     CAM Expert Font"
        char* fWalker;       // Walk through line
        char  fName[128];    // Info name:       "Format"
        char  fValue[128];   // Info value:      "CAM Expert Font"
        char  fDum1[128];    // Dummy for length measuring
        char  fDum2[128];    // Dummy for length measuring
        
        while(!done && !feof(fp)) {
          
          fLine[0]='\0';
          fName[0]='\0';
          fValue[0]='\0';
          fDum1[0]='\0';
          fDum2[0]='\0';

          // Read whole line:
          //
          fscanf(fp, "%127[^\n]%*[\n]", fLine);
          fWalker=fLine;
          
          RLOG("\nWhole Line: ");
          RLOG(fWalker);
          
          // Scan #:
          //
          if(fWalker[0]=='#') {
            
            // Scan Name of current format info:
            //
            ++fWalker;
            sscanf(fWalker, "%127[ ]%127[^: \n]%127[ :]", fDum1, fName, fDum2);
            
            RLOG("\nName: ");
            RLOG(fName);
            RLOG("\nDum1: "); 
            RLOG(fDum1);
            RLOG("\nDum2: "); 
            RLOG(fDum2); 
            
            // Overjump read strings:
            //
            fWalker+=strlen(fDum1);   // Overjump space
            fWalker+=strlen(fName);   // Overjump name
            fWalker+=strlen(fDum2);   // Overjump colon and space
            
            // Scan Value of current format info:
            //
            sscanf(fWalker, "%127[^\n]", fValue);
            if(fValue[strlen(fValue)-1]<32) fValue[strlen(fValue)-1]='\0';
            
            RLOG("\nValue: ");
            RLOG(fValue);
            
            if(!stricmp(fName, _name)) {
              //strncpy(_value, fValue, _maxLength);
              ret = fValue;
              done=true;
              
              RLOG("\nValue: ");
              RLOG(ret);
            }
          }
        }
        
        fclose(fp);
      } // -> if(fp)
      
    }
  }
  
  return ret;
}



/**
 * Searchs a file with a given subdir and a file name.
 */
QString
fileSearchFile(QString _subdir, QString _name)
{
  QString subdir;
  if(_subdir.isEmpty()) subdir = "";
  else                  subdir = "/"+_subdir;

  QString ret = RCONFIG->getPrgDir().path()+subdir+"/"+_name;
  RLOG("\nret1: "); RLOG(ret);
  if(QFileInfo(ret).exists()) return ret;

#ifndef DEF_WINDOWS
  // Test /usr/share/<proj>/...:
  ret = QString("/usr/share/")+DEF_APPNAME_L+subdir+"/"+_name;
  RLOG("\nret2: "); RLOG(ret);
  if(QFileInfo(ret).exists()) return ret;

  // Read from ~/.<proj>/fonts:
  ret = RCONFIG->getConfigDir().path()+subdir+"/"+_name;
  RLOG("\nret3: "); RLOG(ret);
  if(QFileInfo(ret).exists()) return ret;
#endif

  ret="";
  return ret;
}


/**
 * Searchs a subdir.
 * _prior: priority: 0: no special 1: first, 2: second, 3: third
 */
QString
fileSearchSubdir(QString _subdir, int _prior)
{
  QString ret="";

  if(_prior==0 || _prior==1) {
    ret = RCONFIG->getPrgDir().path()+"/"+_subdir;
    if(QFileInfo(ret).exists()) return ret;
  }

#ifndef DEF_WINDOWS
  if(_prior==0 || _prior==2) {
    // Test /usr/share/<proj>/...:
    ret = QString("/usr/share/")+DEF_APPNAME_L+"/"+_subdir;
    if(QFileInfo(ret).exists()) return ret;
  }

  if(_prior==0 || _prior==3) {
    // Read from ~/.<proj>/fonts:
    ret = RCONFIG->getConfigDir().path()+"/"+_subdir;
    if(QFileInfo(ret).exists()) return ret;
  }
#endif

  return ret;
}


// Binary replace string _string with _len characters of _bin.
void 
fileBinaryReplace(QString _fileName, QString _string, char* _bin, int _len)
{
	// Create temp file
  QFile tempFile(_fileName + "._tmp");
	if(!tempFile.open(IO_WriteOnly)) return;

	// Open ori file
	QFile oriFile(_fileName);
	if(!oriFile.open(IO_ReadOnly)) return;

	int ch;
	QString buffer;
	bool done = false;

	// Search for String and replace with pattern
	while(!done) {
	  buffer = "";
	  for(uint i=0; i<_string.length(); ++i) {
		
		  ch = oriFile.getch();
			if(ch==-1) {
			  done = true;
				break;
			}
			
	    else if(ch==_string[i]) {
  			buffer += QChar(ch);
				if(i==_string.length()-1) {
				  tempFile.writeBlock(_bin, _len);
				}
  	  }
	  	else {
			  if(i==0) {
		      buffer += QChar(ch);
		      tempFile.writeBlock(buffer.latin1(), buffer.length());
				}
				else {
				  oriFile.ungetch(ch);
					tempFile.writeBlock(buffer.latin1(), buffer.length());
				}
				break;
	  	}
	  }
	}

	tempFile.close();
	oriFile.close();

	// Copy temp over ori
	oriFile.remove();
	fileCopy(tempFile.name(), oriFile.name(), "Temporary file", 0);
	tempFile.remove();
}


void 
fileFillLines(QString _fileName, QString _string, int _len, char _char)
{
  // Create temp file
  QFile tempFile(_fileName + "._tmp");
  if(!tempFile.open(IO_WriteOnly)) return;

  // Open ori file
  QFile oriFile(_fileName);
  if(!oriFile.open(IO_ReadOnly)) return;

  int ch;
  QString line;
	QString newLine;

  // Search for String and replace with pattern
  while(!oriFile.atEnd()) {
		line = "";

		do {
    	ch = oriFile.getch();
      if(ch>=32) line += ch;
      else if(ch!=-1) { oriFile.ungetch(ch); }
		} while(ch>=32 && !oriFile.atEnd());

		if(line.contains(_string)) {
			int i1 = line.find(_string);
			int i2 = i1 + _string.length();
      QString space;
      space.fill(QChar(_char), _len-line.length()+_string.length());
			newLine = line.left(i1) + space + line.mid(i2);
		}
    else {
			newLine = line;
		}
		tempFile.writeBlock(newLine.latin1(), newLine.length());

    do {
      ch = oriFile.getch();
      if(ch<32) tempFile.putch(ch);
      else if(ch!=-1) { oriFile.ungetch(ch); }
    } while(ch<32 && !oriFile.atEnd());
  }

  tempFile.close();
  oriFile.close();

  // Copy temp over ori
  oriFile.remove();
  fileCopy(tempFile.name(), oriFile.name(), "Temporary file", 0);
  tempFile.remove();
}

// EOF




