/***************************************************************************
                          rattribdialog.h  -  description
                             -------------------
    begin                : Tue Sep 28 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


#ifndef RATTRIBDIALOG_H
#define RATTRIBDIALOG_H

#include <qdialog.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qpushbutton.h>

#include "rcombobox.h"

#define DEF_ATTRIBDLG_WIDTH  256
#define DEF_ATTRIBDLG_HEIGHT 120

/**
 * A Dialog window for choosing colors, widths and styles.
 * @author Andreas Mustun
 */
class RAttribDialog : public QDialog  {
  Q_OBJECT
public: 
	RAttribDialog(const QString& _caption,
	              const QString& _label,
                QWidget* _parent=0);

	~RAttribDialog();
	
	
	int getColor();
	int getWidth();
	int getStyle();
	
private:
  QPushButton* bOk;
  QPushButton* bCancel;
  QPushButton* bHelp;

  QLabel*      lText;
  RComboBox*   cbColor;
  RComboBox*   cbWidth;
  RComboBox*   cbStyle;
};

#endif









