/***************************************************************************
  qbrew.h
  -------------------
  A brewing recipe calculator for Unix/X11
  -------------------
  begin         September 20th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  3. Neither name of the copyright holders nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef QBREW_H
#define QBREW_H

#include <qmainwindow.h>

#include "resource.h"

class QPopupMenu;
class QString;
class QToolBar;

class QBrewView;
class QBrewDoc;
class QBrewCalc;
class Preferences;

class QBrew : public QMainWindow
{
    Q_OBJECT
public:
    // constructor
    QBrew(const QString &filename = AppResource::ID_DEFAULT_FILE);
    // destructor
    ~QBrew();
    
    // get default batch size
    double getBatchSetting();
    // return recipe as an ascii string
    QString getRecipeText();

public slots:
    // generate a new document
    void slotFileNew();
    // open a document
    void slotFileOpen();
    // save a document
    void slotFileSave();
    // save a document under a different filename
    void slotFileSaveAs();
    // print the document
    void slotFilePrint();
    // exits the application
    void slotFileQuit();
    
    // toggle the toolbar
    void slotOptionsToolbar();
    // toggle the statusbar
    void slotOptionsStatusbar();
    // display the setup dialog
    void slotOptionsSetup();
    // save application settings
    void slotOptionsSaveSettings();

    // Popup the hydrometer correction tool
    void slotToolsHydrometer();

    // displays help contents
    void slotHelpContents();
    // displays primer contents
    void slotHelpPrimer();
    // shows an about dialog for Qt
    void slotHelpAboutQt();
    // shows an about dialog for QBrew
    void slotHelpAbout();

    // set statusbar help messages based on menu/toolbar
    void statusCallback(int id);
    // receives if view widgets have changed
    void slotDocumentModified();

private:
    // initialize the menubar
    void initMenuBar();
    // initialize the toolbar
    void initToolBar();
    // initialize the statusbar
    void initStatusBar();
    // initialize the application preferences
    void initPreferences();

    // query user to save the current file
    int querySave();
    // temporarily change the status message of the statusbar
    void statusHelpMessage(const char *text);

private:
    QBrewView* view_;
    QBrewDoc* doc_;
    QBrewCalc* calc_;

    Preferences* preferences_;
    QString filename_;

    QPopupMenu* filemenu_;
    QPopupMenu* optionsmenu_;
    QPopupMenu* toolsmenu_;
    QPopupMenu* helpmenu_;
    QToolBar* toolbar_;
};

#endif // QBREW_H
