/***************************************************************************
  hops.cpp
  -------------------
  A hops class
  -------------------
  begin         October 20th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "hops.h"

#include <cmath>

#include <qstringlist.h>

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// Hops()
// ------
// Constructor

Hops::Hops(const QString &name, const double &quantity, const QString &form,
    const double &alpha, const unsigned &time)
    : name_(name), quantity_(quantity), form_(form), alpha_(alpha), time_(time),
    hbu_(0.75 * quantity * alpha)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// Hops(const Hops &)
// ------------------
// Copy constructor

Hops::Hops(const Hops &h)
 : name_(h.name_), quantity_(h.quantity_), form_(h.form_), alpha_(h.alpha_),
 time_(h.time_), hbu_(h.hbu_)
{ ; }

Hops::~Hops() { ; }

//////////////////////////////////////////////////////////////////////////////
// Operators                                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// operator=()
// -----------
// Assignment operator

Hops Hops::operator=(const Hops &h)
{
    if (this != &h) {
        name_ = h.name_;
        quantity_ = h.quantity_;
        form_ = h.form_;
        alpha_ = h.alpha_;
        time_ = h.time_;
        hbu_ = h.hbu_;
    }
    return *this;
}

//////////////////////////////////////////////////////////////////////////////
// operator==()
// -------=----
// Equivalence operator

bool Hops::operator==(const Hops &h)
{
    return (name_ == h.name_)
        && (quantity_ == h.quantity_)
        && (form_ == h.form_)
        && (alpha_ == h.alpha_)
        && (time_ == h.time_);
}

//////////////////////////////////////////////////////////////////////////////
// Serialization (deprecated)                                               //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// serializeOut()
// --------------
// Serialize class out to a string, deprecated...

QString Hops::obsoleteSerializeOut()
{
    // converting to deprecated file format on the fly...
    QString text = QString::number(quantity_ * 100.0) + ", " + form_ + ", ";
    text += QString::number(alpha_ * 10.0) + ", " + QString::number(time_);
    return text;
}

//////////////////////////////////////////////////////////////////////////////
// serializeIn()
// -------------
// Serialize class in from a name/value pair, deprecated...

void Hops::obsoleteSerializeIn(const QString &name, const QString &value)
{
    QString valuestring = value;
    QStringList tokens;
    int pos;

    // get tokens
    while (valuestring.length() > 0) {
        pos = valuestring.find(',');
        if (pos > 0) {
            tokens += valuestring.left(pos);
            valuestring.remove(0, pos+1);
            valuestring = valuestring.stripWhiteSpace();
        } else {
            // get last token
            tokens += valuestring;
            valuestring = "";
        }
    }
    // create new style
    name_ = name;
    // converting from deprecated file format on the fly...
    quantity_   = tokens[0].toDouble() / 100.0;
    form_       = tokens[1];
    alpha_      = tokens[2].toDouble() / 10.0;
    time_       = tokens[3].toUInt();
    hbu_        = 0.75 * quantity_ * alpha_;
}

//////////////////////////////////////////////////////////////////////////////
// HopsListItem Class                                                       //
//////////////////////////////////////////////////////////////////////////////

HopsListItem::HopsListItem(QListView * parent, QString a, QString b, QString c,
    QString d, QString e, QString f, QString g, QString h)
    : QListViewItem(parent, a, b, c, d, e, f, g, h), hit_(0) { ; }

void HopsListItem::setToIterator()
{
    setText(0, (*hit_).name());
    setText(1, (*hit_).quantityString());
    setText(2, (*hit_).form());
    setText(3, (*hit_).alphaString());
    setText(4, (*hit_).timeString());
}
