/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/



#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "editsimplereport.h"
#include "kbanking.h"

#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>




EditSimpleReport::EditSimpleReport(KBanking *kb,
                                   GWEN_DB_NODE *dbProfile,
                                   QWidget* parent,
                                   const char* name,
                                   bool modal,
                                   Qt::WFlags fl)
:EditSimpleReportUi(parent, name, modal, fl)
,_dbProfile(dbProfile) {
  _profileToGui(_dbProfile);
}



EditSimpleReport::~EditSimpleReport(){
}



QComboBox *EditSimpleReport::_getColumnComboBox(int idx) {
  switch(idx) {
  case 0: return col1Combo;
  case 1: return col2Combo;
  case 2: return col3Combo;
  case 3: return col4Combo;
  case 4: return col5Combo;
  case 5: return col6Combo;
  case 6: return col7Combo;
  case 7: return col8Combo;
  default:
    return 0;
  }
}


void EditSimpleReport::_profileToGui(GWEN_DB_NODE *db){
  const char *s;
  int i;

  s=GWEN_DB_GetCharValue(db, "name", 0, 0);
  if (s)
    nameEdit->setText(QString::fromUtf8(s));

  s=GWEN_DB_GetCharValue(db, "shortDescr", 0, 0);
  if (s)
    descrEdit->setText(QString::fromUtf8(s));

  i=GWEN_DB_GetIntValue(db, "sortByMonth", 0, 0);
  byMonthCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "showBalance", 0, 0);
  balanceCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "useColours", 0, 0);
  coloursCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "border", 0, 0);
  borderCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "useAccountName", 0, 0);
  accountNameCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "useBankName", 0, 0);
  bankNameCheck->setChecked(i);

  for (i=0; i<8; i++) {
    int j;
    QComboBox *qb;

    j=GWEN_DB_GetIntValue(db, "column", i, 0);
    if (j==0)
      break;
    qb=_getColumnComboBox(i);
    if (!qb)
      break;
    qb->setCurrentItem(j);
  } // for


}



void EditSimpleReport::_guiToProfile(GWEN_DB_NODE *db){
  std::string s;
  int i;

  s=KBanking::QStringToUtf8String(nameEdit->text());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "name", s.c_str());

  s=KBanking::QStringToUtf8String(descrEdit->text());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "shortDescr", s.c_str());

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "sortByMonth",
                      (byMonthCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "showBalance",
                      (balanceCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "useColours",
                      (coloursCheck->isChecked())?1:0);
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "border",
                      (borderCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "useAccountName",
                      (accountNameCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "useBankName",
                      (bankNameCheck->isChecked())?1:0);

  GWEN_DB_DeleteVar(db, "column");
  for (i=0; i<8; i++) {
    QComboBox *qb;

    qb=_getColumnComboBox(i);
    assert(qb);

    GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                        "column", qb->currentItem());
  } // for
}



void EditSimpleReport::accept(){
  std::string s;

  s=KBanking::QStringToUtf8String(nameEdit->text());
  if (s.empty()) {
  }
  s=KBanking::QStringToUtf8String(descrEdit->text());
  if (s.empty()) {
  }
  _guiToProfile(_dbProfile);
  return QDialog::accept();
}











