/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculatedecimalsdialog.h"

#include <qlabel.h>
#include <qspinbox.h>
#include <klocale.h>
#include <qgrid.h>

QalculateDecimalsDialog::QalculateDecimalsDialog(QWidget *parent, const char *name) : KDialogBase(parent, name, false, i18n("Decimals"), Close, Close, true) {

	QGrid *grid = makeGridMainWidget(2, Qt::Horizontal);

	new QLabel(i18n("Max decimals:"), grid);

	maxDecimalsBox = new QSpinBox(grid);
	maxDecimalsBox->setButtonSymbols(QSpinBox::PlusMinus);
	maxDecimalsBox->setMinValue(-1);
	maxDecimalsBox->setValue(-1);
	maxDecimalsBox->setSpecialValueText(i18n( "Off" ));

	new QLabel(i18n("Min decimals:"), grid);

	minDecimalsBox = new QSpinBox(grid);
	minDecimalsBox->setButtonSymbols(QSpinBox::PlusMinus);
	minDecimalsBox->setMinValue(0);
	minDecimalsBox->setValue(0);
	minDecimalsBox->setSpecialValueText(i18n( "Off" ));

	resize(QSize(300, minimumSizeHint().height()).expandedTo(minimumSizeHint()));

}


QalculateDecimalsDialog::~QalculateDecimalsDialog() {}


#include "qalculatedecimalsdialog.moc"
