#ifndef _WAVELETS_COEFFS_H_
#define _WAVELETS_COEFFS_H_

// $Id: wavelets_coeffs.h 87 2007-10-29 23:16:18Z filipw $

// Filters coefficients for selected wavelets

// Daubechies:   db1   - db20
// Symlets:      sym2  - sym20
// Coiflets:     coif1 - coif5
// Biorthogonal: bior 1.1, 1.3, 1.5,
//                    2.2, 2.4, 2.6, 2.8,
//                    3.1, 3.3, 3.5, 3.7, 3.9,
//                    4.4, 5.5, 6.8
// Discrete Meyer wavelet *approximation*: dmey
static double db1_double[][2] = {
    {0.70710678118654757, 0.70710678118654757},
    {-0.70710678118654757, 0.70710678118654757},
    {0.70710678118654757, 0.70710678118654757},
    {0.70710678118654757, -0.70710678118654757}
};

static double db2_double[][4] = {
    {-0.12940952255092145, 0.22414386804185735, 0.83651630373746899, 0.48296291314469025},
    {-0.48296291314469025, 0.83651630373746899, -0.22414386804185735, -0.12940952255092145},
    {0.48296291314469025, 0.83651630373746899, 0.22414386804185735, -0.12940952255092145},
    {-0.12940952255092145, -0.22414386804185735, 0.83651630373746899, -0.48296291314469025}
};

static double db3_double[][6] = {
    {0.035226291882100656, -0.085441273882241486, -0.13501102001039084, 0.45987750211933132, 0.80689150931333875, 0.33267055295095688},
    {-0.33267055295095688, 0.80689150931333875, -0.45987750211933132, -0.13501102001039084, 0.085441273882241486, 0.035226291882100656},
    {0.33267055295095688, 0.80689150931333875, 0.45987750211933132, -0.13501102001039084, -0.085441273882241486, 0.035226291882100656},
    {0.035226291882100656, 0.085441273882241486, -0.13501102001039084, -0.45987750211933132, 0.80689150931333875, -0.33267055295095688}
};

static double db4_double[][8] = {
    {-0.010597401784997278, 0.032883011666982945, 0.030841381835986965, -0.18703481171888114, -0.027983769416983849, 0.63088076792959036, 0.71484657055254153, 0.23037781330885523},
    {-0.23037781330885523, 0.71484657055254153, -0.63088076792959036, -0.027983769416983849, 0.18703481171888114, 0.030841381835986965, -0.032883011666982945, -0.010597401784997278},
    {0.23037781330885523, 0.71484657055254153, 0.63088076792959036, -0.027983769416983849, -0.18703481171888114, 0.030841381835986965, 0.032883011666982945, -0.010597401784997278},
    {-0.010597401784997278, -0.032883011666982945, 0.030841381835986965, 0.18703481171888114, -0.027983769416983849, -0.63088076792959036, 0.71484657055254153, -0.23037781330885523}
};

static double db5_double[][10] = {
    {0.0033357252850015492, -0.012580751999015526, -0.0062414902130117052, 0.077571493840065148, -0.03224486958502952, -0.24229488706619015, 0.13842814590110342, 0.72430852843857441, 0.60382926979747287, 0.16010239797412501},
    {-0.16010239797412501, 0.60382926979747287, -0.72430852843857441, 0.13842814590110342, 0.24229488706619015, -0.03224486958502952, -0.077571493840065148, -0.0062414902130117052, 0.012580751999015526, 0.0033357252850015492},
    {0.16010239797412501, 0.60382926979747287, 0.72430852843857441, 0.13842814590110342, -0.24229488706619015, -0.03224486958502952, 0.077571493840065148, -0.0062414902130117052, -0.012580751999015526, 0.0033357252850015492},
    {0.0033357252850015492, 0.012580751999015526, -0.0062414902130117052, -0.077571493840065148, -0.03224486958502952, 0.24229488706619015, 0.13842814590110342, -0.72430852843857441, 0.60382926979747287, -0.16010239797412501}
};

static double db6_double[][12] = {
    {-0.0010773010849955799, 0.0047772575110106514, 0.0005538422009938016, -0.031582039318031156, 0.027522865530016288, 0.097501605587079362, -0.12976686756709563, -0.22626469396516913, 0.3152503517092432, 0.75113390802157753, 0.49462389039838539, 0.11154074335008017},
    {-0.11154074335008017, 0.49462389039838539, -0.75113390802157753, 0.3152503517092432, 0.22626469396516913, -0.12976686756709563, -0.097501605587079362, 0.027522865530016288, 0.031582039318031156, 0.0005538422009938016, -0.0047772575110106514, -0.0010773010849955799},
    {0.11154074335008017, 0.49462389039838539, 0.75113390802157753, 0.3152503517092432, -0.22626469396516913, -0.12976686756709563, 0.097501605587079362, 0.027522865530016288, -0.031582039318031156, 0.0005538422009938016, 0.0047772575110106514, -0.0010773010849955799},
    {-0.0010773010849955799, -0.0047772575110106514, 0.0005538422009938016, 0.031582039318031156, 0.027522865530016288, -0.097501605587079362, -0.12976686756709563, 0.22626469396516913, 0.3152503517092432, -0.75113390802157753, 0.49462389039838539, -0.11154074335008017}
};

static double db7_double[][14] = {
    {0.00035371380000103988, -0.0018016407039998328, 0.00042957797300470274, 0.012550998556013784, -0.01657454163101562, -0.038029936935034633, 0.080612609151065898, 0.071309219267050042, -0.22403618499416572, -0.14390600392910627, 0.4697822874053586, 0.72913209084655506, 0.39653931948230575, 0.077852054085062364},
    {-0.077852054085062364, 0.39653931948230575, -0.72913209084655506, 0.4697822874053586, 0.14390600392910627, -0.22403618499416572, -0.071309219267050042, 0.080612609151065898, 0.038029936935034633, -0.01657454163101562, -0.012550998556013784, 0.00042957797300470274, 0.0018016407039998328, 0.00035371380000103988},
    {0.077852054085062364, 0.39653931948230575, 0.72913209084655506, 0.4697822874053586, -0.14390600392910627, -0.22403618499416572, 0.071309219267050042, 0.080612609151065898, -0.038029936935034633, -0.01657454163101562, 0.012550998556013784, 0.00042957797300470274, -0.0018016407039998328, 0.00035371380000103988},
    {0.00035371380000103988, 0.0018016407039998328, 0.00042957797300470274, -0.012550998556013784, -0.01657454163101562, 0.038029936935034633, 0.080612609151065898, -0.071309219267050042, -0.22403618499416572, 0.14390600392910627, 0.4697822874053586, -0.72913209084655506, 0.39653931948230575, -0.077852054085062364}
};

static double db8_double[][16] = {
    {-0.00011747678400228192, 0.00067544940599855677, -0.00039174037299597711, -0.0048703529930106603, 0.0087460940470156547, 0.013981027917015516, -0.044088253931064719, -0.017369301002022108, 0.12874742662018601, 0.00047248457399797254, -0.28401554296242809, -0.015829105256023893, 0.58535468365486909, 0.67563073629801285, 0.31287159091446592, 0.054415842243081609},
    {-0.054415842243081609, 0.31287159091446592, -0.67563073629801285, 0.58535468365486909, 0.015829105256023893, -0.28401554296242809, -0.00047248457399797254, 0.12874742662018601, 0.017369301002022108, -0.044088253931064719, -0.013981027917015516, 0.0087460940470156547, 0.0048703529930106603, -0.00039174037299597711, -0.00067544940599855677, -0.00011747678400228192},
    {0.054415842243081609, 0.31287159091446592, 0.67563073629801285, 0.58535468365486909, -0.015829105256023893, -0.28401554296242809, 0.00047248457399797254, 0.12874742662018601, -0.017369301002022108, -0.044088253931064719, 0.013981027917015516, 0.0087460940470156547, -0.0048703529930106603, -0.00039174037299597711, 0.00067544940599855677, -0.00011747678400228192},
    {-0.00011747678400228192, -0.00067544940599855677, -0.00039174037299597711, 0.0048703529930106603, 0.0087460940470156547, -0.013981027917015516, -0.044088253931064719, 0.017369301002022108, 0.12874742662018601, -0.00047248457399797254, -0.28401554296242809, 0.015829105256023893, 0.58535468365486909, -0.67563073629801285, 0.31287159091446592, -0.054415842243081609}
};

static double db9_double[][18] = {
    {3.9347319995026124e-005, -0.00025196318899817888, 0.00023038576399541288, 0.0018476468829611268, -0.0042815036819047227, -0.004723204757894831, 0.022361662123515244, 0.00025094711499193845, -0.067632829059523988, 0.030725681478322865, 0.14854074933476008, -0.096840783220879037, -0.29327378327258685, 0.13319738582208895, 0.65728807803663891, 0.6048231236767786, 0.24383467463766728, 0.038077947363167282},
    {-0.038077947363167282, 0.24383467463766728, -0.6048231236767786, 0.65728807803663891, -0.13319738582208895, -0.29327378327258685, 0.096840783220879037, 0.14854074933476008, -0.030725681478322865, -0.067632829059523988, -0.00025094711499193845, 0.022361662123515244, 0.004723204757894831, -0.0042815036819047227, -0.0018476468829611268, 0.00023038576399541288, 0.00025196318899817888, 3.9347319995026124e-005},
    {0.038077947363167282, 0.24383467463766728, 0.6048231236767786, 0.65728807803663891, 0.13319738582208895, -0.29327378327258685, -0.096840783220879037, 0.14854074933476008, 0.030725681478322865, -0.067632829059523988, 0.00025094711499193845, 0.022361662123515244, -0.004723204757894831, -0.0042815036819047227, 0.0018476468829611268, 0.00023038576399541288, -0.00025196318899817888, 3.9347319995026124e-005},
    {3.9347319995026124e-005, 0.00025196318899817888, 0.00023038576399541288, -0.0018476468829611268, -0.0042815036819047227, 0.004723204757894831, 0.022361662123515244, -0.00025094711499193845, -0.067632829059523988, -0.030725681478322865, 0.14854074933476008, 0.096840783220879037, -0.29327378327258685, -0.13319738582208895, 0.65728807803663891, -0.6048231236767786, 0.24383467463766728, -0.038077947363167282}
};

static double db10_double[][20] = {
    {-1.3264203002354869e-005, 9.3588670001089845e-005, -0.0001164668549943862, -0.00068585669500468248, 0.0019924052949908499, 0.0013953517469940798, -0.010733175482979604, 0.0036065535669883944, 0.033212674058933238, -0.029457536821945671, -0.071394147165860775, 0.093057364603806592, 0.12736934033574265, -0.19594627437659665, -0.24984642432648865, 0.28117234366042648, 0.68845903945259213, 0.52720118893091983, 0.18817680007762133, 0.026670057900950818},
    {-0.026670057900950818, 0.18817680007762133, -0.52720118893091983, 0.68845903945259213, -0.28117234366042648, -0.24984642432648865, 0.19594627437659665, 0.12736934033574265, -0.093057364603806592, -0.071394147165860775, 0.029457536821945671, 0.033212674058933238, -0.0036065535669883944, -0.010733175482979604, -0.0013953517469940798, 0.0019924052949908499, 0.00068585669500468248, -0.0001164668549943862, -9.3588670001089845e-005, -1.3264203002354869e-005},
    {0.026670057900950818, 0.18817680007762133, 0.52720118893091983, 0.68845903945259213, 0.28117234366042648, -0.24984642432648865, -0.19594627437659665, 0.12736934033574265, 0.093057364603806592, -0.071394147165860775, -0.029457536821945671, 0.033212674058933238, 0.0036065535669883944, -0.010733175482979604, 0.0013953517469940798, 0.0019924052949908499, -0.00068585669500468248, -0.0001164668549943862, 9.3588670001089845e-005, -1.3264203002354869e-005},
    {-1.3264203002354869e-005, -9.3588670001089845e-005, -0.0001164668549943862, 0.00068585669500468248, 0.0019924052949908499, -0.0013953517469940798, -0.010733175482979604, -0.0036065535669883944, 0.033212674058933238, 0.029457536821945671, -0.071394147165860775, -0.093057364603806592, 0.12736934033574265, 0.19594627437659665, -0.24984642432648865, -0.28117234366042648, 0.68845903945259213, -0.52720118893091983, 0.18817680007762133, -0.026670057900950818}
};

static double db11_double[][22] = {
    {4.4942742772363519e-006, -3.4634984186983789e-005, 5.4439074699366381e-005, 0.00024915252355281426, -0.00089302325066623663, -0.00030859285881515924, 0.0049284176560587777, -0.0033408588730145018, -0.015364820906201324, 0.020840904360180039, 0.031335090219045313, -0.066438785695020222, -0.04647995511667613, 0.14981201246638268, 0.066043588196690886, -0.27423084681792875, -0.16227524502747828, 0.41196436894789695, 0.68568677491617847, 0.44989976435603013, 0.14406702115061959, 0.018694297761470441},
    {-0.018694297761470441, 0.14406702115061959, -0.44989976435603013, 0.68568677491617847, -0.41196436894789695, -0.16227524502747828, 0.27423084681792875, 0.066043588196690886, -0.14981201246638268, -0.04647995511667613, 0.066438785695020222, 0.031335090219045313, -0.020840904360180039, -0.015364820906201324, 0.0033408588730145018, 0.0049284176560587777, 0.00030859285881515924, -0.00089302325066623663, -0.00024915252355281426, 5.4439074699366381e-005, 3.4634984186983789e-005, 4.4942742772363519e-006},
    {0.018694297761470441, 0.14406702115061959, 0.44989976435603013, 0.68568677491617847, 0.41196436894789695, -0.16227524502747828, -0.27423084681792875, 0.066043588196690886, 0.14981201246638268, -0.04647995511667613, -0.066438785695020222, 0.031335090219045313, 0.020840904360180039, -0.015364820906201324, -0.0033408588730145018, 0.0049284176560587777, -0.00030859285881515924, -0.00089302325066623663, 0.00024915252355281426, 5.4439074699366381e-005, -3.4634984186983789e-005, 4.4942742772363519e-006},
    {4.4942742772363519e-006, 3.4634984186983789e-005, 5.4439074699366381e-005, -0.00024915252355281426, -0.00089302325066623663, 0.00030859285881515924, 0.0049284176560587777, 0.0033408588730145018, -0.015364820906201324, -0.020840904360180039, 0.031335090219045313, 0.066438785695020222, -0.04647995511667613, -0.14981201246638268, 0.066043588196690886, 0.27423084681792875, -0.16227524502747828, -0.41196436894789695, 0.68568677491617847, -0.44989976435603013, 0.14406702115061959, -0.018694297761470441}
};

static double db12_double[][24] = {
    {-1.5290717580684923e-006, 1.2776952219379579e-005, -2.4241545757030318e-005, -8.8504109208203182e-005, 0.00038865306282092672, 6.5451282125215034e-006, -0.0021795036186277044, 0.0022486072409952287, 0.0067114990087955486, -0.012840825198299882, -0.01221864906974642, 0.041546277495087637, 0.010849130255828966, -0.09643212009649671, 0.0053595696743599965, 0.18247860592758275, -0.023779257256064865, -0.31617845375277914, -0.044763885653777619, 0.51588647842780067, 0.65719872257929113, 0.37735513521420411, 0.10956627282118277, 0.013112257957229239},
    {-0.013112257957229239, 0.10956627282118277, -0.37735513521420411, 0.65719872257929113, -0.51588647842780067, -0.044763885653777619, 0.31617845375277914, -0.023779257256064865, -0.18247860592758275, 0.0053595696743599965, 0.09643212009649671, 0.010849130255828966, -0.041546277495087637, -0.01221864906974642, 0.012840825198299882, 0.0067114990087955486, -0.0022486072409952287, -0.0021795036186277044, -6.5451282125215034e-006, 0.00038865306282092672, 8.8504109208203182e-005, -2.4241545757030318e-005, -1.2776952219379579e-005, -1.5290717580684923e-006},
    {0.013112257957229239, 0.10956627282118277, 0.37735513521420411, 0.65719872257929113, 0.51588647842780067, -0.044763885653777619, -0.31617845375277914, -0.023779257256064865, 0.18247860592758275, 0.0053595696743599965, -0.09643212009649671, 0.010849130255828966, 0.041546277495087637, -0.01221864906974642, -0.012840825198299882, 0.0067114990087955486, 0.0022486072409952287, -0.0021795036186277044, 6.5451282125215034e-006, 0.00038865306282092672, -8.8504109208203182e-005, -2.4241545757030318e-005, 1.2776952219379579e-005, -1.5290717580684923e-006},
    {-1.5290717580684923e-006, -1.2776952219379579e-005, -2.4241545757030318e-005, 8.8504109208203182e-005, 0.00038865306282092672, -6.5451282125215034e-006, -0.0021795036186277044, -0.0022486072409952287, 0.0067114990087955486, 0.012840825198299882, -0.01221864906974642, -0.041546277495087637, 0.010849130255828966, 0.09643212009649671, 0.0053595696743599965, -0.18247860592758275, -0.023779257256064865, 0.31617845375277914, -0.044763885653777619, -0.51588647842780067, 0.65719872257929113, -0.37735513521420411, 0.10956627282118277, -0.013112257957229239}
};

static double db13_double[][26] = {
    {5.2200350984547998e-007, -4.7004164793608082e-006, 1.0441930571407941e-005, 3.0678537579324358e-005, -0.00016512898855650571, 4.9251525126285676e-005, 0.00093232613086724904, -0.0013156739118922766, -0.002761911234656831, 0.0072555894016171187, 0.0039239414487955773, -0.023831420710327809, 0.0023799722540522269, 0.056139477100276156, -0.026488406475345658, -0.10580761818792761, 0.072948933656788742, 0.17947607942935084, -0.12457673075080665, -0.31497290771138414, 0.086985726179645007, 0.58888957043121193, 0.61105585115878114, 0.31199632216043488, 0.082861243872901946, 0.0092021335389622788},
    {-0.0092021335389622788, 0.082861243872901946, -0.31199632216043488, 0.61105585115878114, -0.58888957043121193, 0.086985726179645007, 0.31497290771138414, -0.12457673075080665, -0.17947607942935084, 0.072948933656788742, 0.10580761818792761, -0.026488406475345658, -0.056139477100276156, 0.0023799722540522269, 0.023831420710327809, 0.0039239414487955773, -0.0072555894016171187, -0.002761911234656831, 0.0013156739118922766, 0.00093232613086724904, -4.9251525126285676e-005, -0.00016512898855650571, -3.0678537579324358e-005, 1.0441930571407941e-005, 4.7004164793608082e-006, 5.2200350984547998e-007},
    {0.0092021335389622788, 0.082861243872901946, 0.31199632216043488, 0.61105585115878114, 0.58888957043121193, 0.086985726179645007, -0.31497290771138414, -0.12457673075080665, 0.17947607942935084, 0.072948933656788742, -0.10580761818792761, -0.026488406475345658, 0.056139477100276156, 0.0023799722540522269, -0.023831420710327809, 0.0039239414487955773, 0.0072555894016171187, -0.002761911234656831, -0.0013156739118922766, 0.00093232613086724904, 4.9251525126285676e-005, -0.00016512898855650571, 3.0678537579324358e-005, 1.0441930571407941e-005, -4.7004164793608082e-006, 5.2200350984547998e-007},
    {5.2200350984547998e-007, 4.7004164793608082e-006, 1.0441930571407941e-005, -3.0678537579324358e-005, -0.00016512898855650571, -4.9251525126285676e-005, 0.00093232613086724904, 0.0013156739118922766, -0.002761911234656831, -0.0072555894016171187, 0.0039239414487955773, 0.023831420710327809, 0.0023799722540522269, -0.056139477100276156, -0.026488406475345658, 0.10580761818792761, 0.072948933656788742, -0.17947607942935084, -0.12457673075080665, 0.31497290771138414, 0.086985726179645007, -0.58888957043121193, 0.61105585115878114, -0.31199632216043488, 0.082861243872901946, -0.0092021335389622788}
};

static double db14_double[][28] = {
    {-1.7871399683109222e-007, 1.7249946753674012e-006, -4.3897049017804176e-006, -1.0337209184568496e-005, 6.875504252695734e-005, -4.1777245770370672e-005, -0.00038683194731287514, 0.00070802115423540481, 0.001061691085606874, -0.003849638868019787, -0.00074621898926387534, 0.012789493266340071, -0.0056150495303375755, -0.030185351540353976, 0.026981408307947971, 0.05523712625925082, -0.071548955503983505, -0.086748411568110598, 0.13998901658445695, 0.13839521386479153, -0.21803352999321651, -0.27168855227867705, 0.21867068775886594, 0.63118784910471981, 0.55430561794077093, 0.25485026779256437, 0.062364758849384874, 0.0064611534600864905},
    {-0.0064611534600864905, 0.062364758849384874, -0.25485026779256437, 0.55430561794077093, -0.63118784910471981, 0.21867068775886594, 0.27168855227867705, -0.21803352999321651, -0.13839521386479153, 0.13998901658445695, 0.086748411568110598, -0.071548955503983505, -0.05523712625925082, 0.026981408307947971, 0.030185351540353976, -0.0056150495303375755, -0.012789493266340071, -0.00074621898926387534, 0.003849638868019787, 0.001061691085606874, -0.00070802115423540481, -0.00038683194731287514, 4.1777245770370672e-005, 6.875504252695734e-005, 1.0337209184568496e-005, -4.3897049017804176e-006, -1.7249946753674012e-006, -1.7871399683109222e-007},
    {0.0064611534600864905, 0.062364758849384874, 0.25485026779256437, 0.55430561794077093, 0.63118784910471981, 0.21867068775886594, -0.27168855227867705, -0.21803352999321651, 0.13839521386479153, 0.13998901658445695, -0.086748411568110598, -0.071548955503983505, 0.05523712625925082, 0.026981408307947971, -0.030185351540353976, -0.0056150495303375755, 0.012789493266340071, -0.00074621898926387534, -0.003849638868019787, 0.001061691085606874, 0.00070802115423540481, -0.00038683194731287514, -4.1777245770370672e-005, 6.875504252695734e-005, -1.0337209184568496e-005, -4.3897049017804176e-006, 1.7249946753674012e-006, -1.7871399683109222e-007},
    {-1.7871399683109222e-007, -1.7249946753674012e-006, -4.3897049017804176e-006, 1.0337209184568496e-005, 6.875504252695734e-005, 4.1777245770370672e-005, -0.00038683194731287514, -0.00070802115423540481, 0.001061691085606874, 0.003849638868019787, -0.00074621898926387534, -0.012789493266340071, -0.0056150495303375755, 0.030185351540353976, 0.026981408307947971, -0.05523712625925082, -0.071548955503983505, 0.086748411568110598, 0.13998901658445695, -0.13839521386479153, -0.21803352999321651, 0.27168855227867705, 0.21867068775886594, -0.63118784910471981, 0.55430561794077093, -0.25485026779256437, 0.062364758849384874, -0.0064611534600864905}
};

static double db15_double[][30] = {
    {6.1333599133037138e-008, -6.3168823258794506e-007, 1.8112704079399406e-006, 3.3629871817363823e-006, -2.8133296266037558e-005, 2.579269915531323e-005, 0.00015589648992055726, -0.00035956524436229364, -0.00037348235413726472, 0.0019433239803823459, -0.00024175649075894543, -0.0064877345603061454, 0.0051010003604228726, 0.015083918027862582, -0.020810050169636805, -0.025767007328366939, 0.054780550584559995, 0.033877143923563204, -0.11112093603713753, -0.039666176555733602, 0.19014671400708816, 0.065282952848765688, -0.28888259656686216, -0.19320413960907623, 0.33900253545462167, 0.64581314035721027, 0.49263177170797529, 0.20602386398692688, 0.046743394892750617, 0.0045385373615773762},
    {-0.0045385373615773762, 0.046743394892750617, -0.20602386398692688, 0.49263177170797529, -0.64581314035721027, 0.33900253545462167, 0.19320413960907623, -0.28888259656686216, -0.065282952848765688, 0.19014671400708816, 0.039666176555733602, -0.11112093603713753, -0.033877143923563204, 0.054780550584559995, 0.025767007328366939, -0.020810050169636805, -0.015083918027862582, 0.0051010003604228726, 0.0064877345603061454, -0.00024175649075894543, -0.0019433239803823459, -0.00037348235413726472, 0.00035956524436229364, 0.00015589648992055726, -2.579269915531323e-005, -2.8133296266037558e-005, -3.3629871817363823e-006, 1.8112704079399406e-006, 6.3168823258794506e-007, 6.1333599133037138e-008},
    {0.0045385373615773762, 0.046743394892750617, 0.20602386398692688, 0.49263177170797529, 0.64581314035721027, 0.33900253545462167, -0.19320413960907623, -0.28888259656686216, 0.065282952848765688, 0.19014671400708816, -0.039666176555733602, -0.11112093603713753, 0.033877143923563204, 0.054780550584559995, -0.025767007328366939, -0.020810050169636805, 0.015083918027862582, 0.0051010003604228726, -0.0064877345603061454, -0.00024175649075894543, 0.0019433239803823459, -0.00037348235413726472, -0.00035956524436229364, 0.00015589648992055726, 2.579269915531323e-005, -2.8133296266037558e-005, 3.3629871817363823e-006, 1.8112704079399406e-006, -6.3168823258794506e-007, 6.1333599133037138e-008},
    {6.1333599133037138e-008, 6.3168823258794506e-007, 1.8112704079399406e-006, -3.3629871817363823e-006, -2.8133296266037558e-005, -2.579269915531323e-005, 0.00015589648992055726, 0.00035956524436229364, -0.00037348235413726472, -0.0019433239803823459, -0.00024175649075894543, 0.0064877345603061454, 0.0051010003604228726, -0.015083918027862582, -0.020810050169636805, 0.025767007328366939, 0.054780550584559995, -0.033877143923563204, -0.11112093603713753, 0.039666176555733602, 0.19014671400708816, -0.065282952848765688, -0.28888259656686216, 0.19320413960907623, 0.33900253545462167, -0.64581314035721027, 0.49263177170797529, -0.20602386398692688, 0.046743394892750617, -0.0045385373615773762}
};

static double db16_double[][32] = {
    {-2.1093396300980412e-008, 2.3087840868545578e-007, -7.3636567854418147e-007, -1.0435713423102517e-006, 1.133660866126152e-005, -1.394566898819319e-005, -6.103596621404321e-005, 0.00017478724522506327, 0.00011424152003843815, -0.00094102174935854332, 0.00040789698084934395, 0.00312802338120381, -0.0036442796214883506, -0.0069900145633907508, 0.013993768859843242, 0.010297659641009963, -0.036888397691556774, -0.0075889743686425939, 0.075924236044457791, -0.0062397227521562536, -0.13238830556335474, 0.027340263752899923, 0.21119069394696974, -0.02791820813292813, -0.32706331052747578, -0.089751089402363524, 0.44029025688580486, 0.63735633208298326, 0.43031272284545874, 0.1650642834886438, 0.034907714323629047, 0.0031892209253436892},
    {-0.0031892209253436892, 0.034907714323629047, -0.1650642834886438, 0.43031272284545874, -0.63735633208298326, 0.44029025688580486, 0.089751089402363524, -0.32706331052747578, 0.02791820813292813, 0.21119069394696974, -0.027340263752899923, -0.13238830556335474, 0.0062397227521562536, 0.075924236044457791, 0.0075889743686425939, -0.036888397691556774, -0.010297659641009963, 0.013993768859843242, 0.0069900145633907508, -0.0036442796214883506, -0.00312802338120381, 0.00040789698084934395, 0.00094102174935854332, 0.00011424152003843815, -0.00017478724522506327, -6.103596621404321e-005, 1.394566898819319e-005, 1.133660866126152e-005, 1.0435713423102517e-006, -7.3636567854418147e-007, -2.3087840868545578e-007, -2.1093396300980412e-008},
    {0.0031892209253436892, 0.034907714323629047, 0.1650642834886438, 0.43031272284545874, 0.63735633208298326, 0.44029025688580486, -0.089751089402363524, -0.32706331052747578, -0.02791820813292813, 0.21119069394696974, 0.027340263752899923, -0.13238830556335474, -0.0062397227521562536, 0.075924236044457791, -0.0075889743686425939, -0.036888397691556774, 0.010297659641009963, 0.013993768859843242, -0.0069900145633907508, -0.0036442796214883506, 0.00312802338120381, 0.00040789698084934395, -0.00094102174935854332, 0.00011424152003843815, 0.00017478724522506327, -6.103596621404321e-005, -1.394566898819319e-005, 1.133660866126152e-005, -1.0435713423102517e-006, -7.3636567854418147e-007, 2.3087840868545578e-007, -2.1093396300980412e-008},
    {-2.1093396300980412e-008, -2.3087840868545578e-007, -7.3636567854418147e-007, 1.0435713423102517e-006, 1.133660866126152e-005, 1.394566898819319e-005, -6.103596621404321e-005, -0.00017478724522506327, 0.00011424152003843815, 0.00094102174935854332, 0.00040789698084934395, -0.00312802338120381, -0.0036442796214883506, 0.0069900145633907508, 0.013993768859843242, -0.010297659641009963, -0.036888397691556774, 0.0075889743686425939, 0.075924236044457791, 0.0062397227521562536, -0.13238830556335474, -0.027340263752899923, 0.21119069394696974, 0.02791820813292813, -0.32706331052747578, 0.089751089402363524, 0.44029025688580486, -0.63735633208298326, 0.43031272284545874, -0.1650642834886438, 0.034907714323629047, -0.0031892209253436892}
};

static double db17_double[][34] = {
    {7.2674929685663697e-009, -8.4239484460081536e-008, 2.9577009333187617e-007, 3.0165496099963414e-007, -4.5059424772259631e-006, 6.9906009850812941e-006, 2.3186813798761639e-005, -8.2048032024582121e-005, -2.5610109566546042e-005, 0.00043946542776894542, -0.00032813251941022427, -0.001436845304805, 0.0023012052421511474, 0.0029679966915180638, -0.0086029215203478147, -0.0030429899813869555, 0.022733676583919053, -0.0032709555358783646, -0.046922438389378908, 0.022312336178011833, 0.081105986654080822, -0.057091419631858077, -0.12681569177849797, 0.10113548917744287, 0.19731058956508457, -0.12659975221599248, -0.32832074836418546, 0.027314970403312946, 0.5183157640572823, 0.61099661568502728, 0.37035072415288578, 0.13121490330791097, 0.025985393703623173, 0.0022418070010387899},
    {-0.0022418070010387899, 0.025985393703623173, -0.13121490330791097, 0.37035072415288578, -0.61099661568502728, 0.5183157640572823, -0.027314970403312946, -0.32832074836418546, 0.12659975221599248, 0.19731058956508457, -0.10113548917744287, -0.12681569177849797, 0.057091419631858077, 0.081105986654080822, -0.022312336178011833, -0.046922438389378908, 0.0032709555358783646, 0.022733676583919053, 0.0030429899813869555, -0.0086029215203478147, -0.0029679966915180638, 0.0023012052421511474, 0.001436845304805, -0.00032813251941022427, -0.00043946542776894542, -2.5610109566546042e-005, 8.2048032024582121e-005, 2.3186813798761639e-005, -6.9906009850812941e-006, -4.5059424772259631e-006, -3.0165496099963414e-007, 2.9577009333187617e-007, 8.4239484460081536e-008, 7.2674929685663697e-009},
    {0.0022418070010387899, 0.025985393703623173, 0.13121490330791097, 0.37035072415288578, 0.61099661568502728, 0.5183157640572823, 0.027314970403312946, -0.32832074836418546, -0.12659975221599248, 0.19731058956508457, 0.10113548917744287, -0.12681569177849797, -0.057091419631858077, 0.081105986654080822, 0.022312336178011833, -0.046922438389378908, -0.0032709555358783646, 0.022733676583919053, -0.0030429899813869555, -0.0086029215203478147, 0.0029679966915180638, 0.0023012052421511474, -0.001436845304805, -0.00032813251941022427, 0.00043946542776894542, -2.5610109566546042e-005, -8.2048032024582121e-005, 2.3186813798761639e-005, 6.9906009850812941e-006, -4.5059424772259631e-006, 3.0165496099963414e-007, 2.9577009333187617e-007, -8.4239484460081536e-008, 7.2674929685663697e-009},
    {7.2674929685663697e-009, 8.4239484460081536e-008, 2.9577009333187617e-007, -3.0165496099963414e-007, -4.5059424772259631e-006, -6.9906009850812941e-006, 2.3186813798761639e-005, 8.2048032024582121e-005, -2.5610109566546042e-005, -0.00043946542776894542, -0.00032813251941022427, 0.001436845304805, 0.0023012052421511474, -0.0029679966915180638, -0.0086029215203478147, 0.0030429899813869555, 0.022733676583919053, 0.0032709555358783646, -0.046922438389378908, -0.022312336178011833, 0.081105986654080822, 0.057091419631858077, -0.12681569177849797, -0.10113548917744287, 0.19731058956508457, 0.12659975221599248, -0.32832074836418546, -0.027314970403312946, 0.5183157640572823, -0.61099661568502728, 0.37035072415288578, -0.13121490330791097, 0.025985393703623173, -0.0022418070010387899}
};

static double db18_double[][36] = {
    {-2.5079344549419292e-009, 3.0688358630370302e-008, -1.1760987670250871e-007, -7.691632689865049e-008, 1.7687129836228861e-006, -3.3326344788769603e-006, -8.5206025374234635e-006, 3.7412378807308472e-005, -1.5359171230213409e-007, -0.00019864855231101547, 0.0002135815619103188, 0.00062846568296447147, -0.0013405962983313922, -0.0011187326669886426, 0.0049433436054565939, 0.00011863003387493042, -0.013051480946517112, 0.0062621679544386608, 0.026670705926689853, -0.023733210395336858, -0.04452614190225633, 0.057051247739058272, 0.064887216212358198, -0.10675224665906288, -0.092331884150304119, 0.16708131276294505, 0.14953397556500755, -0.21648093400458224, -0.29365404073579809, 0.14722311196952223, 0.57180165488712198, 0.57182680776508177, 0.31467894133619284, 0.10358846582214751, 0.019288531724094969, 0.0015763102184365595},
    {-0.0015763102184365595, 0.019288531724094969, -0.10358846582214751, 0.31467894133619284, -0.57182680776508177, 0.57180165488712198, -0.14722311196952223, -0.29365404073579809, 0.21648093400458224, 0.14953397556500755, -0.16708131276294505, -0.092331884150304119, 0.10675224665906288, 0.064887216212358198, -0.057051247739058272, -0.04452614190225633, 0.023733210395336858, 0.026670705926689853, -0.0062621679544386608, -0.013051480946517112, -0.00011863003387493042, 0.0049433436054565939, 0.0011187326669886426, -0.0013405962983313922, -0.00062846568296447147, 0.0002135815619103188, 0.00019864855231101547, -1.5359171230213409e-007, -3.7412378807308472e-005, -8.5206025374234635e-006, 3.3326344788769603e-006, 1.7687129836228861e-006, 7.691632689865049e-008, -1.1760987670250871e-007, -3.0688358630370302e-008, -2.5079344549419292e-009},
    {0.0015763102184365595, 0.019288531724094969, 0.10358846582214751, 0.31467894133619284, 0.57182680776508177, 0.57180165488712198, 0.14722311196952223, -0.29365404073579809, -0.21648093400458224, 0.14953397556500755, 0.16708131276294505, -0.092331884150304119, -0.10675224665906288, 0.064887216212358198, 0.057051247739058272, -0.04452614190225633, -0.023733210395336858, 0.026670705926689853, 0.0062621679544386608, -0.013051480946517112, 0.00011863003387493042, 0.0049433436054565939, -0.0011187326669886426, -0.0013405962983313922, 0.00062846568296447147, 0.0002135815619103188, -0.00019864855231101547, -1.5359171230213409e-007, 3.7412378807308472e-005, -8.5206025374234635e-006, -3.3326344788769603e-006, 1.7687129836228861e-006, -7.691632689865049e-008, -1.1760987670250871e-007, 3.0688358630370302e-008, -2.5079344549419292e-009},
    {-2.5079344549419292e-009, -3.0688358630370302e-008, -1.1760987670250871e-007, 7.691632689865049e-008, 1.7687129836228861e-006, 3.3326344788769603e-006, -8.5206025374234635e-006, -3.7412378807308472e-005, -1.5359171230213409e-007, 0.00019864855231101547, 0.0002135815619103188, -0.00062846568296447147, -0.0013405962983313922, 0.0011187326669886426, 0.0049433436054565939, -0.00011863003387493042, -0.013051480946517112, -0.0062621679544386608, 0.026670705926689853, 0.023733210395336858, -0.04452614190225633, -0.057051247739058272, 0.064887216212358198, 0.10675224665906288, -0.092331884150304119, -0.16708131276294505, 0.14953397556500755, 0.21648093400458224, -0.29365404073579809, -0.14722311196952223, 0.57180165488712198, -0.57182680776508177, 0.31467894133619284, -0.10358846582214751, 0.019288531724094969, -0.0015763102184365595}
};

static double db19_double[][38] = {
    {8.6668488390344833e-010, -1.1164020670405678e-008, 4.6369377758023682e-008, 1.4470882988040879e-008, -6.8627556577981102e-007, 1.5319314766978769e-006, 3.0109643163099385e-006, -1.6640176297224622e-005, 5.1059504870906939e-006, 8.7112704672504432e-005, -0.00012460079173506306, -0.00026067613568119951, 0.0007358025205041731, 0.00034180865344939543, -0.0026875518007344408, 0.00076895435922424884, 0.0070407473670804953, -0.0058669222811121953, -0.013988388678695632, 0.019375549889114482, 0.021623767409452484, -0.045674226277784918, -0.026501236250778635, 0.086906755555450702, 0.027584350624887129, -0.14278569504021468, -0.033518541903202262, 0.21234974330662043, 0.074652269708066474, -0.28583863175723145, -0.22809139421653665, 0.26089495265212009, 0.60170454913009164, 0.52443637746688621, 0.26438843174202237, 0.08127811326580564, 0.01428109845082521, 0.0011086697631864314},
    {-0.0011086697631864314, 0.01428109845082521, -0.08127811326580564, 0.26438843174202237, -0.52443637746688621, 0.60170454913009164, -0.26089495265212009, -0.22809139421653665, 0.28583863175723145, 0.074652269708066474, -0.21234974330662043, -0.033518541903202262, 0.14278569504021468, 0.027584350624887129, -0.086906755555450702, -0.026501236250778635, 0.045674226277784918, 0.021623767409452484, -0.019375549889114482, -0.013988388678695632, 0.0058669222811121953, 0.0070407473670804953, -0.00076895435922424884, -0.0026875518007344408, -0.00034180865344939543, 0.0007358025205041731, 0.00026067613568119951, -0.00012460079173506306, -8.7112704672504432e-005, 5.1059504870906939e-006, 1.6640176297224622e-005, 3.0109643163099385e-006, -1.5319314766978769e-006, -6.8627556577981102e-007, -1.4470882988040879e-008, 4.6369377758023682e-008, 1.1164020670405678e-008, 8.6668488390344833e-010},
    {0.0011086697631864314, 0.01428109845082521, 0.08127811326580564, 0.26438843174202237, 0.52443637746688621, 0.60170454913009164, 0.26089495265212009, -0.22809139421653665, -0.28583863175723145, 0.074652269708066474, 0.21234974330662043, -0.033518541903202262, -0.14278569504021468, 0.027584350624887129, 0.086906755555450702, -0.026501236250778635, -0.045674226277784918, 0.021623767409452484, 0.019375549889114482, -0.013988388678695632, -0.0058669222811121953, 0.0070407473670804953, 0.00076895435922424884, -0.0026875518007344408, 0.00034180865344939543, 0.0007358025205041731, -0.00026067613568119951, -0.00012460079173506306, 8.7112704672504432e-005, 5.1059504870906939e-006, -1.6640176297224622e-005, 3.0109643163099385e-006, 1.5319314766978769e-006, -6.8627556577981102e-007, 1.4470882988040879e-008, 4.6369377758023682e-008, -1.1164020670405678e-008, 8.6668488390344833e-010},
    {8.6668488390344833e-010, 1.1164020670405678e-008, 4.6369377758023682e-008, -1.4470882988040879e-008, -6.8627556577981102e-007, -1.5319314766978769e-006, 3.0109643163099385e-006, 1.6640176297224622e-005, 5.1059504870906939e-006, -8.7112704672504432e-005, -0.00012460079173506306, 0.00026067613568119951, 0.0007358025205041731, -0.00034180865344939543, -0.0026875518007344408, -0.00076895435922424884, 0.0070407473670804953, 0.0058669222811121953, -0.013988388678695632, -0.019375549889114482, 0.021623767409452484, 0.045674226277784918, -0.026501236250778635, -0.086906755555450702, 0.027584350624887129, 0.14278569504021468, -0.033518541903202262, -0.21234974330662043, 0.074652269708066474, 0.28583863175723145, -0.22809139421653665, -0.26089495265212009, 0.60170454913009164, -0.52443637746688621, 0.26438843174202237, -0.08127811326580564, 0.01428109845082521, -0.0011086697631864314}
};

static double db20_double[][40] = {
    {-2.9988364896157532e-010, 4.05612705554717e-009, -1.8148432482976221e-008, 2.0143220235374613e-010, 2.633924226266962e-007, -6.847079596993149e-007, -1.0119940100181473e-006, 7.2412482876637907e-006, -4.3761438621821972e-006, -3.7105861833906152e-005, 6.7742808283730477e-005, 0.00010153288973669777, -0.0003851047486990061, -5.3497598443404532e-005, 0.0013925596193045254, -0.00083156217287724745, -0.003581494259744107, 0.0044205423867663502, 0.0067216273018096935, -0.013810526137727442, -0.0087893249245557647, 0.032294299530119162, 0.0058746818113949465, -0.061722899624668884, 0.0056322468576854544, 0.10229171917513397, -0.024716827337521424, -0.15545875070604531, 0.039850246458519104, 0.22829105082013823, -0.016727088308801888, -0.32678680043353758, -0.13921208801128787, 0.36150229873889705, 0.61049323893785579, 0.47269618531033147, 0.21994211355113222, 0.063423780459005291, 0.010549394624937735, 0.00077995361366591117},
    {-0.00077995361366591117, 0.010549394624937735, -0.063423780459005291, 0.21994211355113222, -0.47269618531033147, 0.61049323893785579, -0.36150229873889705, -0.13921208801128787, 0.32678680043353758, -0.016727088308801888, -0.22829105082013823, 0.039850246458519104, 0.15545875070604531, -0.024716827337521424, -0.10229171917513397, 0.0056322468576854544, 0.061722899624668884, 0.0058746818113949465, -0.032294299530119162, -0.0087893249245557647, 0.013810526137727442, 0.0067216273018096935, -0.0044205423867663502, -0.003581494259744107, 0.00083156217287724745, 0.0013925596193045254, 5.3497598443404532e-005, -0.0003851047486990061, -0.00010153288973669777, 6.7742808283730477e-005, 3.7105861833906152e-005, -4.3761438621821972e-006, -7.2412482876637907e-006, -1.0119940100181473e-006, 6.847079596993149e-007, 2.633924226266962e-007, -2.0143220235374613e-010, -1.8148432482976221e-008, -4.05612705554717e-009, -2.9988364896157532e-010},
    {0.00077995361366591117, 0.010549394624937735, 0.063423780459005291, 0.21994211355113222, 0.47269618531033147, 0.61049323893785579, 0.36150229873889705, -0.13921208801128787, -0.32678680043353758, -0.016727088308801888, 0.22829105082013823, 0.039850246458519104, -0.15545875070604531, -0.024716827337521424, 0.10229171917513397, 0.0056322468576854544, -0.061722899624668884, 0.0058746818113949465, 0.032294299530119162, -0.0087893249245557647, -0.013810526137727442, 0.0067216273018096935, 0.0044205423867663502, -0.003581494259744107, -0.00083156217287724745, 0.0013925596193045254, -5.3497598443404532e-005, -0.0003851047486990061, 0.00010153288973669777, 6.7742808283730477e-005, -3.7105861833906152e-005, -4.3761438621821972e-006, 7.2412482876637907e-006, -1.0119940100181473e-006, -6.847079596993149e-007, 2.633924226266962e-007, 2.0143220235374613e-010, -1.8148432482976221e-008, 4.05612705554717e-009, -2.9988364896157532e-010},
    {-2.9988364896157532e-010, -4.05612705554717e-009, -1.8148432482976221e-008, -2.0143220235374613e-010, 2.633924226266962e-007, 6.847079596993149e-007, -1.0119940100181473e-006, -7.2412482876637907e-006, -4.3761438621821972e-006, 3.7105861833906152e-005, 6.7742808283730477e-005, -0.00010153288973669777, -0.0003851047486990061, 5.3497598443404532e-005, 0.0013925596193045254, 0.00083156217287724745, -0.003581494259744107, -0.0044205423867663502, 0.0067216273018096935, 0.013810526137727442, -0.0087893249245557647, -0.032294299530119162, 0.0058746818113949465, 0.061722899624668884, 0.0056322468576854544, -0.10229171917513397, -0.024716827337521424, 0.15545875070604531, 0.039850246458519104, -0.22829105082013823, -0.016727088308801888, 0.32678680043353758, -0.13921208801128787, -0.36150229873889705, 0.61049323893785579, -0.47269618531033147, 0.21994211355113222, -0.063423780459005291, 0.010549394624937735, -0.00077995361366591117}
};

static double sym2_double[][4] = {
    {-0.12940952255092145, 0.22414386804185735, 0.83651630373746899, 0.48296291314469025},
    {-0.48296291314469025, 0.83651630373746899, -0.22414386804185735, -0.12940952255092145},
    {0.48296291314469025, 0.83651630373746899, 0.22414386804185735, -0.12940952255092145},
    {-0.12940952255092145, -0.22414386804185735, 0.83651630373746899, -0.48296291314469025}
};

static double sym3_double[][6] = {
    {0.035226291882100656, -0.085441273882241486, -0.13501102001039084, 0.45987750211933132, 0.80689150931333875, 0.33267055295095688},
    {-0.33267055295095688, 0.80689150931333875, -0.45987750211933132, -0.13501102001039084, 0.085441273882241486, 0.035226291882100656},
    {0.33267055295095688, 0.80689150931333875, 0.45987750211933132, -0.13501102001039084, -0.085441273882241486, 0.035226291882100656},
    {0.035226291882100656, 0.085441273882241486, -0.13501102001039084, -0.45987750211933132, 0.80689150931333875, -0.33267055295095688}
};

static double sym4_double[][8] = {
    {-0.075765714789273325, -0.02963552764599851, 0.49761866763201545, 0.80373875180591614, 0.29785779560527736, -0.099219543576847216, -0.012603967262037833, 0.032223100604042702},
    {-0.032223100604042702, -0.012603967262037833, 0.099219543576847216, 0.29785779560527736, -0.80373875180591614, 0.49761866763201545, 0.02963552764599851, -0.075765714789273325},
    {0.032223100604042702, -0.012603967262037833, -0.099219543576847216, 0.29785779560527736, 0.80373875180591614, 0.49761866763201545, -0.02963552764599851, -0.075765714789273325},
    {-0.075765714789273325, 0.02963552764599851, 0.49761866763201545, -0.80373875180591614, 0.29785779560527736, 0.099219543576847216, -0.012603967262037833, -0.032223100604042702}
};

static double sym5_double[][10] = {
    {0.027333068345077982, 0.029519490925774643, -0.039134249302383094, 0.1993975339773936, 0.72340769040242059, 0.63397896345821192, 0.016602105764522319, -0.17532808990845047, -0.021101834024758855, 0.019538882735286728},
    {-0.019538882735286728, -0.021101834024758855, 0.17532808990845047, 0.016602105764522319, -0.63397896345821192, 0.72340769040242059, -0.1993975339773936, -0.039134249302383094, -0.029519490925774643, 0.027333068345077982},
    {0.019538882735286728, -0.021101834024758855, -0.17532808990845047, 0.016602105764522319, 0.63397896345821192, 0.72340769040242059, 0.1993975339773936, -0.039134249302383094, 0.029519490925774643, 0.027333068345077982},
    {0.027333068345077982, -0.029519490925774643, -0.039134249302383094, -0.1993975339773936, 0.72340769040242059, -0.63397896345821192, 0.016602105764522319, 0.17532808990845047, -0.021101834024758855, -0.019538882735286728}
};

static double sym6_double[][12] = {
    {0.015404109327027373, 0.0034907120842174702, -0.11799011114819057, -0.048311742585632998, 0.49105594192674662, 0.787641141030194, 0.3379294217276218, -0.072637522786462516, -0.021060292512300564, 0.044724901770665779, 0.0017677118642428036, -0.007800708325034148},
    {0.007800708325034148, 0.0017677118642428036, -0.044724901770665779, -0.021060292512300564, 0.072637522786462516, 0.3379294217276218, -0.787641141030194, 0.49105594192674662, 0.048311742585632998, -0.11799011114819057, -0.0034907120842174702, 0.015404109327027373},
    {-0.007800708325034148, 0.0017677118642428036, 0.044724901770665779, -0.021060292512300564, -0.072637522786462516, 0.3379294217276218, 0.787641141030194, 0.49105594192674662, -0.048311742585632998, -0.11799011114819057, 0.0034907120842174702, 0.015404109327027373},
    {0.015404109327027373, -0.0034907120842174702, -0.11799011114819057, 0.048311742585632998, 0.49105594192674662, -0.787641141030194, 0.3379294217276218, 0.072637522786462516, -0.021060292512300564, -0.044724901770665779, 0.0017677118642428036, 0.007800708325034148}
};

static double sym7_double[][14] = {
    {0.0026818145682578781, -0.0010473848886829163, -0.01263630340325193, 0.03051551316596357, 0.067892693501372697, -0.049552834937127255, 0.017441255086855827, 0.5361019170917628, 0.76776431700316405, 0.28862963175151463, -0.14004724044296152, -0.10780823770381774, 0.0040102448715336634, 0.010268176708511255},
    {-0.010268176708511255, 0.0040102448715336634, 0.10780823770381774, -0.14004724044296152, -0.28862963175151463, 0.76776431700316405, -0.5361019170917628, 0.017441255086855827, 0.049552834937127255, 0.067892693501372697, -0.03051551316596357, -0.01263630340325193, 0.0010473848886829163, 0.0026818145682578781},
    {0.010268176708511255, 0.0040102448715336634, -0.10780823770381774, -0.14004724044296152, 0.28862963175151463, 0.76776431700316405, 0.5361019170917628, 0.017441255086855827, -0.049552834937127255, 0.067892693501372697, 0.03051551316596357, -0.01263630340325193, -0.0010473848886829163, 0.0026818145682578781},
    {0.0026818145682578781, 0.0010473848886829163, -0.01263630340325193, -0.03051551316596357, 0.067892693501372697, 0.049552834937127255, 0.017441255086855827, -0.5361019170917628, 0.76776431700316405, -0.28862963175151463, -0.14004724044296152, 0.10780823770381774, 0.0040102448715336634, -0.010268176708511255}
};

static double sym8_double[][16] = {
    {-0.0033824159510061256, -0.00054213233179114812, 0.031695087811492981, 0.0076074873249176054, -0.14329423835080971, -0.061273359067658524, 0.48135965125837221, 0.77718575170052351, 0.3644418948353314, -0.051945838107709037, -0.027219029917056003, 0.049137179673607506, 0.0038087520138906151, -0.014952258337048231, -0.0003029205147213668, 0.0018899503327594609},
    {-0.0018899503327594609, -0.0003029205147213668, 0.014952258337048231, 0.0038087520138906151, -0.049137179673607506, -0.027219029917056003, 0.051945838107709037, 0.3644418948353314, -0.77718575170052351, 0.48135965125837221, 0.061273359067658524, -0.14329423835080971, -0.0076074873249176054, 0.031695087811492981, 0.00054213233179114812, -0.0033824159510061256},
    {0.0018899503327594609, -0.0003029205147213668, -0.014952258337048231, 0.0038087520138906151, 0.049137179673607506, -0.027219029917056003, -0.051945838107709037, 0.3644418948353314, 0.77718575170052351, 0.48135965125837221, -0.061273359067658524, -0.14329423835080971, 0.0076074873249176054, 0.031695087811492981, -0.00054213233179114812, -0.0033824159510061256},
    {-0.0033824159510061256, 0.00054213233179114812, 0.031695087811492981, -0.0076074873249176054, -0.14329423835080971, 0.061273359067658524, 0.48135965125837221, -0.77718575170052351, 0.3644418948353314, 0.051945838107709037, -0.027219029917056003, -0.049137179673607506, 0.0038087520138906151, 0.014952258337048231, -0.0003029205147213668, -0.0018899503327594609}
};

static double sym9_double[][18] = {
    {0.0014009155259146807, 0.00061978088898558676, -0.013271967781817119, -0.01152821020767923, 0.03022487885827568, 0.00058346274612580684, -0.054568958430834071, 0.238760914607303, 0.717897082764412, 0.61733844914093583, 0.035272488035271894, -0.19155083129728512, -0.018233770779395985, 0.06207778930288603, 0.0088592674934004842, -0.010264064027633142, -0.00047315449868008311, 0.0010694900329086053},
    {-0.0010694900329086053, -0.00047315449868008311, 0.010264064027633142, 0.0088592674934004842, -0.06207778930288603, -0.018233770779395985, 0.19155083129728512, 0.035272488035271894, -0.61733844914093583, 0.717897082764412, -0.238760914607303, -0.054568958430834071, -0.00058346274612580684, 0.03022487885827568, 0.01152821020767923, -0.013271967781817119, -0.00061978088898558676, 0.0014009155259146807},
    {0.0010694900329086053, -0.00047315449868008311, -0.010264064027633142, 0.0088592674934004842, 0.06207778930288603, -0.018233770779395985, -0.19155083129728512, 0.035272488035271894, 0.61733844914093583, 0.717897082764412, 0.238760914607303, -0.054568958430834071, 0.00058346274612580684, 0.03022487885827568, -0.01152821020767923, -0.013271967781817119, 0.00061978088898558676, 0.0014009155259146807},
    {0.0014009155259146807, -0.00061978088898558676, -0.013271967781817119, 0.01152821020767923, 0.03022487885827568, -0.00058346274612580684, -0.054568958430834071, -0.238760914607303, 0.717897082764412, -0.61733844914093583, 0.035272488035271894, 0.19155083129728512, -0.018233770779395985, -0.06207778930288603, 0.0088592674934004842, 0.010264064027633142, -0.00047315449868008311, -0.0010694900329086053}
};

static double sym10_double[][20] = {
    {0.00077015980911449011, 9.5632670722894754e-005, -0.0086412992770224222, -0.0014653825813050513, 0.045927239231092203, 0.011609893903711381, -0.15949427888491757, -0.070880535783243853, 0.47169066693843925, 0.7695100370211071, 0.38382676106708546, -0.035536740473817552, -0.0319900568824278, 0.049994972077376687, 0.0057649120335819086, -0.02035493981231129, -0.00080435893201654491, 0.0045931735853118284, 5.7036083618494284e-005, -0.00045932942100465878},
    {0.00045932942100465878, 5.7036083618494284e-005, -0.0045931735853118284, -0.00080435893201654491, 0.02035493981231129, 0.0057649120335819086, -0.049994972077376687, -0.0319900568824278, 0.035536740473817552, 0.38382676106708546, -0.7695100370211071, 0.47169066693843925, 0.070880535783243853, -0.15949427888491757, -0.011609893903711381, 0.045927239231092203, 0.0014653825813050513, -0.0086412992770224222, -9.5632670722894754e-005, 0.00077015980911449011},
    {-0.00045932942100465878, 5.7036083618494284e-005, 0.0045931735853118284, -0.00080435893201654491, -0.02035493981231129, 0.0057649120335819086, 0.049994972077376687, -0.0319900568824278, -0.035536740473817552, 0.38382676106708546, 0.7695100370211071, 0.47169066693843925, -0.070880535783243853, -0.15949427888491757, 0.011609893903711381, 0.045927239231092203, -0.0014653825813050513, -0.0086412992770224222, 9.5632670722894754e-005, 0.00077015980911449011},
    {0.00077015980911449011, -9.5632670722894754e-005, -0.0086412992770224222, 0.0014653825813050513, 0.045927239231092203, -0.011609893903711381, -0.15949427888491757, 0.070880535783243853, 0.47169066693843925, -0.7695100370211071, 0.38382676106708546, 0.035536740473817552, -0.0319900568824278, -0.049994972077376687, 0.0057649120335819086, 0.02035493981231129, -0.00080435893201654491, -0.0045931735853118284, 5.7036083618494284e-005, 0.00045932942100465878}
};

static double sym11_double[][22] = {
    {0.00017172195069934854, -3.8795655736158566e-005, -0.0017343662672978692, 0.00058835273539699145, 0.0065124956747714497, -0.0098579348287897942, -0.024080841595864003, 0.0370374159788594, 0.069976799610734136, -0.022832651022562687, 0.097198394458909473, 0.57202297801008706, 0.73034354908839572, 0.23768990904924897, -0.2046547944958006, -0.14460234370531561, 0.035266759564466552, 0.043000190681552281, -0.0020034719001093887, -0.0063896036664548919, 0.00011053509764272153, 0.00048926361026192387},
    {-0.00048926361026192387, 0.00011053509764272153, 0.0063896036664548919, -0.0020034719001093887, -0.043000190681552281, 0.035266759564466552, 0.14460234370531561, -0.2046547944958006, -0.23768990904924897, 0.73034354908839572, -0.57202297801008706, 0.097198394458909473, 0.022832651022562687, 0.069976799610734136, -0.0370374159788594, -0.024080841595864003, 0.0098579348287897942, 0.0065124956747714497, -0.00058835273539699145, -0.0017343662672978692, 3.8795655736158566e-005, 0.00017172195069934854},
    {0.00048926361026192387, 0.00011053509764272153, -0.0063896036664548919, -0.0020034719001093887, 0.043000190681552281, 0.035266759564466552, -0.14460234370531561, -0.2046547944958006, 0.23768990904924897, 0.73034354908839572, 0.57202297801008706, 0.097198394458909473, -0.022832651022562687, 0.069976799610734136, 0.0370374159788594, -0.024080841595864003, -0.0098579348287897942, 0.0065124956747714497, 0.00058835273539699145, -0.0017343662672978692, -3.8795655736158566e-005, 0.00017172195069934854},
    {0.00017172195069934854, 3.8795655736158566e-005, -0.0017343662672978692, -0.00058835273539699145, 0.0065124956747714497, 0.0098579348287897942, -0.024080841595864003, -0.0370374159788594, 0.069976799610734136, 0.022832651022562687, 0.097198394458909473, -0.57202297801008706, 0.73034354908839572, -0.23768990904924897, -0.2046547944958006, 0.14460234370531561, 0.035266759564466552, -0.043000190681552281, -0.0020034719001093887, 0.0063896036664548919, 0.00011053509764272153, -0.00048926361026192387}
};

static double sym12_double[][24] = {
    {0.00011196719424656033, -1.1353928041541452e-005, -0.0013497557555715387, 0.00018021409008538188, 0.007414965517654251, -0.0014089092443297553, -0.024220722675013445, 0.0075537806116804775, 0.049179318299660837, -0.035848830736954392, -0.022162306170337816, 0.39888597239022, 0.76347909778365719, 0.46274103121927235, -0.07833262231634322, -0.17037069723886492, 0.01530174062247884, 0.057804179445505657, -0.0026043910313322326, -0.014589836449234145, 0.00030764779631059454, 0.0023502976141834648, -1.8158078862617515e-005, -0.00017906658697508691},
    {0.00017906658697508691, -1.8158078862617515e-005, -0.0023502976141834648, 0.00030764779631059454, 0.014589836449234145, -0.0026043910313322326, -0.057804179445505657, 0.01530174062247884, 0.17037069723886492, -0.07833262231634322, -0.46274103121927235, 0.76347909778365719, -0.39888597239022, -0.022162306170337816, 0.035848830736954392, 0.049179318299660837, -0.0075537806116804775, -0.024220722675013445, 0.0014089092443297553, 0.007414965517654251, -0.00018021409008538188, -0.0013497557555715387, 1.1353928041541452e-005, 0.00011196719424656033},
    {-0.00017906658697508691, -1.8158078862617515e-005, 0.0023502976141834648, 0.00030764779631059454, -0.014589836449234145, -0.0026043910313322326, 0.057804179445505657, 0.01530174062247884, -0.17037069723886492, -0.07833262231634322, 0.46274103121927235, 0.76347909778365719, 0.39888597239022, -0.022162306170337816, -0.035848830736954392, 0.049179318299660837, 0.0075537806116804775, -0.024220722675013445, -0.0014089092443297553, 0.007414965517654251, 0.00018021409008538188, -0.0013497557555715387, -1.1353928041541452e-005, 0.00011196719424656033},
    {0.00011196719424656033, 1.1353928041541452e-005, -0.0013497557555715387, -0.00018021409008538188, 0.007414965517654251, 0.0014089092443297553, -0.024220722675013445, -0.0075537806116804775, 0.049179318299660837, 0.035848830736954392, -0.022162306170337816, -0.39888597239022, 0.76347909778365719, -0.46274103121927235, -0.07833262231634322, 0.17037069723886492, 0.01530174062247884, -0.057804179445505657, -0.0026043910313322326, 0.014589836449234145, 0.00030764779631059454, -0.0023502976141834648, -1.8158078862617515e-005, 0.00017906658697508691}
};

static double sym13_double[][26] = {
    {6.8203252630753188e-005, -3.5738623648689009e-005, -0.0011360634389281183, -0.00017094285853022211, 0.0075262253899680996, 0.0052963597387250252, -0.02021676813338983, -0.017211642726299048, 0.013862497435849205, -0.059750627717943698, -0.12436246075153011, 0.19770481877117801, 0.69573915056149638, 0.64456438390118564, 0.11023022302137217, -0.14049009311363403, 0.0088197576704205465, 0.092926030899137119, 0.017618296880653084, -0.020749686325515677, -0.0014924472742598532, 0.0056748537601224395, 0.00041326119884196064, -0.0007213643851362283, 3.6905373423196241e-005, 7.0429866906944016e-005},
    {-7.0429866906944016e-005, 3.6905373423196241e-005, 0.0007213643851362283, 0.00041326119884196064, -0.0056748537601224395, -0.0014924472742598532, 0.020749686325515677, 0.017618296880653084, -0.092926030899137119, 0.0088197576704205465, 0.14049009311363403, 0.11023022302137217, -0.64456438390118564, 0.69573915056149638, -0.19770481877117801, -0.12436246075153011, 0.059750627717943698, 0.013862497435849205, 0.017211642726299048, -0.02021676813338983, -0.0052963597387250252, 0.0075262253899680996, 0.00017094285853022211, -0.0011360634389281183, 3.5738623648689009e-005, 6.8203252630753188e-005},
    {7.0429866906944016e-005, 3.6905373423196241e-005, -0.0007213643851362283, 0.00041326119884196064, 0.0056748537601224395, -0.0014924472742598532, -0.020749686325515677, 0.017618296880653084, 0.092926030899137119, 0.0088197576704205465, -0.14049009311363403, 0.11023022302137217, 0.64456438390118564, 0.69573915056149638, 0.19770481877117801, -0.12436246075153011, -0.059750627717943698, 0.013862497435849205, -0.017211642726299048, -0.02021676813338983, 0.0052963597387250252, 0.0075262253899680996, -0.00017094285853022211, -0.0011360634389281183, -3.5738623648689009e-005, 6.8203252630753188e-005},
    {6.8203252630753188e-005, 3.5738623648689009e-005, -0.0011360634389281183, 0.00017094285853022211, 0.0075262253899680996, -0.0052963597387250252, -0.02021676813338983, 0.017211642726299048, 0.013862497435849205, 0.059750627717943698, -0.12436246075153011, -0.19770481877117801, 0.69573915056149638, -0.64456438390118564, 0.11023022302137217, 0.14049009311363403, 0.0088197576704205465, -0.092926030899137119, 0.017618296880653084, 0.020749686325515677, -0.0014924472742598532, -0.0056748537601224395, 0.00041326119884196064, 0.0007213643851362283, 3.6905373423196241e-005, -7.0429866906944016e-005}
};

static double sym14_double[][28] = {
    {-2.5879090265397886e-005, 1.1210865808890361e-005, 0.00039843567297594335, -6.2865424814776362e-005, -0.002579441725933078, 0.00036647657366011829, 0.010037693717672269, -0.0027537747912240711, -0.029196217764038187, 0.0042805204990193782, 0.037433088362853452, -0.057634498351326995, -0.035318112114979733, 0.39320152196208885, 0.75997624196109093, 0.47533576263420663, -0.058111823317717831, -0.15999741114652205, 0.025898587531046669, 0.069827616361807551, -0.0023650488367403851, -0.019439314263626713, 0.0010131419871842082, 0.0045326774719456481, -7.3214213567023991e-005, -0.00060576018246643346, 1.9329016965523917e-005, 4.4618977991475265e-005},
    {-4.4618977991475265e-005, 1.9329016965523917e-005, 0.00060576018246643346, -7.3214213567023991e-005, -0.0045326774719456481, 0.0010131419871842082, 0.019439314263626713, -0.0023650488367403851, -0.069827616361807551, 0.025898587531046669, 0.15999741114652205, -0.058111823317717831, -0.47533576263420663, 0.75997624196109093, -0.39320152196208885, -0.035318112114979733, 0.057634498351326995, 0.037433088362853452, -0.0042805204990193782, -0.029196217764038187, 0.0027537747912240711, 0.010037693717672269, -0.00036647657366011829, -0.002579441725933078, 6.2865424814776362e-005, 0.00039843567297594335, -1.1210865808890361e-005, -2.5879090265397886e-005},
    {4.4618977991475265e-005, 1.9329016965523917e-005, -0.00060576018246643346, -7.3214213567023991e-005, 0.0045326774719456481, 0.0010131419871842082, -0.019439314263626713, -0.0023650488367403851, 0.069827616361807551, 0.025898587531046669, -0.15999741114652205, -0.058111823317717831, 0.47533576263420663, 0.75997624196109093, 0.39320152196208885, -0.035318112114979733, -0.057634498351326995, 0.037433088362853452, 0.0042805204990193782, -0.029196217764038187, -0.0027537747912240711, 0.010037693717672269, 0.00036647657366011829, -0.002579441725933078, -6.2865424814776362e-005, 0.00039843567297594335, 1.1210865808890361e-005, -2.5879090265397886e-005},
    {-2.5879090265397886e-005, -1.1210865808890361e-005, 0.00039843567297594335, 6.2865424814776362e-005, -0.002579441725933078, -0.00036647657366011829, 0.010037693717672269, 0.0027537747912240711, -0.029196217764038187, -0.0042805204990193782, 0.037433088362853452, 0.057634498351326995, -0.035318112114979733, -0.39320152196208885, 0.75997624196109093, -0.47533576263420663, -0.058111823317717831, 0.15999741114652205, 0.025898587531046669, -0.069827616361807551, -0.0023650488367403851, 0.019439314263626713, 0.0010131419871842082, -0.0045326774719456481, -7.3214213567023991e-005, 0.00060576018246643346, 1.9329016965523917e-005, -4.4618977991475265e-005}
};

static double sym15_double[][30] = {
    {9.7124197379633478e-006, -7.3596667989194696e-006, -0.00016066186637495343, 5.5122547855586653e-005, 0.0010705672194623959, -0.00026731644647180568, -0.0035901654473726417, 0.003423450736351241, 0.010079977087905669, -0.019405011430934468, -0.038876716876833493, 0.021937642719753955, 0.040735479696810677, -0.04108266663538248, 0.11153369514261872, 0.57864041521503451, 0.72184302963618119, 0.2439627054321663, -0.1966263587662373, -0.13405629845625389, 0.068393310060480245, 0.067969829044879179, -0.0087447888864779517, -0.017171252781638731, 0.0015261382781819983, 0.003481028737064895, -0.00010815440168545525, -0.00040216853760293483, 2.1717890150778919e-005, 2.8660708525318081e-005},
    {-2.8660708525318081e-005, 2.1717890150778919e-005, 0.00040216853760293483, -0.00010815440168545525, -0.003481028737064895, 0.0015261382781819983, 0.017171252781638731, -0.0087447888864779517, -0.067969829044879179, 0.068393310060480245, 0.13405629845625389, -0.1966263587662373, -0.2439627054321663, 0.72184302963618119, -0.57864041521503451, 0.11153369514261872, 0.04108266663538248, 0.040735479696810677, -0.021937642719753955, -0.038876716876833493, 0.019405011430934468, 0.010079977087905669, -0.003423450736351241, -0.0035901654473726417, 0.00026731644647180568, 0.0010705672194623959, -5.5122547855586653e-005, -0.00016066186637495343, 7.3596667989194696e-006, 9.7124197379633478e-006},
    {2.8660708525318081e-005, 2.1717890150778919e-005, -0.00040216853760293483, -0.00010815440168545525, 0.003481028737064895, 0.0015261382781819983, -0.017171252781638731, -0.0087447888864779517, 0.067969829044879179, 0.068393310060480245, -0.13405629845625389, -0.1966263587662373, 0.2439627054321663, 0.72184302963618119, 0.57864041521503451, 0.11153369514261872, -0.04108266663538248, 0.040735479696810677, 0.021937642719753955, -0.038876716876833493, -0.019405011430934468, 0.010079977087905669, 0.003423450736351241, -0.0035901654473726417, -0.00026731644647180568, 0.0010705672194623959, 5.5122547855586653e-005, -0.00016066186637495343, -7.3596667989194696e-006, 9.7124197379633478e-006},
    {9.7124197379633478e-006, 7.3596667989194696e-006, -0.00016066186637495343, -5.5122547855586653e-005, 0.0010705672194623959, 0.00026731644647180568, -0.0035901654473726417, -0.003423450736351241, 0.010079977087905669, 0.019405011430934468, -0.038876716876833493, -0.021937642719753955, 0.040735479696810677, 0.04108266663538248, 0.11153369514261872, -0.57864041521503451, 0.72184302963618119, -0.2439627054321663, -0.1966263587662373, 0.13405629845625389, 0.068393310060480245, -0.067969829044879179, -0.0087447888864779517, 0.017171252781638731, 0.0015261382781819983, -0.003481028737064895, -0.00010815440168545525, 0.00040216853760293483, 2.1717890150778919e-005, -2.8660708525318081e-005}
};

static double sym16_double[][32] = {
    {6.2300067012207606e-006, -3.1135564076219692e-006, -0.00010943147929529757, 2.8078582128442894e-005, 0.00085235471080470952, -0.0001084456223089688, -0.0038809122526038786, 0.00071821197883178923, 0.012666731659857348, -0.0031265171722710075, -0.031051202843553064, 0.0048692744049046071, 0.032333091610663785, -0.066983049070217779, -0.034574228416972504, 0.39712293362064416, 0.75652498787569711, 0.47534280601152273, -0.054040601387606135, -0.15959219218520598, 0.03072113906330156, 0.078037852903419913, -0.0035102750683740089, -0.024952758046290123, 0.001359844742484172, 0.0069377611308027096, -0.00022211647621176323, -0.0013387206066921965, 3.656592483348223e-005, 0.00016545679579108483, -5.3964831793152419e-006, -1.0797982104319795e-005},
    {1.0797982104319795e-005, -5.3964831793152419e-006, -0.00016545679579108483, 3.656592483348223e-005, 0.0013387206066921965, -0.00022211647621176323, -0.0069377611308027096, 0.001359844742484172, 0.024952758046290123, -0.0035102750683740089, -0.078037852903419913, 0.03072113906330156, 0.15959219218520598, -0.054040601387606135, -0.47534280601152273, 0.75652498787569711, -0.39712293362064416, -0.034574228416972504, 0.066983049070217779, 0.032333091610663785, -0.0048692744049046071, -0.031051202843553064, 0.0031265171722710075, 0.012666731659857348, -0.00071821197883178923, -0.0038809122526038786, 0.0001084456223089688, 0.00085235471080470952, -2.8078582128442894e-005, -0.00010943147929529757, 3.1135564076219692e-006, 6.2300067012207606e-006},
    {-1.0797982104319795e-005, -5.3964831793152419e-006, 0.00016545679579108483, 3.656592483348223e-005, -0.0013387206066921965, -0.00022211647621176323, 0.0069377611308027096, 0.001359844742484172, -0.024952758046290123, -0.0035102750683740089, 0.078037852903419913, 0.03072113906330156, -0.15959219218520598, -0.054040601387606135, 0.47534280601152273, 0.75652498787569711, 0.39712293362064416, -0.034574228416972504, -0.066983049070217779, 0.032333091610663785, 0.0048692744049046071, -0.031051202843553064, -0.0031265171722710075, 0.012666731659857348, 0.00071821197883178923, -0.0038809122526038786, -0.0001084456223089688, 0.00085235471080470952, 2.8078582128442894e-005, -0.00010943147929529757, -3.1135564076219692e-006, 6.2300067012207606e-006},
    {6.2300067012207606e-006, 3.1135564076219692e-006, -0.00010943147929529757, -2.8078582128442894e-005, 0.00085235471080470952, 0.0001084456223089688, -0.0038809122526038786, -0.00071821197883178923, 0.012666731659857348, 0.0031265171722710075, -0.031051202843553064, -0.0048692744049046071, 0.032333091610663785, 0.066983049070217779, -0.034574228416972504, -0.39712293362064416, 0.75652498787569711, -0.47534280601152273, -0.054040601387606135, 0.15959219218520598, 0.03072113906330156, -0.078037852903419913, -0.0035102750683740089, 0.024952758046290123, 0.001359844742484172, -0.0069377611308027096, -0.00022211647621176323, 0.0013387206066921965, 3.656592483348223e-005, -0.00016545679579108483, -5.3964831793152419e-006, 1.0797982104319795e-005}
};

static double sym17_double[][34] = {
    {4.297343327345983e-006, 2.7801266938414138e-006, -6.2937025975541919e-005, -1.3506383399901165e-005, 0.0004759963802638669, -0.00013864230268045499, -0.0027416759756816018, 0.0008567700701915741, 0.010482366933031529, -0.0048192128031761478, -0.033291383492359328, 0.017903952214341119, 0.10475461484223211, 0.0172711782105185, -0.11856693261143636, 0.14239835041467819, 0.65071662920454565, 0.68148899534492502, 0.18053958458111286, -0.15507600534974825, -0.086070874720733381, 0.016158808725919346, -0.0072616347509287674, -0.01803889724191924, 0.0099529825235095976, 0.012396988366648726, -0.0019054076898526659, -0.0039323252797979023, 5.8400428694052584e-005, 0.0007198270642148971, 2.5207933140828779e-005, -7.6071244056051285e-005, -2.4527163425832999e-006, 3.7912531943321266e-006},
    {-3.7912531943321266e-006, -2.4527163425832999e-006, 7.6071244056051285e-005, 2.5207933140828779e-005, -0.0007198270642148971, 5.8400428694052584e-005, 0.0039323252797979023, -0.0019054076898526659, -0.012396988366648726, 0.0099529825235095976, 0.01803889724191924, -0.0072616347509287674, -0.016158808725919346, -0.086070874720733381, 0.15507600534974825, 0.18053958458111286, -0.68148899534492502, 0.65071662920454565, -0.14239835041467819, -0.11856693261143636, -0.0172711782105185, 0.10475461484223211, -0.017903952214341119, -0.033291383492359328, 0.0048192128031761478, 0.010482366933031529, -0.0008567700701915741, -0.0027416759756816018, 0.00013864230268045499, 0.0004759963802638669, 1.3506383399901165e-005, -6.2937025975541919e-005, -2.7801266938414138e-006, 4.297343327345983e-006},
    {3.7912531943321266e-006, -2.4527163425832999e-006, -7.6071244056051285e-005, 2.5207933140828779e-005, 0.0007198270642148971, 5.8400428694052584e-005, -0.0039323252797979023, -0.0019054076898526659, 0.012396988366648726, 0.0099529825235095976, -0.01803889724191924, -0.0072616347509287674, 0.016158808725919346, -0.086070874720733381, -0.15507600534974825, 0.18053958458111286, 0.68148899534492502, 0.65071662920454565, 0.14239835041467819, -0.11856693261143636, 0.0172711782105185, 0.10475461484223211, 0.017903952214341119, -0.033291383492359328, -0.0048192128031761478, 0.010482366933031529, 0.0008567700701915741, -0.0027416759756816018, -0.00013864230268045499, 0.0004759963802638669, -1.3506383399901165e-005, -6.2937025975541919e-005, 2.7801266938414138e-006, 4.297343327345983e-006},
    {4.297343327345983e-006, -2.7801266938414138e-006, -6.2937025975541919e-005, 1.3506383399901165e-005, 0.0004759963802638669, 0.00013864230268045499, -0.0027416759756816018, -0.0008567700701915741, 0.010482366933031529, 0.0048192128031761478, -0.033291383492359328, -0.017903952214341119, 0.10475461484223211, -0.0172711782105185, -0.11856693261143636, -0.14239835041467819, 0.65071662920454565, -0.68148899534492502, 0.18053958458111286, 0.15507600534974825, -0.086070874720733381, -0.016158808725919346, -0.0072616347509287674, 0.01803889724191924, 0.0099529825235095976, -0.012396988366648726, -0.0019054076898526659, 0.0039323252797979023, 5.8400428694052584e-005, -0.0007198270642148971, 2.5207933140828779e-005, 7.6071244056051285e-005, -2.4527163425832999e-006, -3.7912531943321266e-006}
};

static double sym18_double[][36] = {
    {2.6126125564836423e-006, 1.354915761832114e-006, -4.5246757874949856e-005, -1.4020992577726755e-005, 0.00039616840638254753, 7.0212734590362685e-005, -0.0023138718145060992, -0.00041152110923597756, 0.0095021643909623654, 0.0016429863972782159, -0.030325091089369604, -0.0050770851607570529, 0.084219929970386548, 0.033995667103947358, -0.15993814866932407, -0.052029158983952786, 0.47396905989393956, 0.75362914010179283, 0.40148386057061813, -0.032480573290138676, -0.073799207290607169, 0.028529597039037808, 0.0062779445543116943, -0.031712684731814537, -0.0032607442000749834, 0.015012356344250213, 0.0010877847895956929, -0.0052397896830266083, -0.00018877623940755607, 0.0014280863270832796, 4.7416145183736671e-005, -0.00026583011024241041, -9.858816030140058e-006, 2.9557437620930811e-005, 7.8472980558317646e-007, -1.5131530692371587e-006},
    {1.5131530692371587e-006, 7.8472980558317646e-007, -2.9557437620930811e-005, -9.858816030140058e-006, 0.00026583011024241041, 4.7416145183736671e-005, -0.0014280863270832796, -0.00018877623940755607, 0.0052397896830266083, 0.0010877847895956929, -0.015012356344250213, -0.0032607442000749834, 0.031712684731814537, 0.0062779445543116943, -0.028529597039037808, -0.073799207290607169, 0.032480573290138676, 0.40148386057061813, -0.75362914010179283, 0.47396905989393956, 0.052029158983952786, -0.15993814866932407, -0.033995667103947358, 0.084219929970386548, 0.0050770851607570529, -0.030325091089369604, -0.0016429863972782159, 0.0095021643909623654, 0.00041152110923597756, -0.0023138718145060992, -7.0212734590362685e-005, 0.00039616840638254753, 1.4020992577726755e-005, -4.5246757874949856e-005, -1.354915761832114e-006, 2.6126125564836423e-006},
    {-1.5131530692371587e-006, 7.8472980558317646e-007, 2.9557437620930811e-005, -9.858816030140058e-006, -0.00026583011024241041, 4.7416145183736671e-005, 0.0014280863270832796, -0.00018877623940755607, -0.0052397896830266083, 0.0010877847895956929, 0.015012356344250213, -0.0032607442000749834, -0.031712684731814537, 0.0062779445543116943, 0.028529597039037808, -0.073799207290607169, -0.032480573290138676, 0.40148386057061813, 0.75362914010179283, 0.47396905989393956, -0.052029158983952786, -0.15993814866932407, 0.033995667103947358, 0.084219929970386548, -0.0050770851607570529, -0.030325091089369604, 0.0016429863972782159, 0.0095021643909623654, -0.00041152110923597756, -0.0023138718145060992, 7.0212734590362685e-005, 0.00039616840638254753, -1.4020992577726755e-005, -4.5246757874949856e-005, 1.354915761832114e-006, 2.6126125564836423e-006},
    {2.6126125564836423e-006, -1.354915761832114e-006, -4.5246757874949856e-005, 1.4020992577726755e-005, 0.00039616840638254753, -7.0212734590362685e-005, -0.0023138718145060992, 0.00041152110923597756, 0.0095021643909623654, -0.0016429863972782159, -0.030325091089369604, 0.0050770851607570529, 0.084219929970386548, -0.033995667103947358, -0.15993814866932407, 0.052029158983952786, 0.47396905989393956, -0.75362914010179283, 0.40148386057061813, 0.032480573290138676, -0.073799207290607169, -0.028529597039037808, 0.0062779445543116943, 0.031712684731814537, -0.0032607442000749834, -0.015012356344250213, 0.0010877847895956929, 0.0052397896830266083, -0.00018877623940755607, -0.0014280863270832796, 4.7416145183736671e-005, 0.00026583011024241041, -9.858816030140058e-006, -2.9557437620930811e-005, 7.8472980558317646e-007, 1.5131530692371587e-006}
};

static double sym19_double[][38] = {
    {5.4877327682158382e-007, -6.4636513033459633e-007, -1.1880518269823984e-005, 8.8733121737292863e-006, 0.0001155392333357879, -4.6120396002105868e-005, -0.00063576451500433403, 0.00015915804768084938, 0.0021214250281823303, -0.0011607032572062486, -0.005122205002583014, 0.0079684383206133063, 0.015797439295674631, -0.022651993378245951, -0.046635983534938946, 0.0070155738571741596, 0.0089545911730436242, -0.067525058040294086, 0.10902582508127781, 0.57814494533860505, 0.71955552571639425, 0.25826616923728363, -0.17659686625203097, -0.11624173010739675, 0.093630843415897141, 0.084072676279245043, -0.016908234861345205, -0.027709896931311252, 0.0043193518748949689, 0.0082622369555282547, -0.00061792232779831076, -0.0017049602611649971, 0.00012930767650701415, 0.00027621877685734072, -1.6821387029373716e-005, -2.8151138661550245e-005, 2.0623170632395688e-006, 1.7509367995348687e-006},
    {-1.7509367995348687e-006, 2.0623170632395688e-006, 2.8151138661550245e-005, -1.6821387029373716e-005, -0.00027621877685734072, 0.00012930767650701415, 0.0017049602611649971, -0.00061792232779831076, -0.0082622369555282547, 0.0043193518748949689, 0.027709896931311252, -0.016908234861345205, -0.084072676279245043, 0.093630843415897141, 0.11624173010739675, -0.17659686625203097, -0.25826616923728363, 0.71955552571639425, -0.57814494533860505, 0.10902582508127781, 0.067525058040294086, 0.0089545911730436242, -0.0070155738571741596, -0.046635983534938946, 0.022651993378245951, 0.015797439295674631, -0.0079684383206133063, -0.005122205002583014, 0.0011607032572062486, 0.0021214250281823303, -0.00015915804768084938, -0.00063576451500433403, 4.6120396002105868e-005, 0.0001155392333357879, -8.8733121737292863e-006, -1.1880518269823984e-005, 6.4636513033459633e-007, 5.4877327682158382e-007},
    {1.7509367995348687e-006, 2.0623170632395688e-006, -2.8151138661550245e-005, -1.6821387029373716e-005, 0.00027621877685734072, 0.00012930767650701415, -0.0017049602611649971, -0.00061792232779831076, 0.0082622369555282547, 0.0043193518748949689, -0.027709896931311252, -0.016908234861345205, 0.084072676279245043, 0.093630843415897141, -0.11624173010739675, -0.17659686625203097, 0.25826616923728363, 0.71955552571639425, 0.57814494533860505, 0.10902582508127781, -0.067525058040294086, 0.0089545911730436242, 0.0070155738571741596, -0.046635983534938946, -0.022651993378245951, 0.015797439295674631, 0.0079684383206133063, -0.005122205002583014, -0.0011607032572062486, 0.0021214250281823303, 0.00015915804768084938, -0.00063576451500433403, -4.6120396002105868e-005, 0.0001155392333357879, 8.8733121737292863e-006, -1.1880518269823984e-005, -6.4636513033459633e-007, 5.4877327682158382e-007},
    {5.4877327682158382e-007, 6.4636513033459633e-007, -1.1880518269823984e-005, -8.8733121737292863e-006, 0.0001155392333357879, 4.6120396002105868e-005, -0.00063576451500433403, -0.00015915804768084938, 0.0021214250281823303, 0.0011607032572062486, -0.005122205002583014, -0.0079684383206133063, 0.015797439295674631, 0.022651993378245951, -0.046635983534938946, -0.0070155738571741596, 0.0089545911730436242, 0.067525058040294086, 0.10902582508127781, -0.57814494533860505, 0.71955552571639425, -0.25826616923728363, -0.17659686625203097, 0.11624173010739675, 0.093630843415897141, -0.084072676279245043, -0.016908234861345205, 0.027709896931311252, 0.0043193518748949689, -0.0082622369555282547, -0.00061792232779831076, 0.0017049602611649971, 0.00012930767650701415, -0.00027621877685734072, -1.6821387029373716e-005, 2.8151138661550245e-005, 2.0623170632395688e-006, -1.7509367995348687e-006}
};

static double sym20_double[][40] = {
    {3.695537474835221e-007, -1.9015675890554106e-007, -7.919361411976999e-006, 3.0256660627369661e-006, 7.992967835772481e-005, -1.928412300645204e-005, -0.00049473109156726548, 7.2159911880740349e-005, 0.0020889947081901982, -0.0003052628317957281, -0.0066065857990888609, 0.0014230873594621453, 0.017004049023390339, -0.0033138573836233591, -0.031629437144957966, 0.0081232283560096815, 0.025579349509413946, -0.078994344928398158, -0.029819368880333728, 0.40583144434845059, 0.75116272842273002, 0.47199147510148703, -0.051088342921067398, -0.16057829841525254, 0.036250951653933078, 0.088919668028199561, -0.0068437019650692274, -0.035373336756604236, 0.0019385970672402002, 0.012157040948785737, -0.0006111263857992088, -0.0034716478028440734, 0.00012544091723067259, 0.00074761085978205719, -2.6615550335516086e-005, -0.00011739133516291466, 4.5254222091516362e-006, 1.22872527779612e-005, -3.2567026420174407e-007, -6.3291290447763946e-007},
    {6.3291290447763946e-007, -3.2567026420174407e-007, -1.22872527779612e-005, 4.5254222091516362e-006, 0.00011739133516291466, -2.6615550335516086e-005, -0.00074761085978205719, 0.00012544091723067259, 0.0034716478028440734, -0.0006111263857992088, -0.012157040948785737, 0.0019385970672402002, 0.035373336756604236, -0.0068437019650692274, -0.088919668028199561, 0.036250951653933078, 0.16057829841525254, -0.051088342921067398, -0.47199147510148703, 0.75116272842273002, -0.40583144434845059, -0.029819368880333728, 0.078994344928398158, 0.025579349509413946, -0.0081232283560096815, -0.031629437144957966, 0.0033138573836233591, 0.017004049023390339, -0.0014230873594621453, -0.0066065857990888609, 0.0003052628317957281, 0.0020889947081901982, -7.2159911880740349e-005, -0.00049473109156726548, 1.928412300645204e-005, 7.992967835772481e-005, -3.0256660627369661e-006, -7.919361411976999e-006, 1.9015675890554106e-007, 3.695537474835221e-007},
    {-6.3291290447763946e-007, -3.2567026420174407e-007, 1.22872527779612e-005, 4.5254222091516362e-006, -0.00011739133516291466, -2.6615550335516086e-005, 0.00074761085978205719, 0.00012544091723067259, -0.0034716478028440734, -0.0006111263857992088, 0.012157040948785737, 0.0019385970672402002, -0.035373336756604236, -0.0068437019650692274, 0.088919668028199561, 0.036250951653933078, -0.16057829841525254, -0.051088342921067398, 0.47199147510148703, 0.75116272842273002, 0.40583144434845059, -0.029819368880333728, -0.078994344928398158, 0.025579349509413946, 0.0081232283560096815, -0.031629437144957966, -0.0033138573836233591, 0.017004049023390339, 0.0014230873594621453, -0.0066065857990888609, -0.0003052628317957281, 0.0020889947081901982, 7.2159911880740349e-005, -0.00049473109156726548, -1.928412300645204e-005, 7.992967835772481e-005, 3.0256660627369661e-006, -7.919361411976999e-006, -1.9015675890554106e-007, 3.695537474835221e-007},
    {3.695537474835221e-007, 1.9015675890554106e-007, -7.919361411976999e-006, -3.0256660627369661e-006, 7.992967835772481e-005, 1.928412300645204e-005, -0.00049473109156726548, -7.2159911880740349e-005, 0.0020889947081901982, 0.0003052628317957281, -0.0066065857990888609, -0.0014230873594621453, 0.017004049023390339, 0.0033138573836233591, -0.031629437144957966, -0.0081232283560096815, 0.025579349509413946, 0.078994344928398158, -0.029819368880333728, -0.40583144434845059, 0.75116272842273002, -0.47199147510148703, -0.051088342921067398, 0.16057829841525254, 0.036250951653933078, -0.088919668028199561, -0.0068437019650692274, 0.035373336756604236, 0.0019385970672402002, -0.012157040948785737, -0.0006111263857992088, 0.0034716478028440734, 0.00012544091723067259, -0.00074761085978205719, -2.6615550335516086e-005, 0.00011739133516291466, 4.5254222091516362e-006, -1.22872527779612e-005, -3.2567026420174407e-007, 6.3291290447763946e-007}
};

static double coif1_double[][6] = {
    {-0.01565572813546454, -0.072732619512853897, 0.38486484686420286, 0.85257202021225542, 0.33789766245780922, -0.072732619512853897},
    {0.072732619512853897, 0.33789766245780922, -0.85257202021225542, 0.38486484686420286, 0.072732619512853897, -0.01565572813546454},
    {-0.072732619512853897, 0.33789766245780922, 0.85257202021225542, 0.38486484686420286, -0.072732619512853897, -0.01565572813546454},
    {-0.01565572813546454, 0.072732619512853897, 0.38486484686420286, -0.85257202021225542, 0.33789766245780922, 0.072732619512853897}
};

static double coif2_double[][12] = {
    {-0.00072054944536451221, -0.0018232088707029932, 0.0056114348193944995, 0.023680171946334084, -0.059434418646456898, -0.076488599078306393, 0.41700518442169254, 0.81272363544554227, 0.38611006682116222, -0.067372554721963018, -0.041464936781759151, 0.016387336463522112},
    {-0.016387336463522112, -0.041464936781759151, 0.067372554721963018, 0.38611006682116222, -0.81272363544554227, 0.41700518442169254, 0.076488599078306393, -0.059434418646456898, -0.023680171946334084, 0.0056114348193944995, 0.0018232088707029932, -0.00072054944536451221},
    {0.016387336463522112, -0.041464936781759151, -0.067372554721963018, 0.38611006682116222, 0.81272363544554227, 0.41700518442169254, -0.076488599078306393, -0.059434418646456898, 0.023680171946334084, 0.0056114348193944995, -0.0018232088707029932, -0.00072054944536451221},
    {-0.00072054944536451221, 0.0018232088707029932, 0.0056114348193944995, -0.023680171946334084, -0.059434418646456898, 0.076488599078306393, 0.41700518442169254, -0.81272363544554227, 0.38611006682116222, 0.067372554721963018, -0.041464936781759151, -0.016387336463522112}
};

static double coif3_double[][18] = {
    {-3.4599772836212559e-005, -7.0983303138141252e-005, 0.00046621696011288631, 0.0011175187708906016, -0.0025745176887502236, -0.0090079761366615805, 0.015880544863615904, 0.034555027573061628, -0.082301927106885983, -0.071799821619312018, 0.42848347637761874, 0.79377722262562056, 0.4051769024096169, -0.061123390002672869, -0.0657719112818555, 0.023452696141836267, 0.0077825964273254182, -0.0037935128644910141},
    {0.0037935128644910141, 0.0077825964273254182, -0.023452696141836267, -0.0657719112818555, 0.061123390002672869, 0.4051769024096169, -0.79377722262562056, 0.42848347637761874, 0.071799821619312018, -0.082301927106885983, -0.034555027573061628, 0.015880544863615904, 0.0090079761366615805, -0.0025745176887502236, -0.0011175187708906016, 0.00046621696011288631, 7.0983303138141252e-005, -3.4599772836212559e-005},
    {-0.0037935128644910141, 0.0077825964273254182, 0.023452696141836267, -0.0657719112818555, -0.061123390002672869, 0.4051769024096169, 0.79377722262562056, 0.42848347637761874, -0.071799821619312018, -0.082301927106885983, 0.034555027573061628, 0.015880544863615904, -0.0090079761366615805, -0.0025745176887502236, 0.0011175187708906016, 0.00046621696011288631, -7.0983303138141252e-005, -3.4599772836212559e-005},
    {-3.4599772836212559e-005, 7.0983303138141252e-005, 0.00046621696011288631, -0.0011175187708906016, -0.0025745176887502236, 0.0090079761366615805, 0.015880544863615904, -0.034555027573061628, -0.082301927106885983, 0.071799821619312018, 0.42848347637761874, -0.79377722262562056, 0.4051769024096169, 0.061123390002672869, -0.0657719112818555, -0.023452696141836267, 0.0077825964273254182, 0.0037935128644910141}
};

static double coif4_double[][24] = {
    {-1.7849850030882614e-006, -3.2596802368833675e-006, 3.1229875865345646e-005, 6.2339034461007128e-005, -0.00025997455248771324, -0.00058902075624433831, 0.0012665619292989445, 0.0037514361572784571, -0.0056582866866107199, -0.015211731527946259, 0.025082261844864097, 0.039334427123337491, -0.096220442033987982, -0.066627474263425038, 0.4343860564914685, 0.78223893092049901, 0.41530840703043026, -0.056077313316754807, -0.081266699680878754, 0.026682300156053072, 0.016068943964776348, -0.0073461663276420935, -0.0016294920126017326, 0.00089231366858231456},
    {-0.00089231366858231456, -0.0016294920126017326, 0.0073461663276420935, 0.016068943964776348, -0.026682300156053072, -0.081266699680878754, 0.056077313316754807, 0.41530840703043026, -0.78223893092049901, 0.4343860564914685, 0.066627474263425038, -0.096220442033987982, -0.039334427123337491, 0.025082261844864097, 0.015211731527946259, -0.0056582866866107199, -0.0037514361572784571, 0.0012665619292989445, 0.00058902075624433831, -0.00025997455248771324, -6.2339034461007128e-005, 3.1229875865345646e-005, 3.2596802368833675e-006, -1.7849850030882614e-006},
    {0.00089231366858231456, -0.0016294920126017326, -0.0073461663276420935, 0.016068943964776348, 0.026682300156053072, -0.081266699680878754, -0.056077313316754807, 0.41530840703043026, 0.78223893092049901, 0.4343860564914685, -0.066627474263425038, -0.096220442033987982, 0.039334427123337491, 0.025082261844864097, -0.015211731527946259, -0.0056582866866107199, 0.0037514361572784571, 0.0012665619292989445, -0.00058902075624433831, -0.00025997455248771324, 6.2339034461007128e-005, 3.1229875865345646e-005, -3.2596802368833675e-006, -1.7849850030882614e-006},
    {-1.7849850030882614e-006, 3.2596802368833675e-006, 3.1229875865345646e-005, -6.2339034461007128e-005, -0.00025997455248771324, 0.00058902075624433831, 0.0012665619292989445, -0.0037514361572784571, -0.0056582866866107199, 0.015211731527946259, 0.025082261844864097, -0.039334427123337491, -0.096220442033987982, 0.066627474263425038, 0.4343860564914685, -0.78223893092049901, 0.41530840703043026, 0.056077313316754807, -0.081266699680878754, -0.026682300156053072, 0.016068943964776348, 0.0073461663276420935, -0.0016294920126017326, -0.00089231366858231456}
};

static double coif5_double[][30] = {
    {-9.517657273819165e-008, -1.6744288576823017e-007, 2.0637618513646814e-006, 3.7346551751414047e-006, -2.1315026809955787e-005, -4.1340432272512511e-005, 0.00014054114970203437, 0.00030225958181306315, -0.00063813134304511142, -0.0016628637020130838, 0.0024333732126576722, 0.0067641854480530832, -0.0091642311624818458, -0.019761778942572639, 0.032683574267111833, 0.041289208750181702, -0.10557420870333893, -0.062035963962903569, 0.43799162617183712, 0.77428960365295618, 0.42156620669085149, -0.052043163176243773, -0.091920010559696244, 0.02816802897093635, 0.023408156785839195, -0.010131117519849788, -0.004159358781386048, 0.0021782363581090178, 0.00035858968789573785, -0.00021208083980379827},
    {0.00021208083980379827, 0.00035858968789573785, -0.0021782363581090178, -0.004159358781386048, 0.010131117519849788, 0.023408156785839195, -0.02816802897093635, -0.091920010559696244, 0.052043163176243773, 0.42156620669085149, -0.77428960365295618, 0.43799162617183712, 0.062035963962903569, -0.10557420870333893, -0.041289208750181702, 0.032683574267111833, 0.019761778942572639, -0.0091642311624818458, -0.0067641854480530832, 0.0024333732126576722, 0.0016628637020130838, -0.00063813134304511142, -0.00030225958181306315, 0.00014054114970203437, 4.1340432272512511e-005, -2.1315026809955787e-005, -3.7346551751414047e-006, 2.0637618513646814e-006, 1.6744288576823017e-007, -9.517657273819165e-008},
    {-0.00021208083980379827, 0.00035858968789573785, 0.0021782363581090178, -0.004159358781386048, -0.010131117519849788, 0.023408156785839195, 0.02816802897093635, -0.091920010559696244, -0.052043163176243773, 0.42156620669085149, 0.77428960365295618, 0.43799162617183712, -0.062035963962903569, -0.10557420870333893, 0.041289208750181702, 0.032683574267111833, -0.019761778942572639, -0.0091642311624818458, 0.0067641854480530832, 0.0024333732126576722, -0.0016628637020130838, -0.00063813134304511142, 0.00030225958181306315, 0.00014054114970203437, -4.1340432272512511e-005, -2.1315026809955787e-005, 3.7346551751414047e-006, 2.0637618513646814e-006, -1.6744288576823017e-007, -9.517657273819165e-008},
    {-9.517657273819165e-008, 1.6744288576823017e-007, 2.0637618513646814e-006, -3.7346551751414047e-006, -2.1315026809955787e-005, 4.1340432272512511e-005, 0.00014054114970203437, -0.00030225958181306315, -0.00063813134304511142, 0.0016628637020130838, 0.0024333732126576722, -0.0067641854480530832, -0.0091642311624818458, 0.019761778942572639, 0.032683574267111833, -0.041289208750181702, -0.10557420870333893, 0.062035963962903569, 0.43799162617183712, -0.77428960365295618, 0.42156620669085149, 0.052043163176243773, -0.091920010559696244, -0.02816802897093635, 0.023408156785839195, 0.010131117519849788, -0.004159358781386048, -0.0021782363581090178, 0.00035858968789573785, 0.00021208083980379827}
};

static double bior1_1_double[][2] = {
    {0.70710678118654757, 0.70710678118654757},
    {-0.70710678118654757, 0.70710678118654757},
    {0.70710678118654757, 0.70710678118654757},
    {0.70710678118654757, -0.70710678118654757}
};

static double bior1_3_double[][6] = {
    {-0.088388347648318447, 0.088388347648318447, 0.70710678118654757, 0.70710678118654757, 0.088388347648318447, -0.088388347648318447},
    {0.0, 0.0, -0.70710678118654757, 0.70710678118654757, 0.0, 0.0},
    {0.0, 0.0, 0.70710678118654757, 0.70710678118654757, 0.0, 0.0},
    {-0.088388347648318447, -0.088388347648318447, 0.70710678118654757, -0.70710678118654757, 0.088388347648318447, 0.088388347648318447}
};

static double bior1_5_double[][10] = {
    {0.01657281518405971, -0.01657281518405971, -0.12153397801643787, 0.12153397801643787, 0.70710678118654757, 0.70710678118654757, 0.12153397801643787, -0.12153397801643787, -0.01657281518405971, 0.01657281518405971},
    {0.0, 0.0, 0.0, 0.0, -0.70710678118654757, 0.70710678118654757, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.70710678118654757, 0.70710678118654757, 0.0, 0.0, 0.0, 0.0},
    {0.01657281518405971, 0.01657281518405971, -0.12153397801643787, -0.12153397801643787, 0.70710678118654757, -0.70710678118654757, 0.12153397801643787, 0.12153397801643787, -0.01657281518405971, -0.01657281518405971}
};

static double bior2_2_double[][6] = {
    {0.0, -0.17677669529663689, 0.35355339059327379, 1.0606601717798214, 0.35355339059327379, -0.17677669529663689},
    {0.0, 0.35355339059327379, -0.70710678118654757, 0.35355339059327379, 0.0, 0.0},
    {0.0, 0.35355339059327379, 0.70710678118654757, 0.35355339059327379, 0.0, 0.0},
    {0.0, 0.17677669529663689, 0.35355339059327379, -1.0606601717798214, 0.35355339059327379, 0.17677669529663689}
};

static double bior2_4_double[][10] = {
    {0.0, 0.033145630368119419, -0.066291260736238838, -0.17677669529663689, 0.4198446513295126, 0.99436891104358249, 0.4198446513295126, -0.17677669529663689, -0.066291260736238838, 0.033145630368119419},
    {0.0, 0.0, 0.0, 0.35355339059327379, -0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.35355339059327379, 0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0},
    {0.0, -0.033145630368119419, -0.066291260736238838, 0.17677669529663689, 0.4198446513295126, -0.99436891104358249, 0.4198446513295126, 0.17677669529663689, -0.066291260736238838, -0.033145630368119419}
};

static double bior2_6_double[][14] = {
    {0.0, -0.0069053396600248784, 0.013810679320049757, 0.046956309688169176, -0.10772329869638811, -0.16987135563661201, 0.44746600996961211, 0.96674755240348298, 0.44746600996961211, -0.16987135563661201, -0.10772329869638811, 0.046956309688169176, 0.013810679320049757, -0.0069053396600248784},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.35355339059327379, -0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.35355339059327379, 0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0069053396600248784, 0.013810679320049757, -0.046956309688169176, -0.10772329869638811, 0.16987135563661201, 0.44746600996961211, -0.96674755240348298, 0.44746600996961211, 0.16987135563661201, -0.10772329869638811, -0.046956309688169176, 0.013810679320049757, 0.0069053396600248784}
};

static double bior2_8_double[][18] = {
    {0.0, 0.0015105430506304422, -0.0030210861012608843, -0.012947511862546647, 0.028916109826354178, 0.052998481890690945, -0.13491307360773608, -0.16382918343409025, 0.46257144047591658, 0.95164212189717856, 0.46257144047591658, -0.16382918343409025, -0.13491307360773608, 0.052998481890690945, 0.028916109826354178, -0.012947511862546647, -0.0030210861012608843, 0.0015105430506304422},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.35355339059327379, -0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.35355339059327379, 0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, -0.0015105430506304422, -0.0030210861012608843, 0.012947511862546647, 0.028916109826354178, -0.052998481890690945, -0.13491307360773608, 0.16382918343409025, 0.46257144047591658, -0.95164212189717856, 0.46257144047591658, 0.16382918343409025, -0.13491307360773608, -0.052998481890690945, 0.028916109826354178, 0.012947511862546647, -0.0030210861012608843, -0.0015105430506304422}
};

static double bior3_1_double[][4] = {
    {-0.35355339059327379, 1.0606601717798214, 1.0606601717798214, -0.35355339059327379},
    {-0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689},
    {0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689},
    {-0.35355339059327379, -1.0606601717798214, 1.0606601717798214, 0.35355339059327379}
};

static double bior3_3_double[][8] = {
    {0.066291260736238838, -0.19887378220871652, -0.15467960838455727, 0.99436891104358249, 0.99436891104358249, -0.15467960838455727, -0.19887378220871652, 0.066291260736238838},
    {0.0, 0.0, -0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689, 0.0, 0.0},
    {0.0, 0.0, 0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689, 0.0, 0.0},
    {0.066291260736238838, 0.19887378220871652, -0.15467960838455727, -0.99436891104358249, 0.99436891104358249, 0.15467960838455727, -0.19887378220871652, -0.066291260736238838}
};

static double bior3_5_double[][12] = {
    {-0.013810679320049757, 0.041432037960149271, 0.052480581416189075, -0.26792717880896527, -0.071815532464258744, 0.96674755240348298, 0.96674755240348298, -0.071815532464258744, -0.26792717880896527, 0.052480581416189075, 0.041432037960149271, -0.013810679320049757},
    {0.0, 0.0, 0.0, 0.0, -0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0},
    {-0.013810679320049757, -0.041432037960149271, 0.052480581416189075, 0.26792717880896527, -0.071815532464258744, -0.96674755240348298, 0.96674755240348298, 0.071815532464258744, -0.26792717880896527, -0.052480581416189075, 0.041432037960149271, 0.013810679320049757}
};

static double bior3_7_double[][16] = {
    {0.0030210861012608843, -0.0090632583037826529, -0.016831765421310641, 0.074663985074019001, 0.031332978707362888, -0.301159125922835, -0.026499240945345472, 0.95164212189717856, 0.95164212189717856, -0.026499240945345472, -0.301159125922835, 0.031332978707362888, 0.074663985074019001, -0.016831765421310641, -0.0090632583037826529, 0.0030210861012608843},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0030210861012608843, 0.0090632583037826529, -0.016831765421310641, -0.074663985074019001, 0.031332978707362888, 0.301159125922835, -0.026499240945345472, -0.95164212189717856, 0.95164212189717856, 0.026499240945345472, -0.301159125922835, -0.031332978707362888, 0.074663985074019001, 0.016831765421310641, -0.0090632583037826529, -0.0030210861012608843}
};

static double bior3_9_double[][20] = {
    {-0.00067974437278369901, 0.0020392331183510968, 0.0050603192196119811, -0.020618912641105536, -0.014112787930175846, 0.09913478249423216, 0.012300136269419315, -0.32019196836077857, 0.0020500227115698858, 0.94212570067820678, 0.94212570067820678, 0.0020500227115698858, -0.32019196836077857, 0.012300136269419315, 0.09913478249423216, -0.014112787930175846, -0.020618912641105536, 0.0050603192196119811, 0.0020392331183510968, -0.00067974437278369901},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-0.00067974437278369901, -0.0020392331183510968, 0.0050603192196119811, 0.020618912641105536, -0.014112787930175846, -0.09913478249423216, 0.012300136269419315, 0.32019196836077857, 0.0020500227115698858, -0.94212570067820678, 0.94212570067820678, -0.0020500227115698858, -0.32019196836077857, -0.012300136269419315, 0.09913478249423216, 0.014112787930175846, -0.020618912641105536, -0.0050603192196119811, 0.0020392331183510968, 0.00067974437278369901}
};

static double bior4_4_double[][10] = {
    {0.0, 0.03782845550726404, -0.023849465019556843, -0.11062440441843718, 0.37740285561283066, 0.85269867900889385, 0.37740285561283066, -0.11062440441843718, -0.023849465019556843, 0.03782845550726404},
    {0.0, -0.064538882628697058, 0.040689417609164058, 0.41809227322161724, -0.7884856164055829, 0.41809227322161724, 0.040689417609164058, -0.064538882628697058, 0.0, 0.0},
    {0.0, -0.064538882628697058, -0.040689417609164058, 0.41809227322161724, 0.7884856164055829, 0.41809227322161724, -0.040689417609164058, -0.064538882628697058, 0.0, 0.0},
    {0.0, -0.03782845550726404, -0.023849465019556843, 0.11062440441843718, 0.37740285561283066, -0.85269867900889385, 0.37740285561283066, 0.11062440441843718, -0.023849465019556843, -0.03782845550726404}
};

static double bior5_5_double[][12] = {
    {0.0, 0.0, 0.03968708834740544, 0.0079481086372403219, -0.054463788468236907, 0.34560528195603346, 0.73666018142821055, 0.34560528195603346, -0.054463788468236907, 0.0079481086372403219, 0.03968708834740544, 0.0},
    {-0.013456709459118716, -0.0026949668801115071, 0.13670658466432914, -0.093504697400938863, -0.47680326579848425, 0.89950610974864842, -0.47680326579848425, -0.093504697400938863, 0.13670658466432914, -0.0026949668801115071, -0.013456709459118716, 0.0},
    {0.013456709459118716, -0.0026949668801115071, -0.13670658466432914, -0.093504697400938863, 0.47680326579848425, 0.89950610974864842, 0.47680326579848425, -0.093504697400938863, -0.13670658466432914, -0.0026949668801115071, 0.013456709459118716, 0.0},
    {0.0, 0.0, 0.03968708834740544, -0.0079481086372403219, -0.054463788468236907, -0.34560528195603346, 0.73666018142821055, -0.34560528195603346, -0.054463788468236907, -0.0079481086372403219, 0.03968708834740544, 0.0}
};

static double bior6_8_double[][18] = {
    {0.0, 0.0019088317364812906, -0.0019142861290887667, -0.016990639867602342, 0.01193456527972926, 0.04973290349094079, -0.077263173167204144, -0.09405920349573646, 0.42079628460982682, 0.82592299745840225, 0.42079628460982682, -0.09405920349573646, -0.077263173167204144, 0.04973290349094079, 0.01193456527972926, -0.016990639867602342, -0.0019142861290887667, 0.0019088317364812906},
    {0.0, 0.0, 0.0, 0.014426282505624435, -0.014467504896790148, -0.078722001062628819, 0.040367979030339923, 0.41784910915027457, -0.75890772945365415, 0.41784910915027457, 0.040367979030339923, -0.078722001062628819, -0.014467504896790148, 0.014426282505624435, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.014426282505624435, 0.014467504896790148, -0.078722001062628819, -0.040367979030339923, 0.41784910915027457, 0.75890772945365415, 0.41784910915027457, -0.040367979030339923, -0.078722001062628819, 0.014467504896790148, 0.014426282505624435, 0.0, 0.0, 0.0, 0.0},
    {0.0, -0.0019088317364812906, -0.0019142861290887667, 0.016990639867602342, 0.01193456527972926, -0.04973290349094079, -0.077263173167204144, 0.09405920349573646, 0.42079628460982682, -0.82592299745840225, 0.42079628460982682, 0.09405920349573646, -0.077263173167204144, -0.04973290349094079, 0.01193456527972926, 0.016990639867602342, -0.0019142861290887667, -0.0019088317364812906}
};

static double dmey_double[][62] = {
    {0.0, -1.0099999569414229e-012, 8.519459636796214e-009, -1.111944952595278e-008, -1.0798819539621958e-008, 6.0669757413511352e-008, -1.0866516536735883e-007, 8.2006806503864813e-008, 1.1783004497663934e-007, -5.5063405652522782e-007, 1.1307947017916706e-006, -1.4895492164971559e-006, 7.367572885903746e-007, 3.2054419133447798e-006, -1.6312699734552807e-005, 6.5543059305751491e-005, -0.00060115023435160925, -0.002704672124643725, 0.0022025341009110021, 0.006045814097323304, -0.0063877183184971563, -0.011061496392513451, 0.015270015130934803, 0.017423434103729693, -0.032130793990211758, -0.024348745906078023, 0.063739024322801596, 0.030655091960824263, -0.13284520043622938, -0.035087555656258346, 0.44459300275757724, 0.74458559231880628, 0.44459300275757724, -0.035087555656258346, -0.13284520043622938, 0.030655091960824263, 0.063739024322801596, -0.024348745906078023, -0.032130793990211758, 0.017423434103729693, 0.015270015130934803, -0.011061496392513451, -0.0063877183184971563, 0.006045814097323304, 0.0022025341009110021, -0.002704672124643725, -0.00060115023435160925, 6.5543059305751491e-005, -1.6312699734552807e-005, 3.2054419133447798e-006, 7.367572885903746e-007, -1.4895492164971559e-006, 1.1307947017916706e-006, -5.5063405652522782e-007, 1.1783004497663934e-007, 8.2006806503864813e-008, -1.0866516536735883e-007, 6.0669757413511352e-008, -1.0798819539621958e-008, -1.111944952595278e-008, 8.519459636796214e-009, -1.0099999569414229e-012},
    {1.0099999569414229e-012, 8.519459636796214e-009, 1.111944952595278e-008, -1.0798819539621958e-008, -6.0669757413511352e-008, -1.0866516536735883e-007, -8.2006806503864813e-008, 1.1783004497663934e-007, 5.5063405652522782e-007, 1.1307947017916706e-006, 1.4895492164971559e-006, 7.367572885903746e-007, -3.2054419133447798e-006, -1.6312699734552807e-005, -6.5543059305751491e-005, -0.00060115023435160925, 0.002704672124643725, 0.0022025341009110021, -0.006045814097323304, -0.0063877183184971563, 0.011061496392513451, 0.015270015130934803, -0.017423434103729693, -0.032130793990211758, 0.024348745906078023, 0.063739024322801596, -0.030655091960824263, -0.13284520043622938, 0.035087555656258346, 0.44459300275757724, -0.74458559231880628, 0.44459300275757724, 0.035087555656258346, -0.13284520043622938, -0.030655091960824263, 0.063739024322801596, 0.024348745906078023, -0.032130793990211758, -0.017423434103729693, 0.015270015130934803, 0.011061496392513451, -0.0063877183184971563, -0.006045814097323304, 0.0022025341009110021, 0.002704672124643725, -0.00060115023435160925, -6.5543059305751491e-005, -1.6312699734552807e-005, -3.2054419133447798e-006, 7.367572885903746e-007, 1.4895492164971559e-006, 1.1307947017916706e-006, 5.5063405652522782e-007, 1.1783004497663934e-007, -8.2006806503864813e-008, -1.0866516536735883e-007, -6.0669757413511352e-008, -1.0798819539621958e-008, 1.111944952595278e-008, 8.519459636796214e-009, 1.0099999569414229e-012, 0.0},
    {-1.0099999569414229e-012, 8.519459636796214e-009, -1.111944952595278e-008, -1.0798819539621958e-008, 6.0669757413511352e-008, -1.0866516536735883e-007, 8.2006806503864813e-008, 1.1783004497663934e-007, -5.5063405652522782e-007, 1.1307947017916706e-006, -1.4895492164971559e-006, 7.367572885903746e-007, 3.2054419133447798e-006, -1.6312699734552807e-005, 6.5543059305751491e-005, -0.00060115023435160925, -0.002704672124643725, 0.0022025341009110021, 0.006045814097323304, -0.0063877183184971563, -0.011061496392513451, 0.015270015130934803, 0.017423434103729693, -0.032130793990211758, -0.024348745906078023, 0.063739024322801596, 0.030655091960824263, -0.13284520043622938, -0.035087555656258346, 0.44459300275757724, 0.74458559231880628, 0.44459300275757724, -0.035087555656258346, -0.13284520043622938, 0.030655091960824263, 0.063739024322801596, -0.024348745906078023, -0.032130793990211758, 0.017423434103729693, 0.015270015130934803, -0.011061496392513451, -0.0063877183184971563, 0.006045814097323304, 0.0022025341009110021, -0.002704672124643725, -0.00060115023435160925, 6.5543059305751491e-005, -1.6312699734552807e-005, 3.2054419133447798e-006, 7.367572885903746e-007, -1.4895492164971559e-006, 1.1307947017916706e-006, -5.5063405652522782e-007, 1.1783004497663934e-007, 8.2006806503864813e-008, -1.0866516536735883e-007, 6.0669757413511352e-008, -1.0798819539621958e-008, -1.111944952595278e-008, 8.519459636796214e-009, -1.0099999569414229e-012, 0.0},
    {0.0, 1.0099999569414229e-012, 8.519459636796214e-009, 1.111944952595278e-008, -1.0798819539621958e-008, -6.0669757413511352e-008, -1.0866516536735883e-007, -8.2006806503864813e-008, 1.1783004497663934e-007, 5.5063405652522782e-007, 1.1307947017916706e-006, 1.4895492164971559e-006, 7.367572885903746e-007, -3.2054419133447798e-006, -1.6312699734552807e-005, -6.5543059305751491e-005, -0.00060115023435160925, 0.002704672124643725, 0.0022025341009110021, -0.006045814097323304, -0.0063877183184971563, 0.011061496392513451, 0.015270015130934803, -0.017423434103729693, -0.032130793990211758, 0.024348745906078023, 0.063739024322801596, -0.030655091960824263, -0.13284520043622938, 0.035087555656258346, 0.44459300275757724, -0.74458559231880628, 0.44459300275757724, 0.035087555656258346, -0.13284520043622938, -0.030655091960824263, 0.063739024322801596, 0.024348745906078023, -0.032130793990211758, -0.017423434103729693, 0.015270015130934803, 0.011061496392513451, -0.0063877183184971563, -0.006045814097323304, 0.0022025341009110021, 0.002704672124643725, -0.00060115023435160925, -6.5543059305751491e-005, -1.6312699734552807e-005, -3.2054419133447798e-006, 7.367572885903746e-007, 1.4895492164971559e-006, 1.1307947017916706e-006, 5.5063405652522782e-007, 1.1783004497663934e-007, -8.2006806503864813e-008, -1.0866516536735883e-007, -6.0669757413511352e-008, -1.0798819539621958e-008, 1.111944952595278e-008, 8.519459636796214e-009, 1.0099999569414229e-012}
};
static float db1_float[][2] = {
    {0.70710678118654757, 0.70710678118654757},
    {-0.70710678118654757, 0.70710678118654757},
    {0.70710678118654757, 0.70710678118654757},
    {0.70710678118654757, -0.70710678118654757}
};

static float db2_float[][4] = {
    {-0.12940952255092145, 0.22414386804185735, 0.83651630373746899, 0.48296291314469025},
    {-0.48296291314469025, 0.83651630373746899, -0.22414386804185735, -0.12940952255092145},
    {0.48296291314469025, 0.83651630373746899, 0.22414386804185735, -0.12940952255092145},
    {-0.12940952255092145, -0.22414386804185735, 0.83651630373746899, -0.48296291314469025}
};

static float db3_float[][6] = {
    {0.035226291882100656, -0.085441273882241486, -0.13501102001039084, 0.45987750211933132, 0.80689150931333875, 0.33267055295095688},
    {-0.33267055295095688, 0.80689150931333875, -0.45987750211933132, -0.13501102001039084, 0.085441273882241486, 0.035226291882100656},
    {0.33267055295095688, 0.80689150931333875, 0.45987750211933132, -0.13501102001039084, -0.085441273882241486, 0.035226291882100656},
    {0.035226291882100656, 0.085441273882241486, -0.13501102001039084, -0.45987750211933132, 0.80689150931333875, -0.33267055295095688}
};

static float db4_float[][8] = {
    {-0.010597401784997278, 0.032883011666982945, 0.030841381835986965, -0.18703481171888114, -0.027983769416983849, 0.63088076792959036, 0.71484657055254153, 0.23037781330885523},
    {-0.23037781330885523, 0.71484657055254153, -0.63088076792959036, -0.027983769416983849, 0.18703481171888114, 0.030841381835986965, -0.032883011666982945, -0.010597401784997278},
    {0.23037781330885523, 0.71484657055254153, 0.63088076792959036, -0.027983769416983849, -0.18703481171888114, 0.030841381835986965, 0.032883011666982945, -0.010597401784997278},
    {-0.010597401784997278, -0.032883011666982945, 0.030841381835986965, 0.18703481171888114, -0.027983769416983849, -0.63088076792959036, 0.71484657055254153, -0.23037781330885523}
};

static float db5_float[][10] = {
    {0.0033357252850015492, -0.012580751999015526, -0.0062414902130117052, 0.077571493840065148, -0.03224486958502952, -0.24229488706619015, 0.13842814590110342, 0.72430852843857441, 0.60382926979747287, 0.16010239797412501},
    {-0.16010239797412501, 0.60382926979747287, -0.72430852843857441, 0.13842814590110342, 0.24229488706619015, -0.03224486958502952, -0.077571493840065148, -0.0062414902130117052, 0.012580751999015526, 0.0033357252850015492},
    {0.16010239797412501, 0.60382926979747287, 0.72430852843857441, 0.13842814590110342, -0.24229488706619015, -0.03224486958502952, 0.077571493840065148, -0.0062414902130117052, -0.012580751999015526, 0.0033357252850015492},
    {0.0033357252850015492, 0.012580751999015526, -0.0062414902130117052, -0.077571493840065148, -0.03224486958502952, 0.24229488706619015, 0.13842814590110342, -0.72430852843857441, 0.60382926979747287, -0.16010239797412501}
};

static float db6_float[][12] = {
    {-0.0010773010849955799, 0.0047772575110106514, 0.0005538422009938016, -0.031582039318031156, 0.027522865530016288, 0.097501605587079362, -0.12976686756709563, -0.22626469396516913, 0.3152503517092432, 0.75113390802157753, 0.49462389039838539, 0.11154074335008017},
    {-0.11154074335008017, 0.49462389039838539, -0.75113390802157753, 0.3152503517092432, 0.22626469396516913, -0.12976686756709563, -0.097501605587079362, 0.027522865530016288, 0.031582039318031156, 0.0005538422009938016, -0.0047772575110106514, -0.0010773010849955799},
    {0.11154074335008017, 0.49462389039838539, 0.75113390802157753, 0.3152503517092432, -0.22626469396516913, -0.12976686756709563, 0.097501605587079362, 0.027522865530016288, -0.031582039318031156, 0.0005538422009938016, 0.0047772575110106514, -0.0010773010849955799},
    {-0.0010773010849955799, -0.0047772575110106514, 0.0005538422009938016, 0.031582039318031156, 0.027522865530016288, -0.097501605587079362, -0.12976686756709563, 0.22626469396516913, 0.3152503517092432, -0.75113390802157753, 0.49462389039838539, -0.11154074335008017}
};

static float db7_float[][14] = {
    {0.00035371380000103988, -0.0018016407039998328, 0.00042957797300470274, 0.012550998556013784, -0.01657454163101562, -0.038029936935034633, 0.080612609151065898, 0.071309219267050042, -0.22403618499416572, -0.14390600392910627, 0.4697822874053586, 0.72913209084655506, 0.39653931948230575, 0.077852054085062364},
    {-0.077852054085062364, 0.39653931948230575, -0.72913209084655506, 0.4697822874053586, 0.14390600392910627, -0.22403618499416572, -0.071309219267050042, 0.080612609151065898, 0.038029936935034633, -0.01657454163101562, -0.012550998556013784, 0.00042957797300470274, 0.0018016407039998328, 0.00035371380000103988},
    {0.077852054085062364, 0.39653931948230575, 0.72913209084655506, 0.4697822874053586, -0.14390600392910627, -0.22403618499416572, 0.071309219267050042, 0.080612609151065898, -0.038029936935034633, -0.01657454163101562, 0.012550998556013784, 0.00042957797300470274, -0.0018016407039998328, 0.00035371380000103988},
    {0.00035371380000103988, 0.0018016407039998328, 0.00042957797300470274, -0.012550998556013784, -0.01657454163101562, 0.038029936935034633, 0.080612609151065898, -0.071309219267050042, -0.22403618499416572, 0.14390600392910627, 0.4697822874053586, -0.72913209084655506, 0.39653931948230575, -0.077852054085062364}
};

static float db8_float[][16] = {
    {-0.00011747678400228192, 0.00067544940599855677, -0.00039174037299597711, -0.0048703529930106603, 0.0087460940470156547, 0.013981027917015516, -0.044088253931064719, -0.017369301002022108, 0.12874742662018601, 0.00047248457399797254, -0.28401554296242809, -0.015829105256023893, 0.58535468365486909, 0.67563073629801285, 0.31287159091446592, 0.054415842243081609},
    {-0.054415842243081609, 0.31287159091446592, -0.67563073629801285, 0.58535468365486909, 0.015829105256023893, -0.28401554296242809, -0.00047248457399797254, 0.12874742662018601, 0.017369301002022108, -0.044088253931064719, -0.013981027917015516, 0.0087460940470156547, 0.0048703529930106603, -0.00039174037299597711, -0.00067544940599855677, -0.00011747678400228192},
    {0.054415842243081609, 0.31287159091446592, 0.67563073629801285, 0.58535468365486909, -0.015829105256023893, -0.28401554296242809, 0.00047248457399797254, 0.12874742662018601, -0.017369301002022108, -0.044088253931064719, 0.013981027917015516, 0.0087460940470156547, -0.0048703529930106603, -0.00039174037299597711, 0.00067544940599855677, -0.00011747678400228192},
    {-0.00011747678400228192, -0.00067544940599855677, -0.00039174037299597711, 0.0048703529930106603, 0.0087460940470156547, -0.013981027917015516, -0.044088253931064719, 0.017369301002022108, 0.12874742662018601, -0.00047248457399797254, -0.28401554296242809, 0.015829105256023893, 0.58535468365486909, -0.67563073629801285, 0.31287159091446592, -0.054415842243081609}
};

static float db9_float[][18] = {
    {3.9347319995026124e-005, -0.00025196318899817888, 0.00023038576399541288, 0.0018476468829611268, -0.0042815036819047227, -0.004723204757894831, 0.022361662123515244, 0.00025094711499193845, -0.067632829059523988, 0.030725681478322865, 0.14854074933476008, -0.096840783220879037, -0.29327378327258685, 0.13319738582208895, 0.65728807803663891, 0.6048231236767786, 0.24383467463766728, 0.038077947363167282},
    {-0.038077947363167282, 0.24383467463766728, -0.6048231236767786, 0.65728807803663891, -0.13319738582208895, -0.29327378327258685, 0.096840783220879037, 0.14854074933476008, -0.030725681478322865, -0.067632829059523988, -0.00025094711499193845, 0.022361662123515244, 0.004723204757894831, -0.0042815036819047227, -0.0018476468829611268, 0.00023038576399541288, 0.00025196318899817888, 3.9347319995026124e-005},
    {0.038077947363167282, 0.24383467463766728, 0.6048231236767786, 0.65728807803663891, 0.13319738582208895, -0.29327378327258685, -0.096840783220879037, 0.14854074933476008, 0.030725681478322865, -0.067632829059523988, 0.00025094711499193845, 0.022361662123515244, -0.004723204757894831, -0.0042815036819047227, 0.0018476468829611268, 0.00023038576399541288, -0.00025196318899817888, 3.9347319995026124e-005},
    {3.9347319995026124e-005, 0.00025196318899817888, 0.00023038576399541288, -0.0018476468829611268, -0.0042815036819047227, 0.004723204757894831, 0.022361662123515244, -0.00025094711499193845, -0.067632829059523988, -0.030725681478322865, 0.14854074933476008, 0.096840783220879037, -0.29327378327258685, -0.13319738582208895, 0.65728807803663891, -0.6048231236767786, 0.24383467463766728, -0.038077947363167282}
};

static float db10_float[][20] = {
    {-1.3264203002354869e-005, 9.3588670001089845e-005, -0.0001164668549943862, -0.00068585669500468248, 0.0019924052949908499, 0.0013953517469940798, -0.010733175482979604, 0.0036065535669883944, 0.033212674058933238, -0.029457536821945671, -0.071394147165860775, 0.093057364603806592, 0.12736934033574265, -0.19594627437659665, -0.24984642432648865, 0.28117234366042648, 0.68845903945259213, 0.52720118893091983, 0.18817680007762133, 0.026670057900950818},
    {-0.026670057900950818, 0.18817680007762133, -0.52720118893091983, 0.68845903945259213, -0.28117234366042648, -0.24984642432648865, 0.19594627437659665, 0.12736934033574265, -0.093057364603806592, -0.071394147165860775, 0.029457536821945671, 0.033212674058933238, -0.0036065535669883944, -0.010733175482979604, -0.0013953517469940798, 0.0019924052949908499, 0.00068585669500468248, -0.0001164668549943862, -9.3588670001089845e-005, -1.3264203002354869e-005},
    {0.026670057900950818, 0.18817680007762133, 0.52720118893091983, 0.68845903945259213, 0.28117234366042648, -0.24984642432648865, -0.19594627437659665, 0.12736934033574265, 0.093057364603806592, -0.071394147165860775, -0.029457536821945671, 0.033212674058933238, 0.0036065535669883944, -0.010733175482979604, 0.0013953517469940798, 0.0019924052949908499, -0.00068585669500468248, -0.0001164668549943862, 9.3588670001089845e-005, -1.3264203002354869e-005},
    {-1.3264203002354869e-005, -9.3588670001089845e-005, -0.0001164668549943862, 0.00068585669500468248, 0.0019924052949908499, -0.0013953517469940798, -0.010733175482979604, -0.0036065535669883944, 0.033212674058933238, 0.029457536821945671, -0.071394147165860775, -0.093057364603806592, 0.12736934033574265, 0.19594627437659665, -0.24984642432648865, -0.28117234366042648, 0.68845903945259213, -0.52720118893091983, 0.18817680007762133, -0.026670057900950818}
};

static float db11_float[][22] = {
    {4.4942742772363519e-006, -3.4634984186983789e-005, 5.4439074699366381e-005, 0.00024915252355281426, -0.00089302325066623663, -0.00030859285881515924, 0.0049284176560587777, -0.0033408588730145018, -0.015364820906201324, 0.020840904360180039, 0.031335090219045313, -0.066438785695020222, -0.04647995511667613, 0.14981201246638268, 0.066043588196690886, -0.27423084681792875, -0.16227524502747828, 0.41196436894789695, 0.68568677491617847, 0.44989976435603013, 0.14406702115061959, 0.018694297761470441},
    {-0.018694297761470441, 0.14406702115061959, -0.44989976435603013, 0.68568677491617847, -0.41196436894789695, -0.16227524502747828, 0.27423084681792875, 0.066043588196690886, -0.14981201246638268, -0.04647995511667613, 0.066438785695020222, 0.031335090219045313, -0.020840904360180039, -0.015364820906201324, 0.0033408588730145018, 0.0049284176560587777, 0.00030859285881515924, -0.00089302325066623663, -0.00024915252355281426, 5.4439074699366381e-005, 3.4634984186983789e-005, 4.4942742772363519e-006},
    {0.018694297761470441, 0.14406702115061959, 0.44989976435603013, 0.68568677491617847, 0.41196436894789695, -0.16227524502747828, -0.27423084681792875, 0.066043588196690886, 0.14981201246638268, -0.04647995511667613, -0.066438785695020222, 0.031335090219045313, 0.020840904360180039, -0.015364820906201324, -0.0033408588730145018, 0.0049284176560587777, -0.00030859285881515924, -0.00089302325066623663, 0.00024915252355281426, 5.4439074699366381e-005, -3.4634984186983789e-005, 4.4942742772363519e-006},
    {4.4942742772363519e-006, 3.4634984186983789e-005, 5.4439074699366381e-005, -0.00024915252355281426, -0.00089302325066623663, 0.00030859285881515924, 0.0049284176560587777, 0.0033408588730145018, -0.015364820906201324, -0.020840904360180039, 0.031335090219045313, 0.066438785695020222, -0.04647995511667613, -0.14981201246638268, 0.066043588196690886, 0.27423084681792875, -0.16227524502747828, -0.41196436894789695, 0.68568677491617847, -0.44989976435603013, 0.14406702115061959, -0.018694297761470441}
};

static float db12_float[][24] = {
    {-1.5290717580684923e-006, 1.2776952219379579e-005, -2.4241545757030318e-005, -8.8504109208203182e-005, 0.00038865306282092672, 6.5451282125215034e-006, -0.0021795036186277044, 0.0022486072409952287, 0.0067114990087955486, -0.012840825198299882, -0.01221864906974642, 0.041546277495087637, 0.010849130255828966, -0.09643212009649671, 0.0053595696743599965, 0.18247860592758275, -0.023779257256064865, -0.31617845375277914, -0.044763885653777619, 0.51588647842780067, 0.65719872257929113, 0.37735513521420411, 0.10956627282118277, 0.013112257957229239},
    {-0.013112257957229239, 0.10956627282118277, -0.37735513521420411, 0.65719872257929113, -0.51588647842780067, -0.044763885653777619, 0.31617845375277914, -0.023779257256064865, -0.18247860592758275, 0.0053595696743599965, 0.09643212009649671, 0.010849130255828966, -0.041546277495087637, -0.01221864906974642, 0.012840825198299882, 0.0067114990087955486, -0.0022486072409952287, -0.0021795036186277044, -6.5451282125215034e-006, 0.00038865306282092672, 8.8504109208203182e-005, -2.4241545757030318e-005, -1.2776952219379579e-005, -1.5290717580684923e-006},
    {0.013112257957229239, 0.10956627282118277, 0.37735513521420411, 0.65719872257929113, 0.51588647842780067, -0.044763885653777619, -0.31617845375277914, -0.023779257256064865, 0.18247860592758275, 0.0053595696743599965, -0.09643212009649671, 0.010849130255828966, 0.041546277495087637, -0.01221864906974642, -0.012840825198299882, 0.0067114990087955486, 0.0022486072409952287, -0.0021795036186277044, 6.5451282125215034e-006, 0.00038865306282092672, -8.8504109208203182e-005, -2.4241545757030318e-005, 1.2776952219379579e-005, -1.5290717580684923e-006},
    {-1.5290717580684923e-006, -1.2776952219379579e-005, -2.4241545757030318e-005, 8.8504109208203182e-005, 0.00038865306282092672, -6.5451282125215034e-006, -0.0021795036186277044, -0.0022486072409952287, 0.0067114990087955486, 0.012840825198299882, -0.01221864906974642, -0.041546277495087637, 0.010849130255828966, 0.09643212009649671, 0.0053595696743599965, -0.18247860592758275, -0.023779257256064865, 0.31617845375277914, -0.044763885653777619, -0.51588647842780067, 0.65719872257929113, -0.37735513521420411, 0.10956627282118277, -0.013112257957229239}
};

static float db13_float[][26] = {
    {5.2200350984547998e-007, -4.7004164793608082e-006, 1.0441930571407941e-005, 3.0678537579324358e-005, -0.00016512898855650571, 4.9251525126285676e-005, 0.00093232613086724904, -0.0013156739118922766, -0.002761911234656831, 0.0072555894016171187, 0.0039239414487955773, -0.023831420710327809, 0.0023799722540522269, 0.056139477100276156, -0.026488406475345658, -0.10580761818792761, 0.072948933656788742, 0.17947607942935084, -0.12457673075080665, -0.31497290771138414, 0.086985726179645007, 0.58888957043121193, 0.61105585115878114, 0.31199632216043488, 0.082861243872901946, 0.0092021335389622788},
    {-0.0092021335389622788, 0.082861243872901946, -0.31199632216043488, 0.61105585115878114, -0.58888957043121193, 0.086985726179645007, 0.31497290771138414, -0.12457673075080665, -0.17947607942935084, 0.072948933656788742, 0.10580761818792761, -0.026488406475345658, -0.056139477100276156, 0.0023799722540522269, 0.023831420710327809, 0.0039239414487955773, -0.0072555894016171187, -0.002761911234656831, 0.0013156739118922766, 0.00093232613086724904, -4.9251525126285676e-005, -0.00016512898855650571, -3.0678537579324358e-005, 1.0441930571407941e-005, 4.7004164793608082e-006, 5.2200350984547998e-007},
    {0.0092021335389622788, 0.082861243872901946, 0.31199632216043488, 0.61105585115878114, 0.58888957043121193, 0.086985726179645007, -0.31497290771138414, -0.12457673075080665, 0.17947607942935084, 0.072948933656788742, -0.10580761818792761, -0.026488406475345658, 0.056139477100276156, 0.0023799722540522269, -0.023831420710327809, 0.0039239414487955773, 0.0072555894016171187, -0.002761911234656831, -0.0013156739118922766, 0.00093232613086724904, 4.9251525126285676e-005, -0.00016512898855650571, 3.0678537579324358e-005, 1.0441930571407941e-005, -4.7004164793608082e-006, 5.2200350984547998e-007},
    {5.2200350984547998e-007, 4.7004164793608082e-006, 1.0441930571407941e-005, -3.0678537579324358e-005, -0.00016512898855650571, -4.9251525126285676e-005, 0.00093232613086724904, 0.0013156739118922766, -0.002761911234656831, -0.0072555894016171187, 0.0039239414487955773, 0.023831420710327809, 0.0023799722540522269, -0.056139477100276156, -0.026488406475345658, 0.10580761818792761, 0.072948933656788742, -0.17947607942935084, -0.12457673075080665, 0.31497290771138414, 0.086985726179645007, -0.58888957043121193, 0.61105585115878114, -0.31199632216043488, 0.082861243872901946, -0.0092021335389622788}
};

static float db14_float[][28] = {
    {-1.7871399683109222e-007, 1.7249946753674012e-006, -4.3897049017804176e-006, -1.0337209184568496e-005, 6.875504252695734e-005, -4.1777245770370672e-005, -0.00038683194731287514, 0.00070802115423540481, 0.001061691085606874, -0.003849638868019787, -0.00074621898926387534, 0.012789493266340071, -0.0056150495303375755, -0.030185351540353976, 0.026981408307947971, 0.05523712625925082, -0.071548955503983505, -0.086748411568110598, 0.13998901658445695, 0.13839521386479153, -0.21803352999321651, -0.27168855227867705, 0.21867068775886594, 0.63118784910471981, 0.55430561794077093, 0.25485026779256437, 0.062364758849384874, 0.0064611534600864905},
    {-0.0064611534600864905, 0.062364758849384874, -0.25485026779256437, 0.55430561794077093, -0.63118784910471981, 0.21867068775886594, 0.27168855227867705, -0.21803352999321651, -0.13839521386479153, 0.13998901658445695, 0.086748411568110598, -0.071548955503983505, -0.05523712625925082, 0.026981408307947971, 0.030185351540353976, -0.0056150495303375755, -0.012789493266340071, -0.00074621898926387534, 0.003849638868019787, 0.001061691085606874, -0.00070802115423540481, -0.00038683194731287514, 4.1777245770370672e-005, 6.875504252695734e-005, 1.0337209184568496e-005, -4.3897049017804176e-006, -1.7249946753674012e-006, -1.7871399683109222e-007},
    {0.0064611534600864905, 0.062364758849384874, 0.25485026779256437, 0.55430561794077093, 0.63118784910471981, 0.21867068775886594, -0.27168855227867705, -0.21803352999321651, 0.13839521386479153, 0.13998901658445695, -0.086748411568110598, -0.071548955503983505, 0.05523712625925082, 0.026981408307947971, -0.030185351540353976, -0.0056150495303375755, 0.012789493266340071, -0.00074621898926387534, -0.003849638868019787, 0.001061691085606874, 0.00070802115423540481, -0.00038683194731287514, -4.1777245770370672e-005, 6.875504252695734e-005, -1.0337209184568496e-005, -4.3897049017804176e-006, 1.7249946753674012e-006, -1.7871399683109222e-007},
    {-1.7871399683109222e-007, -1.7249946753674012e-006, -4.3897049017804176e-006, 1.0337209184568496e-005, 6.875504252695734e-005, 4.1777245770370672e-005, -0.00038683194731287514, -0.00070802115423540481, 0.001061691085606874, 0.003849638868019787, -0.00074621898926387534, -0.012789493266340071, -0.0056150495303375755, 0.030185351540353976, 0.026981408307947971, -0.05523712625925082, -0.071548955503983505, 0.086748411568110598, 0.13998901658445695, -0.13839521386479153, -0.21803352999321651, 0.27168855227867705, 0.21867068775886594, -0.63118784910471981, 0.55430561794077093, -0.25485026779256437, 0.062364758849384874, -0.0064611534600864905}
};

static float db15_float[][30] = {
    {6.1333599133037138e-008, -6.3168823258794506e-007, 1.8112704079399406e-006, 3.3629871817363823e-006, -2.8133296266037558e-005, 2.579269915531323e-005, 0.00015589648992055726, -0.00035956524436229364, -0.00037348235413726472, 0.0019433239803823459, -0.00024175649075894543, -0.0064877345603061454, 0.0051010003604228726, 0.015083918027862582, -0.020810050169636805, -0.025767007328366939, 0.054780550584559995, 0.033877143923563204, -0.11112093603713753, -0.039666176555733602, 0.19014671400708816, 0.065282952848765688, -0.28888259656686216, -0.19320413960907623, 0.33900253545462167, 0.64581314035721027, 0.49263177170797529, 0.20602386398692688, 0.046743394892750617, 0.0045385373615773762},
    {-0.0045385373615773762, 0.046743394892750617, -0.20602386398692688, 0.49263177170797529, -0.64581314035721027, 0.33900253545462167, 0.19320413960907623, -0.28888259656686216, -0.065282952848765688, 0.19014671400708816, 0.039666176555733602, -0.11112093603713753, -0.033877143923563204, 0.054780550584559995, 0.025767007328366939, -0.020810050169636805, -0.015083918027862582, 0.0051010003604228726, 0.0064877345603061454, -0.00024175649075894543, -0.0019433239803823459, -0.00037348235413726472, 0.00035956524436229364, 0.00015589648992055726, -2.579269915531323e-005, -2.8133296266037558e-005, -3.3629871817363823e-006, 1.8112704079399406e-006, 6.3168823258794506e-007, 6.1333599133037138e-008},
    {0.0045385373615773762, 0.046743394892750617, 0.20602386398692688, 0.49263177170797529, 0.64581314035721027, 0.33900253545462167, -0.19320413960907623, -0.28888259656686216, 0.065282952848765688, 0.19014671400708816, -0.039666176555733602, -0.11112093603713753, 0.033877143923563204, 0.054780550584559995, -0.025767007328366939, -0.020810050169636805, 0.015083918027862582, 0.0051010003604228726, -0.0064877345603061454, -0.00024175649075894543, 0.0019433239803823459, -0.00037348235413726472, -0.00035956524436229364, 0.00015589648992055726, 2.579269915531323e-005, -2.8133296266037558e-005, 3.3629871817363823e-006, 1.8112704079399406e-006, -6.3168823258794506e-007, 6.1333599133037138e-008},
    {6.1333599133037138e-008, 6.3168823258794506e-007, 1.8112704079399406e-006, -3.3629871817363823e-006, -2.8133296266037558e-005, -2.579269915531323e-005, 0.00015589648992055726, 0.00035956524436229364, -0.00037348235413726472, -0.0019433239803823459, -0.00024175649075894543, 0.0064877345603061454, 0.0051010003604228726, -0.015083918027862582, -0.020810050169636805, 0.025767007328366939, 0.054780550584559995, -0.033877143923563204, -0.11112093603713753, 0.039666176555733602, 0.19014671400708816, -0.065282952848765688, -0.28888259656686216, 0.19320413960907623, 0.33900253545462167, -0.64581314035721027, 0.49263177170797529, -0.20602386398692688, 0.046743394892750617, -0.0045385373615773762}
};

static float db16_float[][32] = {
    {-2.1093396300980412e-008, 2.3087840868545578e-007, -7.3636567854418147e-007, -1.0435713423102517e-006, 1.133660866126152e-005, -1.394566898819319e-005, -6.103596621404321e-005, 0.00017478724522506327, 0.00011424152003843815, -0.00094102174935854332, 0.00040789698084934395, 0.00312802338120381, -0.0036442796214883506, -0.0069900145633907508, 0.013993768859843242, 0.010297659641009963, -0.036888397691556774, -0.0075889743686425939, 0.075924236044457791, -0.0062397227521562536, -0.13238830556335474, 0.027340263752899923, 0.21119069394696974, -0.02791820813292813, -0.32706331052747578, -0.089751089402363524, 0.44029025688580486, 0.63735633208298326, 0.43031272284545874, 0.1650642834886438, 0.034907714323629047, 0.0031892209253436892},
    {-0.0031892209253436892, 0.034907714323629047, -0.1650642834886438, 0.43031272284545874, -0.63735633208298326, 0.44029025688580486, 0.089751089402363524, -0.32706331052747578, 0.02791820813292813, 0.21119069394696974, -0.027340263752899923, -0.13238830556335474, 0.0062397227521562536, 0.075924236044457791, 0.0075889743686425939, -0.036888397691556774, -0.010297659641009963, 0.013993768859843242, 0.0069900145633907508, -0.0036442796214883506, -0.00312802338120381, 0.00040789698084934395, 0.00094102174935854332, 0.00011424152003843815, -0.00017478724522506327, -6.103596621404321e-005, 1.394566898819319e-005, 1.133660866126152e-005, 1.0435713423102517e-006, -7.3636567854418147e-007, -2.3087840868545578e-007, -2.1093396300980412e-008},
    {0.0031892209253436892, 0.034907714323629047, 0.1650642834886438, 0.43031272284545874, 0.63735633208298326, 0.44029025688580486, -0.089751089402363524, -0.32706331052747578, -0.02791820813292813, 0.21119069394696974, 0.027340263752899923, -0.13238830556335474, -0.0062397227521562536, 0.075924236044457791, -0.0075889743686425939, -0.036888397691556774, 0.010297659641009963, 0.013993768859843242, -0.0069900145633907508, -0.0036442796214883506, 0.00312802338120381, 0.00040789698084934395, -0.00094102174935854332, 0.00011424152003843815, 0.00017478724522506327, -6.103596621404321e-005, -1.394566898819319e-005, 1.133660866126152e-005, -1.0435713423102517e-006, -7.3636567854418147e-007, 2.3087840868545578e-007, -2.1093396300980412e-008},
    {-2.1093396300980412e-008, -2.3087840868545578e-007, -7.3636567854418147e-007, 1.0435713423102517e-006, 1.133660866126152e-005, 1.394566898819319e-005, -6.103596621404321e-005, -0.00017478724522506327, 0.00011424152003843815, 0.00094102174935854332, 0.00040789698084934395, -0.00312802338120381, -0.0036442796214883506, 0.0069900145633907508, 0.013993768859843242, -0.010297659641009963, -0.036888397691556774, 0.0075889743686425939, 0.075924236044457791, 0.0062397227521562536, -0.13238830556335474, -0.027340263752899923, 0.21119069394696974, 0.02791820813292813, -0.32706331052747578, 0.089751089402363524, 0.44029025688580486, -0.63735633208298326, 0.43031272284545874, -0.1650642834886438, 0.034907714323629047, -0.0031892209253436892}
};

static float db17_float[][34] = {
    {7.2674929685663697e-009, -8.4239484460081536e-008, 2.9577009333187617e-007, 3.0165496099963414e-007, -4.5059424772259631e-006, 6.9906009850812941e-006, 2.3186813798761639e-005, -8.2048032024582121e-005, -2.5610109566546042e-005, 0.00043946542776894542, -0.00032813251941022427, -0.001436845304805, 0.0023012052421511474, 0.0029679966915180638, -0.0086029215203478147, -0.0030429899813869555, 0.022733676583919053, -0.0032709555358783646, -0.046922438389378908, 0.022312336178011833, 0.081105986654080822, -0.057091419631858077, -0.12681569177849797, 0.10113548917744287, 0.19731058956508457, -0.12659975221599248, -0.32832074836418546, 0.027314970403312946, 0.5183157640572823, 0.61099661568502728, 0.37035072415288578, 0.13121490330791097, 0.025985393703623173, 0.0022418070010387899},
    {-0.0022418070010387899, 0.025985393703623173, -0.13121490330791097, 0.37035072415288578, -0.61099661568502728, 0.5183157640572823, -0.027314970403312946, -0.32832074836418546, 0.12659975221599248, 0.19731058956508457, -0.10113548917744287, -0.12681569177849797, 0.057091419631858077, 0.081105986654080822, -0.022312336178011833, -0.046922438389378908, 0.0032709555358783646, 0.022733676583919053, 0.0030429899813869555, -0.0086029215203478147, -0.0029679966915180638, 0.0023012052421511474, 0.001436845304805, -0.00032813251941022427, -0.00043946542776894542, -2.5610109566546042e-005, 8.2048032024582121e-005, 2.3186813798761639e-005, -6.9906009850812941e-006, -4.5059424772259631e-006, -3.0165496099963414e-007, 2.9577009333187617e-007, 8.4239484460081536e-008, 7.2674929685663697e-009},
    {0.0022418070010387899, 0.025985393703623173, 0.13121490330791097, 0.37035072415288578, 0.61099661568502728, 0.5183157640572823, 0.027314970403312946, -0.32832074836418546, -0.12659975221599248, 0.19731058956508457, 0.10113548917744287, -0.12681569177849797, -0.057091419631858077, 0.081105986654080822, 0.022312336178011833, -0.046922438389378908, -0.0032709555358783646, 0.022733676583919053, -0.0030429899813869555, -0.0086029215203478147, 0.0029679966915180638, 0.0023012052421511474, -0.001436845304805, -0.00032813251941022427, 0.00043946542776894542, -2.5610109566546042e-005, -8.2048032024582121e-005, 2.3186813798761639e-005, 6.9906009850812941e-006, -4.5059424772259631e-006, 3.0165496099963414e-007, 2.9577009333187617e-007, -8.4239484460081536e-008, 7.2674929685663697e-009},
    {7.2674929685663697e-009, 8.4239484460081536e-008, 2.9577009333187617e-007, -3.0165496099963414e-007, -4.5059424772259631e-006, -6.9906009850812941e-006, 2.3186813798761639e-005, 8.2048032024582121e-005, -2.5610109566546042e-005, -0.00043946542776894542, -0.00032813251941022427, 0.001436845304805, 0.0023012052421511474, -0.0029679966915180638, -0.0086029215203478147, 0.0030429899813869555, 0.022733676583919053, 0.0032709555358783646, -0.046922438389378908, -0.022312336178011833, 0.081105986654080822, 0.057091419631858077, -0.12681569177849797, -0.10113548917744287, 0.19731058956508457, 0.12659975221599248, -0.32832074836418546, -0.027314970403312946, 0.5183157640572823, -0.61099661568502728, 0.37035072415288578, -0.13121490330791097, 0.025985393703623173, -0.0022418070010387899}
};

static float db18_float[][36] = {
    {-2.5079344549419292e-009, 3.0688358630370302e-008, -1.1760987670250871e-007, -7.691632689865049e-008, 1.7687129836228861e-006, -3.3326344788769603e-006, -8.5206025374234635e-006, 3.7412378807308472e-005, -1.5359171230213409e-007, -0.00019864855231101547, 0.0002135815619103188, 0.00062846568296447147, -0.0013405962983313922, -0.0011187326669886426, 0.0049433436054565939, 0.00011863003387493042, -0.013051480946517112, 0.0062621679544386608, 0.026670705926689853, -0.023733210395336858, -0.04452614190225633, 0.057051247739058272, 0.064887216212358198, -0.10675224665906288, -0.092331884150304119, 0.16708131276294505, 0.14953397556500755, -0.21648093400458224, -0.29365404073579809, 0.14722311196952223, 0.57180165488712198, 0.57182680776508177, 0.31467894133619284, 0.10358846582214751, 0.019288531724094969, 0.0015763102184365595},
    {-0.0015763102184365595, 0.019288531724094969, -0.10358846582214751, 0.31467894133619284, -0.57182680776508177, 0.57180165488712198, -0.14722311196952223, -0.29365404073579809, 0.21648093400458224, 0.14953397556500755, -0.16708131276294505, -0.092331884150304119, 0.10675224665906288, 0.064887216212358198, -0.057051247739058272, -0.04452614190225633, 0.023733210395336858, 0.026670705926689853, -0.0062621679544386608, -0.013051480946517112, -0.00011863003387493042, 0.0049433436054565939, 0.0011187326669886426, -0.0013405962983313922, -0.00062846568296447147, 0.0002135815619103188, 0.00019864855231101547, -1.5359171230213409e-007, -3.7412378807308472e-005, -8.5206025374234635e-006, 3.3326344788769603e-006, 1.7687129836228861e-006, 7.691632689865049e-008, -1.1760987670250871e-007, -3.0688358630370302e-008, -2.5079344549419292e-009},
    {0.0015763102184365595, 0.019288531724094969, 0.10358846582214751, 0.31467894133619284, 0.57182680776508177, 0.57180165488712198, 0.14722311196952223, -0.29365404073579809, -0.21648093400458224, 0.14953397556500755, 0.16708131276294505, -0.092331884150304119, -0.10675224665906288, 0.064887216212358198, 0.057051247739058272, -0.04452614190225633, -0.023733210395336858, 0.026670705926689853, 0.0062621679544386608, -0.013051480946517112, 0.00011863003387493042, 0.0049433436054565939, -0.0011187326669886426, -0.0013405962983313922, 0.00062846568296447147, 0.0002135815619103188, -0.00019864855231101547, -1.5359171230213409e-007, 3.7412378807308472e-005, -8.5206025374234635e-006, -3.3326344788769603e-006, 1.7687129836228861e-006, -7.691632689865049e-008, -1.1760987670250871e-007, 3.0688358630370302e-008, -2.5079344549419292e-009},
    {-2.5079344549419292e-009, -3.0688358630370302e-008, -1.1760987670250871e-007, 7.691632689865049e-008, 1.7687129836228861e-006, 3.3326344788769603e-006, -8.5206025374234635e-006, -3.7412378807308472e-005, -1.5359171230213409e-007, 0.00019864855231101547, 0.0002135815619103188, -0.00062846568296447147, -0.0013405962983313922, 0.0011187326669886426, 0.0049433436054565939, -0.00011863003387493042, -0.013051480946517112, -0.0062621679544386608, 0.026670705926689853, 0.023733210395336858, -0.04452614190225633, -0.057051247739058272, 0.064887216212358198, 0.10675224665906288, -0.092331884150304119, -0.16708131276294505, 0.14953397556500755, 0.21648093400458224, -0.29365404073579809, -0.14722311196952223, 0.57180165488712198, -0.57182680776508177, 0.31467894133619284, -0.10358846582214751, 0.019288531724094969, -0.0015763102184365595}
};

static float db19_float[][38] = {
    {8.6668488390344833e-010, -1.1164020670405678e-008, 4.6369377758023682e-008, 1.4470882988040879e-008, -6.8627556577981102e-007, 1.5319314766978769e-006, 3.0109643163099385e-006, -1.6640176297224622e-005, 5.1059504870906939e-006, 8.7112704672504432e-005, -0.00012460079173506306, -0.00026067613568119951, 0.0007358025205041731, 0.00034180865344939543, -0.0026875518007344408, 0.00076895435922424884, 0.0070407473670804953, -0.0058669222811121953, -0.013988388678695632, 0.019375549889114482, 0.021623767409452484, -0.045674226277784918, -0.026501236250778635, 0.086906755555450702, 0.027584350624887129, -0.14278569504021468, -0.033518541903202262, 0.21234974330662043, 0.074652269708066474, -0.28583863175723145, -0.22809139421653665, 0.26089495265212009, 0.60170454913009164, 0.52443637746688621, 0.26438843174202237, 0.08127811326580564, 0.01428109845082521, 0.0011086697631864314},
    {-0.0011086697631864314, 0.01428109845082521, -0.08127811326580564, 0.26438843174202237, -0.52443637746688621, 0.60170454913009164, -0.26089495265212009, -0.22809139421653665, 0.28583863175723145, 0.074652269708066474, -0.21234974330662043, -0.033518541903202262, 0.14278569504021468, 0.027584350624887129, -0.086906755555450702, -0.026501236250778635, 0.045674226277784918, 0.021623767409452484, -0.019375549889114482, -0.013988388678695632, 0.0058669222811121953, 0.0070407473670804953, -0.00076895435922424884, -0.0026875518007344408, -0.00034180865344939543, 0.0007358025205041731, 0.00026067613568119951, -0.00012460079173506306, -8.7112704672504432e-005, 5.1059504870906939e-006, 1.6640176297224622e-005, 3.0109643163099385e-006, -1.5319314766978769e-006, -6.8627556577981102e-007, -1.4470882988040879e-008, 4.6369377758023682e-008, 1.1164020670405678e-008, 8.6668488390344833e-010},
    {0.0011086697631864314, 0.01428109845082521, 0.08127811326580564, 0.26438843174202237, 0.52443637746688621, 0.60170454913009164, 0.26089495265212009, -0.22809139421653665, -0.28583863175723145, 0.074652269708066474, 0.21234974330662043, -0.033518541903202262, -0.14278569504021468, 0.027584350624887129, 0.086906755555450702, -0.026501236250778635, -0.045674226277784918, 0.021623767409452484, 0.019375549889114482, -0.013988388678695632, -0.0058669222811121953, 0.0070407473670804953, 0.00076895435922424884, -0.0026875518007344408, 0.00034180865344939543, 0.0007358025205041731, -0.00026067613568119951, -0.00012460079173506306, 8.7112704672504432e-005, 5.1059504870906939e-006, -1.6640176297224622e-005, 3.0109643163099385e-006, 1.5319314766978769e-006, -6.8627556577981102e-007, 1.4470882988040879e-008, 4.6369377758023682e-008, -1.1164020670405678e-008, 8.6668488390344833e-010},
    {8.6668488390344833e-010, 1.1164020670405678e-008, 4.6369377758023682e-008, -1.4470882988040879e-008, -6.8627556577981102e-007, -1.5319314766978769e-006, 3.0109643163099385e-006, 1.6640176297224622e-005, 5.1059504870906939e-006, -8.7112704672504432e-005, -0.00012460079173506306, 0.00026067613568119951, 0.0007358025205041731, -0.00034180865344939543, -0.0026875518007344408, -0.00076895435922424884, 0.0070407473670804953, 0.0058669222811121953, -0.013988388678695632, -0.019375549889114482, 0.021623767409452484, 0.045674226277784918, -0.026501236250778635, -0.086906755555450702, 0.027584350624887129, 0.14278569504021468, -0.033518541903202262, -0.21234974330662043, 0.074652269708066474, 0.28583863175723145, -0.22809139421653665, -0.26089495265212009, 0.60170454913009164, -0.52443637746688621, 0.26438843174202237, -0.08127811326580564, 0.01428109845082521, -0.0011086697631864314}
};

static float db20_float[][40] = {
    {-2.9988364896157532e-010, 4.05612705554717e-009, -1.8148432482976221e-008, 2.0143220235374613e-010, 2.633924226266962e-007, -6.847079596993149e-007, -1.0119940100181473e-006, 7.2412482876637907e-006, -4.3761438621821972e-006, -3.7105861833906152e-005, 6.7742808283730477e-005, 0.00010153288973669777, -0.0003851047486990061, -5.3497598443404532e-005, 0.0013925596193045254, -0.00083156217287724745, -0.003581494259744107, 0.0044205423867663502, 0.0067216273018096935, -0.013810526137727442, -0.0087893249245557647, 0.032294299530119162, 0.0058746818113949465, -0.061722899624668884, 0.0056322468576854544, 0.10229171917513397, -0.024716827337521424, -0.15545875070604531, 0.039850246458519104, 0.22829105082013823, -0.016727088308801888, -0.32678680043353758, -0.13921208801128787, 0.36150229873889705, 0.61049323893785579, 0.47269618531033147, 0.21994211355113222, 0.063423780459005291, 0.010549394624937735, 0.00077995361366591117},
    {-0.00077995361366591117, 0.010549394624937735, -0.063423780459005291, 0.21994211355113222, -0.47269618531033147, 0.61049323893785579, -0.36150229873889705, -0.13921208801128787, 0.32678680043353758, -0.016727088308801888, -0.22829105082013823, 0.039850246458519104, 0.15545875070604531, -0.024716827337521424, -0.10229171917513397, 0.0056322468576854544, 0.061722899624668884, 0.0058746818113949465, -0.032294299530119162, -0.0087893249245557647, 0.013810526137727442, 0.0067216273018096935, -0.0044205423867663502, -0.003581494259744107, 0.00083156217287724745, 0.0013925596193045254, 5.3497598443404532e-005, -0.0003851047486990061, -0.00010153288973669777, 6.7742808283730477e-005, 3.7105861833906152e-005, -4.3761438621821972e-006, -7.2412482876637907e-006, -1.0119940100181473e-006, 6.847079596993149e-007, 2.633924226266962e-007, -2.0143220235374613e-010, -1.8148432482976221e-008, -4.05612705554717e-009, -2.9988364896157532e-010},
    {0.00077995361366591117, 0.010549394624937735, 0.063423780459005291, 0.21994211355113222, 0.47269618531033147, 0.61049323893785579, 0.36150229873889705, -0.13921208801128787, -0.32678680043353758, -0.016727088308801888, 0.22829105082013823, 0.039850246458519104, -0.15545875070604531, -0.024716827337521424, 0.10229171917513397, 0.0056322468576854544, -0.061722899624668884, 0.0058746818113949465, 0.032294299530119162, -0.0087893249245557647, -0.013810526137727442, 0.0067216273018096935, 0.0044205423867663502, -0.003581494259744107, -0.00083156217287724745, 0.0013925596193045254, -5.3497598443404532e-005, -0.0003851047486990061, 0.00010153288973669777, 6.7742808283730477e-005, -3.7105861833906152e-005, -4.3761438621821972e-006, 7.2412482876637907e-006, -1.0119940100181473e-006, -6.847079596993149e-007, 2.633924226266962e-007, 2.0143220235374613e-010, -1.8148432482976221e-008, 4.05612705554717e-009, -2.9988364896157532e-010},
    {-2.9988364896157532e-010, -4.05612705554717e-009, -1.8148432482976221e-008, -2.0143220235374613e-010, 2.633924226266962e-007, 6.847079596993149e-007, -1.0119940100181473e-006, -7.2412482876637907e-006, -4.3761438621821972e-006, 3.7105861833906152e-005, 6.7742808283730477e-005, -0.00010153288973669777, -0.0003851047486990061, 5.3497598443404532e-005, 0.0013925596193045254, 0.00083156217287724745, -0.003581494259744107, -0.0044205423867663502, 0.0067216273018096935, 0.013810526137727442, -0.0087893249245557647, -0.032294299530119162, 0.0058746818113949465, 0.061722899624668884, 0.0056322468576854544, -0.10229171917513397, -0.024716827337521424, 0.15545875070604531, 0.039850246458519104, -0.22829105082013823, -0.016727088308801888, 0.32678680043353758, -0.13921208801128787, -0.36150229873889705, 0.61049323893785579, -0.47269618531033147, 0.21994211355113222, -0.063423780459005291, 0.010549394624937735, -0.00077995361366591117}
};

static float sym2_float[][4] = {
    {-0.12940952255092145, 0.22414386804185735, 0.83651630373746899, 0.48296291314469025},
    {-0.48296291314469025, 0.83651630373746899, -0.22414386804185735, -0.12940952255092145},
    {0.48296291314469025, 0.83651630373746899, 0.22414386804185735, -0.12940952255092145},
    {-0.12940952255092145, -0.22414386804185735, 0.83651630373746899, -0.48296291314469025}
};

static float sym3_float[][6] = {
    {0.035226291882100656, -0.085441273882241486, -0.13501102001039084, 0.45987750211933132, 0.80689150931333875, 0.33267055295095688},
    {-0.33267055295095688, 0.80689150931333875, -0.45987750211933132, -0.13501102001039084, 0.085441273882241486, 0.035226291882100656},
    {0.33267055295095688, 0.80689150931333875, 0.45987750211933132, -0.13501102001039084, -0.085441273882241486, 0.035226291882100656},
    {0.035226291882100656, 0.085441273882241486, -0.13501102001039084, -0.45987750211933132, 0.80689150931333875, -0.33267055295095688}
};

static float sym4_float[][8] = {
    {-0.075765714789273325, -0.02963552764599851, 0.49761866763201545, 0.80373875180591614, 0.29785779560527736, -0.099219543576847216, -0.012603967262037833, 0.032223100604042702},
    {-0.032223100604042702, -0.012603967262037833, 0.099219543576847216, 0.29785779560527736, -0.80373875180591614, 0.49761866763201545, 0.02963552764599851, -0.075765714789273325},
    {0.032223100604042702, -0.012603967262037833, -0.099219543576847216, 0.29785779560527736, 0.80373875180591614, 0.49761866763201545, -0.02963552764599851, -0.075765714789273325},
    {-0.075765714789273325, 0.02963552764599851, 0.49761866763201545, -0.80373875180591614, 0.29785779560527736, 0.099219543576847216, -0.012603967262037833, -0.032223100604042702}
};

static float sym5_float[][10] = {
    {0.027333068345077982, 0.029519490925774643, -0.039134249302383094, 0.1993975339773936, 0.72340769040242059, 0.63397896345821192, 0.016602105764522319, -0.17532808990845047, -0.021101834024758855, 0.019538882735286728},
    {-0.019538882735286728, -0.021101834024758855, 0.17532808990845047, 0.016602105764522319, -0.63397896345821192, 0.72340769040242059, -0.1993975339773936, -0.039134249302383094, -0.029519490925774643, 0.027333068345077982},
    {0.019538882735286728, -0.021101834024758855, -0.17532808990845047, 0.016602105764522319, 0.63397896345821192, 0.72340769040242059, 0.1993975339773936, -0.039134249302383094, 0.029519490925774643, 0.027333068345077982},
    {0.027333068345077982, -0.029519490925774643, -0.039134249302383094, -0.1993975339773936, 0.72340769040242059, -0.63397896345821192, 0.016602105764522319, 0.17532808990845047, -0.021101834024758855, -0.019538882735286728}
};

static float sym6_float[][12] = {
    {0.015404109327027373, 0.0034907120842174702, -0.11799011114819057, -0.048311742585632998, 0.49105594192674662, 0.787641141030194, 0.3379294217276218, -0.072637522786462516, -0.021060292512300564, 0.044724901770665779, 0.0017677118642428036, -0.007800708325034148},
    {0.007800708325034148, 0.0017677118642428036, -0.044724901770665779, -0.021060292512300564, 0.072637522786462516, 0.3379294217276218, -0.787641141030194, 0.49105594192674662, 0.048311742585632998, -0.11799011114819057, -0.0034907120842174702, 0.015404109327027373},
    {-0.007800708325034148, 0.0017677118642428036, 0.044724901770665779, -0.021060292512300564, -0.072637522786462516, 0.3379294217276218, 0.787641141030194, 0.49105594192674662, -0.048311742585632998, -0.11799011114819057, 0.0034907120842174702, 0.015404109327027373},
    {0.015404109327027373, -0.0034907120842174702, -0.11799011114819057, 0.048311742585632998, 0.49105594192674662, -0.787641141030194, 0.3379294217276218, 0.072637522786462516, -0.021060292512300564, -0.044724901770665779, 0.0017677118642428036, 0.007800708325034148}
};

static float sym7_float[][14] = {
    {0.0026818145682578781, -0.0010473848886829163, -0.01263630340325193, 0.03051551316596357, 0.067892693501372697, -0.049552834937127255, 0.017441255086855827, 0.5361019170917628, 0.76776431700316405, 0.28862963175151463, -0.14004724044296152, -0.10780823770381774, 0.0040102448715336634, 0.010268176708511255},
    {-0.010268176708511255, 0.0040102448715336634, 0.10780823770381774, -0.14004724044296152, -0.28862963175151463, 0.76776431700316405, -0.5361019170917628, 0.017441255086855827, 0.049552834937127255, 0.067892693501372697, -0.03051551316596357, -0.01263630340325193, 0.0010473848886829163, 0.0026818145682578781},
    {0.010268176708511255, 0.0040102448715336634, -0.10780823770381774, -0.14004724044296152, 0.28862963175151463, 0.76776431700316405, 0.5361019170917628, 0.017441255086855827, -0.049552834937127255, 0.067892693501372697, 0.03051551316596357, -0.01263630340325193, -0.0010473848886829163, 0.0026818145682578781},
    {0.0026818145682578781, 0.0010473848886829163, -0.01263630340325193, -0.03051551316596357, 0.067892693501372697, 0.049552834937127255, 0.017441255086855827, -0.5361019170917628, 0.76776431700316405, -0.28862963175151463, -0.14004724044296152, 0.10780823770381774, 0.0040102448715336634, -0.010268176708511255}
};

static float sym8_float[][16] = {
    {-0.0033824159510061256, -0.00054213233179114812, 0.031695087811492981, 0.0076074873249176054, -0.14329423835080971, -0.061273359067658524, 0.48135965125837221, 0.77718575170052351, 0.3644418948353314, -0.051945838107709037, -0.027219029917056003, 0.049137179673607506, 0.0038087520138906151, -0.014952258337048231, -0.0003029205147213668, 0.0018899503327594609},
    {-0.0018899503327594609, -0.0003029205147213668, 0.014952258337048231, 0.0038087520138906151, -0.049137179673607506, -0.027219029917056003, 0.051945838107709037, 0.3644418948353314, -0.77718575170052351, 0.48135965125837221, 0.061273359067658524, -0.14329423835080971, -0.0076074873249176054, 0.031695087811492981, 0.00054213233179114812, -0.0033824159510061256},
    {0.0018899503327594609, -0.0003029205147213668, -0.014952258337048231, 0.0038087520138906151, 0.049137179673607506, -0.027219029917056003, -0.051945838107709037, 0.3644418948353314, 0.77718575170052351, 0.48135965125837221, -0.061273359067658524, -0.14329423835080971, 0.0076074873249176054, 0.031695087811492981, -0.00054213233179114812, -0.0033824159510061256},
    {-0.0033824159510061256, 0.00054213233179114812, 0.031695087811492981, -0.0076074873249176054, -0.14329423835080971, 0.061273359067658524, 0.48135965125837221, -0.77718575170052351, 0.3644418948353314, 0.051945838107709037, -0.027219029917056003, -0.049137179673607506, 0.0038087520138906151, 0.014952258337048231, -0.0003029205147213668, -0.0018899503327594609}
};

static float sym9_float[][18] = {
    {0.0014009155259146807, 0.00061978088898558676, -0.013271967781817119, -0.01152821020767923, 0.03022487885827568, 0.00058346274612580684, -0.054568958430834071, 0.238760914607303, 0.717897082764412, 0.61733844914093583, 0.035272488035271894, -0.19155083129728512, -0.018233770779395985, 0.06207778930288603, 0.0088592674934004842, -0.010264064027633142, -0.00047315449868008311, 0.0010694900329086053},
    {-0.0010694900329086053, -0.00047315449868008311, 0.010264064027633142, 0.0088592674934004842, -0.06207778930288603, -0.018233770779395985, 0.19155083129728512, 0.035272488035271894, -0.61733844914093583, 0.717897082764412, -0.238760914607303, -0.054568958430834071, -0.00058346274612580684, 0.03022487885827568, 0.01152821020767923, -0.013271967781817119, -0.00061978088898558676, 0.0014009155259146807},
    {0.0010694900329086053, -0.00047315449868008311, -0.010264064027633142, 0.0088592674934004842, 0.06207778930288603, -0.018233770779395985, -0.19155083129728512, 0.035272488035271894, 0.61733844914093583, 0.717897082764412, 0.238760914607303, -0.054568958430834071, 0.00058346274612580684, 0.03022487885827568, -0.01152821020767923, -0.013271967781817119, 0.00061978088898558676, 0.0014009155259146807},
    {0.0014009155259146807, -0.00061978088898558676, -0.013271967781817119, 0.01152821020767923, 0.03022487885827568, -0.00058346274612580684, -0.054568958430834071, -0.238760914607303, 0.717897082764412, -0.61733844914093583, 0.035272488035271894, 0.19155083129728512, -0.018233770779395985, -0.06207778930288603, 0.0088592674934004842, 0.010264064027633142, -0.00047315449868008311, -0.0010694900329086053}
};

static float sym10_float[][20] = {
    {0.00077015980911449011, 9.5632670722894754e-005, -0.0086412992770224222, -0.0014653825813050513, 0.045927239231092203, 0.011609893903711381, -0.15949427888491757, -0.070880535783243853, 0.47169066693843925, 0.7695100370211071, 0.38382676106708546, -0.035536740473817552, -0.0319900568824278, 0.049994972077376687, 0.0057649120335819086, -0.02035493981231129, -0.00080435893201654491, 0.0045931735853118284, 5.7036083618494284e-005, -0.00045932942100465878},
    {0.00045932942100465878, 5.7036083618494284e-005, -0.0045931735853118284, -0.00080435893201654491, 0.02035493981231129, 0.0057649120335819086, -0.049994972077376687, -0.0319900568824278, 0.035536740473817552, 0.38382676106708546, -0.7695100370211071, 0.47169066693843925, 0.070880535783243853, -0.15949427888491757, -0.011609893903711381, 0.045927239231092203, 0.0014653825813050513, -0.0086412992770224222, -9.5632670722894754e-005, 0.00077015980911449011},
    {-0.00045932942100465878, 5.7036083618494284e-005, 0.0045931735853118284, -0.00080435893201654491, -0.02035493981231129, 0.0057649120335819086, 0.049994972077376687, -0.0319900568824278, -0.035536740473817552, 0.38382676106708546, 0.7695100370211071, 0.47169066693843925, -0.070880535783243853, -0.15949427888491757, 0.011609893903711381, 0.045927239231092203, -0.0014653825813050513, -0.0086412992770224222, 9.5632670722894754e-005, 0.00077015980911449011},
    {0.00077015980911449011, -9.5632670722894754e-005, -0.0086412992770224222, 0.0014653825813050513, 0.045927239231092203, -0.011609893903711381, -0.15949427888491757, 0.070880535783243853, 0.47169066693843925, -0.7695100370211071, 0.38382676106708546, 0.035536740473817552, -0.0319900568824278, -0.049994972077376687, 0.0057649120335819086, 0.02035493981231129, -0.00080435893201654491, -0.0045931735853118284, 5.7036083618494284e-005, 0.00045932942100465878}
};

static float sym11_float[][22] = {
    {0.00017172195069934854, -3.8795655736158566e-005, -0.0017343662672978692, 0.00058835273539699145, 0.0065124956747714497, -0.0098579348287897942, -0.024080841595864003, 0.0370374159788594, 0.069976799610734136, -0.022832651022562687, 0.097198394458909473, 0.57202297801008706, 0.73034354908839572, 0.23768990904924897, -0.2046547944958006, -0.14460234370531561, 0.035266759564466552, 0.043000190681552281, -0.0020034719001093887, -0.0063896036664548919, 0.00011053509764272153, 0.00048926361026192387},
    {-0.00048926361026192387, 0.00011053509764272153, 0.0063896036664548919, -0.0020034719001093887, -0.043000190681552281, 0.035266759564466552, 0.14460234370531561, -0.2046547944958006, -0.23768990904924897, 0.73034354908839572, -0.57202297801008706, 0.097198394458909473, 0.022832651022562687, 0.069976799610734136, -0.0370374159788594, -0.024080841595864003, 0.0098579348287897942, 0.0065124956747714497, -0.00058835273539699145, -0.0017343662672978692, 3.8795655736158566e-005, 0.00017172195069934854},
    {0.00048926361026192387, 0.00011053509764272153, -0.0063896036664548919, -0.0020034719001093887, 0.043000190681552281, 0.035266759564466552, -0.14460234370531561, -0.2046547944958006, 0.23768990904924897, 0.73034354908839572, 0.57202297801008706, 0.097198394458909473, -0.022832651022562687, 0.069976799610734136, 0.0370374159788594, -0.024080841595864003, -0.0098579348287897942, 0.0065124956747714497, 0.00058835273539699145, -0.0017343662672978692, -3.8795655736158566e-005, 0.00017172195069934854},
    {0.00017172195069934854, 3.8795655736158566e-005, -0.0017343662672978692, -0.00058835273539699145, 0.0065124956747714497, 0.0098579348287897942, -0.024080841595864003, -0.0370374159788594, 0.069976799610734136, 0.022832651022562687, 0.097198394458909473, -0.57202297801008706, 0.73034354908839572, -0.23768990904924897, -0.2046547944958006, 0.14460234370531561, 0.035266759564466552, -0.043000190681552281, -0.0020034719001093887, 0.0063896036664548919, 0.00011053509764272153, -0.00048926361026192387}
};

static float sym12_float[][24] = {
    {0.00011196719424656033, -1.1353928041541452e-005, -0.0013497557555715387, 0.00018021409008538188, 0.007414965517654251, -0.0014089092443297553, -0.024220722675013445, 0.0075537806116804775, 0.049179318299660837, -0.035848830736954392, -0.022162306170337816, 0.39888597239022, 0.76347909778365719, 0.46274103121927235, -0.07833262231634322, -0.17037069723886492, 0.01530174062247884, 0.057804179445505657, -0.0026043910313322326, -0.014589836449234145, 0.00030764779631059454, 0.0023502976141834648, -1.8158078862617515e-005, -0.00017906658697508691},
    {0.00017906658697508691, -1.8158078862617515e-005, -0.0023502976141834648, 0.00030764779631059454, 0.014589836449234145, -0.0026043910313322326, -0.057804179445505657, 0.01530174062247884, 0.17037069723886492, -0.07833262231634322, -0.46274103121927235, 0.76347909778365719, -0.39888597239022, -0.022162306170337816, 0.035848830736954392, 0.049179318299660837, -0.0075537806116804775, -0.024220722675013445, 0.0014089092443297553, 0.007414965517654251, -0.00018021409008538188, -0.0013497557555715387, 1.1353928041541452e-005, 0.00011196719424656033},
    {-0.00017906658697508691, -1.8158078862617515e-005, 0.0023502976141834648, 0.00030764779631059454, -0.014589836449234145, -0.0026043910313322326, 0.057804179445505657, 0.01530174062247884, -0.17037069723886492, -0.07833262231634322, 0.46274103121927235, 0.76347909778365719, 0.39888597239022, -0.022162306170337816, -0.035848830736954392, 0.049179318299660837, 0.0075537806116804775, -0.024220722675013445, -0.0014089092443297553, 0.007414965517654251, 0.00018021409008538188, -0.0013497557555715387, -1.1353928041541452e-005, 0.00011196719424656033},
    {0.00011196719424656033, 1.1353928041541452e-005, -0.0013497557555715387, -0.00018021409008538188, 0.007414965517654251, 0.0014089092443297553, -0.024220722675013445, -0.0075537806116804775, 0.049179318299660837, 0.035848830736954392, -0.022162306170337816, -0.39888597239022, 0.76347909778365719, -0.46274103121927235, -0.07833262231634322, 0.17037069723886492, 0.01530174062247884, -0.057804179445505657, -0.0026043910313322326, 0.014589836449234145, 0.00030764779631059454, -0.0023502976141834648, -1.8158078862617515e-005, 0.00017906658697508691}
};

static float sym13_float[][26] = {
    {6.8203252630753188e-005, -3.5738623648689009e-005, -0.0011360634389281183, -0.00017094285853022211, 0.0075262253899680996, 0.0052963597387250252, -0.02021676813338983, -0.017211642726299048, 0.013862497435849205, -0.059750627717943698, -0.12436246075153011, 0.19770481877117801, 0.69573915056149638, 0.64456438390118564, 0.11023022302137217, -0.14049009311363403, 0.0088197576704205465, 0.092926030899137119, 0.017618296880653084, -0.020749686325515677, -0.0014924472742598532, 0.0056748537601224395, 0.00041326119884196064, -0.0007213643851362283, 3.6905373423196241e-005, 7.0429866906944016e-005},
    {-7.0429866906944016e-005, 3.6905373423196241e-005, 0.0007213643851362283, 0.00041326119884196064, -0.0056748537601224395, -0.0014924472742598532, 0.020749686325515677, 0.017618296880653084, -0.092926030899137119, 0.0088197576704205465, 0.14049009311363403, 0.11023022302137217, -0.64456438390118564, 0.69573915056149638, -0.19770481877117801, -0.12436246075153011, 0.059750627717943698, 0.013862497435849205, 0.017211642726299048, -0.02021676813338983, -0.0052963597387250252, 0.0075262253899680996, 0.00017094285853022211, -0.0011360634389281183, 3.5738623648689009e-005, 6.8203252630753188e-005},
    {7.0429866906944016e-005, 3.6905373423196241e-005, -0.0007213643851362283, 0.00041326119884196064, 0.0056748537601224395, -0.0014924472742598532, -0.020749686325515677, 0.017618296880653084, 0.092926030899137119, 0.0088197576704205465, -0.14049009311363403, 0.11023022302137217, 0.64456438390118564, 0.69573915056149638, 0.19770481877117801, -0.12436246075153011, -0.059750627717943698, 0.013862497435849205, -0.017211642726299048, -0.02021676813338983, 0.0052963597387250252, 0.0075262253899680996, -0.00017094285853022211, -0.0011360634389281183, -3.5738623648689009e-005, 6.8203252630753188e-005},
    {6.8203252630753188e-005, 3.5738623648689009e-005, -0.0011360634389281183, 0.00017094285853022211, 0.0075262253899680996, -0.0052963597387250252, -0.02021676813338983, 0.017211642726299048, 0.013862497435849205, 0.059750627717943698, -0.12436246075153011, -0.19770481877117801, 0.69573915056149638, -0.64456438390118564, 0.11023022302137217, 0.14049009311363403, 0.0088197576704205465, -0.092926030899137119, 0.017618296880653084, 0.020749686325515677, -0.0014924472742598532, -0.0056748537601224395, 0.00041326119884196064, 0.0007213643851362283, 3.6905373423196241e-005, -7.0429866906944016e-005}
};

static float sym14_float[][28] = {
    {-2.5879090265397886e-005, 1.1210865808890361e-005, 0.00039843567297594335, -6.2865424814776362e-005, -0.002579441725933078, 0.00036647657366011829, 0.010037693717672269, -0.0027537747912240711, -0.029196217764038187, 0.0042805204990193782, 0.037433088362853452, -0.057634498351326995, -0.035318112114979733, 0.39320152196208885, 0.75997624196109093, 0.47533576263420663, -0.058111823317717831, -0.15999741114652205, 0.025898587531046669, 0.069827616361807551, -0.0023650488367403851, -0.019439314263626713, 0.0010131419871842082, 0.0045326774719456481, -7.3214213567023991e-005, -0.00060576018246643346, 1.9329016965523917e-005, 4.4618977991475265e-005},
    {-4.4618977991475265e-005, 1.9329016965523917e-005, 0.00060576018246643346, -7.3214213567023991e-005, -0.0045326774719456481, 0.0010131419871842082, 0.019439314263626713, -0.0023650488367403851, -0.069827616361807551, 0.025898587531046669, 0.15999741114652205, -0.058111823317717831, -0.47533576263420663, 0.75997624196109093, -0.39320152196208885, -0.035318112114979733, 0.057634498351326995, 0.037433088362853452, -0.0042805204990193782, -0.029196217764038187, 0.0027537747912240711, 0.010037693717672269, -0.00036647657366011829, -0.002579441725933078, 6.2865424814776362e-005, 0.00039843567297594335, -1.1210865808890361e-005, -2.5879090265397886e-005},
    {4.4618977991475265e-005, 1.9329016965523917e-005, -0.00060576018246643346, -7.3214213567023991e-005, 0.0045326774719456481, 0.0010131419871842082, -0.019439314263626713, -0.0023650488367403851, 0.069827616361807551, 0.025898587531046669, -0.15999741114652205, -0.058111823317717831, 0.47533576263420663, 0.75997624196109093, 0.39320152196208885, -0.035318112114979733, -0.057634498351326995, 0.037433088362853452, 0.0042805204990193782, -0.029196217764038187, -0.0027537747912240711, 0.010037693717672269, 0.00036647657366011829, -0.002579441725933078, -6.2865424814776362e-005, 0.00039843567297594335, 1.1210865808890361e-005, -2.5879090265397886e-005},
    {-2.5879090265397886e-005, -1.1210865808890361e-005, 0.00039843567297594335, 6.2865424814776362e-005, -0.002579441725933078, -0.00036647657366011829, 0.010037693717672269, 0.0027537747912240711, -0.029196217764038187, -0.0042805204990193782, 0.037433088362853452, 0.057634498351326995, -0.035318112114979733, -0.39320152196208885, 0.75997624196109093, -0.47533576263420663, -0.058111823317717831, 0.15999741114652205, 0.025898587531046669, -0.069827616361807551, -0.0023650488367403851, 0.019439314263626713, 0.0010131419871842082, -0.0045326774719456481, -7.3214213567023991e-005, 0.00060576018246643346, 1.9329016965523917e-005, -4.4618977991475265e-005}
};

static float sym15_float[][30] = {
    {9.7124197379633478e-006, -7.3596667989194696e-006, -0.00016066186637495343, 5.5122547855586653e-005, 0.0010705672194623959, -0.00026731644647180568, -0.0035901654473726417, 0.003423450736351241, 0.010079977087905669, -0.019405011430934468, -0.038876716876833493, 0.021937642719753955, 0.040735479696810677, -0.04108266663538248, 0.11153369514261872, 0.57864041521503451, 0.72184302963618119, 0.2439627054321663, -0.1966263587662373, -0.13405629845625389, 0.068393310060480245, 0.067969829044879179, -0.0087447888864779517, -0.017171252781638731, 0.0015261382781819983, 0.003481028737064895, -0.00010815440168545525, -0.00040216853760293483, 2.1717890150778919e-005, 2.8660708525318081e-005},
    {-2.8660708525318081e-005, 2.1717890150778919e-005, 0.00040216853760293483, -0.00010815440168545525, -0.003481028737064895, 0.0015261382781819983, 0.017171252781638731, -0.0087447888864779517, -0.067969829044879179, 0.068393310060480245, 0.13405629845625389, -0.1966263587662373, -0.2439627054321663, 0.72184302963618119, -0.57864041521503451, 0.11153369514261872, 0.04108266663538248, 0.040735479696810677, -0.021937642719753955, -0.038876716876833493, 0.019405011430934468, 0.010079977087905669, -0.003423450736351241, -0.0035901654473726417, 0.00026731644647180568, 0.0010705672194623959, -5.5122547855586653e-005, -0.00016066186637495343, 7.3596667989194696e-006, 9.7124197379633478e-006},
    {2.8660708525318081e-005, 2.1717890150778919e-005, -0.00040216853760293483, -0.00010815440168545525, 0.003481028737064895, 0.0015261382781819983, -0.017171252781638731, -0.0087447888864779517, 0.067969829044879179, 0.068393310060480245, -0.13405629845625389, -0.1966263587662373, 0.2439627054321663, 0.72184302963618119, 0.57864041521503451, 0.11153369514261872, -0.04108266663538248, 0.040735479696810677, 0.021937642719753955, -0.038876716876833493, -0.019405011430934468, 0.010079977087905669, 0.003423450736351241, -0.0035901654473726417, -0.00026731644647180568, 0.0010705672194623959, 5.5122547855586653e-005, -0.00016066186637495343, -7.3596667989194696e-006, 9.7124197379633478e-006},
    {9.7124197379633478e-006, 7.3596667989194696e-006, -0.00016066186637495343, -5.5122547855586653e-005, 0.0010705672194623959, 0.00026731644647180568, -0.0035901654473726417, -0.003423450736351241, 0.010079977087905669, 0.019405011430934468, -0.038876716876833493, -0.021937642719753955, 0.040735479696810677, 0.04108266663538248, 0.11153369514261872, -0.57864041521503451, 0.72184302963618119, -0.2439627054321663, -0.1966263587662373, 0.13405629845625389, 0.068393310060480245, -0.067969829044879179, -0.0087447888864779517, 0.017171252781638731, 0.0015261382781819983, -0.003481028737064895, -0.00010815440168545525, 0.00040216853760293483, 2.1717890150778919e-005, -2.8660708525318081e-005}
};

static float sym16_float[][32] = {
    {6.2300067012207606e-006, -3.1135564076219692e-006, -0.00010943147929529757, 2.8078582128442894e-005, 0.00085235471080470952, -0.0001084456223089688, -0.0038809122526038786, 0.00071821197883178923, 0.012666731659857348, -0.0031265171722710075, -0.031051202843553064, 0.0048692744049046071, 0.032333091610663785, -0.066983049070217779, -0.034574228416972504, 0.39712293362064416, 0.75652498787569711, 0.47534280601152273, -0.054040601387606135, -0.15959219218520598, 0.03072113906330156, 0.078037852903419913, -0.0035102750683740089, -0.024952758046290123, 0.001359844742484172, 0.0069377611308027096, -0.00022211647621176323, -0.0013387206066921965, 3.656592483348223e-005, 0.00016545679579108483, -5.3964831793152419e-006, -1.0797982104319795e-005},
    {1.0797982104319795e-005, -5.3964831793152419e-006, -0.00016545679579108483, 3.656592483348223e-005, 0.0013387206066921965, -0.00022211647621176323, -0.0069377611308027096, 0.001359844742484172, 0.024952758046290123, -0.0035102750683740089, -0.078037852903419913, 0.03072113906330156, 0.15959219218520598, -0.054040601387606135, -0.47534280601152273, 0.75652498787569711, -0.39712293362064416, -0.034574228416972504, 0.066983049070217779, 0.032333091610663785, -0.0048692744049046071, -0.031051202843553064, 0.0031265171722710075, 0.012666731659857348, -0.00071821197883178923, -0.0038809122526038786, 0.0001084456223089688, 0.00085235471080470952, -2.8078582128442894e-005, -0.00010943147929529757, 3.1135564076219692e-006, 6.2300067012207606e-006},
    {-1.0797982104319795e-005, -5.3964831793152419e-006, 0.00016545679579108483, 3.656592483348223e-005, -0.0013387206066921965, -0.00022211647621176323, 0.0069377611308027096, 0.001359844742484172, -0.024952758046290123, -0.0035102750683740089, 0.078037852903419913, 0.03072113906330156, -0.15959219218520598, -0.054040601387606135, 0.47534280601152273, 0.75652498787569711, 0.39712293362064416, -0.034574228416972504, -0.066983049070217779, 0.032333091610663785, 0.0048692744049046071, -0.031051202843553064, -0.0031265171722710075, 0.012666731659857348, 0.00071821197883178923, -0.0038809122526038786, -0.0001084456223089688, 0.00085235471080470952, 2.8078582128442894e-005, -0.00010943147929529757, -3.1135564076219692e-006, 6.2300067012207606e-006},
    {6.2300067012207606e-006, 3.1135564076219692e-006, -0.00010943147929529757, -2.8078582128442894e-005, 0.00085235471080470952, 0.0001084456223089688, -0.0038809122526038786, -0.00071821197883178923, 0.012666731659857348, 0.0031265171722710075, -0.031051202843553064, -0.0048692744049046071, 0.032333091610663785, 0.066983049070217779, -0.034574228416972504, -0.39712293362064416, 0.75652498787569711, -0.47534280601152273, -0.054040601387606135, 0.15959219218520598, 0.03072113906330156, -0.078037852903419913, -0.0035102750683740089, 0.024952758046290123, 0.001359844742484172, -0.0069377611308027096, -0.00022211647621176323, 0.0013387206066921965, 3.656592483348223e-005, -0.00016545679579108483, -5.3964831793152419e-006, 1.0797982104319795e-005}
};

static float sym17_float[][34] = {
    {4.297343327345983e-006, 2.7801266938414138e-006, -6.2937025975541919e-005, -1.3506383399901165e-005, 0.0004759963802638669, -0.00013864230268045499, -0.0027416759756816018, 0.0008567700701915741, 0.010482366933031529, -0.0048192128031761478, -0.033291383492359328, 0.017903952214341119, 0.10475461484223211, 0.0172711782105185, -0.11856693261143636, 0.14239835041467819, 0.65071662920454565, 0.68148899534492502, 0.18053958458111286, -0.15507600534974825, -0.086070874720733381, 0.016158808725919346, -0.0072616347509287674, -0.01803889724191924, 0.0099529825235095976, 0.012396988366648726, -0.0019054076898526659, -0.0039323252797979023, 5.8400428694052584e-005, 0.0007198270642148971, 2.5207933140828779e-005, -7.6071244056051285e-005, -2.4527163425832999e-006, 3.7912531943321266e-006},
    {-3.7912531943321266e-006, -2.4527163425832999e-006, 7.6071244056051285e-005, 2.5207933140828779e-005, -0.0007198270642148971, 5.8400428694052584e-005, 0.0039323252797979023, -0.0019054076898526659, -0.012396988366648726, 0.0099529825235095976, 0.01803889724191924, -0.0072616347509287674, -0.016158808725919346, -0.086070874720733381, 0.15507600534974825, 0.18053958458111286, -0.68148899534492502, 0.65071662920454565, -0.14239835041467819, -0.11856693261143636, -0.0172711782105185, 0.10475461484223211, -0.017903952214341119, -0.033291383492359328, 0.0048192128031761478, 0.010482366933031529, -0.0008567700701915741, -0.0027416759756816018, 0.00013864230268045499, 0.0004759963802638669, 1.3506383399901165e-005, -6.2937025975541919e-005, -2.7801266938414138e-006, 4.297343327345983e-006},
    {3.7912531943321266e-006, -2.4527163425832999e-006, -7.6071244056051285e-005, 2.5207933140828779e-005, 0.0007198270642148971, 5.8400428694052584e-005, -0.0039323252797979023, -0.0019054076898526659, 0.012396988366648726, 0.0099529825235095976, -0.01803889724191924, -0.0072616347509287674, 0.016158808725919346, -0.086070874720733381, -0.15507600534974825, 0.18053958458111286, 0.68148899534492502, 0.65071662920454565, 0.14239835041467819, -0.11856693261143636, 0.0172711782105185, 0.10475461484223211, 0.017903952214341119, -0.033291383492359328, -0.0048192128031761478, 0.010482366933031529, 0.0008567700701915741, -0.0027416759756816018, -0.00013864230268045499, 0.0004759963802638669, -1.3506383399901165e-005, -6.2937025975541919e-005, 2.7801266938414138e-006, 4.297343327345983e-006},
    {4.297343327345983e-006, -2.7801266938414138e-006, -6.2937025975541919e-005, 1.3506383399901165e-005, 0.0004759963802638669, 0.00013864230268045499, -0.0027416759756816018, -0.0008567700701915741, 0.010482366933031529, 0.0048192128031761478, -0.033291383492359328, -0.017903952214341119, 0.10475461484223211, -0.0172711782105185, -0.11856693261143636, -0.14239835041467819, 0.65071662920454565, -0.68148899534492502, 0.18053958458111286, 0.15507600534974825, -0.086070874720733381, -0.016158808725919346, -0.0072616347509287674, 0.01803889724191924, 0.0099529825235095976, -0.012396988366648726, -0.0019054076898526659, 0.0039323252797979023, 5.8400428694052584e-005, -0.0007198270642148971, 2.5207933140828779e-005, 7.6071244056051285e-005, -2.4527163425832999e-006, -3.7912531943321266e-006}
};

static float sym18_float[][36] = {
    {2.6126125564836423e-006, 1.354915761832114e-006, -4.5246757874949856e-005, -1.4020992577726755e-005, 0.00039616840638254753, 7.0212734590362685e-005, -0.0023138718145060992, -0.00041152110923597756, 0.0095021643909623654, 0.0016429863972782159, -0.030325091089369604, -0.0050770851607570529, 0.084219929970386548, 0.033995667103947358, -0.15993814866932407, -0.052029158983952786, 0.47396905989393956, 0.75362914010179283, 0.40148386057061813, -0.032480573290138676, -0.073799207290607169, 0.028529597039037808, 0.0062779445543116943, -0.031712684731814537, -0.0032607442000749834, 0.015012356344250213, 0.0010877847895956929, -0.0052397896830266083, -0.00018877623940755607, 0.0014280863270832796, 4.7416145183736671e-005, -0.00026583011024241041, -9.858816030140058e-006, 2.9557437620930811e-005, 7.8472980558317646e-007, -1.5131530692371587e-006},
    {1.5131530692371587e-006, 7.8472980558317646e-007, -2.9557437620930811e-005, -9.858816030140058e-006, 0.00026583011024241041, 4.7416145183736671e-005, -0.0014280863270832796, -0.00018877623940755607, 0.0052397896830266083, 0.0010877847895956929, -0.015012356344250213, -0.0032607442000749834, 0.031712684731814537, 0.0062779445543116943, -0.028529597039037808, -0.073799207290607169, 0.032480573290138676, 0.40148386057061813, -0.75362914010179283, 0.47396905989393956, 0.052029158983952786, -0.15993814866932407, -0.033995667103947358, 0.084219929970386548, 0.0050770851607570529, -0.030325091089369604, -0.0016429863972782159, 0.0095021643909623654, 0.00041152110923597756, -0.0023138718145060992, -7.0212734590362685e-005, 0.00039616840638254753, 1.4020992577726755e-005, -4.5246757874949856e-005, -1.354915761832114e-006, 2.6126125564836423e-006},
    {-1.5131530692371587e-006, 7.8472980558317646e-007, 2.9557437620930811e-005, -9.858816030140058e-006, -0.00026583011024241041, 4.7416145183736671e-005, 0.0014280863270832796, -0.00018877623940755607, -0.0052397896830266083, 0.0010877847895956929, 0.015012356344250213, -0.0032607442000749834, -0.031712684731814537, 0.0062779445543116943, 0.028529597039037808, -0.073799207290607169, -0.032480573290138676, 0.40148386057061813, 0.75362914010179283, 0.47396905989393956, -0.052029158983952786, -0.15993814866932407, 0.033995667103947358, 0.084219929970386548, -0.0050770851607570529, -0.030325091089369604, 0.0016429863972782159, 0.0095021643909623654, -0.00041152110923597756, -0.0023138718145060992, 7.0212734590362685e-005, 0.00039616840638254753, -1.4020992577726755e-005, -4.5246757874949856e-005, 1.354915761832114e-006, 2.6126125564836423e-006},
    {2.6126125564836423e-006, -1.354915761832114e-006, -4.5246757874949856e-005, 1.4020992577726755e-005, 0.00039616840638254753, -7.0212734590362685e-005, -0.0023138718145060992, 0.00041152110923597756, 0.0095021643909623654, -0.0016429863972782159, -0.030325091089369604, 0.0050770851607570529, 0.084219929970386548, -0.033995667103947358, -0.15993814866932407, 0.052029158983952786, 0.47396905989393956, -0.75362914010179283, 0.40148386057061813, 0.032480573290138676, -0.073799207290607169, -0.028529597039037808, 0.0062779445543116943, 0.031712684731814537, -0.0032607442000749834, -0.015012356344250213, 0.0010877847895956929, 0.0052397896830266083, -0.00018877623940755607, -0.0014280863270832796, 4.7416145183736671e-005, 0.00026583011024241041, -9.858816030140058e-006, -2.9557437620930811e-005, 7.8472980558317646e-007, 1.5131530692371587e-006}
};

static float sym19_float[][38] = {
    {5.4877327682158382e-007, -6.4636513033459633e-007, -1.1880518269823984e-005, 8.8733121737292863e-006, 0.0001155392333357879, -4.6120396002105868e-005, -0.00063576451500433403, 0.00015915804768084938, 0.0021214250281823303, -0.0011607032572062486, -0.005122205002583014, 0.0079684383206133063, 0.015797439295674631, -0.022651993378245951, -0.046635983534938946, 0.0070155738571741596, 0.0089545911730436242, -0.067525058040294086, 0.10902582508127781, 0.57814494533860505, 0.71955552571639425, 0.25826616923728363, -0.17659686625203097, -0.11624173010739675, 0.093630843415897141, 0.084072676279245043, -0.016908234861345205, -0.027709896931311252, 0.0043193518748949689, 0.0082622369555282547, -0.00061792232779831076, -0.0017049602611649971, 0.00012930767650701415, 0.00027621877685734072, -1.6821387029373716e-005, -2.8151138661550245e-005, 2.0623170632395688e-006, 1.7509367995348687e-006},
    {-1.7509367995348687e-006, 2.0623170632395688e-006, 2.8151138661550245e-005, -1.6821387029373716e-005, -0.00027621877685734072, 0.00012930767650701415, 0.0017049602611649971, -0.00061792232779831076, -0.0082622369555282547, 0.0043193518748949689, 0.027709896931311252, -0.016908234861345205, -0.084072676279245043, 0.093630843415897141, 0.11624173010739675, -0.17659686625203097, -0.25826616923728363, 0.71955552571639425, -0.57814494533860505, 0.10902582508127781, 0.067525058040294086, 0.0089545911730436242, -0.0070155738571741596, -0.046635983534938946, 0.022651993378245951, 0.015797439295674631, -0.0079684383206133063, -0.005122205002583014, 0.0011607032572062486, 0.0021214250281823303, -0.00015915804768084938, -0.00063576451500433403, 4.6120396002105868e-005, 0.0001155392333357879, -8.8733121737292863e-006, -1.1880518269823984e-005, 6.4636513033459633e-007, 5.4877327682158382e-007},
    {1.7509367995348687e-006, 2.0623170632395688e-006, -2.8151138661550245e-005, -1.6821387029373716e-005, 0.00027621877685734072, 0.00012930767650701415, -0.0017049602611649971, -0.00061792232779831076, 0.0082622369555282547, 0.0043193518748949689, -0.027709896931311252, -0.016908234861345205, 0.084072676279245043, 0.093630843415897141, -0.11624173010739675, -0.17659686625203097, 0.25826616923728363, 0.71955552571639425, 0.57814494533860505, 0.10902582508127781, -0.067525058040294086, 0.0089545911730436242, 0.0070155738571741596, -0.046635983534938946, -0.022651993378245951, 0.015797439295674631, 0.0079684383206133063, -0.005122205002583014, -0.0011607032572062486, 0.0021214250281823303, 0.00015915804768084938, -0.00063576451500433403, -4.6120396002105868e-005, 0.0001155392333357879, 8.8733121737292863e-006, -1.1880518269823984e-005, -6.4636513033459633e-007, 5.4877327682158382e-007},
    {5.4877327682158382e-007, 6.4636513033459633e-007, -1.1880518269823984e-005, -8.8733121737292863e-006, 0.0001155392333357879, 4.6120396002105868e-005, -0.00063576451500433403, -0.00015915804768084938, 0.0021214250281823303, 0.0011607032572062486, -0.005122205002583014, -0.0079684383206133063, 0.015797439295674631, 0.022651993378245951, -0.046635983534938946, -0.0070155738571741596, 0.0089545911730436242, 0.067525058040294086, 0.10902582508127781, -0.57814494533860505, 0.71955552571639425, -0.25826616923728363, -0.17659686625203097, 0.11624173010739675, 0.093630843415897141, -0.084072676279245043, -0.016908234861345205, 0.027709896931311252, 0.0043193518748949689, -0.0082622369555282547, -0.00061792232779831076, 0.0017049602611649971, 0.00012930767650701415, -0.00027621877685734072, -1.6821387029373716e-005, 2.8151138661550245e-005, 2.0623170632395688e-006, -1.7509367995348687e-006}
};

static float sym20_float[][40] = {
    {3.695537474835221e-007, -1.9015675890554106e-007, -7.919361411976999e-006, 3.0256660627369661e-006, 7.992967835772481e-005, -1.928412300645204e-005, -0.00049473109156726548, 7.2159911880740349e-005, 0.0020889947081901982, -0.0003052628317957281, -0.0066065857990888609, 0.0014230873594621453, 0.017004049023390339, -0.0033138573836233591, -0.031629437144957966, 0.0081232283560096815, 0.025579349509413946, -0.078994344928398158, -0.029819368880333728, 0.40583144434845059, 0.75116272842273002, 0.47199147510148703, -0.051088342921067398, -0.16057829841525254, 0.036250951653933078, 0.088919668028199561, -0.0068437019650692274, -0.035373336756604236, 0.0019385970672402002, 0.012157040948785737, -0.0006111263857992088, -0.0034716478028440734, 0.00012544091723067259, 0.00074761085978205719, -2.6615550335516086e-005, -0.00011739133516291466, 4.5254222091516362e-006, 1.22872527779612e-005, -3.2567026420174407e-007, -6.3291290447763946e-007},
    {6.3291290447763946e-007, -3.2567026420174407e-007, -1.22872527779612e-005, 4.5254222091516362e-006, 0.00011739133516291466, -2.6615550335516086e-005, -0.00074761085978205719, 0.00012544091723067259, 0.0034716478028440734, -0.0006111263857992088, -0.012157040948785737, 0.0019385970672402002, 0.035373336756604236, -0.0068437019650692274, -0.088919668028199561, 0.036250951653933078, 0.16057829841525254, -0.051088342921067398, -0.47199147510148703, 0.75116272842273002, -0.40583144434845059, -0.029819368880333728, 0.078994344928398158, 0.025579349509413946, -0.0081232283560096815, -0.031629437144957966, 0.0033138573836233591, 0.017004049023390339, -0.0014230873594621453, -0.0066065857990888609, 0.0003052628317957281, 0.0020889947081901982, -7.2159911880740349e-005, -0.00049473109156726548, 1.928412300645204e-005, 7.992967835772481e-005, -3.0256660627369661e-006, -7.919361411976999e-006, 1.9015675890554106e-007, 3.695537474835221e-007},
    {-6.3291290447763946e-007, -3.2567026420174407e-007, 1.22872527779612e-005, 4.5254222091516362e-006, -0.00011739133516291466, -2.6615550335516086e-005, 0.00074761085978205719, 0.00012544091723067259, -0.0034716478028440734, -0.0006111263857992088, 0.012157040948785737, 0.0019385970672402002, -0.035373336756604236, -0.0068437019650692274, 0.088919668028199561, 0.036250951653933078, -0.16057829841525254, -0.051088342921067398, 0.47199147510148703, 0.75116272842273002, 0.40583144434845059, -0.029819368880333728, -0.078994344928398158, 0.025579349509413946, 0.0081232283560096815, -0.031629437144957966, -0.0033138573836233591, 0.017004049023390339, 0.0014230873594621453, -0.0066065857990888609, -0.0003052628317957281, 0.0020889947081901982, 7.2159911880740349e-005, -0.00049473109156726548, -1.928412300645204e-005, 7.992967835772481e-005, 3.0256660627369661e-006, -7.919361411976999e-006, -1.9015675890554106e-007, 3.695537474835221e-007},
    {3.695537474835221e-007, 1.9015675890554106e-007, -7.919361411976999e-006, -3.0256660627369661e-006, 7.992967835772481e-005, 1.928412300645204e-005, -0.00049473109156726548, -7.2159911880740349e-005, 0.0020889947081901982, 0.0003052628317957281, -0.0066065857990888609, -0.0014230873594621453, 0.017004049023390339, 0.0033138573836233591, -0.031629437144957966, -0.0081232283560096815, 0.025579349509413946, 0.078994344928398158, -0.029819368880333728, -0.40583144434845059, 0.75116272842273002, -0.47199147510148703, -0.051088342921067398, 0.16057829841525254, 0.036250951653933078, -0.088919668028199561, -0.0068437019650692274, 0.035373336756604236, 0.0019385970672402002, -0.012157040948785737, -0.0006111263857992088, 0.0034716478028440734, 0.00012544091723067259, -0.00074761085978205719, -2.6615550335516086e-005, 0.00011739133516291466, 4.5254222091516362e-006, -1.22872527779612e-005, -3.2567026420174407e-007, 6.3291290447763946e-007}
};

static float coif1_float[][6] = {
    {-0.01565572813546454, -0.072732619512853897, 0.38486484686420286, 0.85257202021225542, 0.33789766245780922, -0.072732619512853897},
    {0.072732619512853897, 0.33789766245780922, -0.85257202021225542, 0.38486484686420286, 0.072732619512853897, -0.01565572813546454},
    {-0.072732619512853897, 0.33789766245780922, 0.85257202021225542, 0.38486484686420286, -0.072732619512853897, -0.01565572813546454},
    {-0.01565572813546454, 0.072732619512853897, 0.38486484686420286, -0.85257202021225542, 0.33789766245780922, 0.072732619512853897}
};

static float coif2_float[][12] = {
    {-0.00072054944536451221, -0.0018232088707029932, 0.0056114348193944995, 0.023680171946334084, -0.059434418646456898, -0.076488599078306393, 0.41700518442169254, 0.81272363544554227, 0.38611006682116222, -0.067372554721963018, -0.041464936781759151, 0.016387336463522112},
    {-0.016387336463522112, -0.041464936781759151, 0.067372554721963018, 0.38611006682116222, -0.81272363544554227, 0.41700518442169254, 0.076488599078306393, -0.059434418646456898, -0.023680171946334084, 0.0056114348193944995, 0.0018232088707029932, -0.00072054944536451221},
    {0.016387336463522112, -0.041464936781759151, -0.067372554721963018, 0.38611006682116222, 0.81272363544554227, 0.41700518442169254, -0.076488599078306393, -0.059434418646456898, 0.023680171946334084, 0.0056114348193944995, -0.0018232088707029932, -0.00072054944536451221},
    {-0.00072054944536451221, 0.0018232088707029932, 0.0056114348193944995, -0.023680171946334084, -0.059434418646456898, 0.076488599078306393, 0.41700518442169254, -0.81272363544554227, 0.38611006682116222, 0.067372554721963018, -0.041464936781759151, -0.016387336463522112}
};

static float coif3_float[][18] = {
    {-3.4599772836212559e-005, -7.0983303138141252e-005, 0.00046621696011288631, 0.0011175187708906016, -0.0025745176887502236, -0.0090079761366615805, 0.015880544863615904, 0.034555027573061628, -0.082301927106885983, -0.071799821619312018, 0.42848347637761874, 0.79377722262562056, 0.4051769024096169, -0.061123390002672869, -0.0657719112818555, 0.023452696141836267, 0.0077825964273254182, -0.0037935128644910141},
    {0.0037935128644910141, 0.0077825964273254182, -0.023452696141836267, -0.0657719112818555, 0.061123390002672869, 0.4051769024096169, -0.79377722262562056, 0.42848347637761874, 0.071799821619312018, -0.082301927106885983, -0.034555027573061628, 0.015880544863615904, 0.0090079761366615805, -0.0025745176887502236, -0.0011175187708906016, 0.00046621696011288631, 7.0983303138141252e-005, -3.4599772836212559e-005},
    {-0.0037935128644910141, 0.0077825964273254182, 0.023452696141836267, -0.0657719112818555, -0.061123390002672869, 0.4051769024096169, 0.79377722262562056, 0.42848347637761874, -0.071799821619312018, -0.082301927106885983, 0.034555027573061628, 0.015880544863615904, -0.0090079761366615805, -0.0025745176887502236, 0.0011175187708906016, 0.00046621696011288631, -7.0983303138141252e-005, -3.4599772836212559e-005},
    {-3.4599772836212559e-005, 7.0983303138141252e-005, 0.00046621696011288631, -0.0011175187708906016, -0.0025745176887502236, 0.0090079761366615805, 0.015880544863615904, -0.034555027573061628, -0.082301927106885983, 0.071799821619312018, 0.42848347637761874, -0.79377722262562056, 0.4051769024096169, 0.061123390002672869, -0.0657719112818555, -0.023452696141836267, 0.0077825964273254182, 0.0037935128644910141}
};

static float coif4_float[][24] = {
    {-1.7849850030882614e-006, -3.2596802368833675e-006, 3.1229875865345646e-005, 6.2339034461007128e-005, -0.00025997455248771324, -0.00058902075624433831, 0.0012665619292989445, 0.0037514361572784571, -0.0056582866866107199, -0.015211731527946259, 0.025082261844864097, 0.039334427123337491, -0.096220442033987982, -0.066627474263425038, 0.4343860564914685, 0.78223893092049901, 0.41530840703043026, -0.056077313316754807, -0.081266699680878754, 0.026682300156053072, 0.016068943964776348, -0.0073461663276420935, -0.0016294920126017326, 0.00089231366858231456},
    {-0.00089231366858231456, -0.0016294920126017326, 0.0073461663276420935, 0.016068943964776348, -0.026682300156053072, -0.081266699680878754, 0.056077313316754807, 0.41530840703043026, -0.78223893092049901, 0.4343860564914685, 0.066627474263425038, -0.096220442033987982, -0.039334427123337491, 0.025082261844864097, 0.015211731527946259, -0.0056582866866107199, -0.0037514361572784571, 0.0012665619292989445, 0.00058902075624433831, -0.00025997455248771324, -6.2339034461007128e-005, 3.1229875865345646e-005, 3.2596802368833675e-006, -1.7849850030882614e-006},
    {0.00089231366858231456, -0.0016294920126017326, -0.0073461663276420935, 0.016068943964776348, 0.026682300156053072, -0.081266699680878754, -0.056077313316754807, 0.41530840703043026, 0.78223893092049901, 0.4343860564914685, -0.066627474263425038, -0.096220442033987982, 0.039334427123337491, 0.025082261844864097, -0.015211731527946259, -0.0056582866866107199, 0.0037514361572784571, 0.0012665619292989445, -0.00058902075624433831, -0.00025997455248771324, 6.2339034461007128e-005, 3.1229875865345646e-005, -3.2596802368833675e-006, -1.7849850030882614e-006},
    {-1.7849850030882614e-006, 3.2596802368833675e-006, 3.1229875865345646e-005, -6.2339034461007128e-005, -0.00025997455248771324, 0.00058902075624433831, 0.0012665619292989445, -0.0037514361572784571, -0.0056582866866107199, 0.015211731527946259, 0.025082261844864097, -0.039334427123337491, -0.096220442033987982, 0.066627474263425038, 0.4343860564914685, -0.78223893092049901, 0.41530840703043026, 0.056077313316754807, -0.081266699680878754, -0.026682300156053072, 0.016068943964776348, 0.0073461663276420935, -0.0016294920126017326, -0.00089231366858231456}
};

static float coif5_float[][30] = {
    {-9.517657273819165e-008, -1.6744288576823017e-007, 2.0637618513646814e-006, 3.7346551751414047e-006, -2.1315026809955787e-005, -4.1340432272512511e-005, 0.00014054114970203437, 0.00030225958181306315, -0.00063813134304511142, -0.0016628637020130838, 0.0024333732126576722, 0.0067641854480530832, -0.0091642311624818458, -0.019761778942572639, 0.032683574267111833, 0.041289208750181702, -0.10557420870333893, -0.062035963962903569, 0.43799162617183712, 0.77428960365295618, 0.42156620669085149, -0.052043163176243773, -0.091920010559696244, 0.02816802897093635, 0.023408156785839195, -0.010131117519849788, -0.004159358781386048, 0.0021782363581090178, 0.00035858968789573785, -0.00021208083980379827},
    {0.00021208083980379827, 0.00035858968789573785, -0.0021782363581090178, -0.004159358781386048, 0.010131117519849788, 0.023408156785839195, -0.02816802897093635, -0.091920010559696244, 0.052043163176243773, 0.42156620669085149, -0.77428960365295618, 0.43799162617183712, 0.062035963962903569, -0.10557420870333893, -0.041289208750181702, 0.032683574267111833, 0.019761778942572639, -0.0091642311624818458, -0.0067641854480530832, 0.0024333732126576722, 0.0016628637020130838, -0.00063813134304511142, -0.00030225958181306315, 0.00014054114970203437, 4.1340432272512511e-005, -2.1315026809955787e-005, -3.7346551751414047e-006, 2.0637618513646814e-006, 1.6744288576823017e-007, -9.517657273819165e-008},
    {-0.00021208083980379827, 0.00035858968789573785, 0.0021782363581090178, -0.004159358781386048, -0.010131117519849788, 0.023408156785839195, 0.02816802897093635, -0.091920010559696244, -0.052043163176243773, 0.42156620669085149, 0.77428960365295618, 0.43799162617183712, -0.062035963962903569, -0.10557420870333893, 0.041289208750181702, 0.032683574267111833, -0.019761778942572639, -0.0091642311624818458, 0.0067641854480530832, 0.0024333732126576722, -0.0016628637020130838, -0.00063813134304511142, 0.00030225958181306315, 0.00014054114970203437, -4.1340432272512511e-005, -2.1315026809955787e-005, 3.7346551751414047e-006, 2.0637618513646814e-006, -1.6744288576823017e-007, -9.517657273819165e-008},
    {-9.517657273819165e-008, 1.6744288576823017e-007, 2.0637618513646814e-006, -3.7346551751414047e-006, -2.1315026809955787e-005, 4.1340432272512511e-005, 0.00014054114970203437, -0.00030225958181306315, -0.00063813134304511142, 0.0016628637020130838, 0.0024333732126576722, -0.0067641854480530832, -0.0091642311624818458, 0.019761778942572639, 0.032683574267111833, -0.041289208750181702, -0.10557420870333893, 0.062035963962903569, 0.43799162617183712, -0.77428960365295618, 0.42156620669085149, 0.052043163176243773, -0.091920010559696244, -0.02816802897093635, 0.023408156785839195, 0.010131117519849788, -0.004159358781386048, -0.0021782363581090178, 0.00035858968789573785, 0.00021208083980379827}
};

static float bior1_1_float[][2] = {
    {0.70710678118654757, 0.70710678118654757},
    {-0.70710678118654757, 0.70710678118654757},
    {0.70710678118654757, 0.70710678118654757},
    {0.70710678118654757, -0.70710678118654757}
};

static float bior1_3_float[][6] = {
    {-0.088388347648318447, 0.088388347648318447, 0.70710678118654757, 0.70710678118654757, 0.088388347648318447, -0.088388347648318447},
    {0.0, 0.0, -0.70710678118654757, 0.70710678118654757, 0.0, 0.0},
    {0.0, 0.0, 0.70710678118654757, 0.70710678118654757, 0.0, 0.0},
    {-0.088388347648318447, -0.088388347648318447, 0.70710678118654757, -0.70710678118654757, 0.088388347648318447, 0.088388347648318447}
};

static float bior1_5_float[][10] = {
    {0.01657281518405971, -0.01657281518405971, -0.12153397801643787, 0.12153397801643787, 0.70710678118654757, 0.70710678118654757, 0.12153397801643787, -0.12153397801643787, -0.01657281518405971, 0.01657281518405971},
    {0.0, 0.0, 0.0, 0.0, -0.70710678118654757, 0.70710678118654757, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.70710678118654757, 0.70710678118654757, 0.0, 0.0, 0.0, 0.0},
    {0.01657281518405971, 0.01657281518405971, -0.12153397801643787, -0.12153397801643787, 0.70710678118654757, -0.70710678118654757, 0.12153397801643787, 0.12153397801643787, -0.01657281518405971, -0.01657281518405971}
};

static float bior2_2_float[][6] = {
    {0.0, -0.17677669529663689, 0.35355339059327379, 1.0606601717798214, 0.35355339059327379, -0.17677669529663689},
    {0.0, 0.35355339059327379, -0.70710678118654757, 0.35355339059327379, 0.0, 0.0},
    {0.0, 0.35355339059327379, 0.70710678118654757, 0.35355339059327379, 0.0, 0.0},
    {0.0, 0.17677669529663689, 0.35355339059327379, -1.0606601717798214, 0.35355339059327379, 0.17677669529663689}
};

static float bior2_4_float[][10] = {
    {0.0, 0.033145630368119419, -0.066291260736238838, -0.17677669529663689, 0.4198446513295126, 0.99436891104358249, 0.4198446513295126, -0.17677669529663689, -0.066291260736238838, 0.033145630368119419},
    {0.0, 0.0, 0.0, 0.35355339059327379, -0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.35355339059327379, 0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0},
    {0.0, -0.033145630368119419, -0.066291260736238838, 0.17677669529663689, 0.4198446513295126, -0.99436891104358249, 0.4198446513295126, 0.17677669529663689, -0.066291260736238838, -0.033145630368119419}
};

static float bior2_6_float[][14] = {
    {0.0, -0.0069053396600248784, 0.013810679320049757, 0.046956309688169176, -0.10772329869638811, -0.16987135563661201, 0.44746600996961211, 0.96674755240348298, 0.44746600996961211, -0.16987135563661201, -0.10772329869638811, 0.046956309688169176, 0.013810679320049757, -0.0069053396600248784},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.35355339059327379, -0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.35355339059327379, 0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0069053396600248784, 0.013810679320049757, -0.046956309688169176, -0.10772329869638811, 0.16987135563661201, 0.44746600996961211, -0.96674755240348298, 0.44746600996961211, 0.16987135563661201, -0.10772329869638811, -0.046956309688169176, 0.013810679320049757, 0.0069053396600248784}
};

static float bior2_8_float[][18] = {
    {0.0, 0.0015105430506304422, -0.0030210861012608843, -0.012947511862546647, 0.028916109826354178, 0.052998481890690945, -0.13491307360773608, -0.16382918343409025, 0.46257144047591658, 0.95164212189717856, 0.46257144047591658, -0.16382918343409025, -0.13491307360773608, 0.052998481890690945, 0.028916109826354178, -0.012947511862546647, -0.0030210861012608843, 0.0015105430506304422},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.35355339059327379, -0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.35355339059327379, 0.70710678118654757, 0.35355339059327379, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, -0.0015105430506304422, -0.0030210861012608843, 0.012947511862546647, 0.028916109826354178, -0.052998481890690945, -0.13491307360773608, 0.16382918343409025, 0.46257144047591658, -0.95164212189717856, 0.46257144047591658, 0.16382918343409025, -0.13491307360773608, -0.052998481890690945, 0.028916109826354178, 0.012947511862546647, -0.0030210861012608843, -0.0015105430506304422}
};

static float bior3_1_float[][4] = {
    {-0.35355339059327379, 1.0606601717798214, 1.0606601717798214, -0.35355339059327379},
    {-0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689},
    {0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689},
    {-0.35355339059327379, -1.0606601717798214, 1.0606601717798214, 0.35355339059327379}
};

static float bior3_3_float[][8] = {
    {0.066291260736238838, -0.19887378220871652, -0.15467960838455727, 0.99436891104358249, 0.99436891104358249, -0.15467960838455727, -0.19887378220871652, 0.066291260736238838},
    {0.0, 0.0, -0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689, 0.0, 0.0},
    {0.0, 0.0, 0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689, 0.0, 0.0},
    {0.066291260736238838, 0.19887378220871652, -0.15467960838455727, -0.99436891104358249, 0.99436891104358249, 0.15467960838455727, -0.19887378220871652, -0.066291260736238838}
};

static float bior3_5_float[][12] = {
    {-0.013810679320049757, 0.041432037960149271, 0.052480581416189075, -0.26792717880896527, -0.071815532464258744, 0.96674755240348298, 0.96674755240348298, -0.071815532464258744, -0.26792717880896527, 0.052480581416189075, 0.041432037960149271, -0.013810679320049757},
    {0.0, 0.0, 0.0, 0.0, -0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0},
    {-0.013810679320049757, -0.041432037960149271, 0.052480581416189075, 0.26792717880896527, -0.071815532464258744, -0.96674755240348298, 0.96674755240348298, 0.071815532464258744, -0.26792717880896527, -0.052480581416189075, 0.041432037960149271, 0.013810679320049757}
};

static float bior3_7_float[][16] = {
    {0.0030210861012608843, -0.0090632583037826529, -0.016831765421310641, 0.074663985074019001, 0.031332978707362888, -0.301159125922835, -0.026499240945345472, 0.95164212189717856, 0.95164212189717856, -0.026499240945345472, -0.301159125922835, 0.031332978707362888, 0.074663985074019001, -0.016831765421310641, -0.0090632583037826529, 0.0030210861012608843},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0030210861012608843, 0.0090632583037826529, -0.016831765421310641, -0.074663985074019001, 0.031332978707362888, 0.301159125922835, -0.026499240945345472, -0.95164212189717856, 0.95164212189717856, 0.026499240945345472, -0.301159125922835, -0.031332978707362888, 0.074663985074019001, 0.016831765421310641, -0.0090632583037826529, -0.0030210861012608843}
};

static float bior3_9_float[][20] = {
    {-0.00067974437278369901, 0.0020392331183510968, 0.0050603192196119811, -0.020618912641105536, -0.014112787930175846, 0.09913478249423216, 0.012300136269419315, -0.32019196836077857, 0.0020500227115698858, 0.94212570067820678, 0.94212570067820678, 0.0020500227115698858, -0.32019196836077857, 0.012300136269419315, 0.09913478249423216, -0.014112787930175846, -0.020618912641105536, 0.0050603192196119811, 0.0020392331183510968, -0.00067974437278369901},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17677669529663689, 0.53033008588991071, -0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17677669529663689, 0.53033008588991071, 0.53033008588991071, 0.17677669529663689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-0.00067974437278369901, -0.0020392331183510968, 0.0050603192196119811, 0.020618912641105536, -0.014112787930175846, -0.09913478249423216, 0.012300136269419315, 0.32019196836077857, 0.0020500227115698858, -0.94212570067820678, 0.94212570067820678, -0.0020500227115698858, -0.32019196836077857, -0.012300136269419315, 0.09913478249423216, 0.014112787930175846, -0.020618912641105536, -0.0050603192196119811, 0.0020392331183510968, 0.00067974437278369901}
};

static float bior4_4_float[][10] = {
    {0.0, 0.03782845550726404, -0.023849465019556843, -0.11062440441843718, 0.37740285561283066, 0.85269867900889385, 0.37740285561283066, -0.11062440441843718, -0.023849465019556843, 0.03782845550726404},
    {0.0, -0.064538882628697058, 0.040689417609164058, 0.41809227322161724, -0.7884856164055829, 0.41809227322161724, 0.040689417609164058, -0.064538882628697058, 0.0, 0.0},
    {0.0, -0.064538882628697058, -0.040689417609164058, 0.41809227322161724, 0.7884856164055829, 0.41809227322161724, -0.040689417609164058, -0.064538882628697058, 0.0, 0.0},
    {0.0, -0.03782845550726404, -0.023849465019556843, 0.11062440441843718, 0.37740285561283066, -0.85269867900889385, 0.37740285561283066, 0.11062440441843718, -0.023849465019556843, -0.03782845550726404}
};

static float bior5_5_float[][12] = {
    {0.0, 0.0, 0.03968708834740544, 0.0079481086372403219, -0.054463788468236907, 0.34560528195603346, 0.73666018142821055, 0.34560528195603346, -0.054463788468236907, 0.0079481086372403219, 0.03968708834740544, 0.0},
    {-0.013456709459118716, -0.0026949668801115071, 0.13670658466432914, -0.093504697400938863, -0.47680326579848425, 0.89950610974864842, -0.47680326579848425, -0.093504697400938863, 0.13670658466432914, -0.0026949668801115071, -0.013456709459118716, 0.0},
    {0.013456709459118716, -0.0026949668801115071, -0.13670658466432914, -0.093504697400938863, 0.47680326579848425, 0.89950610974864842, 0.47680326579848425, -0.093504697400938863, -0.13670658466432914, -0.0026949668801115071, 0.013456709459118716, 0.0},
    {0.0, 0.0, 0.03968708834740544, -0.0079481086372403219, -0.054463788468236907, -0.34560528195603346, 0.73666018142821055, -0.34560528195603346, -0.054463788468236907, -0.0079481086372403219, 0.03968708834740544, 0.0}
};

static float bior6_8_float[][18] = {
    {0.0, 0.0019088317364812906, -0.0019142861290887667, -0.016990639867602342, 0.01193456527972926, 0.04973290349094079, -0.077263173167204144, -0.09405920349573646, 0.42079628460982682, 0.82592299745840225, 0.42079628460982682, -0.09405920349573646, -0.077263173167204144, 0.04973290349094079, 0.01193456527972926, -0.016990639867602342, -0.0019142861290887667, 0.0019088317364812906},
    {0.0, 0.0, 0.0, 0.014426282505624435, -0.014467504896790148, -0.078722001062628819, 0.040367979030339923, 0.41784910915027457, -0.75890772945365415, 0.41784910915027457, 0.040367979030339923, -0.078722001062628819, -0.014467504896790148, 0.014426282505624435, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.014426282505624435, 0.014467504896790148, -0.078722001062628819, -0.040367979030339923, 0.41784910915027457, 0.75890772945365415, 0.41784910915027457, -0.040367979030339923, -0.078722001062628819, 0.014467504896790148, 0.014426282505624435, 0.0, 0.0, 0.0, 0.0},
    {0.0, -0.0019088317364812906, -0.0019142861290887667, 0.016990639867602342, 0.01193456527972926, -0.04973290349094079, -0.077263173167204144, 0.09405920349573646, 0.42079628460982682, -0.82592299745840225, 0.42079628460982682, 0.09405920349573646, -0.077263173167204144, -0.04973290349094079, 0.01193456527972926, 0.016990639867602342, -0.0019142861290887667, -0.0019088317364812906}
};

static float dmey_float[][62] = {
    {0.0, -1.0099999569414229e-012, 8.519459636796214e-009, -1.111944952595278e-008, -1.0798819539621958e-008, 6.0669757413511352e-008, -1.0866516536735883e-007, 8.2006806503864813e-008, 1.1783004497663934e-007, -5.5063405652522782e-007, 1.1307947017916706e-006, -1.4895492164971559e-006, 7.367572885903746e-007, 3.2054419133447798e-006, -1.6312699734552807e-005, 6.5543059305751491e-005, -0.00060115023435160925, -0.002704672124643725, 0.0022025341009110021, 0.006045814097323304, -0.0063877183184971563, -0.011061496392513451, 0.015270015130934803, 0.017423434103729693, -0.032130793990211758, -0.024348745906078023, 0.063739024322801596, 0.030655091960824263, -0.13284520043622938, -0.035087555656258346, 0.44459300275757724, 0.74458559231880628, 0.44459300275757724, -0.035087555656258346, -0.13284520043622938, 0.030655091960824263, 0.063739024322801596, -0.024348745906078023, -0.032130793990211758, 0.017423434103729693, 0.015270015130934803, -0.011061496392513451, -0.0063877183184971563, 0.006045814097323304, 0.0022025341009110021, -0.002704672124643725, -0.00060115023435160925, 6.5543059305751491e-005, -1.6312699734552807e-005, 3.2054419133447798e-006, 7.367572885903746e-007, -1.4895492164971559e-006, 1.1307947017916706e-006, -5.5063405652522782e-007, 1.1783004497663934e-007, 8.2006806503864813e-008, -1.0866516536735883e-007, 6.0669757413511352e-008, -1.0798819539621958e-008, -1.111944952595278e-008, 8.519459636796214e-009, -1.0099999569414229e-012},
    {1.0099999569414229e-012, 8.519459636796214e-009, 1.111944952595278e-008, -1.0798819539621958e-008, -6.0669757413511352e-008, -1.0866516536735883e-007, -8.2006806503864813e-008, 1.1783004497663934e-007, 5.5063405652522782e-007, 1.1307947017916706e-006, 1.4895492164971559e-006, 7.367572885903746e-007, -3.2054419133447798e-006, -1.6312699734552807e-005, -6.5543059305751491e-005, -0.00060115023435160925, 0.002704672124643725, 0.0022025341009110021, -0.006045814097323304, -0.0063877183184971563, 0.011061496392513451, 0.015270015130934803, -0.017423434103729693, -0.032130793990211758, 0.024348745906078023, 0.063739024322801596, -0.030655091960824263, -0.13284520043622938, 0.035087555656258346, 0.44459300275757724, -0.74458559231880628, 0.44459300275757724, 0.035087555656258346, -0.13284520043622938, -0.030655091960824263, 0.063739024322801596, 0.024348745906078023, -0.032130793990211758, -0.017423434103729693, 0.015270015130934803, 0.011061496392513451, -0.0063877183184971563, -0.006045814097323304, 0.0022025341009110021, 0.002704672124643725, -0.00060115023435160925, -6.5543059305751491e-005, -1.6312699734552807e-005, -3.2054419133447798e-006, 7.367572885903746e-007, 1.4895492164971559e-006, 1.1307947017916706e-006, 5.5063405652522782e-007, 1.1783004497663934e-007, -8.2006806503864813e-008, -1.0866516536735883e-007, -6.0669757413511352e-008, -1.0798819539621958e-008, 1.111944952595278e-008, 8.519459636796214e-009, 1.0099999569414229e-012, 0.0},
    {-1.0099999569414229e-012, 8.519459636796214e-009, -1.111944952595278e-008, -1.0798819539621958e-008, 6.0669757413511352e-008, -1.0866516536735883e-007, 8.2006806503864813e-008, 1.1783004497663934e-007, -5.5063405652522782e-007, 1.1307947017916706e-006, -1.4895492164971559e-006, 7.367572885903746e-007, 3.2054419133447798e-006, -1.6312699734552807e-005, 6.5543059305751491e-005, -0.00060115023435160925, -0.002704672124643725, 0.0022025341009110021, 0.006045814097323304, -0.0063877183184971563, -0.011061496392513451, 0.015270015130934803, 0.017423434103729693, -0.032130793990211758, -0.024348745906078023, 0.063739024322801596, 0.030655091960824263, -0.13284520043622938, -0.035087555656258346, 0.44459300275757724, 0.74458559231880628, 0.44459300275757724, -0.035087555656258346, -0.13284520043622938, 0.030655091960824263, 0.063739024322801596, -0.024348745906078023, -0.032130793990211758, 0.017423434103729693, 0.015270015130934803, -0.011061496392513451, -0.0063877183184971563, 0.006045814097323304, 0.0022025341009110021, -0.002704672124643725, -0.00060115023435160925, 6.5543059305751491e-005, -1.6312699734552807e-005, 3.2054419133447798e-006, 7.367572885903746e-007, -1.4895492164971559e-006, 1.1307947017916706e-006, -5.5063405652522782e-007, 1.1783004497663934e-007, 8.2006806503864813e-008, -1.0866516536735883e-007, 6.0669757413511352e-008, -1.0798819539621958e-008, -1.111944952595278e-008, 8.519459636796214e-009, -1.0099999569414229e-012, 0.0},
    {0.0, 1.0099999569414229e-012, 8.519459636796214e-009, 1.111944952595278e-008, -1.0798819539621958e-008, -6.0669757413511352e-008, -1.0866516536735883e-007, -8.2006806503864813e-008, 1.1783004497663934e-007, 5.5063405652522782e-007, 1.1307947017916706e-006, 1.4895492164971559e-006, 7.367572885903746e-007, -3.2054419133447798e-006, -1.6312699734552807e-005, -6.5543059305751491e-005, -0.00060115023435160925, 0.002704672124643725, 0.0022025341009110021, -0.006045814097323304, -0.0063877183184971563, 0.011061496392513451, 0.015270015130934803, -0.017423434103729693, -0.032130793990211758, 0.024348745906078023, 0.063739024322801596, -0.030655091960824263, -0.13284520043622938, 0.035087555656258346, 0.44459300275757724, -0.74458559231880628, 0.44459300275757724, 0.035087555656258346, -0.13284520043622938, -0.030655091960824263, 0.063739024322801596, 0.024348745906078023, -0.032130793990211758, -0.017423434103729693, 0.015270015130934803, 0.011061496392513451, -0.0063877183184971563, -0.006045814097323304, 0.0022025341009110021, 0.002704672124643725, -0.00060115023435160925, -6.5543059305751491e-005, -1.6312699734552807e-005, -3.2054419133447798e-006, 7.367572885903746e-007, 1.4895492164971559e-006, 1.1307947017916706e-006, 5.5063405652522782e-007, 1.1783004497663934e-007, -8.2006806503864813e-008, -1.0866516536735883e-007, -6.0669757413511352e-008, -1.0798819539621958e-008, 1.111944952595278e-008, 8.519459636796214e-009, 1.0099999569414229e-012}
};

#endif
