
# This file contains the lists of error messages used by xmlproc

import string

# The interface to the outside world

# Todo:
# - 3047 needed in Swedish, Norwegian and French
# - 2024 ditto

error_lists={}  # The hash of errors

def add_error_list(language,list):
    error_lists[string.lower(language)]=list

def get_error_list(language):
    return error_lists[string.lower(language)]

def get_language_list():
    return error_lists.keys()

# Errors in English

english={

    # --- Warnings: 1000-1999
    1000: "Undeclared namespace prefix '%s'",
    1002: "Unsupported encoding '%s'",
    1003: "Obsolete namespace syntax",
    1005: "Unsupported character number '%d' in character reference",
    1006: "Element '%s' has attribute list, but no element declaration",
    1007: "Attribute '%s' defined more than once",
    1008: "Ambiguous content model",

    # --- Namespace warnings
    1900: "Namespace prefix names cannot contain ':'s.",
    1901: "Namespace URI cannot be empty",
    1902: "Namespace prefix not declared",
    1903: "Attribute names not unique after namespace processing",

    # --- Validity errors: 2000-2999
    2000: "Actual value of attribute '%s' does not match fixed value",
    2001: "Element '%s' not allowed here",
    2002: "Document root element '%s' does not match declared root element",
    2003: "Element '%s' not declared",
    2004: "Element '%s' ended, but not finished",
    2005: "Character data not allowed in the content of this element",
    2006: "Attribute '%s' not declared",
    2007: "ID '%s' appears more than once in document",
    2008: "Only unparsed entities allowed as the values of ENTITY attributes",
    2009: "Notation '%s' not declared",
    2010: "Required attribute '%s' not present",
    2011: "IDREF referred to non-existent ID '%s'",
    2012: "Element '%s' declared more than once",
    2013: "Only one ID attribute allowed on each element type",
    2014: "ID attributes cannot be #FIXED or defaulted",
    2015: "xml:space must be declared an enumeration type",
    2016: "xml:space must have exactly one or both of the values 'default' and 'preserve'",
    2017: "'%s' is not an allowed value for the '%s' attribute",
    2018: "Value of '%s' attribute must be a valid name",
    2019: "Value of '%s' attribute not a valid name token",
    2020: "Value of '%s' attribute not a valid name token sequence",
    2021: "Token '%s' in the value of the '%s' attribute is not a valid name",
    2022: "Notation attribute '%s' uses undeclared notation '%s'",
    2023: "Unparsed entity '%s' uses undeclared notation '%s'",
    2024: "Cannot resolve relative URI '%s' when document URI unknown",

    # --- Well-formedness errors: 3000-3999
    # From xmlutils
    3000: "Couldn't open resource '%s'",
    3001: "Construct started, but never completed",
    3002: "Whitespace expected here",
    3003: "Didn't match '%s'",   ## FIXME: This must be redone
    3004: "One of %s or '%s' expected",
    3005: "'%s' expected",
    3047: "encoding '%s' conflicts with autodetected encoding",
    3048: "character set conversion problem: %s",

    # From xmlproc.XMLCommonParser
    3006: "SYSTEM or PUBLIC expected",
    3007: "Text declaration must appear first in entity",
    3008: "XML declaration must appear first in document",
    3009: "Multiple text declarations in a single entity",
    3010: "Multiple XML declarations in a single document",
    3011: "XML version missing on XML declaration",
    3012: "Standalone declaration on text declaration not allowed",
    3045: "Processing instruction target names beginning with 'xml' are reserved",
    3046: "Unsupported XML version",
    
    # From xmlproc.XMLProcessor
    3013: "Illegal construct",
    3014: "Premature document end, element '%s' not closed",
    3015: "Premature document end, no root element",
    3016: "Attribute '%s' occurs twice",
    3017: "Elements not allowed outside root element",
    3018: "Illegal character number '%d' in character reference",
    3019: "Entity recursion detected",
    3020: "External entity references not allowed in attribute values",
    3021: "Undeclared entity '%s'",
    3022: "'<' not allowed in attribute values",
    3023: "End tag for '%s' seen, but '%s' expected",
    3024: "Element '%s' not open",
    3025: "']]>' must not occur in character data",
    3027: "Not a valid character number",
    3028: "Character references not allowed outside root element",
    3029: "Character data not allowed outside root element",
    3030: "Entity references not allowed outside root element",
    3031: "References to unparsed entities not allowed in element content",
    3032: "Multiple document type declarations",
    3033: "Document type declaration not allowed inside root element",
    3034: "Premature end of internal DTD subset",
    3042: "Element crossed entity boundary",

    # From xmlproc.DTDParser
    3035: "Parameter entities cannot be unparsed",
    3036: "Parameter entity references not allowed in internal subset declarations",
    3037: "External entity references not allowed in entity replacement text",
    3038: "Unknown parameter entity '%s'",
    3039: "Expected type or alternative list",
    3040: "Choice and sequence lists cannot be mixed",
    3041: "Conditional sections not allowed in internal subset",
    3043: "Conditional section not closed",
    3044: "Token '%s' defined more than once",
    # next: 3049
    
    # From regular expressions that were not matched
    3900: "Not a valid name",
    3901: "Not a valid version number (%s)",
    3902: "Not a valid encoding name",
    3903: "Not a valid comment",
    3905: "Not a valid hexadecimal number",
    3906: "Not a valid number",
    3907: "Not a valid parameter reference",
    3908: "Not a valid attribute type",
    3909: "Not a valid attribute default definition",
    3910: "Not a valid enumerated attribute value",
    3911: "Not a valid standalone declaration",
    
    # --- Internal errors: 4000-4999
    4000: "Internal error: Entity stack broken",
    4001: "Internal error: Entity reference expected.",
    4002: "Internal error: Unknown error number %d.",
    4003: "Internal error: External PE references not allowed in declarations",

    # --- XCatalog errors: 5000-5099
    5000: "Uknown XCatalog element: %s.",
    5001: "Required XCatalog attribute %s on %s missing.",
     
    # --- SOCatalog errors: 5100-5199
    5100: "Invalid or unsupported construct: %s.",
    }

# Errors in Norwegian
norsk = english.copy()
norsk.update({

    # --- Warnings: 1000-1999
    1000: "Navneroms-prefikset '%s' er ikke deklarert",
    1002: "Tegn-kodingen '%s' er ikke stttet",
    1003: "Denne navnerom-syntaksen er foreldet",
    1005: "Tegn nummer '%d' i tegn-referansen er ikke stttet",
    1006: "Element '%s' har attributt-liste, men er ikke deklarert",
    1007: "Attributt '%s' deklarert flere ganger",
    1008: "Tvetydig innholds-modell",

    # --- Namespace warnings: 1900-1999
    1900: "Navnerommets prefiks-navn kan ikke inneholde kolon",
    1901: "Navnerommets URI kan ikke vre tomt",
    1902: "Navnerommets prefiks er ikke deklarert",
    1903: "Attributt-navn ikke unike etter navneroms-prosessering",
    
    # --- Validity errors: 2000-2999
    2000: "Faktisk verdi til attributtet '%s' er ikke lik #FIXED-verdien",
    2001: "Elementet '%s' er ikke tillatt her",
    2002: "Dokumentets rot-element '%s' er ikke det samme som det deklarerte",
    2003: "Element-typen '%s' er ikke deklarert",
    2004: "Elementet '%s' avsluttet, men innholdet ikke ferdig",
    2005: "Tekst-data er ikke tillatt i dette elementets innhold",
    2006: "Attributtet '%s' er ikke deklarert",
    2007: "ID-en '%s' brukt mer enn en gang",
    2008: "Bare uparserte entiteter er tillatt som verdier til ENTITY-attributter",
    2009: "Notasjonen '%s' er ikke deklarert",
    2010: "Pkrevd attributt '%s' mangler",
    2011: "IDREF viste til ikke-eksisterende ID '%s'",
    2012: "Elementet '%s' deklarert mer enn en gang",
    2013: "Bare ett ID-attributt er tillatt pr element-type",
    2014: "ID-attributter kan ikke vre #FIXED eller ha standard-verdier",
    2015: "xml:space m deklareres som en oppramstype",
    2016: "xml:space m ha en eller begge av verdiene 'default' og 'preserve'",
    2017: "'%s' er ikke en gyldig verdi for '%s'-attributtet",
    2018: "Verdien til '%s'-attributtet m vre et gyldig navn",
    2019: "Verdien til '%s'-attributtet er ikke et gyldig NMTOKEN",
    2020: "Verdien til '%s'-attributtet er ikke et gyldig NMTOKENS",
    2021: "Symbolet '%s' i verdien til '%s'-attributtet er ikke et gyldig navn",
    2022: "Notasjons-attributtet '%s' bruker en notasjon '%s' som ikke er deklarert",
    2023: "Uparsert entitet '%s' bruker en notasjon '%s' som ikke er deklarert",

    # --- Well-formedness errors: 3000-3999
    # From xmlutils
    3000: "Kunne ikke pne '%s'",
    3001: "For tidlig slutt p entiteten",
    3002: "Blanke forventet her",
    3003: "Matchet ikke '%s'",   ## FIXME: This must be redone
    3004: "En av %s eller '%s' forventet",
    3005: "'%s' forventet",

    # From xmlproc.XMLCommonParser
    3006: "SYSTEM eller PUBLIC forventet",
    3007: "Tekst-deklarasjonen m st frst i entiteten",
    3008: "XML-deklarasjonen m st frst i dokumentet",
    3009: "Flere tekst-deklarasjoner i samme entitet",
    3010: "Flere tekst-deklarasjoner i samme dokument",
    3011: "XML-versjonen mangler p XML-deklarasjonen",
    3012: "'Standalone'-deklarasjon p tekst-deklarasjon ikke tillatt",

    # From xmlproc.XMLProcessor
    3013: "Syntaksfeil",
    3014: "Dokumentet slutter for tidlig, elementet '%s' er ikke lukket",
    3015: "Dokumentet slutter for tidlig, rot-elementet mangler",
    3016: "Attributtet '%s' gjentatt",
    3017: "Kun ett rot-element er tillatt",
    3018: "Ulovlig tegn nummer '%d' i tegn-referanse",
    3019: "Entitets-rekursjon oppdaget",
    3020: "Eksterne entitets-referanser ikke tillatt i attributt-verdier",
    3021: "Entiteten '%s' er ikke deklarert",
    3022: "'<' er ikke tillatt i attributt-verdier",
    3023: "Slutt-tagg for '%s', men '%s' forventet",
    3024: "Elementet '%s' lukket, men ikke pent",
    3025: "']]>' ikke tillatt i tekst-data",
    3027: "Ikke et gyldig tegn-nummer",
    3028: "Tegn-referanser ikke tillatt utenfor rot-elementet",
    3029: "Tekst-data ikke tillatt utenfor rot-elementet",
    3030: "Entitets-referanser ikke tillatt utenfor rot-elementet",
    3031: "Referanser til uparserte entiteter er ikke tillatt i element-innhold",
    3032: "Mer enn en dokument-type-deklarasjon",
    3033: "Dokument-type-deklarasjon kun tillatt fr rot-elementet",
    3034: "Det interne DTD-subsettet slutter for tidlig",
    3042: "Element krysset entitets-grense",
    3045: "Processing instruction navn som begynner med 'xml' er reservert",
    3046: "Denne XML-versjonen er ikke stttet",

    # From xmlproc.DTDParser
    3035: "Parameter-entiteter kan ikke vre uparserte",
    3036: "Parameter-entitets-referanser ikke tillatt inne i deklarasjoner i det interne DTD-subsettet",
    3037: "Eksterne entitets-referanser ikke tillatt i entitetsdeklarasjoner",
    3038: "Parameter-entiteten '%s' ikke deklarert",
    3039: "Forventet attributt-type eller liste av alternativer",
    3040: "Valg- og sekvens-lister kan ikke blandes",
    3041: "'Conditional sections' er ikke tillatt i det interne DTD-subsettet",
    3043: "'Conditional section' ikke lukket",
    3044: "Symbolet '%s' er definert mer enn en gang",
    
    # From regular expressions that were not matched
    3900: "Ikke et gyldig navn",
    3901: "Ikke et gyldig versjonsnummer (%s)",
    3902: "Ikke et gyldig tegnkodings-navn",
    3903: "Ikke en gyldig kommentar",
    3905: "Ikke et gyldig heksadesimalt tall",
    3906: "Ikke et gyldig tall",
    3907: "Ikke en gyldig parameter-entitets-referanse",
    3908: "Ikke en gyldig attributt-type",
    3909: "Ikke en gyldig attributt-standard-verdi",
    3910: "Ikke en gyldig verdi for opprams-attributter",
    3911: "Ikke en gyldig verdi for 'standalone'",
    
    # --- Internal errors: 4000-4999
    4000: "Intern feil: Entitets-stakken korrupt.",
    4001: "Intern feil: Entitets-referanse forventet.",
    4002: "Intern feil: Ukjent feilmelding %d.",
    4003: "Intern feil: Eksterne parameter-entiteter ikke tillatt i deklarasjoner",
    # --- XCatalog errors: 5000-5099
    5000: "Ukjent XCatalog-element: %s.",
    5001: "Pkrevd XCatalog-attributt %s p %s mangler.",
     
    # --- SOCatalog errors: 5100-5199
    5100: "Ugyldig eller ikke stttet konstruksjon: %s.",
    })

# Errors in Swedish
# Contributed by Marus Brisenfeldt, <marcusb@infotek.no>

svenska = english.copy()
svenska.update({

    # --- Warnings: 1000-1999
    1000: "Namnrymds-prefixet '%s' r inte deklarerat",
    1002: "Systemet stder inte teckenuppsttningen '%s'",
    1003: "Denna namnrymds-syntax r frlegad",
    1005: "Teckennummer '%d' i teckenreferansen stds inte",
    1006: "Ett attribut mste deklareras fr elementet '%s'",
    1007: "Attributet '%s' r deklarerat flera gnger",
    1008: "Tvetydig innhllsmodell",

    # --- Namespace warnings: 1900-1999
    1900: "Namnrymdens prefixnamn kan inte innehlla kolon",
    1901: "Namnrymdens URI fr inte vara tom (mste deklareras)",
    1902: "Namnrymdsprefixet r inte deklarerat",
    1903: "Attribut-namn inte unika efter namnrymds-prosessering",
    
    # --- Validity errors: 2000-2999
    2000: "Attributet '%s' faktiska vrde r inte likt #FIXED-vrdet",
    2001: "Elementet '%s' tillts inte hr",
    2002: "Dokumentets rot-element '%s' r inte det samma som deklarerat",
    2003: "Elementtypen '%s' r inte deklarerad",
    2004: "Elementet '%s' r avslutat, men innhllet r inte fullstndigt",
    2005: "Textdata (PCDATA) r inte tilltet som innehll i elementet",
    2006: "Attributet '%s' r inte deklarerat",
    2007: "ID't '%s' anvnds mer n en gng",
    2008: "Endast icke 'parsade' entiteter r tilltna som vrden till ENTITY-attribut",
    2009: "Notationen '%s' r inte deklarerad",
    2010: "Erfordligt attribut '%s' saknas",
    2011: "IDREF hnvisar till ett icke existerande ID ('%s')",
    2012: "Elementet '%s' har deklarerats mer n en gng",
    2013: "Endast ett ID-attribut er tilltet per elementtyp",
    2014: "ID-attribut kan inte vara '#FIXED' eller ha ett standardvrde",
    2015: "xml:space mste deklareras som en listtyp",
    2016: "xml:space mste ha en eller bda av vrdena 'default' och 'preserve'",
    2017: "'%s' r inte ett giltigt vrde p attributet '%s'",
    2018: "Vrdet p attributet '%s' mste vara ett giltigt namn",
    2019: "Vrdet p attributet '%s' r inte ett giltigt NMTOKEN",
    2020: "Vrdet p attributet '%s' r inte ett giltigt NMTOKENS",
    2021: "Symbolen '%s' i vrdet p attributet '%s' r inte ett giltigt namn",
    2022: "Notations-attributet '%s' anvnder en notation ('%s') som inte r deklarerad",
    2023: "Icke 'parsad' entitet anvnder en notation ('%s') som inte r deklarerad",

    # --- Well-formedness errors: 3000-3999
    # From xmlutils
    3000: "Systemet kunde inte ppna '%s'",
    3001: "Entitet pbrjad, men inte avslutad",
    3002: "Mellanslag frvntat hr",
    3003: "Matchar inte '%s'",   ## FIXME: This must be redone
    3004: "Antingen %s eller '%s' frvntad",
    3005: "'%s' frvntad",

    # From xmlproc.XMLCommonParser
    3006: "Antingen SYSTEM eller PUBLIC frvntad",
    3007: "Textdeklarationen mste st frst i entiteten",
    3008: "XML-deklarationen mste st frst i dokumentet",
    3009: "Flera textdeklarationer i samma entitet",
    3010: "Flera textdeklarationer i samma dokument",
    3011: "XML-version saknas i XML-deklarationen",
    3012: "'Standalone'-deklaration i textdeklarationen r inte tilltet",

    # From xmlproc.XMLProcessor
    3013: "Syntaxfel",
    3014: "Fr tidigt dokumentslut, elementet '%s' r inte stngt",
    3015: "Fr tidigt dokumentslut, rotelement saknas",
    3016: "Attributet '%s' anvnt tv gnger",
    3017: "Endast ett rotelement r tilltet",
    3018: "Olovlig teckennummer ('%d') i teckenreferansen",
    3019: "Entitets-upprepning upptckt",
    3020: "Externa entitets-referanser r inte tilltna i attributvrden",
    3021: "Entiteten '%s' r inte deklarerad",
    3022: "'<' er inte tilltet i attributvrdet",
    3023: "Sluttagg fr '%s' istllet fr frvntad '%s'",
    3024: "Finner elementet '%s' sluttagg, men inte dess starttagg",
    3025: "']]>' inte tilltet i textdata",
    3027: "Inget giltigt teckennummer",
    3028: "Teckenreferanser r inte tilltna utanfr rotelementet",
    3029: "Textdata r inte tilltet utanfr rotelementet",
    3030: "Entitetsreferanser r inte tilltna utanfr rotelementet",
    3031: "Referanser till icke 'parsade' entiteter tillts inte i elementinnhllet",
    3032: "Multipla dokumenttypsdeklarationer",
    3033: "Dokumenttypsdeklarationer tillts inte i rotelementet",
    3034: "Det interna DTD-subsettet avslutas fr tidigt",
    3042: "Element verskrider entitetsgrns",

    # From xmlproc.DTDParser
    3035: "Parameterentiteter kan inte vara 'oparsade'",
    3036: "Parameterentitetsreferanser tillts inte inne i deklarationer i det interna DTD-subsettet",
    3037: "Externa entitetsreferanser tillts inte i entitetsdeklarationer",
    3038: "Parameterentiteten '%s' r inte deklarerad",
    3039: "Frvntat attributtyp eller lista av alternativ",
    3040: "Val- och sekvenslistor kan inte blandas",
    3041: "'Villkorssektioner' r inte tilltna i den interna DTD-delmngden (subsetet)",
    3043: "'Villkorssektionen' r inte stngd",
    3044: "Symbolen '%s' har definerats mer n en gng",
    3045: "Processinstruktionsnamn som brjar med 'xml' r reserverade",
    3046: "Systemet stder inte anvnd XML-versjon",

    # From regular expressions that were not matched
    3900: "Inget giltigt namn",
    3901: "Inget giltigt versionsnummer",
    3902: "Inget giltigt teckenkodsnamn",
    3903: "Ingen giltig kommentar",
    3905: "Inget giltigt hexadecimalt tal",
    3906: "Inget giltigt tal",
    3907: "Ingen giltig parameterentitetsreferans",
    3908: "Ingen giltig attributtyp",
    3909: "Inge giltigt attributstandardvrde",
    3910: "Ikke en gyldig attributt-standard-verdi",
    3911: "Ikke en gyldig verdi for 'standalone'",
    
    # --- Internal errors: 4000-4999
    4000: "Internt fel: Entitetsstacken korrupt.",
    4001: "Internt fel: Entitetsreferans frvntad.",
    4002: "Internt fel: Oknt felmeddelande %d.",
    4003: "Internt fel: Externa parameterentiteter tillts inte i deklarationer.",
    # --- XCatalog errors: 5000-5099
    5000: "Oknt XCatalog-element: %s.",
    5001: "Ndvndigt XCatalog-attribut %s p %s saknas.",
     
    # --- SOCatalog errors: 5100-5199
    5100: "Konstruktionen: %s r ogiltig eller saknar std.",
    })

# Errors in French
# Contributed by Alexandre Fayolle, Logilab. Alexandre.Fayolle@logilab.fr

french = english.copy()
french.update({
    # Les termes franais utiliss sont tirs de l'ouvrage
    # XML, Langage et applications, Alain Michard, Eyrolles
    # ISBN 2-212-09052-8

    # --- Warnings: 1000-1999
    1000: "Prfixe de domaine nominal non dclar '%s'",
    1002: "Encodage non support '%s'",
    1003: "Syntaxe de domaine nominal obsolte",
    1005: "Caractre numro '%d' non support dans la rfrence de caractre",
    1006: "L'lment '%s' a une liste d'attributs mais pas de dclaration d'lment",
    1007: "L'attribute '%s' est dfini plus d'une fois",
    1008: "Modle de contenu ambigu",

    # --- Namespace warnings
    1900: "Les prfixes de domaines nominaux ne peuvent contenir le caractre ':'",
    1901: "L'URI du domaine nominal ne doit pas tre vide",
    1902: "Le prfixe du domaine nominal n'est pas dclar",
    1903: "Le nom d'attribut n'est pas unique aprs traitement des domaines nominaux",

    # --- Validity errors: 2000-2999
    2000: "La valeur de l'attribut '%s' ne correspond pas  la valeur impose",
    2001: "L'lment '%s' ne peut figurer  cet endroit",
    2002: "L'lment racine du document '%s' ne correspond pas  la racine dclare",
    2003: "L'lment '%s' n'a pas t dclar",
    2004: "L'lment '%s' est termin, mais il n'est pas complet",
    2005: "Les donnes ne sont pas autorises comme contenu de cet lment",
    2006: "L'attribut '%s' n'a pas t dclar",
    2007: "L'ID '%s' apparat plusieurs fois dans le document",
    2008: "Seules les entits non XML sont permises dans les attributs ENTITY",
    2009: "La notation '%s' n'a pas t dclare",
    2010: "L'attribut requis '%s' est absent",
    2011: "L'attribut IDREF point sur un ID inexistant '%s'",
    2012: "L'lment '%s' est dclar plus d'une fois",
    2013: "Un seul attribut ID par type d'lment",
    2014: "Les attributs ID nepeuvent tre #FIXED ou avoir de valeur par dfaut",
    2015: "xml:space doit tre de type numration",
    2016: "xml:space doit avoir comme valeurs possibles 'default' et 'preserve'",
    2017: "'%s' n'est pas une valeur autorise pour l'attribut '%s'",
    2018: "La valeur de l'attribut '%s' doit tre un nom valide",
    2019: "La valeur de l'attribut '%s' n'est pas un identifiant de nom valide",
    2020: "La valeur de l'attribut '%s' n'est pas une liste d'identifiants de noms valides",
    2021: "L'identifiant '%s' dans la valeur de l'attribut '%s' n'est pas valide",
    2022: "L'attribut notation '%s' utilise la notation non dclare '%s'",
    2023: "L'entit non XML '%s' utilise la notation non dclare '%s'",

    # --- Well-formedness errors: 3000-3999
    # From xmlutils
    3000: "Impossible d'ouvrir la ressource '%s'",
    3001: "Construction commence mais jamais acheve",
    3002: "Caractres d'espacement attendus  cet endroit",
    3003: "Impossible de faire correspondre '%s'",   ## FIXME: This must be redone
    3004: "'%s' ou '%s' tait attendu",
    3005: "'%s' tat attendu",

    # From xmlproc.XMLCommonParser
    3006: "SYSTEM ou PUBLIC tait attendu",
    3007: "La dclaration de texte doit apparatre en premier dans une entit",
    3008: "La dclaration XML doit apparatre en premier dans un document",
    3009: "Plusieurs dclarations de texte dans une seule entit",
    3010: "Plusieurs dclarations XML dans le document",
    3011: "Il manque la versin d'XML dans la dclaratino XML",
    3012: "Une dclaration indpendante de texte sont interdites",
    3045: "Les noms de cibles d'instruction de traitement commenant par 'xml' sont rservs",
    3046: "Version de XML non supporte",
    
    # From xmlproc.XMLProcessor
    3013: "Construction illgale",
    3014: "Fin de document prmature, l'lment '%s' n'est pas ferm",
    3015: "Fin de document prmature, pas d'lment racine",
    3016: "L'attribut '%s' apparit deux fois",
    3017: "Les lments ne peuvent apparatre  l'extrieur de l'lment racine",
    3018: "Caractre numro '%d' non support dans la rfrence de caractre",
    3019: "Une entit rcursive a t dtecte",
    3020: "Les rfrences  des entits externes sont interdites dans les valeurs d'attributs",
    3021: "L'entit '%s' n'a pas t dclare",
    3022: "'<' est interdit dans les valeurs d'attributs",
    3023: "La balise de fin pour '%s' a t vue, alors que '%s' tait attendu",
    3024: "L'lment'%s' n'a pas t ouvert",
    3025: "']]>' ne doit pas apparatre dans les sections littrales",
    3027: "Numro de caractre invalide",
    3028: "Les rfrences de caractres sont interdites en dehors de l'lment racine",
    3029: "Les sections littrales sont interdites en dehors de l'lment racine",
    3030: "Les rfrences  des entits sont interdites en dehors de l'lment racine",
    3031: "Les rfrences  des entits non XML sont interdites dans un lment",
    3032: "Il y a de multiples dclaratinos de type de document",
    3033: "La dclaration de type de document est interdite dans l'lment racine",
    3034: "Fin prmature de la DTD interne",
    3042: "Un lment chevauche les limites d'une entit",

    # From xmlproc.DTDParser
    3035: "Les entits paramtres ne peuvent pas tre drfrences",
    3036: "Les rfrences  des entits paramtres sont interdites dans la DTD interne",
    3037: "Les rfrences  des entits externes sont interdites dans le texte de remplacement",
    3038: "L'entit paramtre '%s' est inconnue",
    3039: "Un type une liste de valeurs possibles est attendu",
    3040: "Les liste de choix et les listes de squences ne peuvent tre mlanges",
    3041: "Les sections conditionnelles sont interdites dans la DTD interne",
    3043: "La section conditionnelle n'est pas ferme",
    3044: "Le marqueur '%s' est dfini plusieurs fois",
    # next: 3047
    
    # From regular expressions that were not matched
    3900: "Nom invalide",
    3901: "Numro de version invalide (%s)",
    3902: "Nom d'encodage invalide",
    3903: "Commentaire invalide",
    3905: "Nombre hexadcimal invalide",
    3906: "Nombre invalide",
    3907: "Rfrence  un paramtre invalide",
    3908: "Type d'attribut invalide",
    3909: "Dfinitionde valeur par dfaut d'attribut invalide",
    3910: "Valeur d'attribut numr invalide",
    3911: "Dclaration autonome invalide",
    
    # --- Internal errors: 4000-4999
    4000: "Erreur interne : pile dentits casse",
    4001: "Erreur interne : rfrence  une entit attendue.",
    4002: "Erreur interne : numro d'erreur inconnu.",
    4003: "Erreur interne : rfrence  un PE externe interdite dans la dclaration",

    # --- XCatalog errors: 5000-5099
    5000: "L'lment de XCatalog est inconnu : %s.",
    5001: "L'attribut de XCatalog  %s requis sur %s est manquant.",
     
    # --- SOCatalog errors: 5100-5199
    5100: "Construction invalide ou non supporte : %s.",
    })

# Updating the error hash

add_error_list("en", english)
add_error_list("no", norsk)
add_error_list("sv", svenska)
add_error_list("fr", french)

# Checking

def _test():
    def compare(l1, l2):
        for key in l1:
            if not key in l2:
                print "l1:", key

        for key in l2:
            if not key in l1:
                print "l2:", key

    en = english.keys()
    no = norsk.keys()
    sv = svenska.keys()
    fr = french.keys()

    en.sort()
    no.sort()
    sv.sort()
    fr.sort()

    print "en == no"
    compare(en, no)

    print "en == sv"
    compare(en, sv)

    print "en == fr"
    compare(en, fr)
    
if __name__ == "__main__":
    _test()
