#!/www/python/bin/python

import sys
from pprint import pprint
from cStringIO import StringIO
from optik import OptionParser, make_option, OptionValueError, SUPPRESS_USAGE

__revision__ = "$Id: test_misc.py,v 1.2 2002/04/11 19:12:26 gward Exp $"


# Conflicting default values: the last one should win.
parser = OptionParser(option_list=[
    make_option("-v", action="store_true", dest="verbose", default=1),
    make_option("-q", action="store_false", dest="verbose", default=0),])
(values, args) = parser.parse_args([])
assert values.verbose == 0
print "ok: 1"

parser = OptionParser(option_list=[
    make_option("-v", action="store_true", dest="verbose", default=1),
    make_option("-q", action="store_false", dest="verbose", default=None),])
(values, args) = parser.parse_args([])
assert values.verbose is None, values.verbose
print "ok: 2"


# Test --version option: first, should not exist if version string not
# supplied to OptionParser.
parser = OptionParser(usage=SUPPRESS_USAGE)
try:
    parser.parse_args(["--version"])
except SystemExit, err:
    assert err.args[0].endswith("no such option: --version")
    print "ok: 3"
else:
    print "not ok"

# Now make sure it works when expected to
sys.argv[0] = "./foo/bar"
sys.stdout = StringIO()
parser = OptionParser(usage=SUPPRESS_USAGE, version="%prog 0.1")
try:
    parser.parse_args(["--version"])
except SystemExit, err:
    assert err[0] == 0, err[0]
    assert sys.stdout.getvalue() == "bar 0.1\n", sys.stdout.getvalue()
    sys.stdout = sys.__stdout__
    print "ok: 4"
else:
    sys.stdout = sys.__stdout__
    print "not ok"
