#!/usr/bin/env python
#    This file is part of python-evtx.
#
#   Copyright 2012, 2013 Willi Ballenthin <william.ballenthin@mandiant.com>
#                    while at Mandiant <http://www.mandiant.com>
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
#   Version v0.1.1
import mmap
import contextlib

import argparse

from Evtx.Evtx import FileHeader
from Evtx.Views import evtx_file_xml_view


def ascii(s):
    return s.encode('ascii', 'replace').decode('ascii')


def main():
    parser = argparse.ArgumentParser(
        description="Dump a binary EVTX file into XML.")
    parser.add_argument("--cleanup", action="store_true",
                        help="Cleanup unused XML entities (slower)"),
    parser.add_argument("evtx", type=str,
                        help="Path to the Windows EVTX event log file")
    args = parser.parse_args()

    with open(args.evtx, 'r') as f:
        with contextlib.closing(mmap.mmap(f.fileno(), 0,
                                          access=mmap.ACCESS_READ)) as buf:
            fh = FileHeader(buf, 0x0)
            print("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\" ?>")
            print("<Events>")
            for xml, record in evtx_file_xml_view(fh):
                print(ascii(xml))
            print("</Events>")

if __name__ == "__main__":
    main()
