/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef SHAPELIST_H
#define SHAPELIST_H


#include "Shape.h"
#include "GenericShape.h"
#include "vector3.h"
#include "MNTable3D.h"

using std::string;

class ShapeList {
  protected:
    std::vector<Shape*> shapeList;
  
  public:
    void addHexShape(int, int);
    void addGenericShape(string,string,int,int,int,int);
    void insertShape(Vector3, double, MNTable3D *ntable,int tag,int id);
};

#endif /* SHAPELIST_H */
