/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "LineSegment2DPy.h"

using namespace boost::python;

    using boost::python::arg;
    void exportLineSegment2D()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      class_<LineSegment2D, bases<Line2D> >(
        "LineSegment2D",
        "A class defining a line segment in 2 dimensions.",
        init<>()
      )
      .def(init<const LineSegment2D &>())
      .def(
        init<Vector3,Vector3>(
          ( arg("startPoint"), arg("endPoint") ),
          "Constructs a 2D line with specified endpoints.\n"
	  "N.B. This is not an L{AVolume2D} so cannot be used with C{InsertGenerators}.\n"
          "@type startPoint: L{Vector3}\n"
          "@kwarg startPoint: the starting point of the line\n"
          "@type endPoint: L{Vector3}\n"
          "@kwarg endPoint: the end point of the line\n"
        )
      )
      .def(self_ns::str(self))
      ;
    }
