# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class AzureMonitorAlertSettings(msrest.serialization.Model):
    """Settings for Azure Monitor based alerts.

    :ivar alerts_for_all_job_failures: Known values are: "Enabled", "Disabled".
    :vartype alerts_for_all_job_failures: str or ~azure.mgmt.recoveryservices.models.AlertsState
    """

    _attribute_map = {
        'alerts_for_all_job_failures': {'key': 'alertsForAllJobFailures', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alerts_for_all_job_failures: Optional[Union[str, "_models.AlertsState"]] = None,
        **kwargs
    ):
        """
        :keyword alerts_for_all_job_failures: Known values are: "Enabled", "Disabled".
        :paramtype alerts_for_all_job_failures: str or ~azure.mgmt.recoveryservices.models.AlertsState
        """
        super(AzureMonitorAlertSettings, self).__init__(**kwargs)
        self.alerts_for_all_job_failures = alerts_for_all_job_failures


class CertificateRequest(msrest.serialization.Model):
    """Details of the certificate to be uploaded to the vault.

    :ivar properties: Raw certificate data.
    :vartype properties: ~azure.mgmt.recoveryservices.models.RawCertificateData
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RawCertificateData'},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.RawCertificateData"] = None,
        **kwargs
    ):
        """
        :keyword properties: Raw certificate data.
        :paramtype properties: ~azure.mgmt.recoveryservices.models.RawCertificateData
        """
        super(CertificateRequest, self).__init__(**kwargs)
        self.properties = properties


class CheckNameAvailabilityParameters(msrest.serialization.Model):
    """Resource Name availability input parameters - Resource type and resource name.

    :ivar type: Describes the Resource type: Microsoft.RecoveryServices/Vaults.
    :vartype type: str
    :ivar name: Resource name for which availability needs to be checked.
    :vartype name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: Describes the Resource type: Microsoft.RecoveryServices/Vaults.
        :paramtype type: str
        :keyword name: Resource name for which availability needs to be checked.
        :paramtype name: str
        """
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.type = type
        self.name = name


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """Response for check name availability API. Resource provider will set availability as true | false.

    :ivar name_available:
    :vartype name_available: bool
    :ivar reason:
    :vartype reason: str
    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name_available:
        :paramtype name_available: bool
        :keyword reason:
        :paramtype reason: str
        :keyword message:
        :paramtype message: str
        """
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class ClassicAlertSettings(msrest.serialization.Model):
    """Settings for classic alerts.

    :ivar alerts_for_critical_operations: Known values are: "Enabled", "Disabled".
    :vartype alerts_for_critical_operations: str or ~azure.mgmt.recoveryservices.models.AlertsState
    """

    _attribute_map = {
        'alerts_for_critical_operations': {'key': 'alertsForCriticalOperations', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alerts_for_critical_operations: Optional[Union[str, "_models.AlertsState"]] = None,
        **kwargs
    ):
        """
        :keyword alerts_for_critical_operations: Known values are: "Enabled", "Disabled".
        :paramtype alerts_for_critical_operations: str or
         ~azure.mgmt.recoveryservices.models.AlertsState
        """
        super(ClassicAlertSettings, self).__init__(**kwargs)
        self.alerts_for_critical_operations = alerts_for_critical_operations


class ClientDiscoveryDisplay(msrest.serialization.Model):
    """Localized display information of an operation.

    :ivar provider: Name of the provider for display purposes.
    :vartype provider: str
    :ivar resource: ResourceType for which this Operation can be performed.
    :vartype resource: str
    :ivar operation: Operations Name itself.
    :vartype operation: str
    :ivar description: Description of the operation having details of what operation is about.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Name of the provider for display purposes.
        :paramtype provider: str
        :keyword resource: ResourceType for which this Operation can be performed.
        :paramtype resource: str
        :keyword operation: Operations Name itself.
        :paramtype operation: str
        :keyword description: Description of the operation having details of what operation is about.
        :paramtype description: str
        """
        super(ClientDiscoveryDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ClientDiscoveryForLogSpecification(msrest.serialization.Model):
    """Class to represent shoebox log specification in json client discovery.

    :ivar name: Name of the log.
    :vartype name: str
    :ivar display_name: Localized display name.
    :vartype display_name: str
    :ivar blob_duration: Blobs created in customer storage account per hour.
    :vartype blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the log.
        :paramtype name: str
        :keyword display_name: Localized display name.
        :paramtype display_name: str
        :keyword blob_duration: Blobs created in customer storage account per hour.
        :paramtype blob_duration: str
        """
        super(ClientDiscoveryForLogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ClientDiscoveryForProperties(msrest.serialization.Model):
    """Class to represent shoebox properties in json client discovery.

    :ivar service_specification: Operation properties.
    :vartype service_specification:
     ~azure.mgmt.recoveryservices.models.ClientDiscoveryForServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ClientDiscoveryForServiceSpecification'},
    }

    def __init__(
        self,
        *,
        service_specification: Optional["_models.ClientDiscoveryForServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword service_specification: Operation properties.
        :paramtype service_specification:
         ~azure.mgmt.recoveryservices.models.ClientDiscoveryForServiceSpecification
        """
        super(ClientDiscoveryForProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class ClientDiscoveryForServiceSpecification(msrest.serialization.Model):
    """Class to represent shoebox service specification in json client discovery.

    :ivar log_specifications: List of log specifications of this operation.
    :vartype log_specifications:
     list[~azure.mgmt.recoveryservices.models.ClientDiscoveryForLogSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[ClientDiscoveryForLogSpecification]'},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["_models.ClientDiscoveryForLogSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword log_specifications: List of log specifications of this operation.
        :paramtype log_specifications:
         list[~azure.mgmt.recoveryservices.models.ClientDiscoveryForLogSpecification]
        """
        super(ClientDiscoveryForServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications


class ClientDiscoveryResponse(msrest.serialization.Model):
    """Operations List response which contains list of available APIs.

    :ivar value: List of available operations.
    :vartype value: list[~azure.mgmt.recoveryservices.models.ClientDiscoveryValueForSingleApi]
    :ivar next_link: Link to the next chunk of the response.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ClientDiscoveryValueForSingleApi]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ClientDiscoveryValueForSingleApi"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of available operations.
        :paramtype value: list[~azure.mgmt.recoveryservices.models.ClientDiscoveryValueForSingleApi]
        :keyword next_link: Link to the next chunk of the response.
        :paramtype next_link: str
        """
        super(ClientDiscoveryResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClientDiscoveryValueForSingleApi(msrest.serialization.Model):
    """Available operation details.

    :ivar name: Name of the Operation.
    :vartype name: str
    :ivar display: Contains the localized display information for this particular operation.
    :vartype display: ~azure.mgmt.recoveryservices.models.ClientDiscoveryDisplay
    :ivar origin: The intended executor of the operation;governs the display of the operation in
     the RBAC UX and the audit logs UX.
    :vartype origin: str
    :ivar properties: ShoeBox properties for the given operation.
    :vartype properties: ~azure.mgmt.recoveryservices.models.ClientDiscoveryForProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ClientDiscoveryDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ClientDiscoveryForProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.ClientDiscoveryDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.ClientDiscoveryForProperties"] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the Operation.
        :paramtype name: str
        :keyword display: Contains the localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.recoveryservices.models.ClientDiscoveryDisplay
        :keyword origin: The intended executor of the operation;governs the display of the operation in
         the RBAC UX and the audit logs UX.
        :paramtype origin: str
        :keyword properties: ShoeBox properties for the given operation.
        :paramtype properties: ~azure.mgmt.recoveryservices.models.ClientDiscoveryForProperties
        """
        super(ClientDiscoveryValueForSingleApi, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class CmkKekIdentity(msrest.serialization.Model):
    """The details of the identity used for CMK.

    :ivar use_system_assigned_identity: Indicate that system assigned identity should be used.
     Mutually exclusive with 'userAssignedIdentity' field.
    :vartype use_system_assigned_identity: bool
    :ivar user_assigned_identity: The user assigned identity to be used to grant permissions in
     case the type of identity used is UserAssigned.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        'use_system_assigned_identity': {'key': 'useSystemAssignedIdentity', 'type': 'bool'},
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        use_system_assigned_identity: Optional[bool] = None,
        user_assigned_identity: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword use_system_assigned_identity: Indicate that system assigned identity should be used.
         Mutually exclusive with 'userAssignedIdentity' field.
        :paramtype use_system_assigned_identity: bool
        :keyword user_assigned_identity: The user assigned identity to be used to grant permissions in
         case the type of identity used is UserAssigned.
        :paramtype user_assigned_identity: str
        """
        super(CmkKekIdentity, self).__init__(**kwargs)
        self.use_system_assigned_identity = use_system_assigned_identity
        self.user_assigned_identity = user_assigned_identity


class CmkKeyVaultProperties(msrest.serialization.Model):
    """The properties of the Key Vault which hosts CMK.

    :ivar key_uri: The key uri of the Customer Managed Key.
    :vartype key_uri: str
    """

    _attribute_map = {
        'key_uri': {'key': 'keyUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_uri: The key uri of the Customer Managed Key.
        :paramtype key_uri: str
        """
        super(CmkKeyVaultProperties, self).__init__(**kwargs)
        self.key_uri = key_uri


class Error(msrest.serialization.Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.recoveryservices.models.ErrorAdditionalInfo]
    :ivar code: The error code.
    :vartype code: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.recoveryservices.models.Error]
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    """

    _validation = {
        'additional_info': {'readonly': True},
        'code': {'readonly': True},
        'details': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
        'code': {'key': 'code', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Error, self).__init__(**kwargs)
        self.additional_info = None
        self.code = None
        self.details = None
        self.message = None
        self.target = None


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar info: The additional info.
    :vartype info: any
    :ivar type: The additional info type.
    :vartype type: str
    """

    _validation = {
        'info': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'info': {'key': 'info', 'type': 'object'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.info = None
        self.type = None


class IdentityData(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: Required. The type of managed identity used. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user-assigned
     identities. The type 'None' will remove any identities. Known values are: "SystemAssigned",
     "None", "UserAssigned", "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.recoveryservices.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user-assigned identities associated with the
     resource. The user-assigned identity dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.recoveryservices.models.UserIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ResourceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. The type of managed identity used. The type 'SystemAssigned,
         UserAssigned' includes both an implicitly created identity and a set of user-assigned
         identities. The type 'None' will remove any identities. Known values are: "SystemAssigned",
         "None", "UserAssigned", "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.recoveryservices.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user-assigned identities associated with the
         resource. The user-assigned identity dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.recoveryservices.models.UserIdentity]
        """
        super(IdentityData, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class JobsSummary(msrest.serialization.Model):
    """Summary of the replication job data for this vault.

    :ivar failed_jobs: Count of failed jobs.
    :vartype failed_jobs: int
    :ivar suspended_jobs: Count of suspended jobs.
    :vartype suspended_jobs: int
    :ivar in_progress_jobs: Count of in-progress jobs.
    :vartype in_progress_jobs: int
    """

    _attribute_map = {
        'failed_jobs': {'key': 'failedJobs', 'type': 'int'},
        'suspended_jobs': {'key': 'suspendedJobs', 'type': 'int'},
        'in_progress_jobs': {'key': 'inProgressJobs', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        failed_jobs: Optional[int] = None,
        suspended_jobs: Optional[int] = None,
        in_progress_jobs: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword failed_jobs: Count of failed jobs.
        :paramtype failed_jobs: int
        :keyword suspended_jobs: Count of suspended jobs.
        :paramtype suspended_jobs: int
        :keyword in_progress_jobs: Count of in-progress jobs.
        :paramtype in_progress_jobs: int
        """
        super(JobsSummary, self).__init__(**kwargs)
        self.failed_jobs = failed_jobs
        self.suspended_jobs = suspended_jobs
        self.in_progress_jobs = in_progress_jobs


class MonitoringSettings(msrest.serialization.Model):
    """Monitoring Settings of the vault.

    :ivar azure_monitor_alert_settings: Settings for Azure Monitor based alerts.
    :vartype azure_monitor_alert_settings:
     ~azure.mgmt.recoveryservices.models.AzureMonitorAlertSettings
    :ivar classic_alert_settings: Settings for classic alerts.
    :vartype classic_alert_settings: ~azure.mgmt.recoveryservices.models.ClassicAlertSettings
    """

    _attribute_map = {
        'azure_monitor_alert_settings': {'key': 'azureMonitorAlertSettings', 'type': 'AzureMonitorAlertSettings'},
        'classic_alert_settings': {'key': 'classicAlertSettings', 'type': 'ClassicAlertSettings'},
    }

    def __init__(
        self,
        *,
        azure_monitor_alert_settings: Optional["_models.AzureMonitorAlertSettings"] = None,
        classic_alert_settings: Optional["_models.ClassicAlertSettings"] = None,
        **kwargs
    ):
        """
        :keyword azure_monitor_alert_settings: Settings for Azure Monitor based alerts.
        :paramtype azure_monitor_alert_settings:
         ~azure.mgmt.recoveryservices.models.AzureMonitorAlertSettings
        :keyword classic_alert_settings: Settings for classic alerts.
        :paramtype classic_alert_settings: ~azure.mgmt.recoveryservices.models.ClassicAlertSettings
        """
        super(MonitoringSettings, self).__init__(**kwargs)
        self.azure_monitor_alert_settings = azure_monitor_alert_settings
        self.classic_alert_settings = classic_alert_settings


class MonitoringSummary(msrest.serialization.Model):
    """Summary of the replication monitoring data for this vault.

    :ivar un_healthy_vm_count: Count of unhealthy VMs.
    :vartype un_healthy_vm_count: int
    :ivar un_healthy_provider_count: Count of unhealthy replication providers.
    :vartype un_healthy_provider_count: int
    :ivar events_count: Count of all critical warnings.
    :vartype events_count: int
    :ivar deprecated_provider_count: Count of all deprecated recovery service providers.
    :vartype deprecated_provider_count: int
    :ivar supported_provider_count: Count of all the supported recovery service providers.
    :vartype supported_provider_count: int
    :ivar unsupported_provider_count: Count of all the unsupported recovery service providers.
    :vartype unsupported_provider_count: int
    """

    _attribute_map = {
        'un_healthy_vm_count': {'key': 'unHealthyVmCount', 'type': 'int'},
        'un_healthy_provider_count': {'key': 'unHealthyProviderCount', 'type': 'int'},
        'events_count': {'key': 'eventsCount', 'type': 'int'},
        'deprecated_provider_count': {'key': 'deprecatedProviderCount', 'type': 'int'},
        'supported_provider_count': {'key': 'supportedProviderCount', 'type': 'int'},
        'unsupported_provider_count': {'key': 'unsupportedProviderCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        un_healthy_vm_count: Optional[int] = None,
        un_healthy_provider_count: Optional[int] = None,
        events_count: Optional[int] = None,
        deprecated_provider_count: Optional[int] = None,
        supported_provider_count: Optional[int] = None,
        unsupported_provider_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword un_healthy_vm_count: Count of unhealthy VMs.
        :paramtype un_healthy_vm_count: int
        :keyword un_healthy_provider_count: Count of unhealthy replication providers.
        :paramtype un_healthy_provider_count: int
        :keyword events_count: Count of all critical warnings.
        :paramtype events_count: int
        :keyword deprecated_provider_count: Count of all deprecated recovery service providers.
        :paramtype deprecated_provider_count: int
        :keyword supported_provider_count: Count of all the supported recovery service providers.
        :paramtype supported_provider_count: int
        :keyword unsupported_provider_count: Count of all the unsupported recovery service providers.
        :paramtype unsupported_provider_count: int
        """
        super(MonitoringSummary, self).__init__(**kwargs)
        self.un_healthy_vm_count = un_healthy_vm_count
        self.un_healthy_provider_count = un_healthy_provider_count
        self.events_count = events_count
        self.deprecated_provider_count = deprecated_provider_count
        self.supported_provider_count = supported_provider_count
        self.unsupported_provider_count = unsupported_provider_count


class NameInfo(msrest.serialization.Model):
    """The name of usage.

    :ivar value: Value of usage.
    :vartype value: str
    :ivar localized_value: Localized value of usage.
    :vartype localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Value of usage.
        :paramtype value: str
        :keyword localized_value: Localized value of usage.
        :paramtype localized_value: str
        """
        super(NameInfo, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class OperationResource(msrest.serialization.Model):
    """Operation Resource.

    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: Required if status == failed or status == canceled. This is the OData v4 error
     format, used by the RPC and will go into the v2.2 Azure REST API guidelines.
    :vartype error: ~azure.mgmt.recoveryservices.models.Error
    :ivar id: It should match what is used to GET the operation result.
    :vartype id: str
    :ivar name: It must match the last segment of the "id" field, and will typically be a GUID /
     system generated value.
    :vartype name: str
    :ivar status: The status of the operation. (InProgress/Success/Failed/Cancelled).
    :vartype status: str
    :ivar start_time: Start time of the operation.
    :vartype start_time: ~datetime.datetime
    """

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'Error'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        end_time: Optional[datetime.datetime] = None,
        error: Optional["_models.Error"] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword end_time: End time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword error: Required if status == failed or status == canceled. This is the OData v4 error
         format, used by the RPC and will go into the v2.2 Azure REST API guidelines.
        :paramtype error: ~azure.mgmt.recoveryservices.models.Error
        :keyword id: It should match what is used to GET the operation result.
        :paramtype id: str
        :keyword name: It must match the last segment of the "id" field, and will typically be a GUID /
         system generated value.
        :paramtype name: str
        :keyword status: The status of the operation. (InProgress/Success/Failed/Cancelled).
        :paramtype status: str
        :keyword start_time: Start time of the operation.
        :paramtype start_time: ~datetime.datetime
        """
        super(OperationResource, self).__init__(**kwargs)
        self.end_time = end_time
        self.error = error
        self.id = id
        self.name = name
        self.status = status
        self.start_time = start_time


class Resource(msrest.serialization.Model):
    """ARM Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar etag: Optional ETag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Optional ETag.
        :paramtype etag: str
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = etag


class PatchTrackedResource(Resource):
    """Tracked resource with location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar etag: Optional ETag.
    :vartype etag: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword etag: Optional ETag.
        :paramtype etag: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PatchTrackedResource, self).__init__(etag=etag, **kwargs)
        self.location = location
        self.tags = tags


class PatchVault(PatchTrackedResource):
    """Patch Resource information, as returned by the resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar etag: Optional ETag.
    :vartype etag: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.recoveryservices.models.VaultProperties
    :ivar sku: Identifies the unique system identifier for each Azure resource.
    :vartype sku: ~azure.mgmt.recoveryservices.models.Sku
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.recoveryservices.models.IdentityData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'VaultProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'IdentityData'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VaultProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.IdentityData"] = None,
        **kwargs
    ):
        """
        :keyword etag: Optional ETag.
        :paramtype etag: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault.
        :paramtype properties: ~azure.mgmt.recoveryservices.models.VaultProperties
        :keyword sku: Identifies the unique system identifier for each Azure resource.
        :paramtype sku: ~azure.mgmt.recoveryservices.models.Sku
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.recoveryservices.models.IdentityData
        """
        super(PatchVault, self).__init__(etag=etag, location=location, tags=tags, **kwargs)
        self.properties = properties
        self.sku = sku
        self.identity = identity


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint network resource that is linked to the Private Endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets or sets id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(msrest.serialization.Model):
    """Private Endpoint Connection Response Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Gets or sets provisioning state of the private endpoint connection.
     Known values are: "Succeeded", "Deleting", "Failed", "Pending".
    :vartype provisioning_state: str or ~azure.mgmt.recoveryservices.models.ProvisioningState
    :ivar private_endpoint: The Private Endpoint network resource that is linked to the Private
     Endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.recoveryservices.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Gets or sets private link service connection
     state.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.recoveryservices.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'private_endpoint': {'readonly': True},
        'private_link_service_connection_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = None
        self.private_link_service_connection_state = None


class PrivateEndpointConnectionVaultProperties(msrest.serialization.Model):
    """Information to be stored in Vault properties as an element of privateEndpointConnections List.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Format of id
     subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
    :vartype id: str
    :ivar properties: Private Endpoint Connection Response Properties.
    :vartype properties: ~azure.mgmt.recoveryservices.models.PrivateEndpointConnection
    :ivar name: The name of the private Endpoint Connection.
    :vartype name: str
    :ivar type: The type, which will be of the format,
     Microsoft.RecoveryServices/vaults/privateEndpointConnections.
    :vartype type: str
    :ivar location: The location of the private Endpoint connection.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'properties': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnection'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateEndpointConnectionVaultProperties, self).__init__(**kwargs)
        self.id = None
        self.properties = None
        self.name = None
        self.type = None
        self.location = None


class PrivateLinkResource(msrest.serialization.Model):
    """Information of the private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: e.g. Microsoft.RecoveryServices/vaults/privateLinkResources.
    :vartype type: str
    :ivar group_id: e.g. f9ad6492-33d4-4690-9999-6bfd52a0d081 (Backup) or
     f9ad6492-33d4-4690-9999-6bfd52a0d082 (SiteRecovery).
    :vartype group_id: str
    :ivar required_members: [backup-ecs1, backup-prot1, backup-prot1b, backup-prot1c, backup-id1].
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkResources(msrest.serialization.Model):
    """Class which represent the stamps associated with the vault.

    :ivar value: A collection of private link resources.
    :vartype value: list[~azure.mgmt.recoveryservices.models.PrivateLinkResource]
    :ivar next_link: Link to the next chunk of the response.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A collection of private link resources.
        :paramtype value: list[~azure.mgmt.recoveryservices.models.PrivateLinkResource]
        :keyword next_link: Link to the next chunk of the response.
        :paramtype next_link: str
        """
        super(PrivateLinkResources, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """Gets or sets private link service connection state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Gets or sets the status. Known values are: "Pending", "Approved", "Rejected",
     "Disconnected".
    :vartype status: str or ~azure.mgmt.recoveryservices.models.PrivateEndpointConnectionStatus
    :ivar description: Gets or sets description.
    :vartype description: str
    :ivar actions_required: Gets or sets actions required.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'readonly': True},
        'description': {'readonly': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = None
        self.description = None
        self.actions_required = None


class RawCertificateData(msrest.serialization.Model):
    """Raw certificate data.

    :ivar auth_type: Specifies the authentication type. Known values are: "Invalid", "ACS", "AAD",
     "AccessControlService", "AzureActiveDirectory".
    :vartype auth_type: str or ~azure.mgmt.recoveryservices.models.AuthType
    :ivar certificate: The base64 encoded certificate raw data string.
    :vartype certificate: bytearray
    """

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        auth_type: Optional[Union[str, "_models.AuthType"]] = None,
        certificate: Optional[bytearray] = None,
        **kwargs
    ):
        """
        :keyword auth_type: Specifies the authentication type. Known values are: "Invalid", "ACS",
         "AAD", "AccessControlService", "AzureActiveDirectory".
        :paramtype auth_type: str or ~azure.mgmt.recoveryservices.models.AuthType
        :keyword certificate: The base64 encoded certificate raw data string.
        :paramtype certificate: bytearray
        """
        super(RawCertificateData, self).__init__(**kwargs)
        self.auth_type = auth_type
        self.certificate = certificate


class ReplicationUsage(msrest.serialization.Model):
    """Replication usages of a vault.

    :ivar monitoring_summary: Summary of the replication monitoring data for this vault.
    :vartype monitoring_summary: ~azure.mgmt.recoveryservices.models.MonitoringSummary
    :ivar jobs_summary: Summary of the replication jobs data for this vault.
    :vartype jobs_summary: ~azure.mgmt.recoveryservices.models.JobsSummary
    :ivar protected_item_count: Number of replication protected items for this vault.
    :vartype protected_item_count: int
    :ivar recovery_plan_count: Number of replication recovery plans for this vault.
    :vartype recovery_plan_count: int
    :ivar registered_servers_count: Number of servers registered to this vault.
    :vartype registered_servers_count: int
    :ivar recovery_services_provider_auth_type: The authentication type of recovery service
     providers in the vault.
    :vartype recovery_services_provider_auth_type: int
    """

    _attribute_map = {
        'monitoring_summary': {'key': 'monitoringSummary', 'type': 'MonitoringSummary'},
        'jobs_summary': {'key': 'jobsSummary', 'type': 'JobsSummary'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'int'},
        'recovery_plan_count': {'key': 'recoveryPlanCount', 'type': 'int'},
        'registered_servers_count': {'key': 'registeredServersCount', 'type': 'int'},
        'recovery_services_provider_auth_type': {'key': 'recoveryServicesProviderAuthType', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        monitoring_summary: Optional["_models.MonitoringSummary"] = None,
        jobs_summary: Optional["_models.JobsSummary"] = None,
        protected_item_count: Optional[int] = None,
        recovery_plan_count: Optional[int] = None,
        registered_servers_count: Optional[int] = None,
        recovery_services_provider_auth_type: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword monitoring_summary: Summary of the replication monitoring data for this vault.
        :paramtype monitoring_summary: ~azure.mgmt.recoveryservices.models.MonitoringSummary
        :keyword jobs_summary: Summary of the replication jobs data for this vault.
        :paramtype jobs_summary: ~azure.mgmt.recoveryservices.models.JobsSummary
        :keyword protected_item_count: Number of replication protected items for this vault.
        :paramtype protected_item_count: int
        :keyword recovery_plan_count: Number of replication recovery plans for this vault.
        :paramtype recovery_plan_count: int
        :keyword registered_servers_count: Number of servers registered to this vault.
        :paramtype registered_servers_count: int
        :keyword recovery_services_provider_auth_type: The authentication type of recovery service
         providers in the vault.
        :paramtype recovery_services_provider_auth_type: int
        """
        super(ReplicationUsage, self).__init__(**kwargs)
        self.monitoring_summary = monitoring_summary
        self.jobs_summary = jobs_summary
        self.protected_item_count = protected_item_count
        self.recovery_plan_count = recovery_plan_count
        self.registered_servers_count = registered_servers_count
        self.recovery_services_provider_auth_type = recovery_services_provider_auth_type


class ReplicationUsageList(msrest.serialization.Model):
    """Replication usages for vault.

    :ivar value: The list of replication usages for the given vault.
    :vartype value: list[~azure.mgmt.recoveryservices.models.ReplicationUsage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReplicationUsage]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ReplicationUsage"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of replication usages for the given vault.
        :paramtype value: list[~azure.mgmt.recoveryservices.models.ReplicationUsage]
        """
        super(ReplicationUsageList, self).__init__(**kwargs)
        self.value = value


class ResourceCertificateDetails(msrest.serialization.Model):
    """Certificate details representing the Vault credentials.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ResourceCertificateAndAcsDetails, ResourceCertificateAndAadDetails.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types.Constant filled by server.
    :vartype auth_type: str
    :ivar certificate: The base64 encoded certificate raw data string.
    :vartype certificate: bytearray
    :ivar friendly_name: Certificate friendly name.
    :vartype friendly_name: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar resource_id: Resource ID of the vault.
    :vartype resource_id: long
    :ivar subject: Certificate Subject Name.
    :vartype subject: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid_from: Certificate Validity start Date time.
    :vartype valid_from: ~datetime.datetime
    :ivar valid_to: Certificate Validity End Date time.
    :vartype valid_to: ~datetime.datetime
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'long'},
        'subject': {'key': 'subject', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'valid_from': {'key': 'validFrom', 'type': 'iso-8601'},
        'valid_to': {'key': 'validTo', 'type': 'iso-8601'},
    }

    _subtype_map = {
        'auth_type': {'AccessControlService': 'ResourceCertificateAndAcsDetails', 'AzureActiveDirectory': 'ResourceCertificateAndAadDetails'}
    }

    def __init__(
        self,
        *,
        certificate: Optional[bytearray] = None,
        friendly_name: Optional[str] = None,
        issuer: Optional[str] = None,
        resource_id: Optional[int] = None,
        subject: Optional[str] = None,
        thumbprint: Optional[str] = None,
        valid_from: Optional[datetime.datetime] = None,
        valid_to: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword certificate: The base64 encoded certificate raw data string.
        :paramtype certificate: bytearray
        :keyword friendly_name: Certificate friendly name.
        :paramtype friendly_name: str
        :keyword issuer: Certificate issuer.
        :paramtype issuer: str
        :keyword resource_id: Resource ID of the vault.
        :paramtype resource_id: long
        :keyword subject: Certificate Subject Name.
        :paramtype subject: str
        :keyword thumbprint: Certificate thumbprint.
        :paramtype thumbprint: str
        :keyword valid_from: Certificate Validity start Date time.
        :paramtype valid_from: ~datetime.datetime
        :keyword valid_to: Certificate Validity End Date time.
        :paramtype valid_to: ~datetime.datetime
        """
        super(ResourceCertificateDetails, self).__init__(**kwargs)
        self.auth_type = None  # type: Optional[str]
        self.certificate = certificate
        self.friendly_name = friendly_name
        self.issuer = issuer
        self.resource_id = resource_id
        self.subject = subject
        self.thumbprint = thumbprint
        self.valid_from = valid_from
        self.valid_to = valid_to


class ResourceCertificateAndAadDetails(ResourceCertificateDetails):
    """Certificate details representing the Vault credentials for AAD.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types.Constant filled by server.
    :vartype auth_type: str
    :ivar certificate: The base64 encoded certificate raw data string.
    :vartype certificate: bytearray
    :ivar friendly_name: Certificate friendly name.
    :vartype friendly_name: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar resource_id: Resource ID of the vault.
    :vartype resource_id: long
    :ivar subject: Certificate Subject Name.
    :vartype subject: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid_from: Certificate Validity start Date time.
    :vartype valid_from: ~datetime.datetime
    :ivar valid_to: Certificate Validity End Date time.
    :vartype valid_to: ~datetime.datetime
    :ivar aad_authority: Required. AAD tenant authority.
    :vartype aad_authority: str
    :ivar aad_tenant_id: Required. AAD tenant Id.
    :vartype aad_tenant_id: str
    :ivar service_principal_client_id: Required. AAD service principal clientId.
    :vartype service_principal_client_id: str
    :ivar service_principal_object_id: Required. AAD service principal ObjectId.
    :vartype service_principal_object_id: str
    :ivar azure_management_endpoint_audience: Required. Azure Management Endpoint Audience.
    :vartype azure_management_endpoint_audience: str
    :ivar service_resource_id: Service Resource Id.
    :vartype service_resource_id: str
    :ivar aad_audience: AAD audience for the resource.
    :vartype aad_audience: str
    """

    _validation = {
        'auth_type': {'required': True},
        'aad_authority': {'required': True},
        'aad_tenant_id': {'required': True},
        'service_principal_client_id': {'required': True},
        'service_principal_object_id': {'required': True},
        'azure_management_endpoint_audience': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'long'},
        'subject': {'key': 'subject', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'valid_from': {'key': 'validFrom', 'type': 'iso-8601'},
        'valid_to': {'key': 'validTo', 'type': 'iso-8601'},
        'aad_authority': {'key': 'aadAuthority', 'type': 'str'},
        'aad_tenant_id': {'key': 'aadTenantId', 'type': 'str'},
        'service_principal_client_id': {'key': 'servicePrincipalClientId', 'type': 'str'},
        'service_principal_object_id': {'key': 'servicePrincipalObjectId', 'type': 'str'},
        'azure_management_endpoint_audience': {'key': 'azureManagementEndpointAudience', 'type': 'str'},
        'service_resource_id': {'key': 'serviceResourceId', 'type': 'str'},
        'aad_audience': {'key': 'aadAudience', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        aad_authority: str,
        aad_tenant_id: str,
        service_principal_client_id: str,
        service_principal_object_id: str,
        azure_management_endpoint_audience: str,
        certificate: Optional[bytearray] = None,
        friendly_name: Optional[str] = None,
        issuer: Optional[str] = None,
        resource_id: Optional[int] = None,
        subject: Optional[str] = None,
        thumbprint: Optional[str] = None,
        valid_from: Optional[datetime.datetime] = None,
        valid_to: Optional[datetime.datetime] = None,
        service_resource_id: Optional[str] = None,
        aad_audience: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword certificate: The base64 encoded certificate raw data string.
        :paramtype certificate: bytearray
        :keyword friendly_name: Certificate friendly name.
        :paramtype friendly_name: str
        :keyword issuer: Certificate issuer.
        :paramtype issuer: str
        :keyword resource_id: Resource ID of the vault.
        :paramtype resource_id: long
        :keyword subject: Certificate Subject Name.
        :paramtype subject: str
        :keyword thumbprint: Certificate thumbprint.
        :paramtype thumbprint: str
        :keyword valid_from: Certificate Validity start Date time.
        :paramtype valid_from: ~datetime.datetime
        :keyword valid_to: Certificate Validity End Date time.
        :paramtype valid_to: ~datetime.datetime
        :keyword aad_authority: Required. AAD tenant authority.
        :paramtype aad_authority: str
        :keyword aad_tenant_id: Required. AAD tenant Id.
        :paramtype aad_tenant_id: str
        :keyword service_principal_client_id: Required. AAD service principal clientId.
        :paramtype service_principal_client_id: str
        :keyword service_principal_object_id: Required. AAD service principal ObjectId.
        :paramtype service_principal_object_id: str
        :keyword azure_management_endpoint_audience: Required. Azure Management Endpoint Audience.
        :paramtype azure_management_endpoint_audience: str
        :keyword service_resource_id: Service Resource Id.
        :paramtype service_resource_id: str
        :keyword aad_audience: AAD audience for the resource.
        :paramtype aad_audience: str
        """
        super(ResourceCertificateAndAadDetails, self).__init__(certificate=certificate, friendly_name=friendly_name, issuer=issuer, resource_id=resource_id, subject=subject, thumbprint=thumbprint, valid_from=valid_from, valid_to=valid_to, **kwargs)
        self.auth_type = 'AzureActiveDirectory'  # type: str
        self.aad_authority = aad_authority
        self.aad_tenant_id = aad_tenant_id
        self.service_principal_client_id = service_principal_client_id
        self.service_principal_object_id = service_principal_object_id
        self.azure_management_endpoint_audience = azure_management_endpoint_audience
        self.service_resource_id = service_resource_id
        self.aad_audience = aad_audience


class ResourceCertificateAndAcsDetails(ResourceCertificateDetails):
    """Certificate details representing the Vault credentials for ACS.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types.Constant filled by server.
    :vartype auth_type: str
    :ivar certificate: The base64 encoded certificate raw data string.
    :vartype certificate: bytearray
    :ivar friendly_name: Certificate friendly name.
    :vartype friendly_name: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar resource_id: Resource ID of the vault.
    :vartype resource_id: long
    :ivar subject: Certificate Subject Name.
    :vartype subject: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid_from: Certificate Validity start Date time.
    :vartype valid_from: ~datetime.datetime
    :ivar valid_to: Certificate Validity End Date time.
    :vartype valid_to: ~datetime.datetime
    :ivar global_acs_namespace: Required. ACS namespace name - tenant for our service.
    :vartype global_acs_namespace: str
    :ivar global_acs_host_name: Required. Acs mgmt host name to connect to.
    :vartype global_acs_host_name: str
    :ivar global_acs_rp_realm: Required. Global ACS namespace RP realm.
    :vartype global_acs_rp_realm: str
    """

    _validation = {
        'auth_type': {'required': True},
        'global_acs_namespace': {'required': True},
        'global_acs_host_name': {'required': True},
        'global_acs_rp_realm': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'long'},
        'subject': {'key': 'subject', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'valid_from': {'key': 'validFrom', 'type': 'iso-8601'},
        'valid_to': {'key': 'validTo', 'type': 'iso-8601'},
        'global_acs_namespace': {'key': 'globalAcsNamespace', 'type': 'str'},
        'global_acs_host_name': {'key': 'globalAcsHostName', 'type': 'str'},
        'global_acs_rp_realm': {'key': 'globalAcsRPRealm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        global_acs_namespace: str,
        global_acs_host_name: str,
        global_acs_rp_realm: str,
        certificate: Optional[bytearray] = None,
        friendly_name: Optional[str] = None,
        issuer: Optional[str] = None,
        resource_id: Optional[int] = None,
        subject: Optional[str] = None,
        thumbprint: Optional[str] = None,
        valid_from: Optional[datetime.datetime] = None,
        valid_to: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword certificate: The base64 encoded certificate raw data string.
        :paramtype certificate: bytearray
        :keyword friendly_name: Certificate friendly name.
        :paramtype friendly_name: str
        :keyword issuer: Certificate issuer.
        :paramtype issuer: str
        :keyword resource_id: Resource ID of the vault.
        :paramtype resource_id: long
        :keyword subject: Certificate Subject Name.
        :paramtype subject: str
        :keyword thumbprint: Certificate thumbprint.
        :paramtype thumbprint: str
        :keyword valid_from: Certificate Validity start Date time.
        :paramtype valid_from: ~datetime.datetime
        :keyword valid_to: Certificate Validity End Date time.
        :paramtype valid_to: ~datetime.datetime
        :keyword global_acs_namespace: Required. ACS namespace name - tenant for our service.
        :paramtype global_acs_namespace: str
        :keyword global_acs_host_name: Required. Acs mgmt host name to connect to.
        :paramtype global_acs_host_name: str
        :keyword global_acs_rp_realm: Required. Global ACS namespace RP realm.
        :paramtype global_acs_rp_realm: str
        """
        super(ResourceCertificateAndAcsDetails, self).__init__(certificate=certificate, friendly_name=friendly_name, issuer=issuer, resource_id=resource_id, subject=subject, thumbprint=thumbprint, valid_from=valid_from, valid_to=valid_to, **kwargs)
        self.auth_type = 'AccessControlService'  # type: str
        self.global_acs_namespace = global_acs_namespace
        self.global_acs_host_name = global_acs_host_name
        self.global_acs_rp_realm = global_acs_rp_realm


class Sku(msrest.serialization.Model):
    """Identifies the unique system identifier for each Azure resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Name of SKU is RS0 (Recovery Services 0th version) and the tier is
     standard tier. They do not have affect on backend storage redundancy or any other vault
     settings. To manage storage redundancy, use the backupstorageconfig. Known values are:
     "Standard", "RS0".
    :vartype name: str or ~azure.mgmt.recoveryservices.models.SkuName
    :ivar tier: The Sku tier.
    :vartype tier: str
    :ivar family: The sku family.
    :vartype family: str
    :ivar size: The sku size.
    :vartype size: str
    :ivar capacity: The sku capacity.
    :vartype capacity: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        tier: Optional[str] = None,
        family: Optional[str] = None,
        size: Optional[str] = None,
        capacity: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Name of SKU is RS0 (Recovery Services 0th version) and the tier is
         standard tier. They do not have affect on backend storage redundancy or any other vault
         settings. To manage storage redundancy, use the backupstorageconfig. Known values are:
         "Standard", "RS0".
        :paramtype name: str or ~azure.mgmt.recoveryservices.models.SkuName
        :keyword tier: The Sku tier.
        :paramtype tier: str
        :keyword family: The sku family.
        :paramtype family: str
        :keyword size: The sku size.
        :paramtype size: str
        :keyword capacity: The sku capacity.
        :paramtype capacity: str
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family
        self.size = size
        self.capacity = capacity


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.recoveryservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.recoveryservices.models.CreatedByType
    :ivar last_modified_at: The type of identity that last modified the resource.
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.recoveryservices.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.recoveryservices.models.CreatedByType
        :keyword last_modified_at: The type of identity that last modified the resource.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TrackedResource(Resource):
    """Tracked resource with location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar etag: Optional ETag.
    :vartype etag: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        etag: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword etag: Optional ETag.
        :paramtype etag: str
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(TrackedResource, self).__init__(etag=etag, **kwargs)
        self.location = location
        self.tags = tags


class UpgradeDetails(msrest.serialization.Model):
    """Details for upgrading vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation_id: ID of the vault upgrade operation.
    :vartype operation_id: str
    :ivar start_time_utc: UTC time at which the upgrade operation has started.
    :vartype start_time_utc: ~datetime.datetime
    :ivar last_updated_time_utc: UTC time at which the upgrade operation status was last updated.
    :vartype last_updated_time_utc: ~datetime.datetime
    :ivar end_time_utc: UTC time at which the upgrade operation has ended.
    :vartype end_time_utc: ~datetime.datetime
    :ivar status: Status of the vault upgrade operation. Known values are: "Unknown", "InProgress",
     "Upgraded", "Failed".
    :vartype status: str or ~azure.mgmt.recoveryservices.models.VaultUpgradeState
    :ivar message: Message to the user containing information about the upgrade operation.
    :vartype message: str
    :ivar trigger_type: The way the vault upgrade was triggered. Known values are: "UserTriggered",
     "ForcedUpgrade".
    :vartype trigger_type: str or ~azure.mgmt.recoveryservices.models.TriggerType
    :ivar upgraded_resource_id: Resource ID of the upgraded vault.
    :vartype upgraded_resource_id: str
    :ivar previous_resource_id: Resource ID of the vault before the upgrade.
    :vartype previous_resource_id: str
    """

    _validation = {
        'operation_id': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'last_updated_time_utc': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
        'trigger_type': {'readonly': True},
        'upgraded_resource_id': {'readonly': True},
        'previous_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'last_updated_time_utc': {'key': 'lastUpdatedTimeUtc', 'type': 'iso-8601'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'upgraded_resource_id': {'key': 'upgradedResourceId', 'type': 'str'},
        'previous_resource_id': {'key': 'previousResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UpgradeDetails, self).__init__(**kwargs)
        self.operation_id = None
        self.start_time_utc = None
        self.last_updated_time_utc = None
        self.end_time_utc = None
        self.status = None
        self.message = None
        self.trigger_type = None
        self.upgraded_resource_id = None
        self.previous_resource_id = None


class UserIdentity(msrest.serialization.Model):
    """A resource identity that is managed by the user of the service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the user-assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the user-assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class Vault(TrackedResource):
    """Resource information, as returned by the resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar etag: Optional ETag.
    :vartype etag: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.recoveryservices.models.IdentityData
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.recoveryservices.models.VaultProperties
    :ivar sku: Identifies the unique system identifier for each Azure resource.
    :vartype sku: ~azure.mgmt.recoveryservices.models.Sku
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityData'},
        'properties': {'key': 'properties', 'type': 'VaultProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        etag: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityData"] = None,
        properties: Optional["_models.VaultProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs
    ):
        """
        :keyword etag: Optional ETag.
        :paramtype etag: str
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.recoveryservices.models.IdentityData
        :keyword properties: Properties of the vault.
        :paramtype properties: ~azure.mgmt.recoveryservices.models.VaultProperties
        :keyword sku: Identifies the unique system identifier for each Azure resource.
        :paramtype sku: ~azure.mgmt.recoveryservices.models.Sku
        """
        super(Vault, self).__init__(etag=etag, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.properties = properties
        self.sku = sku
        self.system_data = None


class VaultCertificateResponse(msrest.serialization.Model):
    """Certificate corresponding to a vault that can be used by clients to register themselves with the vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar properties: Certificate details representing the Vault credentials.
    :vartype properties: ~azure.mgmt.recoveryservices.models.ResourceCertificateDetails
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ResourceCertificateDetails'},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ResourceCertificateDetails"] = None,
        **kwargs
    ):
        """
        :keyword properties: Certificate details representing the Vault credentials.
        :paramtype properties: ~azure.mgmt.recoveryservices.models.ResourceCertificateDetails
        """
        super(VaultCertificateResponse, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.id = None
        self.properties = properties


class VaultExtendedInfoResource(Resource):
    """Vault extended information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar etag: Optional ETag.
    :vartype etag: str
    :ivar integrity_key: Integrity key.
    :vartype integrity_key: str
    :ivar encryption_key: Encryption key.
    :vartype encryption_key: str
    :ivar encryption_key_thumbprint: Encryption key thumbprint.
    :vartype encryption_key_thumbprint: str
    :ivar algorithm: Algorithm for Vault ExtendedInfo.
    :vartype algorithm: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'integrity_key': {'key': 'properties.integrityKey', 'type': 'str'},
        'encryption_key': {'key': 'properties.encryptionKey', 'type': 'str'},
        'encryption_key_thumbprint': {'key': 'properties.encryptionKeyThumbprint', 'type': 'str'},
        'algorithm': {'key': 'properties.algorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        integrity_key: Optional[str] = None,
        encryption_key: Optional[str] = None,
        encryption_key_thumbprint: Optional[str] = None,
        algorithm: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: Optional ETag.
        :paramtype etag: str
        :keyword integrity_key: Integrity key.
        :paramtype integrity_key: str
        :keyword encryption_key: Encryption key.
        :paramtype encryption_key: str
        :keyword encryption_key_thumbprint: Encryption key thumbprint.
        :paramtype encryption_key_thumbprint: str
        :keyword algorithm: Algorithm for Vault ExtendedInfo.
        :paramtype algorithm: str
        """
        super(VaultExtendedInfoResource, self).__init__(etag=etag, **kwargs)
        self.integrity_key = integrity_key
        self.encryption_key = encryption_key
        self.encryption_key_thumbprint = encryption_key_thumbprint
        self.algorithm = algorithm


class VaultList(msrest.serialization.Model):
    """The response model for a list of Vaults.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.recoveryservices.models.Vault]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Vault]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Vault"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.recoveryservices.models.Vault]
        """
        super(VaultList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class VaultProperties(msrest.serialization.Model):
    """Properties of the vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning State.
    :vartype provisioning_state: str
    :ivar upgrade_details: Details for upgrading vault.
    :vartype upgrade_details: ~azure.mgmt.recoveryservices.models.UpgradeDetails
    :ivar private_endpoint_connections: List of private endpoint connection.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.recoveryservices.models.PrivateEndpointConnectionVaultProperties]
    :ivar private_endpoint_state_for_backup: Private endpoint state for backup. Known values are:
     "None", "Enabled".
    :vartype private_endpoint_state_for_backup: str or
     ~azure.mgmt.recoveryservices.models.VaultPrivateEndpointState
    :ivar private_endpoint_state_for_site_recovery: Private endpoint state for site recovery. Known
     values are: "None", "Enabled".
    :vartype private_endpoint_state_for_site_recovery: str or
     ~azure.mgmt.recoveryservices.models.VaultPrivateEndpointState
    :ivar encryption: Customer Managed Key details of the resource.
    :vartype encryption: ~azure.mgmt.recoveryservices.models.VaultPropertiesEncryption
    :ivar move_details: The details of the latest move operation performed on the Azure Resource.
    :vartype move_details: ~azure.mgmt.recoveryservices.models.VaultPropertiesMoveDetails
    :ivar move_state: The State of the Resource after the move operation. Known values are:
     "Unknown", "InProgress", "PrepareFailed", "CommitFailed", "PrepareTimedout", "CommitTimedout",
     "MoveSucceeded", "Failure", "CriticalFailure", "PartialSuccess".
    :vartype move_state: str or ~azure.mgmt.recoveryservices.models.ResourceMoveState
    :ivar backup_storage_version: Backup storage version. Known values are: "V1", "V2",
     "Unassigned".
    :vartype backup_storage_version: str or
     ~azure.mgmt.recoveryservices.models.BackupStorageVersion
    :ivar monitoring_settings: Monitoring Settings of the vault.
    :vartype monitoring_settings: ~azure.mgmt.recoveryservices.models.MonitoringSettings
    :ivar redundancy_settings: The redundancy Settings of a Vault.
    :vartype redundancy_settings:
     ~azure.mgmt.recoveryservices.models.VaultPropertiesRedundancySettings
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'private_endpoint_state_for_backup': {'readonly': True},
        'private_endpoint_state_for_site_recovery': {'readonly': True},
        'move_state': {'readonly': True},
        'backup_storage_version': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'upgrade_details': {'key': 'upgradeDetails', 'type': 'UpgradeDetails'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[PrivateEndpointConnectionVaultProperties]'},
        'private_endpoint_state_for_backup': {'key': 'privateEndpointStateForBackup', 'type': 'str'},
        'private_endpoint_state_for_site_recovery': {'key': 'privateEndpointStateForSiteRecovery', 'type': 'str'},
        'encryption': {'key': 'encryption', 'type': 'VaultPropertiesEncryption'},
        'move_details': {'key': 'moveDetails', 'type': 'VaultPropertiesMoveDetails'},
        'move_state': {'key': 'moveState', 'type': 'str'},
        'backup_storage_version': {'key': 'backupStorageVersion', 'type': 'str'},
        'monitoring_settings': {'key': 'monitoringSettings', 'type': 'MonitoringSettings'},
        'redundancy_settings': {'key': 'redundancySettings', 'type': 'VaultPropertiesRedundancySettings'},
    }

    def __init__(
        self,
        *,
        upgrade_details: Optional["_models.UpgradeDetails"] = None,
        encryption: Optional["_models.VaultPropertiesEncryption"] = None,
        move_details: Optional["_models.VaultPropertiesMoveDetails"] = None,
        monitoring_settings: Optional["_models.MonitoringSettings"] = None,
        redundancy_settings: Optional["_models.VaultPropertiesRedundancySettings"] = None,
        **kwargs
    ):
        """
        :keyword upgrade_details: Details for upgrading vault.
        :paramtype upgrade_details: ~azure.mgmt.recoveryservices.models.UpgradeDetails
        :keyword encryption: Customer Managed Key details of the resource.
        :paramtype encryption: ~azure.mgmt.recoveryservices.models.VaultPropertiesEncryption
        :keyword move_details: The details of the latest move operation performed on the Azure
         Resource.
        :paramtype move_details: ~azure.mgmt.recoveryservices.models.VaultPropertiesMoveDetails
        :keyword monitoring_settings: Monitoring Settings of the vault.
        :paramtype monitoring_settings: ~azure.mgmt.recoveryservices.models.MonitoringSettings
        :keyword redundancy_settings: The redundancy Settings of a Vault.
        :paramtype redundancy_settings:
         ~azure.mgmt.recoveryservices.models.VaultPropertiesRedundancySettings
        """
        super(VaultProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.upgrade_details = upgrade_details
        self.private_endpoint_connections = None
        self.private_endpoint_state_for_backup = None
        self.private_endpoint_state_for_site_recovery = None
        self.encryption = encryption
        self.move_details = move_details
        self.move_state = None
        self.backup_storage_version = None
        self.monitoring_settings = monitoring_settings
        self.redundancy_settings = redundancy_settings


class VaultPropertiesEncryption(msrest.serialization.Model):
    """Customer Managed Key details of the resource.

    :ivar key_vault_properties: The properties of the Key Vault which hosts CMK.
    :vartype key_vault_properties: ~azure.mgmt.recoveryservices.models.CmkKeyVaultProperties
    :ivar kek_identity: The details of the identity used for CMK.
    :vartype kek_identity: ~azure.mgmt.recoveryservices.models.CmkKekIdentity
    :ivar infrastructure_encryption: Enabling/Disabling the Double Encryption state. Known values
     are: "Enabled", "Disabled".
    :vartype infrastructure_encryption: str or
     ~azure.mgmt.recoveryservices.models.InfrastructureEncryptionState
    """

    _attribute_map = {
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'CmkKeyVaultProperties'},
        'kek_identity': {'key': 'kekIdentity', 'type': 'CmkKekIdentity'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_properties: Optional["_models.CmkKeyVaultProperties"] = None,
        kek_identity: Optional["_models.CmkKekIdentity"] = None,
        infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryptionState"]] = None,
        **kwargs
    ):
        """
        :keyword key_vault_properties: The properties of the Key Vault which hosts CMK.
        :paramtype key_vault_properties: ~azure.mgmt.recoveryservices.models.CmkKeyVaultProperties
        :keyword kek_identity: The details of the identity used for CMK.
        :paramtype kek_identity: ~azure.mgmt.recoveryservices.models.CmkKekIdentity
        :keyword infrastructure_encryption: Enabling/Disabling the Double Encryption state. Known
         values are: "Enabled", "Disabled".
        :paramtype infrastructure_encryption: str or
         ~azure.mgmt.recoveryservices.models.InfrastructureEncryptionState
        """
        super(VaultPropertiesEncryption, self).__init__(**kwargs)
        self.key_vault_properties = key_vault_properties
        self.kek_identity = kek_identity
        self.infrastructure_encryption = infrastructure_encryption


class VaultPropertiesMoveDetails(msrest.serialization.Model):
    """The details of the latest move operation performed on the Azure Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation_id: OperationId of the Resource Move Operation.
    :vartype operation_id: str
    :ivar start_time_utc: Start Time of the Resource Move Operation.
    :vartype start_time_utc: ~datetime.datetime
    :ivar completion_time_utc: End Time of the Resource Move Operation.
    :vartype completion_time_utc: ~datetime.datetime
    :ivar source_resource_id: Source Resource of the Resource Move Operation.
    :vartype source_resource_id: str
    :ivar target_resource_id: Target Resource of the Resource Move Operation.
    :vartype target_resource_id: str
    """

    _validation = {
        'operation_id': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'completion_time_utc': {'readonly': True},
        'source_resource_id': {'readonly': True},
        'target_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'completion_time_utc': {'key': 'completionTimeUtc', 'type': 'iso-8601'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(VaultPropertiesMoveDetails, self).__init__(**kwargs)
        self.operation_id = None
        self.start_time_utc = None
        self.completion_time_utc = None
        self.source_resource_id = None
        self.target_resource_id = None


class VaultPropertiesRedundancySettings(msrest.serialization.Model):
    """The redundancy Settings of a Vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar standard_tier_storage_redundancy: The storage redundancy setting of a vault. Known values
     are: "LocallyRedundant", "GeoRedundant", "ZoneRedundant".
    :vartype standard_tier_storage_redundancy: str or
     ~azure.mgmt.recoveryservices.models.StandardTierStorageRedundancy
    :ivar cross_region_restore: Flag to show if Cross Region Restore is enabled on the Vault or
     not. Known values are: "Enabled", "Disabled".
    :vartype cross_region_restore: str or ~azure.mgmt.recoveryservices.models.CrossRegionRestore
    """

    _validation = {
        'standard_tier_storage_redundancy': {'readonly': True},
        'cross_region_restore': {'readonly': True},
    }

    _attribute_map = {
        'standard_tier_storage_redundancy': {'key': 'standardTierStorageRedundancy', 'type': 'str'},
        'cross_region_restore': {'key': 'crossRegionRestore', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(VaultPropertiesRedundancySettings, self).__init__(**kwargs)
        self.standard_tier_storage_redundancy = None
        self.cross_region_restore = None


class VaultUsage(msrest.serialization.Model):
    """Usages of a vault.

    :ivar unit: Unit of the usage. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.recoveryservices.models.UsagesUnit
    :ivar quota_period: Quota period of usage.
    :vartype quota_period: str
    :ivar next_reset_time: Next reset time of usage.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: Current value of usage.
    :vartype current_value: long
    :ivar limit: Limit of usage.
    :vartype limit: long
    :ivar name: Name of usage.
    :vartype name: ~azure.mgmt.recoveryservices.models.NameInfo
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'NameInfo'},
    }

    def __init__(
        self,
        *,
        unit: Optional[Union[str, "_models.UsagesUnit"]] = None,
        quota_period: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.NameInfo"] = None,
        **kwargs
    ):
        """
        :keyword unit: Unit of the usage. Known values are: "Count", "Bytes", "Seconds", "Percent",
         "CountPerSecond", "BytesPerSecond".
        :paramtype unit: str or ~azure.mgmt.recoveryservices.models.UsagesUnit
        :keyword quota_period: Quota period of usage.
        :paramtype quota_period: str
        :keyword next_reset_time: Next reset time of usage.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: Current value of usage.
        :paramtype current_value: long
        :keyword limit: Limit of usage.
        :paramtype limit: long
        :keyword name: Name of usage.
        :paramtype name: ~azure.mgmt.recoveryservices.models.NameInfo
        """
        super(VaultUsage, self).__init__(**kwargs)
        self.unit = unit
        self.quota_period = quota_period
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class VaultUsageList(msrest.serialization.Model):
    """Usage for vault.

    :ivar value: The list of usages for the given vault.
    :vartype value: list[~azure.mgmt.recoveryservices.models.VaultUsage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VaultUsage]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VaultUsage"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of usages for the given vault.
        :paramtype value: list[~azure.mgmt.recoveryservices.models.VaultUsage]
        """
        super(VaultUsageList, self).__init__(**kwargs)
        self.value = value
